/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.store;

import com.google.bitcoin.core.ECKey;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.PeerAddress;
import com.google.bitcoin.core.ScriptException;
import com.google.bitcoin.core.Sha256Hash;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.TransactionConfidence;
import com.google.bitcoin.core.TransactionInput;
import com.google.bitcoin.core.TransactionOutPoint;
import com.google.bitcoin.core.TransactionOutput;
import com.google.bitcoin.core.Wallet;
import com.google.bitcoin.core.WalletExtension;
import com.google.bitcoin.crypto.EncryptedPrivateKey;
import com.google.bitcoin.crypto.KeyCrypter;
import com.google.bitcoin.crypto.KeyCrypterScrypt;
import com.google.bitcoin.script.Script;
import com.google.bitcoin.store.UnreadableWalletException;
import com.google.bitcoin.wallet.WalletTransaction;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import org.bitcoinj.wallet.Protos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WalletProtobufSerializer {
    private static final Logger log = LoggerFactory.getLogger(WalletProtobufSerializer.class);
    protected Map<ByteString, Transaction> txMap = new HashMap<ByteString, Transaction>();
    private boolean requireMandatoryExtensions = true;

    public void setRequireMandatoryExtensions(boolean value) {
        this.requireMandatoryExtensions = value;
    }

    public void writeWallet(Wallet wallet, OutputStream output) throws IOException {
        Protos.Wallet walletProto = this.walletToProto(wallet);
        walletProto.writeTo(output);
    }

    public String walletToText(Wallet wallet) {
        Protos.Wallet walletProto = this.walletToProto(wallet);
        return TextFormat.printToString((MessageOrBuilder)walletProto);
    }

    public Protos.Wallet walletToProto(Wallet wallet) {
        KeyCrypter keyCrypter;
        Protos.Wallet.Builder walletBuilder = Protos.Wallet.newBuilder();
        walletBuilder.setNetworkIdentifier(wallet.getNetworkParameters().getId());
        if (wallet.getDescription() != null) {
            walletBuilder.setDescription(wallet.getDescription());
        }
        for (WalletTransaction wtx : wallet.getWalletTransactions()) {
            Protos.Transaction txProto = WalletProtobufSerializer.makeTxProto(wtx);
            walletBuilder.addTransaction(txProto);
        }
        for (ECKey key : wallet.getKeys()) {
            EncryptedPrivateKey encryptedPrivateKey;
            Protos.Key.Builder keyBuilder = Protos.Key.newBuilder().setCreationTimestamp(key.getCreationTimeSeconds() * 1000L).setType(Protos.Key.Type.ORIGINAL);
            if (key.getPrivKeyBytes() != null) {
                keyBuilder.setPrivateKey(ByteString.copyFrom((byte[])key.getPrivKeyBytes()));
            }
            if ((encryptedPrivateKey = key.getEncryptedPrivateKey()) != null) {
                Protos.EncryptedPrivateKey.Builder encryptedKeyBuilder = Protos.EncryptedPrivateKey.newBuilder().setEncryptedPrivateKey(ByteString.copyFrom((byte[])encryptedPrivateKey.getEncryptedBytes())).setInitialisationVector(ByteString.copyFrom((byte[])encryptedPrivateKey.getInitialisationVector()));
                if (key.getKeyCrypter() == null) {
                    throw new IllegalStateException("The encrypted key " + key.toString() + " has no KeyCrypter.");
                }
                if (key.getKeyCrypter().getUnderstoodEncryptionType() != Protos.Wallet.EncryptionType.ENCRYPTED_SCRYPT_AES) {
                    throw new IllegalArgumentException("The key " + key.toString() + " is encrypted with a KeyCrypter of type " + (Object)((Object)key.getKeyCrypter().getUnderstoodEncryptionType()) + ". This WalletProtobufSerialiser does not understand that type of encryption.");
                }
                keyBuilder.setType(Protos.Key.Type.ENCRYPTED_SCRYPT_AES);
                keyBuilder.setEncryptedPrivateKey(encryptedKeyBuilder);
            }
            keyBuilder.setPublicKey(ByteString.copyFrom((byte[])key.getPubKey()));
            walletBuilder.addKey(keyBuilder);
        }
        for (Script script : wallet.getWatchedScripts()) {
            Protos.Script protoScript = Protos.Script.newBuilder().setProgram(ByteString.copyFrom((byte[])script.getProgram())).setCreationTimestamp(script.getCreationTimeSeconds() * 1000L).build();
            walletBuilder.addWatchedScript(protoScript);
        }
        Sha256Hash lastSeenBlockHash = wallet.getLastBlockSeenHash();
        if (lastSeenBlockHash != null) {
            walletBuilder.setLastSeenBlockHash(WalletProtobufSerializer.hashToByteString(lastSeenBlockHash));
            walletBuilder.setLastSeenBlockHeight(wallet.getLastBlockSeenHeight());
        }
        if (wallet.getLastBlockSeenTimeSecs() > 0L) {
            walletBuilder.setLastSeenBlockTimeSecs(wallet.getLastBlockSeenTimeSecs());
        }
        if ((keyCrypter = wallet.getKeyCrypter()) == null) {
            walletBuilder.setEncryptionType(Protos.Wallet.EncryptionType.UNENCRYPTED);
        } else {
            walletBuilder.setEncryptionType(keyCrypter.getUnderstoodEncryptionType());
            if (keyCrypter instanceof KeyCrypterScrypt) {
                KeyCrypterScrypt keyCrypterScrypt = (KeyCrypterScrypt)keyCrypter;
                walletBuilder.setEncryptionParameters(keyCrypterScrypt.getScryptParameters());
            } else {
                throw new RuntimeException("The wallet has encryption of type '" + (Object)((Object)keyCrypter.getUnderstoodEncryptionType()) + "' but this WalletProtobufSerializer does not know how to persist this.");
            }
        }
        if (wallet.getKeyRotationTime() != null) {
            long timeSecs = wallet.getKeyRotationTime().getTime() / 1000L;
            walletBuilder.setKeyRotationTime(timeSecs);
        }
        WalletProtobufSerializer.populateExtensions(wallet, walletBuilder);
        walletBuilder.setVersion(wallet.getVersion());
        return walletBuilder.build();
    }

    private static void populateExtensions(Wallet wallet, Protos.Wallet.Builder walletBuilder) {
        for (WalletExtension extension : wallet.getExtensions().values()) {
            Protos.Extension.Builder proto = Protos.Extension.newBuilder();
            proto.setId(extension.getWalletExtensionID());
            proto.setMandatory(extension.isWalletExtensionMandatory());
            proto.setData(ByteString.copyFrom((byte[])extension.serializeWalletExtension()));
            walletBuilder.addExtension(proto);
        }
    }

    private static Protos.Transaction makeTxProto(WalletTransaction wtx) {
        Protos.Transaction.Purpose purpose;
        Transaction tx = wtx.getTransaction();
        Protos.Transaction.Builder txBuilder = Protos.Transaction.newBuilder();
        txBuilder.setPool(WalletProtobufSerializer.getProtoPool(wtx)).setHash(WalletProtobufSerializer.hashToByteString(tx.getHash())).setVersion((int)tx.getVersion());
        if (tx.getUpdateTime() != null) {
            txBuilder.setUpdatedAt(tx.getUpdateTime().getTime());
        }
        if (tx.getLockTime() > 0L) {
            txBuilder.setLockTime((int)tx.getLockTime());
        }
        for (TransactionInput input : tx.getInputs()) {
            Protos.TransactionInput.Builder inputBuilder = Protos.TransactionInput.newBuilder().setScriptBytes(ByteString.copyFrom((byte[])input.getScriptBytes())).setTransactionOutPointHash(WalletProtobufSerializer.hashToByteString(input.getOutpoint().getHash())).setTransactionOutPointIndex((int)input.getOutpoint().getIndex());
            if (input.hasSequence()) {
                inputBuilder.setSequence((int)input.getSequenceNumber());
            }
            txBuilder.addTransactionInput(inputBuilder);
        }
        for (TransactionOutput output : tx.getOutputs()) {
            Protos.TransactionOutput.Builder outputBuilder = Protos.TransactionOutput.newBuilder().setScriptBytes(ByteString.copyFrom((byte[])output.getScriptBytes())).setValue(output.getValue().longValue());
            TransactionInput spentBy = output.getSpentBy();
            if (spentBy != null) {
                Sha256Hash spendingHash = spentBy.getParentTransaction().getHash();
                int spentByTransactionIndex = spentBy.getParentTransaction().getInputs().indexOf(spentBy);
                outputBuilder.setSpentByTransactionHash(WalletProtobufSerializer.hashToByteString(spendingHash)).setSpentByTransactionIndex(spentByTransactionIndex);
            }
            txBuilder.addTransactionOutput(outputBuilder);
        }
        Map<Sha256Hash, Integer> appearsInHashes = tx.getAppearsInHashes();
        if (appearsInHashes != null) {
            for (Map.Entry<Sha256Hash, Integer> entry : appearsInHashes.entrySet()) {
                txBuilder.addBlockHash(WalletProtobufSerializer.hashToByteString(entry.getKey()));
                txBuilder.addBlockRelativityOffsets(entry.getValue());
            }
        }
        if (tx.hasConfidence()) {
            TransactionConfidence confidence = tx.getConfidence();
            Protos.TransactionConfidence.Builder confidenceBuilder = Protos.TransactionConfidence.newBuilder();
            WalletProtobufSerializer.writeConfidence(txBuilder, confidence, confidenceBuilder);
        }
        switch (tx.getPurpose()) {
            case UNKNOWN: {
                purpose = Protos.Transaction.Purpose.UNKNOWN;
                break;
            }
            case USER_PAYMENT: {
                purpose = Protos.Transaction.Purpose.USER_PAYMENT;
                break;
            }
            case KEY_ROTATION: {
                purpose = Protos.Transaction.Purpose.KEY_ROTATION;
                break;
            }
            default: {
                throw new RuntimeException("New tx purpose serialization not implemented.");
            }
        }
        txBuilder.setPurpose(purpose);
        return txBuilder.build();
    }

    private static Protos.Transaction.Pool getProtoPool(WalletTransaction wtx) {
        switch (wtx.getPool()) {
            case UNSPENT: {
                return Protos.Transaction.Pool.UNSPENT;
            }
            case SPENT: {
                return Protos.Transaction.Pool.SPENT;
            }
            case DEAD: {
                return Protos.Transaction.Pool.DEAD;
            }
            case PENDING: {
                return Protos.Transaction.Pool.PENDING;
            }
        }
        throw new RuntimeException("Unreachable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeConfidence(Protos.Transaction.Builder txBuilder, TransactionConfidence confidence, Protos.TransactionConfidence.Builder confidenceBuilder) {
        TransactionConfidence transactionConfidence = confidence;
        synchronized (transactionConfidence) {
            confidenceBuilder.setType(Protos.TransactionConfidence.Type.valueOf(confidence.getConfidenceType().getValue()));
            if (confidence.getConfidenceType() == TransactionConfidence.ConfidenceType.BUILDING) {
                confidenceBuilder.setAppearedAtHeight(confidence.getAppearedAtChainHeight());
                confidenceBuilder.setDepth(confidence.getDepthInBlocks());
                if (confidence.getWorkDone() != null) {
                    confidenceBuilder.setWorkDone(confidence.getWorkDone().longValue());
                }
            }
            if (confidence.getConfidenceType() == TransactionConfidence.ConfidenceType.DEAD && confidence.getOverridingTransaction() != null) {
                Sha256Hash overridingHash = confidence.getOverridingTransaction().getHash();
                confidenceBuilder.setOverridingTransaction(WalletProtobufSerializer.hashToByteString(overridingHash));
            }
            TransactionConfidence.Source source = confidence.getSource();
            switch (source) {
                case SELF: {
                    confidenceBuilder.setSource(Protos.TransactionConfidence.Source.SOURCE_SELF);
                    break;
                }
                case NETWORK: {
                    confidenceBuilder.setSource(Protos.TransactionConfidence.Source.SOURCE_NETWORK);
                    break;
                }
                default: {
                    confidenceBuilder.setSource(Protos.TransactionConfidence.Source.SOURCE_UNKNOWN);
                }
            }
        }
        ListIterator<PeerAddress> it = confidence.getBroadcastBy();
        while (it.hasNext()) {
            PeerAddress address = it.next();
            Protos.PeerAddress proto = Protos.PeerAddress.newBuilder().setIpAddress(ByteString.copyFrom((byte[])address.getAddr().getAddress())).setPort(address.getPort()).setServices(address.getServices().longValue()).build();
            confidenceBuilder.addBroadcastBy(proto);
        }
        txBuilder.setConfidence(confidenceBuilder);
    }

    public static ByteString hashToByteString(Sha256Hash hash) {
        return ByteString.copyFrom((byte[])hash.getBytes());
    }

    public static Sha256Hash byteStringToHash(ByteString bs) {
        return new Sha256Hash(bs.toByteArray());
    }

    public Wallet readWallet(InputStream input) throws UnreadableWalletException {
        try {
            Protos.Wallet walletProto = WalletProtobufSerializer.parseToProto(input);
            String paramsID = walletProto.getNetworkIdentifier();
            NetworkParameters params = NetworkParameters.fromID(paramsID);
            if (params == null) {
                throw new UnreadableWalletException("Unknown network parameters ID " + paramsID);
            }
            Wallet wallet = new Wallet(params);
            this.readWallet(walletProto, wallet);
            return wallet;
        }
        catch (IOException e) {
            throw new UnreadableWalletException("Could not parse input stream to protobuf", e);
        }
    }

    public void readWallet(Protos.Wallet walletProto, Wallet wallet) throws UnreadableWalletException {
        if (walletProto.hasEncryptionParameters()) {
            Protos.ScryptParameters encryptionParameters = walletProto.getEncryptionParameters();
            wallet.setKeyCrypter(new KeyCrypterScrypt(encryptionParameters));
        }
        if (walletProto.hasDescription()) {
            wallet.setDescription(walletProto.getDescription());
        }
        for (Protos.Key keyProto : walletProto.getKeyList()) {
            if (keyProto.getType() != Protos.Key.Type.ORIGINAL && keyProto.getType() != Protos.Key.Type.ENCRYPTED_SCRYPT_AES) {
                throw new UnreadableWalletException("Unknown key type in wallet, type = " + (Object)((Object)keyProto.getType()));
            }
            byte[] privKey = keyProto.hasPrivateKey() ? keyProto.getPrivateKey().toByteArray() : null;
            EncryptedPrivateKey encryptedPrivateKey = null;
            if (keyProto.hasEncryptedPrivateKey()) {
                Protos.EncryptedPrivateKey encryptedPrivateKeyProto = keyProto.getEncryptedPrivateKey();
                encryptedPrivateKey = new EncryptedPrivateKey(encryptedPrivateKeyProto.getInitialisationVector().toByteArray(), encryptedPrivateKeyProto.getEncryptedPrivateKey().toByteArray());
            }
            byte[] pubKey = keyProto.hasPublicKey() ? keyProto.getPublicKey().toByteArray() : null;
            KeyCrypter keyCrypter = wallet.getKeyCrypter();
            ECKey ecKey = keyCrypter != null && keyCrypter.getUnderstoodEncryptionType() != Protos.Wallet.EncryptionType.UNENCRYPTED ? new ECKey(encryptedPrivateKey, pubKey, keyCrypter) : new ECKey(privKey, pubKey);
            ecKey.setCreationTimeSeconds((keyProto.getCreationTimestamp() + 500L) / 1000L);
            wallet.addKey(ecKey);
        }
        ArrayList scripts = Lists.newArrayList();
        for (Protos.Script protoScript : walletProto.getWatchedScriptList()) {
            try {
                Script script = new Script(protoScript.getProgram().toByteArray(), protoScript.getCreationTimestamp() / 1000L);
                scripts.add(script);
            }
            catch (ScriptException e) {
                throw new UnreadableWalletException("Unparseable script in wallet");
            }
        }
        wallet.addWatchedScripts(scripts);
        for (Protos.Transaction txProto : walletProto.getTransactionList()) {
            this.readTransaction(txProto, wallet.getParams());
        }
        for (Protos.Transaction txProto : walletProto.getTransactionList()) {
            WalletTransaction wtx = this.connectTransactionOutputs(txProto);
            wallet.addWalletTransaction(wtx);
        }
        if (!walletProto.hasLastSeenBlockHash()) {
            wallet.setLastBlockSeenHash(null);
        } else {
            wallet.setLastBlockSeenHash(WalletProtobufSerializer.byteStringToHash(walletProto.getLastSeenBlockHash()));
        }
        if (!walletProto.hasLastSeenBlockHeight()) {
            wallet.setLastBlockSeenHeight(-1);
        } else {
            wallet.setLastBlockSeenHeight(walletProto.getLastSeenBlockHeight());
        }
        wallet.setLastBlockSeenTimeSecs(walletProto.getLastSeenBlockTimeSecs());
        if (walletProto.hasKeyRotationTime()) {
            wallet.setKeyRotationTime(new Date(walletProto.getKeyRotationTime() * 1000L));
        }
        this.loadExtensions(wallet, walletProto);
        if (walletProto.hasVersion()) {
            wallet.setVersion(walletProto.getVersion());
        }
        this.txMap.clear();
    }

    private void loadExtensions(Wallet wallet, Protos.Wallet walletProto) throws UnreadableWalletException {
        Map<String, WalletExtension> extensions = wallet.getExtensions();
        for (Protos.Extension extProto : walletProto.getExtensionList()) {
            String id = extProto.getId();
            WalletExtension extension = extensions.get(id);
            if (extension == null) {
                if (!extProto.getMandatory()) continue;
                if (this.requireMandatoryExtensions) {
                    throw new UnreadableWalletException("Unknown mandatory extension in wallet: " + id);
                }
                log.error("Unknown extension in wallet {}, ignoring", (Object)id);
                continue;
            }
            log.info("Loading wallet extension {}", (Object)id);
            try {
                extension.deserializeWalletExtension(wallet, extProto.getData().toByteArray());
            }
            catch (Exception e) {
                if (extProto.getMandatory() && this.requireMandatoryExtensions) {
                    throw new UnreadableWalletException("Could not parse mandatory extension in wallet: " + id);
                }
                log.error("Error whilst reading extension {}, ignoring: {}", (Object)id, (Object)e);
            }
        }
    }

    public static Protos.Wallet parseToProto(InputStream input) throws IOException {
        return Protos.Wallet.parseFrom(input);
    }

    private void readTransaction(Protos.Transaction txProto, NetworkParameters params) throws UnreadableWalletException {
        Transaction tx;
        block15: {
            block14: {
                tx = new Transaction(params);
                if (txProto.hasUpdatedAt()) {
                    tx.setUpdateTime(new Date(txProto.getUpdatedAt()));
                }
                for (Protos.TransactionOutput outputProto : txProto.getTransactionOutputList()) {
                    BigInteger value = BigInteger.valueOf(outputProto.getValue());
                    byte[] scriptBytes = outputProto.getScriptBytes().toByteArray();
                    TransactionOutput output = new TransactionOutput(params, tx, value, scriptBytes);
                    tx.addOutput(output);
                }
                for (Protos.TransactionInput transactionInput : txProto.getTransactionInputList()) {
                    byte[] scriptBytes = transactionInput.getScriptBytes().toByteArray();
                    TransactionOutPoint outpoint = new TransactionOutPoint(params, (long)transactionInput.getTransactionOutPointIndex() & 0xFFFFFFFFL, WalletProtobufSerializer.byteStringToHash(transactionInput.getTransactionOutPointHash()));
                    TransactionInput input = new TransactionInput(params, tx, scriptBytes, outpoint);
                    if (transactionInput.hasSequence()) {
                        input.setSequenceNumber(transactionInput.getSequence());
                    }
                    tx.addInput(input);
                }
                for (int i = 0; i < txProto.getBlockHashCount(); ++i) {
                    ByteString blockHash = txProto.getBlockHash(i);
                    int relativityOffset = 0;
                    if (txProto.getBlockRelativityOffsetsCount() > 0) {
                        relativityOffset = txProto.getBlockRelativityOffsets(i);
                    }
                    tx.addBlockAppearance(WalletProtobufSerializer.byteStringToHash(blockHash), relativityOffset);
                }
                if (txProto.hasLockTime()) {
                    tx.setLockTime(0xFFFFFFFFL & (long)txProto.getLockTime());
                }
                if (!txProto.hasPurpose()) break block14;
                switch (txProto.getPurpose()) {
                    case UNKNOWN: {
                        tx.setPurpose(Transaction.Purpose.UNKNOWN);
                        break block15;
                    }
                    case USER_PAYMENT: {
                        tx.setPurpose(Transaction.Purpose.USER_PAYMENT);
                        break block15;
                    }
                    case KEY_ROTATION: {
                        tx.setPurpose(Transaction.Purpose.KEY_ROTATION);
                        break block15;
                    }
                    default: {
                        throw new RuntimeException("New purpose serialization not implemented");
                    }
                }
            }
            tx.setPurpose(Transaction.Purpose.USER_PAYMENT);
        }
        Sha256Hash protoHash = WalletProtobufSerializer.byteStringToHash(txProto.getHash());
        if (!tx.getHash().equals(protoHash)) {
            throw new UnreadableWalletException(String.format("Transaction did not deserialize completely: %s vs %s", tx.getHash(), protoHash));
        }
        if (this.txMap.containsKey(txProto.getHash())) {
            throw new UnreadableWalletException("Wallet contained duplicate transaction " + WalletProtobufSerializer.byteStringToHash(txProto.getHash()));
        }
        this.txMap.put(txProto.getHash(), tx);
    }

    private WalletTransaction connectTransactionOutputs(Protos.Transaction txProto) throws UnreadableWalletException {
        WalletTransaction.Pool pool;
        Transaction tx = this.txMap.get(txProto.getHash());
        switch (txProto.getPool()) {
            case DEAD: {
                pool = WalletTransaction.Pool.DEAD;
                break;
            }
            case PENDING: {
                pool = WalletTransaction.Pool.PENDING;
                break;
            }
            case SPENT: {
                pool = WalletTransaction.Pool.SPENT;
                break;
            }
            case UNSPENT: {
                pool = WalletTransaction.Pool.UNSPENT;
                break;
            }
            case INACTIVE: 
            case PENDING_INACTIVE: {
                pool = WalletTransaction.Pool.PENDING;
                break;
            }
            default: {
                throw new UnreadableWalletException("Unknown transaction pool: " + (Object)((Object)txProto.getPool()));
            }
        }
        for (int i = 0; i < tx.getOutputs().size(); ++i) {
            TransactionOutput output = tx.getOutputs().get(i);
            Protos.TransactionOutput transactionOutput = txProto.getTransactionOutput(i);
            if (!transactionOutput.hasSpentByTransactionHash()) continue;
            ByteString spentByTransactionHash = transactionOutput.getSpentByTransactionHash();
            Transaction spendingTx = this.txMap.get(spentByTransactionHash);
            if (spendingTx == null) {
                throw new UnreadableWalletException(String.format("Could not connect %s to %s", tx.getHashAsString(), WalletProtobufSerializer.byteStringToHash(spentByTransactionHash)));
            }
            int spendingIndex = transactionOutput.getSpentByTransactionIndex();
            TransactionInput input = (TransactionInput)Preconditions.checkNotNull((Object)spendingTx.getInput(spendingIndex));
            input.connect(output);
        }
        if (txProto.hasConfidence()) {
            Protos.TransactionConfidence confidenceProto = txProto.getConfidence();
            TransactionConfidence confidence = tx.getConfidence();
            this.readConfidence(tx, confidenceProto, confidence);
        }
        return new WalletTransaction(pool, tx);
    }

    private void readConfidence(Transaction tx, Protos.TransactionConfidence confidenceProto, TransactionConfidence confidence) throws UnreadableWalletException {
        TransactionConfidence.ConfidenceType confidenceType;
        if (!confidenceProto.hasType()) {
            log.warn("Unknown confidence type for tx {}", (Object)tx.getHashAsString());
            return;
        }
        switch (confidenceProto.getType()) {
            case BUILDING: {
                confidenceType = TransactionConfidence.ConfidenceType.BUILDING;
                break;
            }
            case DEAD: {
                confidenceType = TransactionConfidence.ConfidenceType.DEAD;
                break;
            }
            case NOT_IN_BEST_CHAIN: {
                confidenceType = TransactionConfidence.ConfidenceType.PENDING;
                break;
            }
            case PENDING: {
                confidenceType = TransactionConfidence.ConfidenceType.PENDING;
                break;
            }
            default: {
                confidenceType = TransactionConfidence.ConfidenceType.UNKNOWN;
            }
        }
        confidence.setConfidenceType(confidenceType);
        if (confidenceProto.hasAppearedAtHeight()) {
            if (confidence.getConfidenceType() != TransactionConfidence.ConfidenceType.BUILDING) {
                log.warn("Have appearedAtHeight but not BUILDING for tx {}", (Object)tx.getHashAsString());
                return;
            }
            confidence.setAppearedAtChainHeight(confidenceProto.getAppearedAtHeight());
        }
        if (confidenceProto.hasDepth()) {
            if (confidence.getConfidenceType() != TransactionConfidence.ConfidenceType.BUILDING) {
                log.warn("Have depth but not BUILDING for tx {}", (Object)tx.getHashAsString());
                return;
            }
            confidence.setDepthInBlocks(confidenceProto.getDepth());
        }
        if (confidenceProto.hasWorkDone()) {
            if (confidence.getConfidenceType() != TransactionConfidence.ConfidenceType.BUILDING) {
                log.warn("Have workDone but not BUILDING for tx {}", (Object)tx.getHashAsString());
                return;
            }
            confidence.setWorkDone(BigInteger.valueOf(confidenceProto.getWorkDone()));
        }
        if (confidenceProto.hasOverridingTransaction()) {
            if (confidence.getConfidenceType() != TransactionConfidence.ConfidenceType.DEAD) {
                log.warn("Have overridingTransaction but not OVERRIDDEN for tx {}", (Object)tx.getHashAsString());
                return;
            }
            Transaction overridingTransaction = this.txMap.get(confidenceProto.getOverridingTransaction());
            if (overridingTransaction == null) {
                log.warn("Have overridingTransaction that is not in wallet for tx {}", (Object)tx.getHashAsString());
                return;
            }
            confidence.setOverridingTransaction(overridingTransaction);
        }
        for (Protos.PeerAddress proto : confidenceProto.getBroadcastByList()) {
            InetAddress ip;
            try {
                ip = InetAddress.getByAddress(proto.getIpAddress().toByteArray());
            }
            catch (UnknownHostException e) {
                throw new UnreadableWalletException("Peer IP address does not have the right length", e);
            }
            int port = proto.getPort();
            PeerAddress address = new PeerAddress(ip, port);
            address.setServices(BigInteger.valueOf(proto.getServices()));
            confidence.markBroadcastBy(address);
        }
        switch (confidenceProto.getSource()) {
            case SOURCE_SELF: {
                confidence.setSource(TransactionConfidence.Source.SELF);
                break;
            }
            case SOURCE_NETWORK: {
                confidence.setSource(TransactionConfidence.Source.NETWORK);
                break;
            }
            default: {
                confidence.setSource(TransactionConfidence.Source.UNKNOWN);
            }
        }
    }

    public static boolean isWallet(InputStream is) {
        try {
            CodedInputStream cis = CodedInputStream.newInstance((InputStream)is);
            int tag = cis.readTag();
            int field = WireFormat.getTagFieldNumber((int)tag);
            if (field != 1) {
                return false;
            }
            String network = cis.readString();
            return NetworkParameters.fromID(network) != null;
        }
        catch (IOException x) {
            return false;
        }
    }
}

