/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.store;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;

class TransactionalHashMap<KeyType, ValueType> {
    ThreadLocal<HashMap<KeyType, ValueType>> tempMap = new ThreadLocal();
    ThreadLocal<HashSet<KeyType>> tempSetRemoved = new ThreadLocal();
    private ThreadLocal<Boolean> inTransaction = new ThreadLocal();
    HashMap<KeyType, ValueType> map = new HashMap();

    public void beginDatabaseBatchWrite() {
        this.inTransaction.set(true);
    }

    public void commitDatabaseBatchWrite() {
        if (this.tempSetRemoved.get() != null) {
            for (KeyType KeyType : this.tempSetRemoved.get()) {
                this.map.remove(KeyType);
            }
        }
        if (this.tempMap.get() != null) {
            for (Map.Entry entry : this.tempMap.get().entrySet()) {
                this.map.put(entry.getKey(), entry.getValue());
            }
        }
        this.abortDatabaseBatchWrite();
    }

    public void abortDatabaseBatchWrite() {
        this.inTransaction.set(false);
        this.tempSetRemoved.remove();
        this.tempMap.remove();
    }

    @Nullable
    public ValueType get(KeyType key) {
        if (Boolean.TRUE.equals(this.inTransaction.get())) {
            ValueType value;
            if (this.tempMap.get() != null && (value = this.tempMap.get().get(key)) != null) {
                return value;
            }
            if (this.tempSetRemoved.get() != null && this.tempSetRemoved.get().contains(key)) {
                return null;
            }
        }
        return this.map.get(key);
    }

    public void put(KeyType key, ValueType value) {
        if (Boolean.TRUE.equals(this.inTransaction.get())) {
            if (this.tempSetRemoved.get() != null) {
                this.tempSetRemoved.get().remove(key);
            }
            if (this.tempMap.get() == null) {
                this.tempMap.set(new HashMap());
            }
            this.tempMap.get().put(key, value);
        } else {
            this.map.put(key, value);
        }
    }

    @Nullable
    public ValueType remove(KeyType key) {
        if (Boolean.TRUE.equals(this.inTransaction.get())) {
            ValueType tempVal;
            ValueType retVal = this.map.get(key);
            if (retVal != null) {
                if (this.tempSetRemoved.get() == null) {
                    this.tempSetRemoved.set(new HashSet());
                }
                this.tempSetRemoved.get().add(key);
            }
            if (this.tempMap.get() != null && (tempVal = this.tempMap.get().remove(key)) != null) {
                return tempVal;
            }
            return retVal;
        }
        return this.map.remove(key);
    }
}

