/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.store;

import com.google.bitcoin.core.Sha256Hash;
import com.google.bitcoin.core.StoredTransactionOutput;
import com.google.common.base.Objects;
import java.io.Serializable;

class StoredTransactionOutPoint
implements Serializable {
    private static final long serialVersionUID = -4064230006297064377L;
    Sha256Hash hash;
    long index;

    StoredTransactionOutPoint(Sha256Hash hash, long index) {
        this.hash = hash;
        this.index = index;
    }

    StoredTransactionOutPoint(StoredTransactionOutput out) {
        this.hash = out.getHash();
        this.index = out.getIndex();
    }

    Sha256Hash getHash() {
        return this.hash;
    }

    long getIndex() {
        return this.index;
    }

    public int hashCode() {
        return this.hash.hashCode() + (int)this.index;
    }

    public String toString() {
        return "Stored transaction out point: " + this.hash.toString() + ":" + this.index;
    }

    public boolean equals(Object o) {
        if (!(o instanceof StoredTransactionOutPoint)) {
            return false;
        }
        return ((StoredTransactionOutPoint)o).getIndex() == this.index && Objects.equal((Object)this.getHash(), (Object)((StoredTransactionOutPoint)o).getHash());
    }
}

