/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.script;

import com.google.bitcoin.core.Utils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class ScriptChunk {
    private boolean isOpCode;
    public final byte[] data;
    private int startLocationInProgram;

    public ScriptChunk(boolean isOpCode, byte[] data) {
        this(isOpCode, data, -1);
    }

    public ScriptChunk(boolean isOpCode, byte[] data, int startLocationInProgram) {
        this.isOpCode = isOpCode;
        this.data = data;
        this.startLocationInProgram = startLocationInProgram;
    }

    public boolean equalsOpCode(int opCode) {
        return this.isOpCode && this.data.length == 1 && (0xFF & this.data[0]) == opCode;
    }

    public boolean isOpCode() {
        return this.isOpCode;
    }

    public int getStartLocationInProgram() {
        Preconditions.checkState((this.startLocationInProgram >= 0 ? 1 : 0) != 0);
        return this.startLocationInProgram;
    }

    public void write(OutputStream stream) throws IOException {
        if (this.isOpCode) {
            Preconditions.checkState((this.data.length == 1 ? 1 : 0) != 0);
            stream.write(this.data);
        } else {
            Preconditions.checkState(((long)this.data.length <= 520L ? 1 : 0) != 0);
            if (this.data.length < 76) {
                stream.write(this.data.length);
            } else if (this.data.length <= 255) {
                stream.write(76);
                stream.write(this.data.length);
            } else if (this.data.length <= 65535) {
                stream.write(77);
                stream.write(0xFF & this.data.length);
                stream.write(0xFF & this.data.length >> 8);
            } else {
                stream.write(78);
                Utils.uint32ToByteStreamLE(this.data.length, stream);
            }
            stream.write(this.data);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptChunk chunk = (ScriptChunk)o;
        if (this.isOpCode != chunk.isOpCode) {
            return false;
        }
        if (this.startLocationInProgram != chunk.startLocationInProgram) {
            return false;
        }
        return Arrays.equals(this.data, chunk.data);
    }

    public int hashCode() {
        int result = this.isOpCode ? 1 : 0;
        result = 31 * result + (this.data != null ? Arrays.hashCode(this.data) : 0);
        result = 31 * result + this.startLocationInProgram;
        return result;
    }
}

