/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.script;

import com.google.bitcoin.core.Address;
import com.google.bitcoin.core.ECKey;
import com.google.bitcoin.crypto.TransactionSignature;
import com.google.bitcoin.script.Script;
import com.google.bitcoin.script.ScriptChunk;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ScriptBuilder {
    private List<ScriptChunk> chunks = Lists.newLinkedList();

    public ScriptBuilder op(int opcode) {
        this.chunks.add(new ScriptChunk(true, new byte[]{(byte)opcode}));
        return this;
    }

    public ScriptBuilder data(byte[] data) {
        byte[] copy = Arrays.copyOf(data, data.length);
        this.chunks.add(new ScriptChunk(false, copy));
        return this;
    }

    public ScriptBuilder smallNum(int num) {
        Preconditions.checkArgument((num >= 0 ? 1 : 0) != 0, (Object)"Cannot encode negative numbers with smallNum");
        Preconditions.checkArgument((num <= 16 ? 1 : 0) != 0, (Object)"Cannot encode numbers larger than 16 with smallNum");
        this.chunks.add(new ScriptChunk(true, new byte[]{(byte)Script.encodeToOpN(num)}));
        return this;
    }

    public Script build() {
        return new Script(this.chunks);
    }

    public static Script createOutputScript(Address to) {
        if (to.isP2SHAddress()) {
            return new ScriptBuilder().op(169).data(to.getHash160()).op(135).build();
        }
        return new ScriptBuilder().op(118).op(169).data(to.getHash160()).op(136).op(172).build();
    }

    public static Script createOutputScript(ECKey key) {
        return new ScriptBuilder().data(key.getPubKey()).op(172).build();
    }

    public static Script createInputScript(TransactionSignature signature, ECKey pubKey) {
        byte[] pubkeyBytes = pubKey.getPubKey();
        return new ScriptBuilder().data(signature.encodeToBitcoin()).data(pubkeyBytes).build();
    }

    public static Script createInputScript(TransactionSignature signature) {
        return new ScriptBuilder().data(signature.encodeToBitcoin()).build();
    }

    public static Script createMultiSigOutputScript(int threshold, List<ECKey> pubkeys) {
        Preconditions.checkArgument((threshold > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((threshold <= pubkeys.size() ? 1 : 0) != 0);
        Preconditions.checkArgument((pubkeys.size() <= 16 ? 1 : 0) != 0);
        ScriptBuilder builder = new ScriptBuilder();
        builder.smallNum(threshold);
        for (ECKey key : pubkeys) {
            builder.data(key.getPubKey());
        }
        builder.smallNum(pubkeys.size());
        builder.op(174);
        return builder.build();
    }

    public static Script createMultiSigInputScript(List<TransactionSignature> signatures) {
        ArrayList<byte[]> sigs = new ArrayList<byte[]>(signatures.size());
        for (TransactionSignature signature : signatures) {
            sigs.add(signature.encodeToBitcoin());
        }
        return ScriptBuilder.createMultiSigInputScriptBytes(sigs);
    }

    public static Script createMultiSigInputScript(TransactionSignature ... signatures) {
        return ScriptBuilder.createMultiSigInputScript(Arrays.asList(signatures));
    }

    public static Script createMultiSigInputScriptBytes(List<byte[]> signatures) {
        Preconditions.checkArgument((signatures.size() <= 16 ? 1 : 0) != 0);
        ScriptBuilder builder = new ScriptBuilder();
        builder.smallNum(0);
        for (byte[] signature : signatures) {
            builder.data(signature);
        }
        return builder.build();
    }

    public static Script createP2SHOutputScript(byte[] hash) {
        Preconditions.checkArgument((hash.length == 20 ? 1 : 0) != 0);
        return new ScriptBuilder().op(169).data(hash).op(135).build();
    }
}

