/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.protocols.payments;

import com.google.bitcoin.core.Address;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.TransactionOutput;
import com.google.bitcoin.core.VerificationException;
import com.google.bitcoin.core.Wallet;
import com.google.bitcoin.params.MainNetParams;
import com.google.bitcoin.protocols.payments.PaymentRequestException;
import com.google.bitcoin.script.ScriptBuilder;
import com.google.bitcoin.uri.BitcoinURI;
import com.google.bitcoin.utils.Threading;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import javax.security.auth.x500.X500Principal;
import org.bitcoin.protocols.payments.Protos;
import org.spongycastle.asn1.ASN1String;
import org.spongycastle.asn1.x500.AttributeTypeAndValue;
import org.spongycastle.asn1.x500.RDN;
import org.spongycastle.asn1.x500.X500Name;
import org.spongycastle.asn1.x500.style.RFC4519Style;

public class PaymentSession {
    private static ListeningExecutorService executor = Threading.THREAD_POOL;
    private NetworkParameters params;
    private String trustStorePath;
    private Protos.PaymentRequest paymentRequest;
    private Protos.PaymentDetails paymentDetails;
    private BigInteger totalValue = BigInteger.ZERO;
    public PkiVerificationData pkiVerificationData;

    public static ListenableFuture<PaymentSession> createFromBitcoinUri(BitcoinURI uri) throws PaymentRequestException {
        return PaymentSession.createFromBitcoinUri(uri, true, null);
    }

    public static ListenableFuture<PaymentSession> createFromBitcoinUri(BitcoinURI uri, boolean verifyPki) throws PaymentRequestException {
        return PaymentSession.createFromBitcoinUri(uri, verifyPki, null);
    }

    public static ListenableFuture<PaymentSession> createFromBitcoinUri(BitcoinURI uri, boolean verifyPki, @Nullable String trustStorePath) throws PaymentRequestException {
        String url = uri.getPaymentRequestUrl();
        if (url == null) {
            throw new PaymentRequestException.InvalidPaymentRequestURL("No payment request URL (r= parameter) in BitcoinURI " + uri);
        }
        try {
            return PaymentSession.fetchPaymentRequest(new URI(url), verifyPki, trustStorePath);
        }
        catch (URISyntaxException e) {
            throw new PaymentRequestException.InvalidPaymentRequestURL(e);
        }
    }

    public static ListenableFuture<PaymentSession> createFromUrl(String url) throws PaymentRequestException {
        return PaymentSession.createFromUrl(url, true, null);
    }

    public static ListenableFuture<PaymentSession> createFromUrl(String url, boolean verifyPki) throws PaymentRequestException {
        return PaymentSession.createFromUrl(url, verifyPki, null);
    }

    public static ListenableFuture<PaymentSession> createFromUrl(String url, boolean verifyPki, @Nullable String trustStorePath) throws PaymentRequestException {
        if (url == null) {
            throw new PaymentRequestException.InvalidPaymentRequestURL("null paymentRequestUrl");
        }
        try {
            return PaymentSession.fetchPaymentRequest(new URI(url), verifyPki, trustStorePath);
        }
        catch (URISyntaxException e) {
            throw new PaymentRequestException.InvalidPaymentRequestURL(e);
        }
    }

    private static ListenableFuture<PaymentSession> fetchPaymentRequest(final URI uri, final boolean verifyPki, final @Nullable String trustStorePath) {
        return executor.submit((Callable)new Callable<PaymentSession>(){

            @Override
            public PaymentSession call() throws Exception {
                HttpURLConnection connection = (HttpURLConnection)uri.toURL().openConnection();
                connection.setRequestProperty("Accept", "application/bitcoin-paymentrequest");
                connection.setUseCaches(false);
                Protos.PaymentRequest paymentRequest = Protos.PaymentRequest.parseFrom(connection.getInputStream());
                return new PaymentSession(paymentRequest, verifyPki, trustStorePath);
            }
        });
    }

    public PaymentSession(Protos.PaymentRequest request) throws PaymentRequestException {
        this.parsePaymentRequest(request);
        this.verifyPki();
    }

    public PaymentSession(Protos.PaymentRequest request, boolean verifyPki) throws PaymentRequestException {
        this.parsePaymentRequest(request);
        if (verifyPki) {
            this.verifyPki();
        }
    }

    public PaymentSession(Protos.PaymentRequest request, boolean verifyPki, @Nullable String trustStorePath) throws PaymentRequestException {
        this.trustStorePath = trustStorePath;
        this.parsePaymentRequest(request);
        if (verifyPki) {
            this.verifyPki();
        }
    }

    @Nullable
    public String getMemo() {
        if (this.paymentDetails.hasMemo()) {
            return this.paymentDetails.getMemo();
        }
        return null;
    }

    public BigInteger getValue() {
        return this.totalValue;
    }

    public Date getDate() {
        return new Date(this.paymentDetails.getTime() * 1000L);
    }

    public boolean isExpired() {
        return this.paymentDetails.hasExpires() && System.currentTimeMillis() / 1000L > this.paymentDetails.getExpires();
    }

    @Nullable
    public String getPaymentUrl() {
        if (this.paymentDetails.hasPaymentUrl()) {
            return this.paymentDetails.getPaymentUrl();
        }
        return null;
    }

    public Wallet.SendRequest getSendRequest() {
        Transaction tx = new Transaction(this.params);
        for (Protos.Output output : this.paymentDetails.getOutputsList()) {
            tx.addOutput(new TransactionOutput(this.params, tx, BigInteger.valueOf(output.getAmount()), output.getScript().toByteArray()));
        }
        return Wallet.SendRequest.forTx(tx);
    }

    @Nullable
    public ListenableFuture<Ack> sendPayment(List<Transaction> txns, @Nullable Address refundAddr, @Nullable String memo) throws PaymentRequestException, VerificationException, IOException {
        URL url;
        Protos.Payment payment = this.getPayment(txns, refundAddr, memo);
        if (payment == null) {
            return null;
        }
        if (this.isExpired()) {
            throw new PaymentRequestException.Expired("PaymentRequest is expired");
        }
        try {
            url = new URL(this.paymentDetails.getPaymentUrl());
        }
        catch (MalformedURLException e) {
            throw new PaymentRequestException.InvalidPaymentURL(e);
        }
        return this.sendPayment(url, payment);
    }

    @Nullable
    public Protos.Payment getPayment(List<Transaction> txns, @Nullable Address refundAddr, @Nullable String memo) throws IOException {
        if (!this.paymentDetails.hasPaymentUrl()) {
            return null;
        }
        Protos.Payment.Builder payment = Protos.Payment.newBuilder();
        if (this.paymentDetails.hasMerchantData()) {
            payment.setMerchantData(this.paymentDetails.getMerchantData());
        }
        if (refundAddr != null) {
            Protos.Output.Builder refundOutput = Protos.Output.newBuilder();
            refundOutput.setAmount(this.totalValue.longValue());
            refundOutput.setScript(ByteString.copyFrom((byte[])ScriptBuilder.createOutputScript(refundAddr).getProgram()));
            payment.addRefundTo(refundOutput);
        }
        if (memo != null) {
            payment.setMemo(memo);
        }
        for (Transaction txn : txns) {
            txn.verify();
            ByteArrayOutputStream o = new ByteArrayOutputStream();
            txn.bitcoinSerialize(o);
            payment.addTransactions(ByteString.copyFrom((byte[])o.toByteArray()));
        }
        return payment.build();
    }

    @VisibleForTesting
    protected ListenableFuture<Ack> sendPayment(final URL url, final Protos.Payment payment) {
        return executor.submit((Callable)new Callable<Ack>(){

            @Override
            public Ack call() throws Exception {
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/bitcoin-payment");
                connection.setRequestProperty("Accept", "application/bitcoin-paymentack");
                connection.setRequestProperty("Content-Length", Integer.toString(payment.getSerializedSize()));
                connection.setUseCaches(false);
                connection.setDoInput(true);
                connection.setDoOutput(true);
                DataOutputStream outStream = new DataOutputStream(connection.getOutputStream());
                payment.writeTo(outStream);
                outStream.flush();
                outStream.close();
                InputStream inStream = connection.getInputStream();
                Protos.PaymentACK.Builder paymentAckBuilder = (Protos.PaymentACK.Builder)Protos.PaymentACK.newBuilder().mergeFrom(inStream);
                Protos.PaymentACK paymentAck = paymentAckBuilder.build();
                String memo = null;
                if (paymentAck.hasMemo()) {
                    memo = paymentAck.getMemo();
                }
                return new Ack(memo);
            }
        });
    }

    @Nullable
    public PkiVerificationData verifyPki() throws PaymentRequestException {
        try {
            PkiVerificationData data;
            String algorithm;
            if (this.pkiVerificationData != null) {
                return this.pkiVerificationData;
            }
            if (this.paymentRequest.getPkiType().equals("none")) {
                return null;
            }
            if (this.paymentRequest.getPkiType().equals("x509+sha256")) {
                algorithm = "SHA256withRSA";
            } else if (this.paymentRequest.getPkiType().equals("x509+sha1")) {
                algorithm = "SHA1withRSA";
            } else {
                throw new PaymentRequestException.InvalidPkiType("Unsupported PKI type: " + this.paymentRequest.getPkiType());
            }
            Protos.X509Certificates protoCerts = Protos.X509Certificates.parseFrom(this.paymentRequest.getPkiData());
            if (protoCerts.getCertificateCount() == 0) {
                throw new PaymentRequestException.InvalidPkiData("No certificates provided in message: server config error");
            }
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            ArrayList certs = Lists.newArrayList();
            for (ByteString bytes : protoCerts.getCertificateList()) {
                certs.add((X509Certificate)certificateFactory.generateCertificate(bytes.newInput()));
            }
            CertPath path = certificateFactory.generateCertPath(certs);
            PKIXParameters params = new PKIXParameters(this.createKeyStore(this.trustStorePath));
            params.setRevocationEnabled(false);
            CertPathValidator validator = CertPathValidator.getInstance("PKIX");
            PKIXCertPathValidatorResult result = (PKIXCertPathValidatorResult)validator.validate(path, params);
            PublicKey publicKey = result.getPublicKey();
            Signature signature = Signature.getInstance(algorithm);
            signature.initVerify(publicKey);
            Protos.PaymentRequest.Builder reqToCheck = this.paymentRequest.toBuilder();
            reqToCheck.setSignature(ByteString.EMPTY);
            signature.update(reqToCheck.build().toByteArray());
            if (!signature.verify(this.paymentRequest.getSignature().toByteArray())) {
                throw new PaymentRequestException.PkiVerificationException("Invalid signature, this payment request is not valid.");
            }
            X509Certificate cert = (X509Certificate)certs.get(0);
            X500Principal principal = cert.getSubjectX500Principal();
            X500Name name = new X500Name(principal.getName());
            String entityName = null;
            String orgName = null;
            for (RDN rdn : name.getRDNs()) {
                AttributeTypeAndValue pair = rdn.getFirst();
                if (pair.getType().equals((Object)RFC4519Style.cn)) {
                    entityName = ((ASN1String)pair.getValue()).getString();
                    continue;
                }
                if (!pair.getType().equals((Object)RFC4519Style.o)) continue;
                orgName = ((ASN1String)pair.getValue()).getString();
            }
            if (entityName == null && orgName == null) {
                List<?> list;
                Iterator<List<?>> it = cert.getSubjectAlternativeNames().iterator();
                if (it.hasNext() && (list = it.next()) != null && (Integer)list.get(0) == 1) {
                    entityName = (String)list.get(1);
                }
                if (entityName == null) {
                    throw new PaymentRequestException.PkiVerificationException("Could not extract name from certificate");
                }
            }
            this.pkiVerificationData = data = new PkiVerificationData(entityName, orgName, publicKey, result.getTrustAnchor());
            return data;
        }
        catch (InvalidProtocolBufferException e) {
            throw new PaymentRequestException.InvalidPkiData((Exception)((Object)e));
        }
        catch (CertificateException e) {
            throw new PaymentRequestException.PkiVerificationException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException(e);
        }
        catch (CertPathValidatorException e) {
            throw new PaymentRequestException.PkiVerificationException(e);
        }
        catch (InvalidKeyException e) {
            throw new PaymentRequestException.PkiVerificationException(e);
        }
        catch (SignatureException e) {
            throw new PaymentRequestException.PkiVerificationException(e);
        }
        catch (IOException e) {
            throw new PaymentRequestException.PkiVerificationException(e);
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(e);
        }
    }

    private KeyStore createKeyStore(@Nullable String path) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        String keyStoreType = KeyStore.getDefaultType();
        char[] defaultPassword = "changeit".toCharArray();
        if (path != null) {
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            FileInputStream is = new FileInputStream(path);
            keyStore.load(is, defaultPassword);
            return keyStore;
        }
        try {
            Class<?> version = Class.forName("android.os.Build$VERSION");
            if (version.getDeclaredField("SDK_INT").getInt(version) >= 14) {
                KeyStore keystore = KeyStore.getInstance("AndroidCAStore");
                keystore.load(null, null);
                return keystore;
            }
            keyStoreType = "BKS";
            path = System.getProperty("java.home") + "/etc/security/cacerts.bks".replace('/', File.separatorChar);
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (path == null) {
            path = System.getProperty("javax.net.ssl.trustStore");
        }
        if (path == null) {
            path = System.getProperty("java.home") + "/lib/security/cacerts".replace('/', File.separatorChar);
        }
        try {
            KeyStore keyStore = KeyStore.getInstance(keyStoreType);
            FileInputStream is = new FileInputStream(path);
            keyStore.load(is, defaultPassword);
            return keyStore;
        }
        catch (FileNotFoundException e) {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            InputStream is = this.getClass().getResourceAsStream("cacerts");
            keyStore.load(is, defaultPassword);
            return keyStore;
        }
    }

    private void parsePaymentRequest(Protos.PaymentRequest request) throws PaymentRequestException {
        try {
            if (request == null) {
                throw new PaymentRequestException("request cannot be null");
            }
            if (request.getPaymentDetailsVersion() != 1) {
                throw new PaymentRequestException.InvalidVersion("Version 1 required. Received version " + request.getPaymentDetailsVersion());
            }
            this.paymentRequest = request;
            if (!request.hasSerializedPaymentDetails()) {
                throw new PaymentRequestException("No PaymentDetails");
            }
            this.paymentDetails = ((Protos.PaymentDetails.Builder)Protos.PaymentDetails.newBuilder().mergeFrom(request.getSerializedPaymentDetails())).build();
            if (this.paymentDetails == null) {
                throw new PaymentRequestException("Invalid PaymentDetails");
            }
            this.params = !this.paymentDetails.hasNetwork() ? MainNetParams.get() : NetworkParameters.fromPmtProtocolID(this.paymentDetails.getNetwork());
            if (this.params == null) {
                throw new PaymentRequestException.InvalidNetwork("Invalid network " + this.paymentDetails.getNetwork());
            }
            if (this.paymentDetails.getOutputsCount() < 1) {
                throw new PaymentRequestException.InvalidOutputs("No outputs");
            }
            for (Protos.Output output : this.paymentDetails.getOutputsList()) {
                if (!output.hasAmount()) continue;
                this.totalValue = this.totalValue.add(BigInteger.valueOf(output.getAmount()));
            }
            if (this.totalValue.compareTo(NetworkParameters.MAX_MONEY) > 0) {
                throw new PaymentRequestException.InvalidOutputs("The outputs are way too big.");
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new PaymentRequestException((Exception)((Object)e));
        }
    }

    public Protos.PaymentRequest getPaymentRequest() {
        return this.paymentRequest;
    }

    public Protos.PaymentDetails getPaymentDetails() {
        return this.paymentDetails;
    }

    public static class PkiVerificationData {
        public final String name;
        public final String orgName;
        public final PublicKey merchantSigningKey;
        public final TrustAnchor rootAuthority;
        public final String rootAuthorityName;

        private PkiVerificationData(@Nullable String name, @Nullable String orgName, PublicKey merchantSigningKey, TrustAnchor rootAuthority) throws PaymentRequestException.PkiVerificationException {
            this.name = name;
            this.orgName = orgName;
            this.merchantSigningKey = merchantSigningKey;
            this.rootAuthority = rootAuthority;
            this.rootAuthorityName = this.getNameFromCert(rootAuthority);
        }

        @Nullable
        private String getNameFromCert(TrustAnchor rootAuthority) throws PaymentRequestException.PkiVerificationException {
            X500Name name = new X500Name(rootAuthority.getTrustedCert().getSubjectX500Principal().getName());
            String commonName = null;
            String org = null;
            String location = null;
            String country = null;
            for (RDN rdn : name.getRDNs()) {
                AttributeTypeAndValue pair = rdn.getFirst();
                String val = ((ASN1String)pair.getValue()).getString();
                if (pair.getType().equals((Object)RFC4519Style.cn)) {
                    commonName = val;
                    continue;
                }
                if (pair.getType().equals((Object)RFC4519Style.o)) {
                    org = val;
                    continue;
                }
                if (pair.getType().equals((Object)RFC4519Style.l)) {
                    location = val;
                    continue;
                }
                if (!pair.getType().equals((Object)RFC4519Style.c)) continue;
                country = val;
            }
            if (org != null) {
                return Joiner.on((String)", ").skipNulls().join(org, location, new Object[]{country});
            }
            return commonName;
        }
    }

    public class Ack {
        @Nullable
        private String memo;

        Ack(String memo) {
            this.memo = memo;
        }

        @Nullable
        public String getMemo() {
            return this.memo;
        }
    }
}

