/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.protocols.channels;

import com.google.bitcoin.core.ECKey;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.TransactionBroadcaster;
import com.google.bitcoin.core.TransactionOutput;
import com.google.bitcoin.core.VerificationException;
import com.google.bitcoin.core.Wallet;
import com.google.bitcoin.protocols.channels.PaymentChannelServer;
import com.google.bitcoin.protocols.channels.PaymentChannelServerState;
import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.util.Date;
import javax.annotation.Nullable;

public class StoredServerChannel {
    BigInteger bestValueToMe;
    byte[] bestValueSignature;
    long refundTransactionUnlockTimeSecs;
    Transaction contract;
    TransactionOutput clientOutput;
    ECKey myKey;
    private PaymentChannelServer connectedHandler = null;
    PaymentChannelServerState state = null;

    StoredServerChannel(@Nullable PaymentChannelServerState state, Transaction contract, TransactionOutput clientOutput, long refundTransactionUnlockTimeSecs, ECKey myKey, BigInteger bestValueToMe, @Nullable byte[] bestValueSignature) {
        this.contract = contract;
        this.clientOutput = clientOutput;
        this.refundTransactionUnlockTimeSecs = refundTransactionUnlockTimeSecs;
        this.myKey = myKey;
        this.bestValueToMe = bestValueToMe;
        this.bestValueSignature = bestValueSignature;
        this.state = state;
    }

    synchronized void updateValueToMe(BigInteger newValue, byte[] newSignature) {
        this.bestValueToMe = newValue;
        this.bestValueSignature = newSignature;
    }

    synchronized PaymentChannelServer setConnectedHandler(PaymentChannelServer connectedHandler, boolean override) {
        if (this.connectedHandler != null && !override) {
            return this.connectedHandler;
        }
        this.connectedHandler = connectedHandler;
        return connectedHandler;
    }

    synchronized void clearConnectedHandler() {
        this.connectedHandler = null;
    }

    synchronized void closeConnectedHandler() {
        if (this.connectedHandler != null) {
            this.connectedHandler.close();
        }
    }

    public synchronized PaymentChannelServerState getOrCreateState(Wallet wallet, TransactionBroadcaster broadcaster) throws VerificationException {
        if (this.state == null) {
            this.state = new PaymentChannelServerState(this, wallet, broadcaster);
        }
        Preconditions.checkArgument((wallet == this.state.wallet ? 1 : 0) != 0);
        return this.state;
    }

    public synchronized String toString() {
        String newline = String.format("%n", new Object[0]);
        return String.format("Stored server channel (%s)%n    Key:           %s%n    Value to me:   %d%n    Client output: %s%n    Refund unlock: %s (%d unix time)%n    Contract:    %s%n", this.connectedHandler != null ? "connected" : "disconnected", this.myKey, this.bestValueToMe, this.clientOutput, new Date(this.refundTransactionUnlockTimeSecs * 1000L), this.refundTransactionUnlockTimeSecs, this.contract.toString().replaceAll(newline, newline + "    "));
    }
}

