/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.protocols.channels;

import com.google.bitcoin.core.ECKey;
import com.google.bitcoin.core.InsufficientMoneyException;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.Sha256Hash;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.TransactionBroadcaster;
import com.google.bitcoin.core.TransactionOutput;
import com.google.bitcoin.core.Utils;
import com.google.bitcoin.core.VerificationException;
import com.google.bitcoin.core.Wallet;
import com.google.bitcoin.core.WalletExtension;
import com.google.bitcoin.protocols.channels.ServerState;
import com.google.bitcoin.protocols.channels.StoredServerChannel;
import com.google.bitcoin.utils.Threading;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.math.BigInteger;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoredPaymentChannelServerStates
implements WalletExtension {
    private static final Logger log = LoggerFactory.getLogger(StoredPaymentChannelServerStates.class);
    static final String EXTENSION_ID = StoredPaymentChannelServerStates.class.getName();
    @GuardedBy(value="lock")
    @VisibleForTesting
    final Map<Sha256Hash, StoredServerChannel> mapChannels = new HashMap<Sha256Hash, StoredServerChannel>();
    private final Wallet wallet;
    private final TransactionBroadcaster broadcaster;
    private final Timer channelTimeoutHandler = new Timer(true);
    private final ReentrantLock lock = Threading.lock("StoredPaymentChannelServerStates");
    public static final long CHANNEL_EXPIRE_OFFSET = -7200L;

    public StoredPaymentChannelServerStates(Wallet wallet, TransactionBroadcaster broadcaster) {
        this.wallet = (Wallet)Preconditions.checkNotNull((Object)wallet);
        this.broadcaster = (TransactionBroadcaster)Preconditions.checkNotNull((Object)broadcaster);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChannel(StoredServerChannel channel) {
        this.lock.lock();
        try {
            if (this.mapChannels.remove(channel.contract.getHash()) == null) {
                return;
            }
        }
        finally {
            this.lock.unlock();
        }
        StoredServerChannel storedServerChannel = channel;
        synchronized (storedServerChannel) {
            channel.closeConnectedHandler();
            try {
                channel.getOrCreateState(this.wallet, this.broadcaster).close();
            }
            catch (InsufficientMoneyException e) {
                e.printStackTrace();
            }
            catch (VerificationException e) {
                e.printStackTrace();
            }
            channel.state = null;
        }
        this.wallet.addOrUpdateExtension(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredServerChannel getChannel(Sha256Hash id) {
        this.lock.lock();
        try {
            StoredServerChannel storedServerChannel = this.mapChannels.get(id);
            return storedServerChannel;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putChannel(final StoredServerChannel channel) {
        this.lock.lock();
        try {
            Preconditions.checkArgument((this.mapChannels.put(channel.contract.getHash(), (StoredServerChannel)Preconditions.checkNotNull((Object)channel)) == null ? 1 : 0) != 0);
            Date autocloseTime = new Date((channel.refundTransactionUnlockTimeSecs + -7200L) * 1000L + (System.currentTimeMillis() - Utils.currentTimeMillis()));
            log.info("Scheduling channel for automatic closure at {}: {}", (Object)autocloseTime, (Object)channel);
            this.channelTimeoutHandler.schedule(new TimerTask(){

                @Override
                public void run() {
                    log.info("Auto-closing channel: {}", (Object)channel);
                    StoredPaymentChannelServerStates.this.closeChannel(channel);
                }
            }, autocloseTime);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public String getWalletExtensionID() {
        return EXTENSION_ID;
    }

    @Override
    public boolean isWalletExtensionMandatory() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] serializeWalletExtension() {
        this.lock.lock();
        try {
            ServerState.StoredServerPaymentChannels.Builder builder = ServerState.StoredServerPaymentChannels.newBuilder();
            for (StoredServerChannel channel : this.mapChannels.values()) {
                Preconditions.checkState((channel.bestValueToMe.compareTo(BigInteger.ZERO) >= 0 && channel.bestValueToMe.compareTo(NetworkParameters.MAX_MONEY) < 0 ? 1 : 0) != 0);
                Preconditions.checkState((channel.refundTransactionUnlockTimeSecs > 0L ? 1 : 0) != 0);
                Preconditions.checkNotNull((Object)channel.myKey.getPrivKeyBytes());
                ServerState.StoredServerPaymentChannel.Builder channelBuilder = ServerState.StoredServerPaymentChannel.newBuilder().setBestValueToMe(channel.bestValueToMe.longValue()).setRefundTransactionUnlockTimeSecs(channel.refundTransactionUnlockTimeSecs).setContractTransaction(ByteString.copyFrom((byte[])channel.contract.bitcoinSerialize())).setClientOutput(ByteString.copyFrom((byte[])channel.clientOutput.bitcoinSerialize())).setMyKey(ByteString.copyFrom((byte[])channel.myKey.getPrivKeyBytes()));
                if (channel.bestValueSignature != null) {
                    channelBuilder.setBestValueSignature(ByteString.copyFrom((byte[])channel.bestValueSignature));
                }
                builder.addChannels(channelBuilder);
            }
            byte[] byArray = builder.build().toByteArray();
            return byArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deserializeWalletExtension(Wallet containingWallet, byte[] data) throws Exception {
        this.lock.lock();
        try {
            Preconditions.checkArgument((containingWallet == this.wallet ? 1 : 0) != 0);
            ServerState.StoredServerPaymentChannels states = ServerState.StoredServerPaymentChannels.parseFrom(data);
            NetworkParameters params = containingWallet.getParams();
            for (ServerState.StoredServerPaymentChannel storedState : states.getChannelsList()) {
                StoredServerChannel channel = new StoredServerChannel(null, new Transaction(params, storedState.getContractTransaction().toByteArray()), new TransactionOutput(params, null, storedState.getClientOutput().toByteArray(), 0), storedState.getRefundTransactionUnlockTimeSecs(), new ECKey(storedState.getMyKey().toByteArray(), null), BigInteger.valueOf(storedState.getBestValueToMe()), storedState.hasBestValueSignature() ? storedState.getBestValueSignature().toByteArray() : null);
                this.putChannel(channel);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.lock.lock();
        try {
            StringBuilder buf = new StringBuilder();
            for (StoredServerChannel stored : this.mapChannels.values()) {
                buf.append(stored);
            }
            String string = buf.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }
}

