/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.protocols.channels;

import com.google.bitcoin.core.ECKey;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.Sha256Hash;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.TransactionBroadcaster;
import com.google.bitcoin.core.TransactionConfidence;
import com.google.bitcoin.core.Utils;
import com.google.bitcoin.core.Wallet;
import com.google.bitcoin.core.WalletExtension;
import com.google.bitcoin.protocols.channels.ClientState;
import com.google.bitcoin.protocols.channels.StoredClientChannel;
import com.google.bitcoin.utils.Threading;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.protobuf.ByteString;
import java.math.BigInteger;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import net.jcip.annotations.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoredPaymentChannelClientStates
implements WalletExtension {
    private static final Logger log = LoggerFactory.getLogger(StoredPaymentChannelClientStates.class);
    static final String EXTENSION_ID = StoredPaymentChannelClientStates.class.getName();
    @GuardedBy(value="lock")
    @VisibleForTesting
    final HashMultimap<Sha256Hash, StoredClientChannel> mapChannels = HashMultimap.create();
    @VisibleForTesting
    final Timer channelTimeoutHandler = new Timer(true);
    private Wallet containingWallet;
    private final TransactionBroadcaster announcePeerGroup;
    protected final ReentrantLock lock = Threading.lock("StoredPaymentChannelClientStates");

    public StoredPaymentChannelClientStates(Wallet containingWallet, TransactionBroadcaster announcePeerGroup) {
        this.announcePeerGroup = (TransactionBroadcaster)Preconditions.checkNotNull((Object)announcePeerGroup);
        this.containingWallet = (Wallet)Preconditions.checkNotNull((Object)containingWallet);
    }

    @Nullable
    public static StoredPaymentChannelClientStates getFromWallet(Wallet wallet) {
        return (StoredPaymentChannelClientStates)wallet.getExtensions().get(EXTENSION_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigInteger getBalanceForServer(Sha256Hash id) {
        BigInteger balance = BigInteger.ZERO;
        this.lock.lock();
        try {
            Set setChannels = this.mapChannels.get((Object)id);
            Iterator i$ = setChannels.iterator();
            while (i$.hasNext()) {
                StoredClientChannel channel;
                StoredClientChannel storedClientChannel = channel = (StoredClientChannel)i$.next();
                synchronized (storedClientChannel) {
                    if (channel.close != null) {
                        continue;
                    }
                    balance = balance.add(channel.valueToMe);
                }
            }
            BigInteger bigInteger = balance;
            return bigInteger;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSecondsUntilExpiry(Sha256Hash id) {
        this.lock.lock();
        try {
            Set setChannels = this.mapChannels.get((Object)id);
            long nowSeconds = Utils.currentTimeMillis() / 1000L;
            int earliestTime = Integer.MAX_VALUE;
            Iterator i$ = setChannels.iterator();
            while (i$.hasNext()) {
                StoredClientChannel channel;
                StoredClientChannel storedClientChannel = channel = (StoredClientChannel)i$.next();
                synchronized (storedClientChannel) {
                    if (channel.expiryTimeSeconds() > nowSeconds) {
                        earliestTime = Math.min(earliestTime, (int)channel.expiryTimeSeconds());
                    }
                }
            }
            long l = earliestTime == Integer.MAX_VALUE ? 0L : (long)earliestTime - nowSeconds;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    StoredClientChannel getUsableChannelForServerID(Sha256Hash id) {
        this.lock.lock();
        try {
            Set setChannels = this.mapChannels.get((Object)id);
            Iterator i$ = setChannels.iterator();
            while (i$.hasNext()) {
                StoredClientChannel channel;
                StoredClientChannel storedClientChannel = channel = (StoredClientChannel)i$.next();
                synchronized (storedClientChannel) {
                    log.info("Considering channel {} contract {}", (Object)channel.hashCode(), (Object)channel.contract.getHash());
                    if (channel.close != null || channel.valueToMe.equals(BigInteger.ZERO)) {
                        log.info("  ... but is closed or empty");
                        continue;
                    }
                    if (!channel.active) {
                        log.info("  ... activating");
                        channel.active = true;
                        StoredClientChannel storedClientChannel2 = channel;
                        return storedClientChannel2;
                    }
                    log.info("  ... but is already active");
                }
            }
            return null;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    StoredClientChannel getChannel(Sha256Hash id, Sha256Hash contractHash) {
        this.lock.lock();
        try {
            Set setChannels = this.mapChannels.get((Object)id);
            for (StoredClientChannel channel : setChannels) {
                if (!channel.contract.getHash().equals(contractHash)) continue;
                StoredClientChannel storedClientChannel = channel;
                return storedClientChannel;
            }
            StoredClientChannel storedClientChannel = null;
            return storedClientChannel;
        }
        finally {
            this.lock.unlock();
        }
    }

    void putChannel(StoredClientChannel channel) {
        this.putChannel(channel, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putChannel(final StoredClientChannel channel, boolean updateWallet) {
        this.lock.lock();
        try {
            this.mapChannels.put((Object)channel.id, (Object)channel);
            this.channelTimeoutHandler.schedule(new TimerTask(){

                @Override
                public void run() {
                    StoredPaymentChannelClientStates.this.removeChannel(channel);
                    StoredPaymentChannelClientStates.this.announcePeerGroup.broadcastTransaction(channel.contract);
                    StoredPaymentChannelClientStates.this.announcePeerGroup.broadcastTransaction(channel.refund);
                }
            }, new Date(channel.expiryTimeSeconds() * 1000L + (System.currentTimeMillis() - Utils.currentTimeMillis())));
        }
        finally {
            this.lock.unlock();
        }
        if (updateWallet) {
            this.containingWallet.addOrUpdateExtension(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeChannel(StoredClientChannel channel) {
        this.lock.lock();
        try {
            this.mapChannels.remove((Object)channel.id, (Object)channel);
        }
        finally {
            this.lock.unlock();
        }
        this.containingWallet.addOrUpdateExtension(this);
    }

    @Override
    public String getWalletExtensionID() {
        return EXTENSION_ID;
    }

    @Override
    public boolean isWalletExtensionMandatory() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] serializeWalletExtension() {
        this.lock.lock();
        try {
            ClientState.StoredClientPaymentChannels.Builder builder = ClientState.StoredClientPaymentChannels.newBuilder();
            for (StoredClientChannel channel : this.mapChannels.values()) {
                Preconditions.checkState((channel.valueToMe.compareTo(BigInteger.ZERO) >= 0 && channel.valueToMe.compareTo(NetworkParameters.MAX_MONEY) < 0 ? 1 : 0) != 0);
                Preconditions.checkState((channel.refundFees.compareTo(BigInteger.ZERO) >= 0 && channel.refundFees.compareTo(NetworkParameters.MAX_MONEY) < 0 ? 1 : 0) != 0);
                Preconditions.checkNotNull((Object)channel.myKey.getPrivKeyBytes());
                Preconditions.checkState((channel.refund.getConfidence().getSource() == TransactionConfidence.Source.SELF ? 1 : 0) != 0);
                ClientState.StoredClientPaymentChannel.Builder value = ClientState.StoredClientPaymentChannel.newBuilder().setId(ByteString.copyFrom((byte[])channel.id.getBytes())).setContractTransaction(ByteString.copyFrom((byte[])channel.contract.bitcoinSerialize())).setRefundTransaction(ByteString.copyFrom((byte[])channel.refund.bitcoinSerialize())).setMyKey(ByteString.copyFrom((byte[])channel.myKey.getPrivKeyBytes())).setValueToMe(channel.valueToMe.longValue()).setRefundFees(channel.refundFees.longValue());
                if (channel.close != null) {
                    value.setCloseTransactionHash(ByteString.copyFrom((byte[])channel.close.getHash().getBytes()));
                }
                builder.addChannels(value);
            }
            byte[] byArray = builder.build().toByteArray();
            return byArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deserializeWalletExtension(Wallet containingWallet, byte[] data) throws Exception {
        this.lock.lock();
        try {
            Preconditions.checkState((this.containingWallet == null || this.containingWallet == containingWallet ? 1 : 0) != 0);
            this.containingWallet = containingWallet;
            NetworkParameters params = containingWallet.getParams();
            ClientState.StoredClientPaymentChannels states = ClientState.StoredClientPaymentChannels.parseFrom(data);
            for (ClientState.StoredClientPaymentChannel storedState : states.getChannelsList()) {
                Transaction refundTransaction = new Transaction(params, storedState.getRefundTransaction().toByteArray());
                refundTransaction.getConfidence().setSource(TransactionConfidence.Source.SELF);
                StoredClientChannel channel = new StoredClientChannel(new Sha256Hash(storedState.getId().toByteArray()), new Transaction(params, storedState.getContractTransaction().toByteArray()), refundTransaction, new ECKey(new BigInteger(1, storedState.getMyKey().toByteArray()), null, true), BigInteger.valueOf(storedState.getValueToMe()), BigInteger.valueOf(storedState.getRefundFees()), false);
                if (storedState.hasCloseTransactionHash()) {
                    channel.close = containingWallet.getTransaction(new Sha256Hash(storedState.toByteArray()));
                }
                this.putChannel(channel, false);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.lock.lock();
        try {
            StringBuilder buf = new StringBuilder("Client payment channel states:\n");
            for (StoredClientChannel channel : this.mapChannels.values()) {
                buf.append("  ").append(channel).append("\n");
            }
            String string = buf.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }
}

