/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.protocols.channels;

import com.google.bitcoin.core.ECKey;
import com.google.bitcoin.core.Sha256Hash;
import com.google.bitcoin.core.Transaction;
import java.math.BigInteger;

class StoredClientChannel {
    Sha256Hash id;
    Transaction contract;
    Transaction refund;
    Transaction close;
    ECKey myKey;
    BigInteger valueToMe;
    BigInteger refundFees;
    boolean active = false;

    StoredClientChannel(Sha256Hash id, Transaction contract, Transaction refund, ECKey myKey, BigInteger valueToMe, BigInteger refundFees, boolean active) {
        this.id = id;
        this.contract = contract;
        this.refund = refund;
        this.myKey = myKey;
        this.valueToMe = valueToMe;
        this.refundFees = refundFees;
        this.active = active;
    }

    long expiryTimeSeconds() {
        return this.refund.getLockTime() + 300L;
    }

    public String toString() {
        String newline = String.format("%n", new Object[0]);
        String closeStr = this.close == null ? "still open" : this.close.toString().replaceAll(newline, newline + "   ");
        return String.format("Stored client channel for server ID %s (%s)%n    Key:         %s%n    Value left:  %d%n    Refund fees: %d%n    Contract:  %sRefund:    %sClose:     %s", this.id, this.active ? "active" : "inactive", this.myKey, this.valueToMe, this.refundFees, this.contract.toString().replaceAll(newline, newline + "    "), this.refund.toString().replaceAll(newline, newline + "    "), closeStr);
    }
}

