/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.protocols.channels;

import com.google.bitcoin.core.ECKey;
import com.google.bitcoin.core.InsufficientMoneyException;
import com.google.bitcoin.core.Sha256Hash;
import com.google.bitcoin.core.Wallet;
import com.google.bitcoin.net.NioClient;
import com.google.bitcoin.net.ProtobufParser;
import com.google.bitcoin.protocols.channels.IPaymentChannelClient;
import com.google.bitcoin.protocols.channels.PaymentChannelClient;
import com.google.bitcoin.protocols.channels.PaymentChannelClientState;
import com.google.bitcoin.protocols.channels.PaymentChannelCloseException;
import com.google.bitcoin.protocols.channels.ValueOutOfRangeException;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import org.bitcoin.paymentchannel.Protos;

public class PaymentChannelClientConnection {
    private final SettableFuture<PaymentChannelClientConnection> channelOpenFuture = SettableFuture.create();
    private final PaymentChannelClient channelClient;
    private final ProtobufParser<Protos.TwoWayChannelMessage> wireParser;

    public PaymentChannelClientConnection(InetSocketAddress server, int timeoutSeconds, Wallet wallet, ECKey myKey, BigInteger maxValue, String serverId) throws IOException, ValueOutOfRangeException {
        this.channelClient = new PaymentChannelClient(wallet, myKey, maxValue, Sha256Hash.create(serverId.getBytes()), new IPaymentChannelClient.ClientConnection(){

            @Override
            public void sendToServer(Protos.TwoWayChannelMessage msg) {
                PaymentChannelClientConnection.this.wireParser.write(msg);
            }

            @Override
            public void destroyConnection(PaymentChannelCloseException.CloseReason reason) {
                PaymentChannelClientConnection.this.channelOpenFuture.setException((Throwable)new PaymentChannelCloseException("Payment channel client requested that the connection be closed: " + (Object)((Object)reason), reason));
                PaymentChannelClientConnection.this.wireParser.closeConnection();
            }

            @Override
            public void channelOpen(boolean wasInitiated) {
                PaymentChannelClientConnection.this.wireParser.setSocketTimeout(0);
                PaymentChannelClientConnection.this.channelOpenFuture.set((Object)PaymentChannelClientConnection.this);
            }
        });
        this.wireParser = new ProtobufParser<Protos.TwoWayChannelMessage>(new ProtobufParser.Listener<Protos.TwoWayChannelMessage>(){

            @Override
            public void messageReceived(ProtobufParser handler, Protos.TwoWayChannelMessage msg) {
                try {
                    PaymentChannelClientConnection.this.channelClient.receiveMessage(msg);
                }
                catch (InsufficientMoneyException e) {
                    PaymentChannelClientConnection.this.channelOpenFuture.setException((Throwable)e);
                }
            }

            @Override
            public void connectionOpen(ProtobufParser handler) {
                PaymentChannelClientConnection.this.channelClient.connectionOpen();
            }

            @Override
            public void connectionClosed(ProtobufParser handler) {
                PaymentChannelClientConnection.this.channelClient.connectionClosed();
                PaymentChannelClientConnection.this.channelOpenFuture.setException((Throwable)new PaymentChannelCloseException("The TCP socket died", PaymentChannelCloseException.CloseReason.CONNECTION_CLOSED));
            }
        }, Protos.TwoWayChannelMessage.getDefaultInstance(), Short.MAX_VALUE, timeoutSeconds * 1000);
        new NioClient(server, this.wireParser, timeoutSeconds * 1000);
    }

    public ListenableFuture<PaymentChannelClientConnection> getChannelOpenFuture() {
        return this.channelOpenFuture;
    }

    public ListenableFuture<BigInteger> incrementPayment(BigInteger size) throws ValueOutOfRangeException, IllegalStateException {
        return this.channelClient.incrementPayment(size);
    }

    public PaymentChannelClientState state() {
        return this.channelClient.state();
    }

    public void settle() {
        try {
            this.channelClient.settle();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void disconnectWithoutSettlement() {
        this.wireParser.closeConnection();
    }
}

