/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.protocols.channels;

import com.google.bitcoin.core.ECKey;
import com.google.bitcoin.core.InsufficientMoneyException;
import com.google.bitcoin.core.Sha256Hash;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.Utils;
import com.google.bitcoin.core.VerificationException;
import com.google.bitcoin.core.Wallet;
import com.google.bitcoin.protocols.channels.IPaymentChannelClient;
import com.google.bitcoin.protocols.channels.PaymentChannelClientState;
import com.google.bitcoin.protocols.channels.PaymentChannelCloseException;
import com.google.bitcoin.protocols.channels.StoredClientChannel;
import com.google.bitcoin.protocols.channels.StoredPaymentChannelClientStates;
import com.google.bitcoin.protocols.channels.ValueOutOfRangeException;
import com.google.bitcoin.utils.Threading;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.ByteString;
import java.math.BigInteger;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import net.jcip.annotations.GuardedBy;
import org.bitcoin.paymentchannel.Protos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaymentChannelClient
implements IPaymentChannelClient {
    private static final Logger log = LoggerFactory.getLogger(PaymentChannelClient.class);
    protected final ReentrantLock lock = Threading.lock("channelclient");
    @GuardedBy(value="lock")
    private final IPaymentChannelClient.ClientConnection conn;
    @GuardedBy(value="lock")
    @VisibleForTesting
    boolean connectionOpen = false;
    @GuardedBy(value="lock")
    private PaymentChannelClientState state;
    @GuardedBy(value="lock")
    private InitStep step = InitStep.WAITING_FOR_CONNECTION_OPEN;
    private StoredClientChannel storedChannel;
    private final Sha256Hash serverId;
    private final Wallet wallet;
    private final ECKey myKey;
    private final BigInteger maxValue;
    private BigInteger missing;
    @GuardedBy(value="lock")
    private long minPayment;
    @GuardedBy(value="lock")
    SettableFuture<BigInteger> increasePaymentFuture;
    @GuardedBy(value="lock")
    BigInteger lastPaymentActualAmount;
    public long MAX_TIME_WINDOW = 86400L;

    public PaymentChannelClient(Wallet wallet, ECKey myKey, BigInteger maxValue, Sha256Hash serverId, IPaymentChannelClient.ClientConnection conn) {
        this.wallet = (Wallet)Preconditions.checkNotNull((Object)wallet);
        this.myKey = (ECKey)Preconditions.checkNotNull((Object)myKey);
        this.maxValue = (BigInteger)Preconditions.checkNotNull((Object)maxValue);
        this.serverId = (Sha256Hash)Preconditions.checkNotNull((Object)serverId);
        this.conn = (IPaymentChannelClient.ClientConnection)Preconditions.checkNotNull((Object)conn);
    }

    public BigInteger getMissing() {
        return this.missing;
    }

    @Nullable
    @GuardedBy(value="lock")
    private PaymentChannelCloseException.CloseReason receiveInitiate(Protos.Initiate initiate, BigInteger contractValue, Protos.Error.Builder errorBuilder) throws VerificationException, InsufficientMoneyException {
        log.info("Got INITIATE message:\n{}", (Object)initiate.toString());
        Preconditions.checkState((initiate.getExpireTimeSecs() > 0L && initiate.getMinAcceptedChannelSize() >= 0L ? 1 : 0) != 0);
        long MAX_EXPIRY_TIME = Utils.currentTimeMillis() / 1000L + this.MAX_TIME_WINDOW;
        if (initiate.getExpireTimeSecs() > MAX_EXPIRY_TIME) {
            log.error("Server expiry time was out of our allowed bounds: {} vs {}", (Object)initiate.getExpireTimeSecs(), (Object)MAX_EXPIRY_TIME);
            errorBuilder.setCode(Protos.Error.ErrorCode.TIME_WINDOW_TOO_LARGE);
            errorBuilder.setExpectedValue(MAX_EXPIRY_TIME);
            return PaymentChannelCloseException.CloseReason.TIME_WINDOW_TOO_LARGE;
        }
        BigInteger minChannelSize = BigInteger.valueOf(initiate.getMinAcceptedChannelSize());
        if (contractValue.compareTo(minChannelSize) < 0) {
            log.error("Server requested too much value");
            errorBuilder.setCode(Protos.Error.ErrorCode.CHANNEL_VALUE_TOO_LARGE);
            this.missing = minChannelSize.subtract(contractValue);
            return PaymentChannelCloseException.CloseReason.SERVER_REQUESTED_TOO_MUCH_VALUE;
        }
        long MIN_PAYMENT = Transaction.REFERENCE_DEFAULT_MIN_TX_FEE.longValue();
        if (initiate.getMinPayment() != MIN_PAYMENT) {
            log.error("Server requested a min payment of {} but we expected {}", (Object)initiate.getMinPayment(), (Object)MIN_PAYMENT);
            errorBuilder.setCode(Protos.Error.ErrorCode.MIN_PAYMENT_TOO_LARGE);
            errorBuilder.setExpectedValue(MIN_PAYMENT);
            this.missing = BigInteger.valueOf(initiate.getMinPayment() - MIN_PAYMENT);
            return PaymentChannelCloseException.CloseReason.SERVER_REQUESTED_TOO_MUCH_VALUE;
        }
        this.state = new PaymentChannelClientState(this.wallet, this.myKey, new ECKey(null, initiate.getMultisigKey().toByteArray()), contractValue, initiate.getExpireTimeSecs());
        try {
            this.state.initiate();
        }
        catch (ValueOutOfRangeException e) {
            log.error("Value out of range when trying to initiate", (Throwable)e);
            errorBuilder.setCode(Protos.Error.ErrorCode.CHANNEL_VALUE_TOO_LARGE);
            return PaymentChannelCloseException.CloseReason.SERVER_REQUESTED_TOO_MUCH_VALUE;
        }
        this.minPayment = initiate.getMinPayment();
        this.step = InitStep.WAITING_FOR_REFUND_RETURN;
        Protos.ProvideRefund.Builder provideRefundBuilder = Protos.ProvideRefund.newBuilder().setMultisigKey(ByteString.copyFrom((byte[])this.myKey.getPubKey())).setTx(ByteString.copyFrom((byte[])this.state.getIncompleteRefundTransaction().bitcoinSerialize()));
        this.conn.sendToServer(Protos.TwoWayChannelMessage.newBuilder().setProvideRefund(provideRefundBuilder).setType(Protos.TwoWayChannelMessage.MessageType.PROVIDE_REFUND).build());
        return null;
    }

    @GuardedBy(value="lock")
    private void receiveRefund(Protos.TwoWayChannelMessage refundMsg) throws VerificationException {
        Preconditions.checkState((this.step == InitStep.WAITING_FOR_REFUND_RETURN && refundMsg.hasReturnRefund() ? 1 : 0) != 0);
        log.info("Got RETURN_REFUND message, providing signed contract");
        Protos.ReturnRefund returnedRefund = refundMsg.getReturnRefund();
        this.state.provideRefundSignature(returnedRefund.getSignature().toByteArray());
        this.step = InitStep.WAITING_FOR_CHANNEL_OPEN;
        this.state.storeChannelInWallet(this.serverId);
        Protos.ProvideContract.Builder contractMsg = Protos.ProvideContract.newBuilder().setTx(ByteString.copyFrom((byte[])this.state.getMultisigContract().bitcoinSerialize()));
        try {
            PaymentChannelClientState.IncrementedPayment payment = this.state().incrementPaymentBy(BigInteger.valueOf(this.minPayment));
            Protos.UpdatePayment.Builder initialMsg = contractMsg.getInitialPaymentBuilder();
            initialMsg.setSignature(ByteString.copyFrom((byte[])payment.signature.encodeToBitcoin()));
            initialMsg.setClientChangeValue(this.state.getValueRefunded().longValue());
        }
        catch (ValueOutOfRangeException e) {
            throw new IllegalStateException(e);
        }
        Protos.TwoWayChannelMessage.Builder msg = Protos.TwoWayChannelMessage.newBuilder();
        msg.setProvideContract(contractMsg);
        msg.setType(Protos.TwoWayChannelMessage.MessageType.PROVIDE_CONTRACT);
        this.conn.sendToServer(msg.build());
    }

    @GuardedBy(value="lock")
    private void receiveChannelOpen() throws VerificationException {
        Preconditions.checkState((this.step == InitStep.WAITING_FOR_CHANNEL_OPEN || this.step == InitStep.WAITING_FOR_INITIATE && this.storedChannel != null ? 1 : 0) != 0, (Object)((Object)this.step));
        log.info("Got CHANNEL_OPEN message, ready to pay");
        boolean wasInitiated = true;
        if (this.step == InitStep.WAITING_FOR_INITIATE) {
            wasInitiated = false;
            this.state = new PaymentChannelClientState(this.storedChannel, this.wallet);
        }
        this.step = InitStep.CHANNEL_OPEN;
        this.conn.channelOpen(wasInitiated);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void receiveMessage(Protos.TwoWayChannelMessage msg) throws InsufficientMoneyException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 11[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @GuardedBy(value="lock")
    private void receiveClose(Protos.TwoWayChannelMessage msg) throws VerificationException {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        if (msg.hasSettlement()) {
            Transaction settleTx = new Transaction(this.wallet.getParams(), msg.getSettlement().getTx().toByteArray());
            log.info("CLOSE message received with settlement tx {}", (Object)settleTx.getHash());
            if (this.state != null && this.state().isSettlementTransaction(settleTx)) {
                this.wallet.receivePending(settleTx, null);
            }
        } else {
            log.info("CLOSE message received without settlement tx");
        }
        if (this.step == InitStep.WAITING_FOR_CHANNEL_CLOSE) {
            this.conn.destroyConnection(PaymentChannelCloseException.CloseReason.CLIENT_REQUESTED_CLOSE);
        } else {
            this.conn.destroyConnection(PaymentChannelCloseException.CloseReason.SERVER_REQUESTED_CLOSE);
        }
        this.step = InitStep.CHANNEL_CLOSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionClosed() {
        this.lock.lock();
        try {
            this.connectionOpen = false;
            if (this.state != null) {
                this.state.disconnectFromChannel();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void settle() throws IllegalStateException {
        this.lock.lock();
        try {
            Preconditions.checkState((boolean)this.connectionOpen);
            this.step = InitStep.WAITING_FOR_CHANNEL_CLOSE;
            log.info("Sending a CLOSE message to the server and waiting for response indicating successful settlement.");
            this.conn.sendToServer(Protos.TwoWayChannelMessage.newBuilder().setType(Protos.TwoWayChannelMessage.MessageType.CLOSE).build());
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionOpen() {
        this.lock.lock();
        try {
            this.connectionOpen = true;
            StoredPaymentChannelClientStates channels = (StoredPaymentChannelClientStates)this.wallet.getExtensions().get(StoredPaymentChannelClientStates.EXTENSION_ID);
            if (channels != null) {
                this.storedChannel = channels.getUsableChannelForServerID(this.serverId);
            }
            this.step = InitStep.WAITING_FOR_VERSION_NEGOTIATION;
            Protos.ClientVersion.Builder versionNegotiationBuilder = Protos.ClientVersion.newBuilder().setMajor(1).setMinor(0);
            if (this.storedChannel != null) {
                versionNegotiationBuilder.setPreviousChannelContractHash(ByteString.copyFrom((byte[])this.storedChannel.contract.getHash().getBytes()));
                log.info("Begun version handshake, attempting to reopen channel with contract hash {}", (Object)this.storedChannel.contract.getHash());
            } else {
                log.info("Begun version handshake creating new channel");
            }
            this.conn.sendToServer(Protos.TwoWayChannelMessage.newBuilder().setType(Protos.TwoWayChannelMessage.MessageType.CLIENT_VERSION).setClientVersion(versionNegotiationBuilder).build());
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PaymentChannelClientState state() {
        this.lock.lock();
        try {
            PaymentChannelClientState paymentChannelClientState = this.state;
            return paymentChannelClientState;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListenableFuture<BigInteger> incrementPayment(BigInteger size) throws ValueOutOfRangeException, IllegalStateException {
        this.lock.lock();
        try {
            if (this.state() == null || !this.connectionOpen || this.step != InitStep.CHANNEL_OPEN) {
                throw new IllegalStateException("Channel is not fully initialized/has already been closed");
            }
            if (this.increasePaymentFuture != null) {
                throw new IllegalStateException("Already incrementing paying, wait for previous payment to complete.");
            }
            PaymentChannelClientState.IncrementedPayment payment = this.state().incrementPaymentBy(size);
            Protos.UpdatePayment.Builder updatePaymentBuilder = Protos.UpdatePayment.newBuilder().setSignature(ByteString.copyFrom((byte[])payment.signature.encodeToBitcoin())).setClientChangeValue(this.state.getValueRefunded().longValue());
            this.increasePaymentFuture = SettableFuture.create();
            this.increasePaymentFuture.addListener(new Runnable(){

                @Override
                public void run() {
                    PaymentChannelClient.this.lock.lock();
                    PaymentChannelClient.this.increasePaymentFuture = null;
                    PaymentChannelClient.this.lock.unlock();
                }
            }, (Executor)MoreExecutors.sameThreadExecutor());
            this.conn.sendToServer(Protos.TwoWayChannelMessage.newBuilder().setUpdatePayment(updatePaymentBuilder).setType(Protos.TwoWayChannelMessage.MessageType.UPDATE_PAYMENT).build());
            this.lastPaymentActualAmount = payment.amount;
            SettableFuture<BigInteger> settableFuture = this.increasePaymentFuture;
            return settableFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receivePaymentAck() {
        BigInteger value;
        SettableFuture<BigInteger> future;
        this.lock.lock();
        try {
            if (this.increasePaymentFuture == null) {
                return;
            }
            Preconditions.checkNotNull(this.increasePaymentFuture, (Object)"Server sent a PAYMENT_ACK with no outstanding payment");
            log.info("Received a PAYMENT_ACK from the server");
            future = this.increasePaymentFuture;
            value = this.lastPaymentActualAmount;
        }
        finally {
            this.lock.unlock();
        }
        future.set((Object)value);
    }

    static class 2 {
        static final /* synthetic */ int[] $SwitchMap$org$bitcoin$paymentchannel$Protos$TwoWayChannelMessage$MessageType;

        static {
            $SwitchMap$org$bitcoin$paymentchannel$Protos$TwoWayChannelMessage$MessageType = new int[Protos.TwoWayChannelMessage.MessageType.values().length];
            try {
                2.$SwitchMap$org$bitcoin$paymentchannel$Protos$TwoWayChannelMessage$MessageType[Protos.TwoWayChannelMessage.MessageType.SERVER_VERSION.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$bitcoin$paymentchannel$Protos$TwoWayChannelMessage$MessageType[Protos.TwoWayChannelMessage.MessageType.INITIATE.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$bitcoin$paymentchannel$Protos$TwoWayChannelMessage$MessageType[Protos.TwoWayChannelMessage.MessageType.RETURN_REFUND.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$bitcoin$paymentchannel$Protos$TwoWayChannelMessage$MessageType[Protos.TwoWayChannelMessage.MessageType.CHANNEL_OPEN.ordinal()] = 4;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$bitcoin$paymentchannel$Protos$TwoWayChannelMessage$MessageType[Protos.TwoWayChannelMessage.MessageType.PAYMENT_ACK.ordinal()] = 5;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$bitcoin$paymentchannel$Protos$TwoWayChannelMessage$MessageType[Protos.TwoWayChannelMessage.MessageType.CLOSE.ordinal()] = 6;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                2.$SwitchMap$org$bitcoin$paymentchannel$Protos$TwoWayChannelMessage$MessageType[Protos.TwoWayChannelMessage.MessageType.ERROR.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    private static enum InitStep {
        WAITING_FOR_CONNECTION_OPEN,
        WAITING_FOR_VERSION_NEGOTIATION,
        WAITING_FOR_INITIATE,
        WAITING_FOR_REFUND_RETURN,
        WAITING_FOR_CHANNEL_OPEN,
        CHANNEL_OPEN,
        WAITING_FOR_CHANNEL_CLOSE,
        CHANNEL_CLOSED;

    }
}

