/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.params;

import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.Utils;
import com.google.common.base.Preconditions;
import org.spongycastle.util.encoders.Hex;

public class TestNet3Params
extends NetworkParameters {
    private static TestNet3Params instance;

    public TestNet3Params() {
        this.id = "org.bitcoin.test";
        this.packetMagic = 185665799L;
        this.interval = 2016;
        this.targetTimespan = 1209600;
        this.proofOfWorkLimit = Utils.decodeCompactBits(486604799L);
        this.port = 18333;
        this.addressHeader = 111;
        this.p2shHeader = 196;
        this.acceptableAddressCodes = new int[]{this.addressHeader, this.p2shHeader};
        this.dumpedPrivateKeyHeader = 239;
        this.genesisBlock.setTime(1296688602L);
        this.genesisBlock.setDifficultyTarget(486604799L);
        this.genesisBlock.setNonce(414098458L);
        this.spendableCoinbaseDepth = 100;
        this.subsidyDecreaseBlockCount = 210000;
        String genesisHash = this.genesisBlock.getHashAsString();
        Preconditions.checkState((boolean)genesisHash.equals("000000000933ea01ad0ee984209779baaec3ced90fa3f408719526f8d77f4943"));
        this.alertSigningKey = Hex.decode((String)"04302390343f91cc401d56d68b123028bf52e5fca1939df127f63c6467cdf9c8e2c14b61104cf817d0b780da337893ecc4aaff1309e536162dabbdb45200ca2b0a");
        this.dnsSeeds = new String[]{"testnet-seed.bitcoin.petertodd.org", "testnet-seed.bluematt.me"};
    }

    public static synchronized TestNet3Params get() {
        if (instance == null) {
            instance = new TestNet3Params();
        }
        return instance;
    }

    @Override
    public String getPaymentProtocolId() {
        return "test";
    }
}

