/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.params;

import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.Utils;
import com.google.common.base.Preconditions;

public class TestNet2Params
extends NetworkParameters {
    private static TestNet2Params instance;

    public TestNet2Params() {
        this.id = "org.bitcoin.test";
        this.packetMagic = 4206867930L;
        this.port = 18333;
        this.addressHeader = 111;
        this.p2shHeader = 196;
        this.acceptableAddressCodes = new int[]{this.addressHeader, this.p2shHeader};
        this.interval = 2016;
        this.targetTimespan = 1209600;
        this.proofOfWorkLimit = Utils.decodeCompactBits(487587839L);
        this.dumpedPrivateKeyHeader = 239;
        this.genesisBlock.setTime(1296688602L);
        this.genesisBlock.setDifficultyTarget(487063544L);
        this.genesisBlock.setNonce(384568319L);
        this.spendableCoinbaseDepth = 100;
        this.subsidyDecreaseBlockCount = 210000;
        String genesisHash = this.genesisBlock.getHashAsString();
        Preconditions.checkState((boolean)genesisHash.equals("00000007199508e34a9ff81e6ec0c477a4cccff2a4767a8eee39c11db367b008"));
        this.dnsSeeds = null;
    }

    public static synchronized TestNet2Params get() {
        if (instance == null) {
            instance = new TestNet2Params();
        }
        return instance;
    }

    @Override
    public String getPaymentProtocolId() {
        return null;
    }
}

