/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.net.discovery;

import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.net.discovery.PeerDiscovery;
import com.google.bitcoin.net.discovery.PeerDiscoveryException;
import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsDiscovery
implements PeerDiscovery {
    private static final Logger log = LoggerFactory.getLogger(DnsDiscovery.class);
    private final String[] hostNames;
    private final NetworkParameters netParams;

    public DnsDiscovery(NetworkParameters netParams) {
        this(netParams.getDnsSeeds(), netParams);
    }

    public DnsDiscovery(String[] hostNames, NetworkParameters netParams) {
        this.hostNames = hostNames;
        this.netParams = netParams;
    }

    @Override
    public InetSocketAddress[] getPeers(long timeoutValue, TimeUnit timeoutUnit) throws PeerDiscoveryException {
        if (this.hostNames == null) {
            throw new PeerDiscoveryException("Unable to find any peers via DNS");
        }
        ExecutorService threadPool = Executors.newFixedThreadPool(this.hostNames.length);
        try {
            ArrayList tasks = Lists.newArrayList();
            for (final String seed : this.hostNames) {
                tasks.add(new Callable<InetAddress[]>(){

                    @Override
                    public InetAddress[] call() throws Exception {
                        return InetAddress.getAllByName(seed);
                    }
                });
            }
            List futures = threadPool.invokeAll(tasks, timeoutValue, timeoutUnit);
            ArrayList addrs = Lists.newArrayList();
            for (int i = 0; i < futures.size(); ++i) {
                InetAddress[] inetAddresses;
                Future future = futures.get(i);
                if (future.isCancelled()) {
                    log.warn("{} timed out", (Object)this.hostNames[i]);
                    continue;
                }
                try {
                    inetAddresses = (InetAddress[])future.get();
                }
                catch (ExecutionException e) {
                    log.error("Failed to look up DNS seeds from {}: {}", (Object)this.hostNames[i], (Object)e.getMessage());
                    continue;
                }
                for (InetAddress addr : inetAddresses) {
                    addrs.add(new InetSocketAddress(addr, this.netParams.getPort()));
                }
            }
            if (addrs.size() == 0) {
                throw new PeerDiscoveryException("Unable to find any peers via DNS");
            }
            Collections.shuffle(addrs);
            threadPool.shutdownNow();
            InetSocketAddress[] inetSocketAddressArray = addrs.toArray(new InetSocketAddress[addrs.size()]);
            return inetSocketAddressArray;
        }
        catch (InterruptedException e) {
            throw new PeerDiscoveryException(e);
        }
        finally {
            threadPool.shutdown();
        }
    }

    @Override
    public void shutdown() {
    }
}

