/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.net;

import com.google.bitcoin.core.Utils;
import com.google.bitcoin.net.AbstractTimeoutHandler;
import com.google.bitcoin.net.MessageWriteTarget;
import com.google.bitcoin.net.StreamParser;
import com.google.bitcoin.utils.Threading;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufParser<MessageType extends MessageLite>
extends AbstractTimeoutHandler
implements StreamParser {
    private static final Logger log = LoggerFactory.getLogger(ProtobufParser.class);
    private final Listener<MessageType> handler;
    private final MessageLite prototype;
    final int maxMessageSize;
    @GuardedBy(value="lock")
    private int messageBytesOffset = 0;
    @GuardedBy(value="lock")
    private byte[] messageBytes;
    private final ReentrantLock lock = Threading.lock("ProtobufParser");
    @VisibleForTesting
    final AtomicReference<MessageWriteTarget> writeTarget = new AtomicReference();

    public ProtobufParser(Listener<MessageType> handler, MessageType prototype, int maxMessageSize, int timeoutMillis) {
        this.handler = handler;
        this.prototype = prototype;
        this.maxMessageSize = Math.min(maxMessageSize, 0x7FFFFFFB);
        this.setTimeoutEnabled(false);
        this.setSocketTimeout(timeoutMillis);
    }

    @Override
    public void setWriteTarget(MessageWriteTarget writeTarget) {
        Preconditions.checkState((this.writeTarget.getAndSet((MessageWriteTarget)Preconditions.checkNotNull((Object)writeTarget)) == null ? 1 : 0) != 0);
    }

    @Override
    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void closeConnection() {
        this.writeTarget.get().closeConnection();
    }

    @Override
    protected void timeoutOccurred() {
        log.warn("Timeout occurred for " + this.handler);
        this.closeConnection();
    }

    private void deserializeMessage(ByteBuffer buff) throws Exception {
        MessageLite msg = this.prototype.newBuilderForType().mergeFrom(ByteString.copyFrom((ByteBuffer)buff)).build();
        this.resetTimeout();
        this.handler.messageReceived(this, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int receiveBytes(ByteBuffer buff) throws Exception {
        this.lock.lock();
        try {
            if (this.messageBytes != null) {
                int bytesToGet = Math.min(this.messageBytes.length - this.messageBytesOffset, buff.remaining());
                buff.get(this.messageBytes, this.messageBytesOffset, bytesToGet);
                this.messageBytesOffset += bytesToGet;
                if (this.messageBytesOffset == this.messageBytes.length) {
                    this.deserializeMessage(ByteBuffer.wrap(this.messageBytes));
                    this.messageBytes = null;
                    if (buff.hasRemaining()) {
                        int n = bytesToGet + this.receiveBytes(buff);
                        return n;
                    }
                }
                int n = bytesToGet;
                return n;
            }
            if (buff.remaining() < 4) {
                int bytesToGet = 0;
                return bytesToGet;
            }
            buff.order(ByteOrder.BIG_ENDIAN);
            int len = buff.getInt();
            if (len > this.maxMessageSize || len + 4 < 4) {
                throw new IllegalStateException("Message too large or length underflowed");
            }
            if (buff.capacity() < len + 4) {
                this.messageBytes = new byte[len];
                int bytesToRead = buff.remaining();
                buff.get(this.messageBytes, 0, bytesToRead);
                this.messageBytesOffset = bytesToRead;
                int n = bytesToRead + 4;
                return n;
            }
            if (buff.remaining() < len) {
                buff.position(buff.position() - 4);
                int bytesToRead = 0;
                return bytesToRead;
            }
            int limit = buff.limit();
            buff.limit(buff.position() + len);
            this.deserializeMessage(buff);
            Preconditions.checkState((buff.remaining() == 0 ? 1 : 0) != 0);
            buff.limit(limit);
            if (buff.hasRemaining()) {
                int n = len + 4 + this.receiveBytes(buff);
                return n;
            }
            int n = len + 4;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void connectionClosed() {
        this.handler.connectionClosed(this);
    }

    @Override
    public void connectionOpened() {
        this.setTimeoutEnabled(true);
        this.handler.connectionOpen(this);
    }

    public void write(MessageType msg) throws IllegalStateException {
        byte[] messageBytes = msg.toByteArray();
        Preconditions.checkState((messageBytes.length <= this.maxMessageSize ? 1 : 0) != 0);
        byte[] messageLength = new byte[4];
        Utils.uint32ToByteArrayBE(messageBytes.length, messageLength, 0);
        try {
            MessageWriteTarget target = this.writeTarget.get();
            target.writeBytes(messageLength);
            target.writeBytes(messageBytes);
        }
        catch (IOException e) {
            this.closeConnection();
        }
    }

    public static interface Listener<MessageType extends MessageLite> {
        public void messageReceived(ProtobufParser<MessageType> var1, MessageType var2);

        public void connectionOpen(ProtobufParser<MessageType> var1);

        public void connectionClosed(ProtobufParser<MessageType> var1);
    }
}

