/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.net;

import com.google.bitcoin.net.ClientConnectionManager;
import com.google.bitcoin.net.ConnectionHandler;
import com.google.bitcoin.net.StreamParser;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.AbstractExecutionThreadService;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioClientManager
extends AbstractExecutionThreadService
implements ClientConnectionManager {
    private static final Logger log = LoggerFactory.getLogger(NioClientManager.class);
    private final Selector selector;
    final Queue<SocketChannelAndParser> newConnectionChannels = new LinkedBlockingQueue<SocketChannelAndParser>();
    private final Set<ConnectionHandler> connectedHandlers = Collections.synchronizedSet(new HashSet());

    private void handleKey(SelectionKey key) throws IOException {
        block5: {
            if (key.isValid() && key.isConnectable()) {
                StreamParser parser = (StreamParser)key.attachment();
                SocketChannel sc = (SocketChannel)key.channel();
                ConnectionHandler handler = new ConnectionHandler(parser, key, this.connectedHandlers);
                try {
                    if (sc.finishConnect()) {
                        log.info("Successfully connected to {}", (Object)sc.socket().getRemoteSocketAddress());
                        key.interestOps(1).attach(handler);
                        handler.parser.connectionOpened();
                        break block5;
                    }
                    log.error("Failed to connect to {}", (Object)sc.socket().getRemoteSocketAddress());
                    handler.closeConnection();
                }
                catch (Exception e) {
                    log.error("Failed to connect with exception: {}", (Object)Throwables.getRootCause((Throwable)e).getMessage());
                    handler.closeConnection();
                }
            } else {
                ConnectionHandler.handleKey(key);
            }
        }
    }

    public NioClientManager() {
        try {
            this.selector = SelectorProvider.provider().openSelector();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Thread.currentThread().setPriority(1);
            while (this.isRunning()) {
                SocketChannelAndParser conn;
                while ((conn = this.newConnectionChannels.poll()) != null) {
                    try {
                        SelectionKey key = conn.sc.register(this.selector, 8);
                        key.attach(conn.parser);
                    }
                    catch (ClosedChannelException e) {
                        log.info("SocketChannel was closed before it could be registered");
                    }
                }
                this.selector.select();
                Iterator<SelectionKey> keyIterator = this.selector.selectedKeys().iterator();
                while (keyIterator.hasNext()) {
                    SelectionKey key = keyIterator.next();
                    keyIterator.remove();
                    this.handleKey(key);
                }
            }
        }
        catch (Exception e) {
            log.error("Error trying to open/read from connection: ", (Throwable)e);
        }
        finally {
            for (SelectionKey key : this.selector.keys()) {
                try {
                    key.channel().close();
                }
                catch (IOException e) {
                    log.error("Error closing channel", (Throwable)e);
                }
                key.cancel();
                if (!(key.attachment() instanceof ConnectionHandler)) continue;
                ConnectionHandler.handleKey(key);
            }
            try {
                this.selector.close();
            }
            catch (IOException e) {
                log.error("Error closing client manager selector", (Throwable)e);
            }
        }
    }

    @Override
    public void openConnection(SocketAddress serverAddress, StreamParser parser) {
        if (!this.isRunning()) {
            throw new IllegalStateException();
        }
        try {
            SocketChannel sc = SocketChannel.open();
            sc.configureBlocking(false);
            sc.connect(serverAddress);
            this.newConnectionChannels.offer(new SocketChannelAndParser(sc, parser));
            this.selector.wakeup();
        }
        catch (IOException e) {
            log.error("Could not connect to " + serverAddress);
            throw new RuntimeException(e);
        }
    }

    public void triggerShutdown() {
        this.selector.wakeup();
    }

    @Override
    public int getConnectedClientCount() {
        return this.connectedHandlers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeConnections(int n) {
        while (n-- > 0) {
            ConnectionHandler handler;
            Set<ConnectionHandler> set = this.connectedHandlers;
            synchronized (set) {
                handler = this.connectedHandlers.iterator().next();
            }
            if (handler == null) continue;
            handler.closeConnection();
        }
    }

    class SocketChannelAndParser {
        SocketChannel sc;
        StreamParser parser;

        SocketChannelAndParser(SocketChannel sc, StreamParser parser) {
            this.sc = sc;
            this.parser = parser;
        }
    }
}

