/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.net;

import com.google.bitcoin.net.AbstractTimeoutHandler;
import com.google.bitcoin.net.MessageWriteTarget;
import com.google.bitcoin.net.NioClientManager;
import com.google.bitcoin.net.StreamParser;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;

public class NioClient
implements MessageWriteTarget {
    private final Handler handler;
    private final NioClientManager manager = new NioClientManager();

    public NioClient(SocketAddress serverAddress, StreamParser parser, int connectTimeoutMillis) throws IOException {
        this.manager.startAndWait();
        this.handler = new Handler(parser, connectTimeoutMillis);
        this.manager.openConnection(serverAddress, this.handler);
    }

    @Override
    public void closeConnection() {
        this.handler.writeTarget.closeConnection();
    }

    @Override
    public synchronized void writeBytes(byte[] message) throws IOException {
        this.handler.writeTarget.writeBytes(message);
    }

    class Handler
    extends AbstractTimeoutHandler
    implements StreamParser {
        private final StreamParser upstreamParser;
        private MessageWriteTarget writeTarget;
        private boolean closeOnOpen = false;

        Handler(StreamParser upstreamParser, int connectTimeoutMillis) {
            this.upstreamParser = upstreamParser;
            this.setSocketTimeout(connectTimeoutMillis);
            this.setTimeoutEnabled(true);
        }

        @Override
        protected synchronized void timeoutOccurred() {
            this.upstreamParser.connectionClosed();
            this.closeOnOpen = true;
        }

        @Override
        public void connectionClosed() {
            this.upstreamParser.connectionClosed();
            NioClient.this.manager.stop();
        }

        @Override
        public synchronized void connectionOpened() {
            if (!this.closeOnOpen) {
                this.upstreamParser.connectionOpened();
            }
        }

        @Override
        public int receiveBytes(ByteBuffer buff) throws Exception {
            return this.upstreamParser.receiveBytes(buff);
        }

        @Override
        public synchronized void setWriteTarget(MessageWriteTarget writeTarget) {
            if (this.closeOnOpen) {
                writeTarget.closeConnection();
            } else {
                this.setTimeoutEnabled(false);
                this.writeTarget = writeTarget;
                this.upstreamParser.setWriteTarget(writeTarget);
            }
        }

        @Override
        public int getMaxMessageSize() {
            return this.upstreamParser.getMaxMessageSize();
        }
    }
}

