/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.net;

import com.google.bitcoin.net.MessageWriteTarget;
import com.google.bitcoin.net.StreamParser;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Set;
import javax.annotation.Nullable;
import javax.net.SocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingClient
implements MessageWriteTarget {
    private static final Logger log = LoggerFactory.getLogger(BlockingClient.class);
    private static final int BUFFER_SIZE_LOWER_BOUND = 4096;
    private static final int BUFFER_SIZE_UPPER_BOUND = 65536;
    private final ByteBuffer dbuf;
    private Socket socket;
    private volatile boolean vCloseRequested = false;

    public BlockingClient(final SocketAddress serverAddress, final StreamParser parser, final int connectTimeoutMillis, SocketFactory socketFactory, final @Nullable Set<BlockingClient> clientSet) throws IOException {
        this.dbuf = ByteBuffer.allocateDirect(Math.min(Math.max(parser.getMaxMessageSize(), 4096), 65536));
        parser.setWriteTarget(this);
        this.socket = socketFactory.createSocket();
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                if (clientSet != null) {
                    clientSet.add(BlockingClient.this);
                }
                try {
                    BlockingClient.this.socket.connect(serverAddress, connectTimeoutMillis);
                    parser.connectionOpened();
                    InputStream stream = BlockingClient.this.socket.getInputStream();
                    byte[] readBuff = new byte[BlockingClient.this.dbuf.capacity()];
                    while (true) {
                        Preconditions.checkState((BlockingClient.this.dbuf.remaining() > 0 && BlockingClient.this.dbuf.remaining() <= readBuff.length ? 1 : 0) != 0);
                        int read = stream.read(readBuff, 0, Math.max(1, Math.min(BlockingClient.this.dbuf.remaining(), stream.available())));
                        if (read == -1) {
                            return;
                        }
                        BlockingClient.this.dbuf.put(readBuff, 0, read);
                        BlockingClient.this.dbuf.flip();
                        int bytesConsumed = parser.receiveBytes(BlockingClient.this.dbuf);
                        Preconditions.checkState((BlockingClient.this.dbuf.position() == bytesConsumed ? 1 : 0) != 0);
                        BlockingClient.this.dbuf.compact();
                        continue;
                        break;
                    }
                }
                catch (Exception e) {
                    if (BlockingClient.this.vCloseRequested) return;
                    log.error("Error trying to open/read from connection: " + serverAddress, (Throwable)e);
                    return;
                }
                finally {
                    try {
                        BlockingClient.this.socket.close();
                    }
                    catch (IOException e1) {}
                    if (clientSet != null) {
                        clientSet.remove(BlockingClient.this);
                    }
                    parser.connectionClosed();
                }
            }
        };
        t.setName("BlockingClient network thread for " + serverAddress);
        t.setDaemon(true);
        t.start();
    }

    @Override
    public void closeConnection() {
        try {
            this.vCloseRequested = true;
            this.socket.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void writeBytes(byte[] message) throws IOException {
        try {
            OutputStream stream = this.socket.getOutputStream();
            stream.write(message);
            stream.flush();
        }
        catch (IOException e) {
            log.error("Error writing message to connection, closing connection", (Throwable)e);
            this.closeConnection();
            throw e;
        }
    }
}

