/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.kits;

import com.google.bitcoin.core.BlockChain;
import com.google.bitcoin.core.CheckpointManager;
import com.google.bitcoin.core.DownloadListener;
import com.google.bitcoin.core.ECKey;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.PeerAddress;
import com.google.bitcoin.core.PeerEventListener;
import com.google.bitcoin.core.PeerGroup;
import com.google.bitcoin.core.Wallet;
import com.google.bitcoin.net.discovery.DnsDiscovery;
import com.google.bitcoin.store.BlockStoreException;
import com.google.bitcoin.store.SPVBlockStore;
import com.google.bitcoin.store.WalletProtobufSerializer;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Service;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;

public class WalletAppKit
extends AbstractIdleService {
    protected final String filePrefix;
    protected final NetworkParameters params;
    protected volatile BlockChain vChain;
    protected volatile SPVBlockStore vStore;
    protected volatile Wallet vWallet;
    protected volatile PeerGroup vPeerGroup;
    protected final File directory;
    protected volatile File vWalletFile;
    protected boolean useAutoSave = true;
    protected PeerAddress[] peerAddresses;
    protected PeerEventListener downloadListener;
    protected boolean autoStop = true;
    protected InputStream checkpoints;
    protected boolean blockingStartup = true;
    protected String userAgent;
    protected String version;

    public WalletAppKit(NetworkParameters params, File directory, String filePrefix) {
        this.params = (NetworkParameters)Preconditions.checkNotNull((Object)params);
        this.directory = (File)Preconditions.checkNotNull((Object)directory);
        this.filePrefix = (String)Preconditions.checkNotNull((Object)filePrefix);
    }

    public WalletAppKit setPeerNodes(PeerAddress ... addresses) {
        Preconditions.checkState((this.state() == Service.State.NEW ? 1 : 0) != 0, (Object)"Cannot call after startup");
        this.peerAddresses = addresses;
        return this;
    }

    public WalletAppKit connectToLocalHost() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            return this.setPeerNodes(new PeerAddress(localHost, this.params.getPort()));
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public WalletAppKit setAutoSave(boolean value) {
        Preconditions.checkState((this.state() == Service.State.NEW ? 1 : 0) != 0, (Object)"Cannot call after startup");
        this.useAutoSave = value;
        return this;
    }

    public WalletAppKit setDownloadListener(PeerEventListener listener) {
        this.downloadListener = listener;
        return this;
    }

    public WalletAppKit setAutoStop(boolean autoStop) {
        this.autoStop = autoStop;
        return this;
    }

    public WalletAppKit setCheckpoints(InputStream checkpoints) {
        this.checkpoints = (InputStream)Preconditions.checkNotNull((Object)checkpoints);
        return this;
    }

    public WalletAppKit setBlockingStartup(boolean blockingStartup) {
        this.blockingStartup = blockingStartup;
        return this;
    }

    public WalletAppKit setUserAgent(String userAgent, String version) {
        this.userAgent = (String)Preconditions.checkNotNull((Object)userAgent);
        this.version = (String)Preconditions.checkNotNull((Object)version);
        return this;
    }

    protected void addWalletExtensions() throws Exception {
    }

    protected void onSetupCompleted() {
    }

    protected void startUp() throws Exception {
        if (!this.directory.exists() && !this.directory.mkdir()) {
            throw new IOException("Could not create named directory.");
        }
        FileInputStream walletStream = null;
        try {
            File chainFile = new File(this.directory, this.filePrefix + ".spvchain");
            boolean chainFileExists = chainFile.exists();
            this.vWalletFile = new File(this.directory, this.filePrefix + ".wallet");
            boolean shouldReplayWallet = this.vWalletFile.exists() && !chainFileExists;
            this.vStore = new SPVBlockStore(this.params, chainFile);
            if (!chainFileExists && this.checkpoints != null) {
                long time = Long.MAX_VALUE;
                if (this.vWalletFile.exists()) {
                    Wallet wallet = new Wallet(this.params);
                    FileInputStream stream = new FileInputStream(this.vWalletFile);
                    new WalletProtobufSerializer().readWallet(WalletProtobufSerializer.parseToProto(stream), wallet);
                    time = wallet.getEarliestKeyCreationTime();
                }
                CheckpointManager.checkpoint(this.params, this.checkpoints, this.vStore, time);
            }
            this.vChain = new BlockChain(this.params, this.vStore);
            this.vPeerGroup = this.createPeerGroup();
            if (this.userAgent != null) {
                this.vPeerGroup.setUserAgent(this.userAgent, this.version);
            }
            if (this.vWalletFile.exists()) {
                walletStream = new FileInputStream(this.vWalletFile);
                this.vWallet = new Wallet(this.params);
                this.addWalletExtensions();
                new WalletProtobufSerializer().readWallet(WalletProtobufSerializer.parseToProto(walletStream), this.vWallet);
                if (shouldReplayWallet) {
                    this.vWallet.clearTransactions(0);
                }
            } else {
                this.vWallet = new Wallet(this.params);
                this.vWallet.addKey(new ECKey());
                this.addWalletExtensions();
            }
            if (this.useAutoSave) {
                this.vWallet.autosaveToFile(this.vWalletFile, 1L, TimeUnit.SECONDS, null);
            }
            if (this.peerAddresses != null) {
                for (PeerAddress addr : this.peerAddresses) {
                    this.vPeerGroup.addAddress(addr);
                }
                this.peerAddresses = null;
            } else {
                this.vPeerGroup.addPeerDiscovery(new DnsDiscovery(this.params));
            }
            this.vChain.addWallet(this.vWallet);
            this.vPeerGroup.addWallet(this.vWallet);
            this.onSetupCompleted();
            if (this.blockingStartup) {
                this.vPeerGroup.startAndWait();
                this.installShutdownHook();
                DownloadListener listener = new DownloadListener();
                this.vPeerGroup.startBlockChainDownload(listener);
                listener.await();
            } else {
                Futures.addCallback((ListenableFuture)this.vPeerGroup.start(), (FutureCallback)new FutureCallback<Service.State>(){

                    public void onSuccess(Service.State result) {
                        PeerEventListener l = WalletAppKit.this.downloadListener == null ? new DownloadListener() : WalletAppKit.this.downloadListener;
                        WalletAppKit.this.vPeerGroup.startBlockChainDownload(l);
                    }

                    public void onFailure(Throwable t) {
                        throw new RuntimeException(t);
                    }
                });
            }
        }
        catch (BlockStoreException e) {
            throw new IOException(e);
        }
        finally {
            if (walletStream != null) {
                walletStream.close();
            }
        }
    }

    protected PeerGroup createPeerGroup() {
        return new PeerGroup(this.params, this.vChain);
    }

    private void installShutdownHook() {
        if (this.autoStop) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        WalletAppKit.this.stopAndWait();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
    }

    protected void shutDown() throws Exception {
        try {
            this.vPeerGroup.stopAndWait();
            this.vWallet.saveToFile(this.vWalletFile);
            this.vStore.close();
            this.vPeerGroup = null;
            this.vWallet = null;
            this.vStore = null;
            this.vChain = null;
        }
        catch (BlockStoreException e) {
            throw new IOException(e);
        }
    }

    public NetworkParameters params() {
        return this.params;
    }

    public BlockChain chain() {
        Preconditions.checkState((this.state() == Service.State.STARTING || this.state() == Service.State.RUNNING ? 1 : 0) != 0, (Object)"Cannot call until startup is complete");
        return this.vChain;
    }

    public SPVBlockStore store() {
        Preconditions.checkState((this.state() == Service.State.STARTING || this.state() == Service.State.RUNNING ? 1 : 0) != 0, (Object)"Cannot call until startup is complete");
        return this.vStore;
    }

    public Wallet wallet() {
        Preconditions.checkState((this.state() == Service.State.STARTING || this.state() == Service.State.RUNNING ? 1 : 0) != 0, (Object)"Cannot call until startup is complete");
        return this.vWallet;
    }

    public PeerGroup peerGroup() {
        Preconditions.checkState((this.state() == Service.State.STARTING || this.state() == Service.State.RUNNING ? 1 : 0) != 0, (Object)"Cannot call until startup is complete");
        return this.vPeerGroup;
    }

    public File directory() {
        return this.directory;
    }
}

