/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.crypto;

import com.google.bitcoin.core.ECKey;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.VerificationException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class TransactionSignature
extends ECKey.ECDSASignature {
    public int sighashFlags = Transaction.SigHash.ALL.ordinal() + 1;

    public TransactionSignature(BigInteger r, BigInteger s) {
        super(r, s);
    }

    public TransactionSignature(ECKey.ECDSASignature signature, Transaction.SigHash mode, boolean anyoneCanPay) {
        super(signature.r, signature.s);
        this.setSigHash(mode, anyoneCanPay);
    }

    public static TransactionSignature dummy() {
        BigInteger val = ECKey.HALF_CURVE_ORDER;
        return new TransactionSignature(val, val);
    }

    public static int calcSigHashValue(Transaction.SigHash mode, boolean anyoneCanPay) {
        int sighashFlags = mode.ordinal() + 1;
        if (anyoneCanPay) {
            sighashFlags |= 0xFFFFFF80;
        }
        return sighashFlags;
    }

    public static boolean isEncodingCanonical(byte[] signature) {
        if (signature.length < 9 || signature.length > 73) {
            return false;
        }
        int hashType = signature[signature.length - 1] & 0x7F;
        if (hashType < Transaction.SigHash.ALL.ordinal() + 1 || hashType > Transaction.SigHash.SINGLE.ordinal() + 1) {
            return false;
        }
        if ((signature[0] & 0xFF) != 48 || (signature[1] & 0xFF) != signature.length - 3) {
            return false;
        }
        int lenR = signature[3] & 0xFF;
        if (5 + lenR >= signature.length || lenR == 0) {
            return false;
        }
        int lenS = signature[5 + lenR] & 0xFF;
        if (lenR + lenS + 7 != signature.length || lenS == 0) {
            return false;
        }
        if (signature[2] != 2 || (signature[4] & 0x80) == 128) {
            return false;
        }
        if (lenR > 1 && signature[4] == 0 && (signature[5] & 0x80) != 128) {
            return false;
        }
        if (signature[6 + lenR - 2] != 2 || (signature[6 + lenR] & 0x80) == 128) {
            return false;
        }
        return lenS <= 1 || signature[6 + lenR] != 0 || (signature[6 + lenR + 1] & 0x80) == 128;
    }

    public void setSigHash(Transaction.SigHash mode, boolean anyoneCanPay) {
        this.sighashFlags = TransactionSignature.calcSigHashValue(mode, anyoneCanPay);
    }

    public boolean anyoneCanPay() {
        return (this.sighashFlags & 0xFFFFFF80) != 0;
    }

    public Transaction.SigHash sigHashMode() {
        int mode = this.sighashFlags & 0x1F;
        if (mode == Transaction.SigHash.NONE.ordinal() + 1) {
            return Transaction.SigHash.NONE;
        }
        if (mode == Transaction.SigHash.SINGLE.ordinal() + 1) {
            return Transaction.SigHash.SINGLE;
        }
        return Transaction.SigHash.ALL;
    }

    public byte[] encodeToBitcoin() {
        try {
            ByteArrayOutputStream bos = this.derByteStream();
            bos.write(this.sighashFlags);
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static TransactionSignature decodeFromBitcoin(byte[] bytes, boolean requireCanonical) throws VerificationException {
        ECKey.ECDSASignature sig;
        if (requireCanonical && !TransactionSignature.isEncodingCanonical(bytes)) {
            throw new VerificationException("Signature encoding is not canonical.");
        }
        try {
            sig = ECKey.ECDSASignature.decodeFromDER(bytes);
        }
        catch (IllegalArgumentException e) {
            throw new VerificationException("Could not decode DER", e);
        }
        TransactionSignature tsig = new TransactionSignature(sig.r, sig.s);
        tsig.sighashFlags = bytes[bytes.length - 1];
        return tsig;
    }
}

