/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.crypto;

import com.google.bitcoin.core.Sha256Hash;
import com.google.bitcoin.crypto.MnemonicException;
import com.google.bitcoin.crypto.PBKDF2SHA512;
import com.google.common.base.Joiner;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.spongycastle.util.encoders.Hex;

public class MnemonicCode {
    private ArrayList<String> wordList;
    public static String BIP39_ENGLISH_SHA256 = "ad90bf3beb7b0eb7e5acd74727dc0da96e0a280a258354e7293fb7e211ac03db";
    private static final int PBKDF2_ROUNDS_V0_5 = 4096;
    private static final int PBKDF2_ROUNDS_V0_6 = 2048;

    public MnemonicCode() throws IOException {
        this(MnemonicCode.class.getResourceAsStream("mnemonic/wordlist/english.txt"), BIP39_ENGLISH_SHA256);
    }

    public MnemonicCode(InputStream wordstream, String wordListDigest) throws IOException, IllegalArgumentException {
        byte[] digest;
        String hexdigest;
        String word;
        MessageDigest md;
        BufferedReader br = new BufferedReader(new InputStreamReader(wordstream, "UTF-8"));
        this.wordList = new ArrayList();
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
        while ((word = br.readLine()) != null) {
            md.update(word.getBytes());
            this.wordList.add(word);
        }
        br.close();
        if (this.wordList.size() != 2048) {
            throw new IllegalArgumentException("input stream did not contain 2048 words");
        }
        if (wordListDigest != null && !(hexdigest = new String(Hex.encode((byte[])(digest = md.digest())))).equals(wordListDigest)) {
            throw new IllegalArgumentException("wordlist digest mismatch");
        }
    }

    public static byte[] toSeed(List<String> words, String passphrase) {
        return MnemonicCode.toSeed(words, passphrase, Version.V0_6);
    }

    public static byte[] toSeed(List<String> words, String passphrase, Version version) {
        String pass = Joiner.on((char)' ').join(words);
        String salt = "mnemonic" + passphrase;
        int rounds = version == Version.V0_5 ? 4096 : 2048;
        return PBKDF2SHA512.derive(pass, salt, rounds, 64);
    }

    public byte[] toEntropy(List<String> words) throws MnemonicException.MnemonicLengthException, MnemonicException.MnemonicWordException, MnemonicException.MnemonicChecksumException {
        int ii;
        if (words.size() % 3 > 0) {
            throw new MnemonicException.MnemonicLengthException("Word list size must be multiple of three words.");
        }
        int concatLenBits = words.size() * 11;
        boolean[] concatBits = new boolean[concatLenBits];
        int wordindex = 0;
        for (String word : words) {
            int ndx = Collections.binarySearch(this.wordList, word);
            if (ndx < 0) {
                throw new MnemonicException.MnemonicWordException(word);
            }
            for (ii = 0; ii < 11; ++ii) {
                concatBits[wordindex * 11 + ii] = (ndx & 1 << 10 - ii) != 0;
            }
            ++wordindex;
        }
        int checksumLengthBits = concatLenBits / 33;
        int entropyLengthBits = concatLenBits - checksumLengthBits;
        byte[] entropy = new byte[entropyLengthBits / 8];
        for (ii = 0; ii < entropy.length; ++ii) {
            for (int jj = 0; jj < 8; ++jj) {
                if (!concatBits[ii * 8 + jj]) continue;
                int n = ii;
                entropy[n] = (byte)(entropy[n] | 1 << 7 - jj);
            }
        }
        byte[] hash = Sha256Hash.create(entropy).getBytes();
        boolean[] hashBits = MnemonicCode.bytesToBits(hash);
        for (int i = 0; i < checksumLengthBits; ++i) {
            if (concatBits[entropyLengthBits + i] == hashBits[i]) continue;
            throw new MnemonicException.MnemonicChecksumException();
        }
        return entropy;
    }

    public List<String> toMnemonic(byte[] entropy) throws MnemonicException.MnemonicLengthException {
        if (entropy.length % 4 > 0) {
            throw new MnemonicException.MnemonicLengthException("entropy length not multiple of 32 bits");
        }
        byte[] hash = Sha256Hash.create(entropy).getBytes();
        boolean[] hashBits = MnemonicCode.bytesToBits(hash);
        boolean[] entropyBits = MnemonicCode.bytesToBits(entropy);
        int checksumLengthBits = entropyBits.length / 32;
        boolean[] concatBits = new boolean[entropyBits.length + checksumLengthBits];
        System.arraycopy(entropyBits, 0, concatBits, 0, entropyBits.length);
        System.arraycopy(hashBits, 0, concatBits, entropyBits.length, checksumLengthBits);
        ArrayList<String> words = new ArrayList<String>();
        int nwords = concatBits.length / 11;
        for (int i = 0; i < nwords; ++i) {
            int index = 0;
            for (int j = 0; j < 11; ++j) {
                index <<= 1;
                if (!concatBits[i * 11 + j]) continue;
                index |= 1;
            }
            words.add(this.wordList.get(index));
        }
        return words;
    }

    public void check(List<String> words) throws MnemonicException {
        this.toEntropy(words);
    }

    private static boolean[] bytesToBits(byte[] data) {
        boolean[] bits = new boolean[data.length * 8];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < 8; ++j) {
                bits[i * 8 + j] = (data[i] & 1 << 7 - j) != 0;
            }
        }
        return bits;
    }

    public static enum Version {
        V0_5,
        V0_6;

    }
}

