/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.crypto;

import com.google.bitcoin.crypto.EncryptedPrivateKey;
import com.google.bitcoin.crypto.KeyCrypter;
import com.google.bitcoin.crypto.KeyCrypterException;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import com.lambdaworks.crypto.SCrypt;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Arrays;
import org.bitcoinj.wallet.Protos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongycastle.crypto.BlockCipher;
import org.spongycastle.crypto.CipherParameters;
import org.spongycastle.crypto.engines.AESFastEngine;
import org.spongycastle.crypto.modes.CBCBlockCipher;
import org.spongycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.spongycastle.crypto.params.KeyParameter;
import org.spongycastle.crypto.params.ParametersWithIV;

public class KeyCrypterScrypt
implements KeyCrypter,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(KeyCrypterScrypt.class);
    private static final long serialVersionUID = 949662512049152670L;
    public static final int KEY_LENGTH = 32;
    public static final int BLOCK_LENGTH = 16;
    public static final int SALT_LENGTH = 8;
    private static final transient SecureRandom secureRandom = new SecureRandom();
    private final transient Protos.ScryptParameters scryptParameters;

    public KeyCrypterScrypt() {
        byte[] salt = new byte[8];
        secureRandom.nextBytes(salt);
        Protos.ScryptParameters.Builder scryptParametersBuilder = Protos.ScryptParameters.newBuilder().setSalt(ByteString.copyFrom((byte[])salt));
        this.scryptParameters = scryptParametersBuilder.build();
    }

    public KeyCrypterScrypt(Protos.ScryptParameters scryptParameters) {
        this.scryptParameters = (Protos.ScryptParameters)Preconditions.checkNotNull((Object)scryptParameters);
        if (scryptParameters.getSalt() == null || scryptParameters.getSalt().toByteArray() == null || scryptParameters.getSalt().toByteArray().length == 0) {
            log.warn("You are using a ScryptParameters with no salt. Your encryption may be vulnerable to a dictionary attack.");
        }
    }

    @Override
    public KeyParameter deriveKey(CharSequence password) throws KeyCrypterException {
        byte[] passwordBytes = null;
        try {
            passwordBytes = KeyCrypterScrypt.convertToByteArray(password);
            byte[] salt = new byte[]{};
            if (this.scryptParameters.getSalt() != null) {
                salt = this.scryptParameters.getSalt().toByteArray();
            } else {
                log.warn("You are using a ScryptParameters with no salt. Your encryption may be vulnerable to a dictionary attack.");
            }
            byte[] keyBytes = SCrypt.scrypt((byte[])passwordBytes, (byte[])salt, (int)((int)this.scryptParameters.getN()), (int)this.scryptParameters.getR(), (int)this.scryptParameters.getP(), (int)32);
            KeyParameter keyParameter = new KeyParameter(keyBytes);
            return keyParameter;
        }
        catch (Exception e) {
            throw new KeyCrypterException("Could not generate key from password and salt.", e);
        }
        finally {
            if (passwordBytes != null) {
                Arrays.fill(passwordBytes, (byte)0);
            }
        }
    }

    @Override
    public EncryptedPrivateKey encrypt(byte[] plainBytes, KeyParameter aesKey) throws KeyCrypterException {
        Preconditions.checkNotNull((Object)plainBytes);
        Preconditions.checkNotNull((Object)aesKey);
        try {
            byte[] iv = new byte[16];
            secureRandom.nextBytes(iv);
            ParametersWithIV keyWithIv = new ParametersWithIV((CipherParameters)aesKey, iv);
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESFastEngine()));
            cipher.init(true, (CipherParameters)keyWithIv);
            byte[] encryptedBytes = new byte[cipher.getOutputSize(plainBytes.length)];
            int length1 = cipher.processBytes(plainBytes, 0, plainBytes.length, encryptedBytes, 0);
            int length2 = cipher.doFinal(encryptedBytes, length1);
            return new EncryptedPrivateKey(iv, Arrays.copyOf(encryptedBytes, length1 + length2));
        }
        catch (Exception e) {
            throw new KeyCrypterException("Could not encrypt bytes.", e);
        }
    }

    @Override
    public byte[] decrypt(EncryptedPrivateKey privateKeyToDecode, KeyParameter aesKey) throws KeyCrypterException {
        Preconditions.checkNotNull((Object)privateKeyToDecode);
        Preconditions.checkNotNull((Object)aesKey);
        try {
            ParametersWithIV keyWithIv = new ParametersWithIV((CipherParameters)new KeyParameter(aesKey.getKey()), privateKeyToDecode.getInitialisationVector());
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESFastEngine()));
            cipher.init(false, (CipherParameters)keyWithIv);
            byte[] cipherBytes = privateKeyToDecode.getEncryptedBytes();
            byte[] decryptedBytes = new byte[cipher.getOutputSize(cipherBytes.length)];
            int length1 = cipher.processBytes(cipherBytes, 0, cipherBytes.length, decryptedBytes, 0);
            int length2 = cipher.doFinal(decryptedBytes, length1);
            return Arrays.copyOf(decryptedBytes, length1 + length2);
        }
        catch (Exception e) {
            throw new KeyCrypterException("Could not decrypt bytes", e);
        }
    }

    private static byte[] convertToByteArray(CharSequence charSequence) {
        Preconditions.checkNotNull((Object)charSequence);
        byte[] byteArray = new byte[charSequence.length() << 1];
        for (int i = 0; i < charSequence.length(); ++i) {
            int bytePosition = i << 1;
            byteArray[bytePosition] = (byte)((charSequence.charAt(i) & 0xFF00) >> 8);
            byteArray[bytePosition + 1] = (byte)(charSequence.charAt(i) & 0xFF);
        }
        return byteArray;
    }

    public Protos.ScryptParameters getScryptParameters() {
        return this.scryptParameters;
    }

    @Override
    public Protos.Wallet.EncryptionType getUnderstoodEncryptionType() {
        return Protos.Wallet.EncryptionType.ENCRYPTED_SCRYPT_AES;
    }

    public String toString() {
        return "Scrypt/AES";
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.scryptParameters});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyCrypterScrypt other = (KeyCrypterScrypt)obj;
        return Objects.equal((Object)this.scryptParameters, (Object)other.scryptParameters);
    }
}

