/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.crypto;

import com.google.bitcoin.core.ECKey;
import com.google.bitcoin.crypto.ChildNumber;
import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.spongycastle.crypto.CipherParameters;
import org.spongycastle.crypto.Digest;
import org.spongycastle.crypto.digests.SHA512Digest;
import org.spongycastle.crypto.macs.HMac;
import org.spongycastle.crypto.params.KeyParameter;
import org.spongycastle.math.ec.ECPoint;

public final class HDUtils {
    private HDUtils() {
    }

    static HMac createHmacSha512Digest(byte[] key) {
        SHA512Digest digest = new SHA512Digest();
        HMac hMac = new HMac((Digest)digest);
        hMac.init((CipherParameters)new KeyParameter(key));
        return hMac;
    }

    static byte[] hmacSha512(HMac hmacSha512, byte[] input) {
        hmacSha512.reset();
        hmacSha512.update(input, 0, input.length);
        byte[] out = new byte[64];
        hmacSha512.doFinal(out, 0);
        return out;
    }

    public static byte[] hmacSha512(byte[] key, byte[] data) {
        return HDUtils.hmacSha512(HDUtils.createHmacSha512Digest(key), data);
    }

    static ECPoint compressedCopy(ECPoint pubKPoint) {
        return ECKey.CURVE.getCurve().createPoint(pubKPoint.getX().toBigInteger(), pubKPoint.getY().toBigInteger(), true);
    }

    static ECPoint toUncompressed(ECPoint pubKPoint) {
        return ECKey.CURVE.getCurve().createPoint(pubKPoint.getX().toBigInteger(), pubKPoint.getY().toBigInteger(), false);
    }

    static byte[] toCompressed(byte[] uncompressedPoint) {
        return HDUtils.compressedCopy(ECKey.CURVE.getCurve().decodePoint(uncompressedPoint)).getEncoded();
    }

    static byte[] longTo4ByteArray(long n) {
        byte[] bytes = Arrays.copyOfRange(ByteBuffer.allocate(8).putLong(n).array(), 4, 8);
        assert (bytes.length == 4) : bytes.length;
        return bytes;
    }

    static byte[] getBytes(ECPoint pubKPoint) {
        return HDUtils.compressedCopy(pubKPoint).getEncoded();
    }

    static ImmutableList<ChildNumber> append(ImmutableList<ChildNumber> path, ChildNumber childNumber) {
        return ImmutableList.builder().addAll(path).add((Object)childNumber).build();
    }
}

