/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.crypto;

import com.google.bitcoin.core.ECKey;
import com.google.bitcoin.crypto.ChildNumber;
import com.google.bitcoin.crypto.DeterministicKey;
import com.google.bitcoin.crypto.HDDerivationException;
import com.google.bitcoin.crypto.HDUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.spongycastle.crypto.macs.HMac;
import org.spongycastle.math.ec.ECPoint;

public final class HDKeyDerivation {
    private static final HMac MASTER_HMAC_SHA512 = HDUtils.createHmacSha512Digest("Bitcoin seed".getBytes());

    private HDKeyDerivation() {
    }

    public static DeterministicKey createMasterPrivateKey(byte[] seed) throws HDDerivationException {
        Preconditions.checkArgument((seed.length > 8 ? 1 : 0) != 0, (Object)"Seed is too short and could be brute forced");
        byte[] i = HDUtils.hmacSha512(MASTER_HMAC_SHA512, seed);
        Preconditions.checkState((i.length == 64 ? 1 : 0) != 0, (Object)i.length);
        byte[] il = Arrays.copyOfRange(i, 0, 32);
        byte[] ir = Arrays.copyOfRange(i, 32, 64);
        Arrays.fill(i, (byte)0);
        DeterministicKey masterPrivKey = HDKeyDerivation.createMasterPrivKeyFromBytes(il, ir);
        Arrays.fill(il, (byte)0);
        Arrays.fill(ir, (byte)0);
        return masterPrivKey;
    }

    public static DeterministicKey createMasterPrivKeyFromBytes(byte[] privKeyBytes, byte[] chainCode) throws HDDerivationException {
        BigInteger privateKeyFieldElt = new BigInteger(1, privKeyBytes);
        HDKeyDerivation.assertNonZero(privateKeyFieldElt, "Generated master key is invalid.");
        HDKeyDerivation.assertLessThanN(privateKeyFieldElt, "Generated master key is invalid.");
        return new DeterministicKey((ImmutableList<ChildNumber>)ImmutableList.of(), chainCode, null, privateKeyFieldElt, null);
    }

    public static DeterministicKey createMasterPubKeyFromBytes(byte[] pubKeyBytes, byte[] chainCode) {
        return new DeterministicKey((ImmutableList<ChildNumber>)ImmutableList.of(), chainCode, ECKey.CURVE.getCurve().decodePoint(pubKeyBytes), null, null);
    }

    public static DeterministicKey deriveChildKey(DeterministicKey parent, int childNumber) {
        return HDKeyDerivation.deriveChildKey(parent, new ChildNumber(childNumber));
    }

    public static DeterministicKey deriveChildKey(DeterministicKey parent, ChildNumber childNumber) throws HDDerivationException {
        RawKeyBytes rawKey = HDKeyDerivation.deriveChildKeyBytes(parent, childNumber);
        return new DeterministicKey(HDUtils.append(parent.getChildNumberPath(), childNumber), rawKey.chainCode, parent.hasPrivate() ? null : ECKey.CURVE.getCurve().decodePoint(rawKey.keyBytes), parent.hasPrivate() ? new BigInteger(1, rawKey.keyBytes) : null, parent);
    }

    private static RawKeyBytes deriveChildKeyBytes(DeterministicKey parent, ChildNumber childNumber) throws HDDerivationException {
        byte[] keyBytes;
        byte[] parentPublicKey = HDUtils.getBytes(parent.getPubPoint());
        assert (parentPublicKey.length == 33) : parentPublicKey.length;
        ByteBuffer data = ByteBuffer.allocate(37);
        if (childNumber.isPrivateDerivation()) {
            data.put(parent.getPrivKeyBytes33());
        } else {
            data.put(parentPublicKey);
        }
        data.putInt(childNumber.getI());
        byte[] i = HDUtils.hmacSha512(parent.getChainCode(), data.array());
        assert (i.length == 64) : i.length;
        byte[] il = Arrays.copyOfRange(i, 0, 32);
        byte[] chainCode = Arrays.copyOfRange(i, 32, 64);
        BigInteger ilInt = new BigInteger(1, il);
        HDKeyDerivation.assertLessThanN(ilInt, "Illegal derived key: I_L >= n");
        BigInteger privAsFieldElement = parent.getPrivAsFieldElement();
        if (privAsFieldElement != null) {
            BigInteger ki = privAsFieldElement.add(ilInt).mod(ECKey.CURVE.getN());
            HDKeyDerivation.assertNonZero(ki, "Illegal derived key: derived private key equals 0.");
            keyBytes = ki.toByteArray();
        } else {
            Preconditions.checkArgument((!childNumber.isPrivateDerivation() ? 1 : 0) != 0, (Object)"Can't use private derivation with public keys only.");
            ECPoint Ki = ECKey.CURVE.getG().multiply(ilInt).add(parent.getPubPoint());
            Preconditions.checkArgument((!Ki.equals((Object)ECKey.CURVE.getCurve().getInfinity()) ? 1 : 0) != 0, (Object)"Illegal derived key: derived public key equals infinity.");
            keyBytes = HDUtils.toCompressed(Ki.getEncoded());
        }
        return new RawKeyBytes(keyBytes, chainCode);
    }

    private static void assertNonZero(BigInteger integer, String errorMessage) {
        Preconditions.checkArgument((!integer.equals(BigInteger.ZERO) ? 1 : 0) != 0, (Object)errorMessage);
    }

    private static void assertLessThanN(BigInteger integer, String errorMessage) {
        Preconditions.checkArgument((integer.compareTo(ECKey.CURVE.getN()) < 0 ? 1 : 0) != 0, (Object)errorMessage);
    }

    private static class RawKeyBytes {
        private final byte[] keyBytes;
        private final byte[] chainCode;

        private RawKeyBytes(byte[] keyBytes, byte[] chainCode) {
            this.keyBytes = keyBytes;
            this.chainCode = chainCode;
        }
    }
}

