/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.crypto;

import com.google.bitcoin.core.Base58;
import com.google.bitcoin.core.ECKey;
import com.google.bitcoin.core.Utils;
import com.google.bitcoin.crypto.ChildNumber;
import com.google.bitcoin.crypto.HDUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import javax.annotation.Nullable;
import org.spongycastle.math.ec.ECPoint;
import org.spongycastle.util.encoders.Hex;

public class DeterministicKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Joiner PATH_JOINER = Joiner.on((String)"/");
    private final DeterministicKey parent;
    private ECPoint publicAsPoint;
    private final BigInteger privateAsFieldElement;
    private final ImmutableList<ChildNumber> childNumberPath;
    private final byte[] chainCode;

    DeterministicKey(ImmutableList<ChildNumber> childNumberPath, byte[] chainCode, @Nullable ECPoint publicAsPoint, @Nullable BigInteger privateKeyFieldElt, @Nullable DeterministicKey parent) {
        Preconditions.checkArgument((chainCode.length == 32 ? 1 : 0) != 0);
        this.parent = parent;
        this.childNumberPath = childNumberPath;
        this.chainCode = Arrays.copyOf(chainCode, chainCode.length);
        this.publicAsPoint = publicAsPoint == null ? null : HDUtils.compressedCopy(publicAsPoint);
        this.privateAsFieldElement = privateKeyFieldElt;
    }

    public ImmutableList<ChildNumber> getChildNumberPath() {
        return this.childNumberPath;
    }

    private int getDepth() {
        return this.childNumberPath.size();
    }

    public ChildNumber getChildNumber() {
        return this.getDepth() == 0 ? ChildNumber.ZERO : (ChildNumber)this.childNumberPath.get(this.childNumberPath.size() - 1);
    }

    public byte[] getChainCode() {
        return this.chainCode;
    }

    public String getPath() {
        return PATH_JOINER.join(Iterables.concat(Collections.singleton("M"), this.getChildNumberPath()));
    }

    public byte[] getIdentifier() {
        return Utils.sha256hash160(this.getPubKeyBytes());
    }

    ECPoint getPubPoint() {
        if (this.publicAsPoint == null) {
            Preconditions.checkNotNull((Object)this.privateAsFieldElement);
            this.publicAsPoint = ECKey.CURVE.getG().multiply(this.privateAsFieldElement);
        }
        return HDUtils.compressedCopy(this.publicAsPoint);
    }

    public byte[] getPubKeyBytes() {
        return this.getPubPoint().getEncoded();
    }

    public byte[] getFingerprint() {
        return Arrays.copyOfRange(this.getIdentifier(), 0, 4);
    }

    @Nullable
    public BigInteger getPrivAsFieldElement() {
        return this.privateAsFieldElement;
    }

    @Nullable
    public DeterministicKey getParent() {
        return this.parent;
    }

    @Nullable
    public byte[] getPrivKeyBytes() {
        return this.privateAsFieldElement == null ? null : this.privateAsFieldElement.toByteArray();
    }

    public byte[] getPrivKeyBytes33() {
        byte[] bytes33 = new byte[33];
        byte[] priv = (byte[])Preconditions.checkNotNull((Object)this.getPrivKeyBytes(), (Object)"Private key missing");
        System.arraycopy(priv, 0, bytes33, 33 - priv.length, priv.length);
        return bytes33;
    }

    public DeterministicKey getPubOnly() {
        if (!this.hasPrivate()) {
            return this;
        }
        DeterministicKey parentPub = this.getParent() == null ? null : this.getParent().getPubOnly();
        return new DeterministicKey(this.getChildNumberPath(), this.getChainCode(), this.getPubPoint(), null, parentPub);
    }

    public boolean hasPrivate() {
        return this.privateAsFieldElement != null;
    }

    public ECKey toECKey() {
        return new ECKey(this.getPrivKeyBytes(), this.getPubKeyBytes());
    }

    public String serializePubB58() {
        return DeterministicKey.toBase58(this.serialize(true));
    }

    public String serializePrivB58() {
        return DeterministicKey.toBase58(this.serialize(false));
    }

    static String toBase58(byte[] ser) {
        return Base58.encode(DeterministicKey.addChecksum(ser));
    }

    static byte[] addChecksum(byte[] input) {
        int inputLength = input.length;
        byte[] checksummed = new byte[inputLength + 4];
        System.arraycopy(input, 0, checksummed, 0, inputLength);
        byte[] checksum = Utils.doubleDigest(input);
        System.arraycopy(checksum, 0, checksummed, inputLength, 4);
        return checksummed;
    }

    public byte[] serializePublic() {
        return this.serialize(true);
    }

    public byte[] serializePrivate() {
        return this.serialize(false);
    }

    private byte[] serialize(boolean pub) {
        ByteBuffer ser = ByteBuffer.allocate(78);
        ser.putInt(pub ? 76067358 : 76066276);
        ser.put((byte)this.getDepth());
        if (this.parent == null) {
            ser.putInt(0);
        } else {
            ser.put(this.parent.getFingerprint());
        }
        ser.putInt(this.getChildNumber().getI());
        ser.put(this.getChainCode());
        ser.put(pub ? this.getPubKeyBytes() : this.getPrivKeyBytes33());
        assert (ser.position() == 78);
        return ser.array();
    }

    public String toString() {
        return MessageFormat.format("ExtendedHierarchicKey[pub: {0}]", new String(Hex.encode((byte[])this.getPubKeyBytes())));
    }
}

