/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.crypto;

import com.google.bitcoin.crypto.ChildNumber;
import com.google.bitcoin.crypto.DeterministicKey;
import com.google.bitcoin.crypto.HDDerivationException;
import com.google.bitcoin.crypto.HDKeyDerivation;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class DeterministicHierarchy
implements Serializable {
    private static final int MAX_CHILD_DERIVATION_ATTEMPTS = 100;
    private final Map<ImmutableList<ChildNumber>, DeterministicKey> keys = Maps.newHashMap();
    private final ImmutableList<ChildNumber> rootPath;
    private final Map<ImmutableList<ChildNumber>, ChildNumber> lastPrivDerivedNumbers = Maps.newHashMap();
    private final Map<ImmutableList<ChildNumber>, ChildNumber> lastPubDerivedNumbers = Maps.newHashMap();

    public DeterministicHierarchy(DeterministicKey rootKey) {
        this.putKey(rootKey);
        this.rootPath = rootKey.getChildNumberPath();
    }

    private void putKey(DeterministicKey key) {
        this.keys.put(key.getChildNumberPath(), key);
    }

    public DeterministicKey get(List<ChildNumber> path, boolean relativePath, boolean create) {
        ImmutableList absolutePath;
        ImmutableList immutableList = absolutePath = relativePath ? ImmutableList.builder().addAll(this.rootPath).addAll(path).build() : ImmutableList.copyOf(path);
        if (!this.keys.containsKey(absolutePath)) {
            Preconditions.checkArgument((boolean)create, (String)"No key found for {} path {}.", (Object[])new Object[]{relativePath ? "relative" : "absolute", path});
            Preconditions.checkArgument((absolutePath.size() > 0 ? 1 : 0) != 0, (Object)"Can't derive the master key: nothing to derive from.");
            DeterministicKey parent = this.get((List<ChildNumber>)absolutePath.subList(0, absolutePath.size() - 1), relativePath, true);
            this.putKey(HDKeyDerivation.deriveChildKey(parent, (ChildNumber)absolutePath.get(absolutePath.size() - 1)));
        }
        return this.keys.get(absolutePath);
    }

    public DeterministicKey deriveNextChild(ImmutableList<ChildNumber> parentPath, boolean relative, boolean createParent, boolean privateDerivation) {
        DeterministicKey parent = this.get((List<ChildNumber>)parentPath, relative, createParent);
        int nAttempts = 0;
        while (nAttempts++ < 100) {
            try {
                ChildNumber createChildNumber = this.getNextChildNumberToDerive(parent.getChildNumberPath(), privateDerivation);
                return this.deriveChild(parent, createChildNumber);
            }
            catch (HDDerivationException ignore) {
            }
        }
        throw new HDDerivationException("Maximum number of child derivation attempts reached, this is probably an indication of a bug.");
    }

    private ChildNumber getNextChildNumberToDerive(ImmutableList<ChildNumber> path, boolean privateDerivation) {
        Map<ImmutableList<ChildNumber>, ChildNumber> lastDerivedNumbers = this.getLastDerivedNumbers(privateDerivation);
        ChildNumber lastChildNumber = lastDerivedNumbers.get(path);
        ChildNumber nextChildNumber = new ChildNumber(lastChildNumber != null ? lastChildNumber.getChildNumber() + 1 : 0, privateDerivation);
        lastDerivedNumbers.put(path, nextChildNumber);
        return nextChildNumber;
    }

    public DeterministicKey deriveChild(List<ChildNumber> parentPath, boolean relative, boolean createParent, ChildNumber createChildNumber) {
        return this.deriveChild(this.get(parentPath, relative, createParent), createChildNumber);
    }

    private DeterministicKey deriveChild(DeterministicKey parent, ChildNumber createChildNumber) {
        DeterministicKey childKey = HDKeyDerivation.deriveChildKey(parent, createChildNumber);
        this.putKey(childKey);
        return childKey;
    }

    public DeterministicKey getRootKey() {
        return this.get((List<ChildNumber>)this.rootPath, false, false);
    }

    private Map<ImmutableList<ChildNumber>, ChildNumber> getLastDerivedNumbers(boolean privateDerivation) {
        return privateDerivation ? this.lastPrivDerivedNumbers : this.lastPubDerivedNumbers;
    }
}

