/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.crypto;

public class ChildNumber {
    public static final int PRIV_BIT = Integer.MIN_VALUE;
    public static final ChildNumber ZERO = new ChildNumber(0);
    private final int i;

    public ChildNumber(int childNumber, boolean isPrivate) {
        if (ChildNumber.hasPrivateBit(childNumber)) {
            throw new IllegalArgumentException("Most significant bit is reserved and shouldn't be set: " + childNumber);
        }
        this.i = isPrivate ? childNumber | Integer.MIN_VALUE : childNumber;
    }

    public ChildNumber(int i) {
        this.i = i;
    }

    public int getI() {
        return this.i;
    }

    public boolean isPrivateDerivation() {
        return ChildNumber.hasPrivateBit(this.i);
    }

    private static boolean hasPrivateBit(int a) {
        return (a & Integer.MIN_VALUE) != 0;
    }

    public int getChildNumber() {
        return this.i & Integer.MAX_VALUE;
    }

    public String toString() {
        return String.format("%d%s", this.getChildNumber(), this.isPrivateDerivation() ? "'" : "");
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.i == ((ChildNumber)o).i;
    }

    public int hashCode() {
        return this.i;
    }
}

