/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.AbstractBlockChain;
import com.google.bitcoin.core.Address;
import com.google.bitcoin.core.BlockChainListener;
import com.google.bitcoin.core.BloomFilter;
import com.google.bitcoin.core.ECKey;
import com.google.bitcoin.core.InsufficientMoneyException;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.Peer;
import com.google.bitcoin.core.PeerFilterProvider;
import com.google.bitcoin.core.ScriptException;
import com.google.bitcoin.core.Sha256Hash;
import com.google.bitcoin.core.StoredBlock;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.TransactionBroadcaster;
import com.google.bitcoin.core.TransactionConfidence;
import com.google.bitcoin.core.TransactionInput;
import com.google.bitcoin.core.TransactionOutPoint;
import com.google.bitcoin.core.TransactionOutput;
import com.google.bitcoin.core.Utils;
import com.google.bitcoin.core.VarInt;
import com.google.bitcoin.core.VerificationException;
import com.google.bitcoin.core.WalletEventListener;
import com.google.bitcoin.core.WalletExtension;
import com.google.bitcoin.crypto.KeyCrypter;
import com.google.bitcoin.crypto.KeyCrypterException;
import com.google.bitcoin.crypto.KeyCrypterScrypt;
import com.google.bitcoin.script.Script;
import com.google.bitcoin.script.ScriptBuilder;
import com.google.bitcoin.script.ScriptChunk;
import com.google.bitcoin.store.UnreadableWalletException;
import com.google.bitcoin.store.WalletProtobufSerializer;
import com.google.bitcoin.utils.ListenerRegistration;
import com.google.bitcoin.utils.Threading;
import com.google.bitcoin.wallet.AllowUnconfirmedCoinSelector;
import com.google.bitcoin.wallet.CoinSelection;
import com.google.bitcoin.wallet.CoinSelector;
import com.google.bitcoin.wallet.DefaultCoinSelector;
import com.google.bitcoin.wallet.DefaultRiskAnalysis;
import com.google.bitcoin.wallet.KeyTimeCoinSelector;
import com.google.bitcoin.wallet.RiskAnalysis;
import com.google.bitcoin.wallet.WalletFiles;
import com.google.bitcoin.wallet.WalletTransaction;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.bitcoinj.wallet.Protos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongycastle.crypto.params.KeyParameter;
import org.spongycastle.util.encoders.Hex;

public class Wallet
implements Serializable,
BlockChainListener,
PeerFilterProvider {
    private static final Logger log = LoggerFactory.getLogger(Wallet.class);
    private static final long serialVersionUID = 2L;
    private static final int MINIMUM_BLOOM_DATA_LENGTH = 8;
    protected final ReentrantLock lock = Threading.lock("wallet");
    final Map<Sha256Hash, Transaction> pending;
    final Map<Sha256Hash, Transaction> unspent;
    final Map<Sha256Hash, Transaction> spent;
    final Map<Sha256Hash, Transaction> dead;
    final Map<Sha256Hash, Transaction> transactions;
    private ArrayList<ECKey> keychain;
    private Set<Script> watchedScripts;
    private final NetworkParameters params;
    @Nullable
    private Sha256Hash lastBlockSeenHash;
    private int lastBlockSeenHeight;
    private long lastBlockSeenTimeSecs;
    private transient CopyOnWriteArrayList<ListenerRegistration<WalletEventListener>> eventListeners;
    private transient TransactionConfidence.Listener txConfidenceListener;
    private transient HashSet<Sha256Hash> ignoreNextNewBlock;
    private boolean acceptRiskyTransactions;
    private int onWalletChangedSuppressions;
    private boolean insideReorg;
    private Map<Transaction, TransactionConfidence.Listener.ChangeReason> confidenceChanged;
    private volatile WalletFiles vFileManager;
    private volatile TransactionBroadcaster vTransactionBroadcaster;
    private volatile long vKeyRotationTimestamp;
    private volatile boolean vKeyRotationEnabled;
    private transient CoinSelector coinSelector = new DefaultCoinSelector();
    private KeyCrypter keyCrypter;
    private int version;
    private String description;
    private final HashMap<String, WalletExtension> extensions;
    private RiskAnalysis.Analyzer riskAnalyzer = DefaultRiskAnalysis.FACTORY;
    private static final Comparator<Transaction> SORT_ORDER_BY_UPDATE_TIME = new Comparator<Transaction>(){

        @Override
        public int compare(Transaction tx1, Transaction tx2) {
            long time1 = tx1.getUpdateTime().getTime();
            long time2 = tx2.getUpdateTime().getTime();
            return -Longs.compare((long)time1, (long)time2);
        }
    };
    private static final Comparator<Transaction> SORT_ORDER_BY_HEIGHT = new Comparator<Transaction>(){

        @Override
        public int compare(Transaction tx1, Transaction tx2) {
            int height1 = tx1.getConfidence().getAppearedAtChainHeight();
            int height2 = tx2.getConfidence().getAppearedAtChainHeight();
            return -Ints.compare((int)height1, (int)height2);
        }
    };
    @GuardedBy(value="lock")
    private List<BalanceFutureRequest> balanceFutureRequests = Lists.newLinkedList();

    public Wallet(NetworkParameters params) {
        this.params = (NetworkParameters)Preconditions.checkNotNull((Object)params);
        this.keychain = new ArrayList();
        this.watchedScripts = Sets.newHashSet();
        this.unspent = new HashMap<Sha256Hash, Transaction>();
        this.spent = new HashMap<Sha256Hash, Transaction>();
        this.pending = new HashMap<Sha256Hash, Transaction>();
        this.dead = new HashMap<Sha256Hash, Transaction>();
        this.transactions = new HashMap<Sha256Hash, Transaction>();
        this.eventListeners = new CopyOnWriteArrayList();
        this.extensions = new HashMap();
        this.confidenceChanged = new HashMap<Transaction, TransactionConfidence.Listener.ChangeReason>();
        this.createTransientState();
    }

    public Wallet(NetworkParameters params, KeyCrypter keyCrypter) {
        this(params);
        this.keyCrypter = (KeyCrypter)Preconditions.checkNotNull((Object)keyCrypter);
    }

    private void createTransientState() {
        this.ignoreNextNewBlock = new HashSet();
        this.txConfidenceListener = new TransactionConfidence.Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConfidenceChanged(Transaction tx, TransactionConfidence.Listener.ChangeReason reason) {
                if (reason == TransactionConfidence.Listener.ChangeReason.SEEN_PEERS) {
                    Wallet.this.lock.lock();
                    try {
                        Wallet.this.checkBalanceFuturesLocked(null);
                        Wallet.this.queueOnTransactionConfidenceChanged(tx);
                        Wallet.this.maybeQueueOnWalletChanged();
                    }
                    finally {
                        Wallet.this.lock.unlock();
                    }
                }
            }
        };
        this.acceptRiskyTransactions = false;
    }

    public NetworkParameters getNetworkParameters() {
        return this.params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ECKey> getKeys() {
        this.lock.lock();
        try {
            ArrayList<ECKey> arrayList = new ArrayList<ECKey>(this.keychain);
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Script> getWatchedScripts() {
        this.lock.lock();
        try {
            ArrayList<Script> arrayList = new ArrayList<Script>(this.watchedScripts);
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeKey(ECKey key) {
        this.lock.lock();
        try {
            boolean bl = this.keychain.remove(key);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getKeychainSize() {
        this.lock.lock();
        try {
            int n = this.keychain.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void saveToFile(File temp, File destFile) throws IOException {
        FileOutputStream stream = null;
        this.lock.lock();
        try {
            stream = new FileOutputStream(temp);
            this.saveToFileStream(stream);
            stream.flush();
            stream.getFD().sync();
            stream.close();
            stream = null;
            if (Utils.isWindows()) {
                File canonical = destFile.getCanonicalFile();
                canonical.delete();
                if (temp.renameTo(canonical)) {
                    return;
                }
                throw new IOException("Failed to rename " + temp + " to " + canonical);
            }
            if (!temp.renameTo(destFile)) {
                throw new IOException("Failed to rename " + temp + " to " + destFile);
            }
        }
        catch (RuntimeException e) {
            log.error("Failed whilst saving wallet", (Throwable)e);
            throw e;
        }
        finally {
            this.lock.unlock();
            if (stream != null) {
                stream.close();
            }
            if (temp.delete()) {
                log.warn("Deleted temp file after failed save.");
            }
        }
    }

    public void saveToFile(File f) throws IOException {
        File directory = f.getAbsoluteFile().getParentFile();
        File temp = File.createTempFile("wallet", null, directory);
        this.saveToFile(temp, f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAcceptRiskyTransactions(boolean acceptRiskyTransactions) {
        this.lock.lock();
        try {
            this.acceptRiskyTransactions = acceptRiskyTransactions;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doesAcceptRiskyTransactions() {
        this.lock.lock();
        try {
            boolean bl = this.acceptRiskyTransactions;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRiskAnalyzer(RiskAnalysis.Analyzer analyzer) {
        this.lock.lock();
        try {
            this.riskAnalyzer = (RiskAnalysis.Analyzer)Preconditions.checkNotNull((Object)analyzer);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RiskAnalysis.Analyzer getRiskAnalyzer() {
        this.lock.lock();
        try {
            RiskAnalysis.Analyzer analyzer = this.riskAnalyzer;
            return analyzer;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WalletFiles autosaveToFile(File f, long delayTime, TimeUnit timeUnit, @Nullable WalletFiles.Listener eventListener) {
        this.lock.lock();
        try {
            Preconditions.checkState((this.vFileManager == null ? 1 : 0) != 0, (Object)"Already auto saving this wallet.");
            WalletFiles manager = new WalletFiles(this, f, delayTime, timeUnit);
            if (eventListener != null) {
                manager.setListener(eventListener);
            }
            this.vFileManager = manager;
            WalletFiles walletFiles = manager;
            return walletFiles;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownAutosaveAndWait() {
        this.lock.lock();
        try {
            WalletFiles files = this.vFileManager;
            this.vFileManager = null;
            Preconditions.checkState((files != null ? 1 : 0) != 0, (Object)"Auto saving not enabled.");
            files.shutdownAndWait();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void saveLater() {
        WalletFiles files = this.vFileManager;
        if (files != null) {
            files.saveLater();
        }
    }

    private void saveNow() {
        block3: {
            WalletFiles files = this.vFileManager;
            if (files != null) {
                try {
                    files.saveNow();
                }
                catch (IOException e) {
                    log.error("Failed to save wallet to disk!", (Throwable)e);
                    Thread.UncaughtExceptionHandler handler = Threading.uncaughtExceptionHandler;
                    if (handler == null) break block3;
                    handler.uncaughtException(Thread.currentThread(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToFileStream(OutputStream f) throws IOException {
        this.lock.lock();
        try {
            new WalletProtobufSerializer().writeWallet(this, f);
        }
        finally {
            this.lock.unlock();
        }
    }

    public NetworkParameters getParams() {
        return this.params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Wallet loadFromFile(File f) throws UnreadableWalletException {
        Wallet wallet;
        block6: {
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(f);
                wallet = Wallet.loadFromFileStream(stream);
                if (stream == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UnreadableWalletException("Could not open file", e);
                }
            }
            stream.close();
        }
        return wallet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConsistent() {
        this.lock.lock();
        try {
            int size2;
            boolean success = true;
            Set<Transaction> transactions = this.getTransactions(true);
            HashSet<Sha256Hash> hashes = new HashSet<Sha256Hash>();
            for (Transaction tx : transactions) {
                hashes.add(tx.getHash());
            }
            int size1 = transactions.size();
            if (size1 != hashes.size()) {
                log.error("Two transactions with same hash");
                success = false;
            }
            if (size1 != (size2 = this.unspent.size() + this.spent.size() + this.pending.size() + this.dead.size())) {
                log.error("Inconsistent wallet sizes: {} {}", (Object)size1, (Object)size2);
                success = false;
            }
            for (Transaction tx : this.unspent.values()) {
                if (tx.isConsistent(this, false)) continue;
                success = false;
                log.error("Inconsistent unspent tx {}", (Object)tx.getHashAsString());
            }
            for (Transaction tx : this.spent.values()) {
                if (tx.isConsistent(this, true)) continue;
                success = false;
                log.error("Inconsistent spent tx {}", (Object)tx.getHashAsString());
            }
            if (!success) {
                try {
                    log.error(this.toString());
                }
                catch (RuntimeException x) {
                    log.error("Printing inconsistent wallet failed", (Throwable)x);
                }
            }
            boolean bl = success;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public static Wallet loadFromFileStream(InputStream stream) throws UnreadableWalletException {
        Wallet wallet = new WalletProtobufSerializer().readWallet(stream);
        if (!wallet.isConsistent()) {
            log.error("Loaded an inconsistent wallet");
        }
        return wallet;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.createTransientState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyTransactionIsInBlock(Sha256Hash txHash, StoredBlock block, AbstractBlockChain.NewBlockType blockType, int relativityOffset) throws VerificationException {
        this.lock.lock();
        try {
            Transaction tx = this.transactions.get(txHash);
            if (tx == null) {
                log.error("TX {} not found despite being sent to wallet", (Object)txHash);
                return;
            }
            this.receive(tx, block, blockType, relativityOffset);
        }
        finally {
            this.lock.unlock();
        }
        if (blockType == AbstractBlockChain.NewBlockType.BEST_CHAIN) {
            this.maybeRotateKeys();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivePending(Transaction tx, @Nullable List<Transaction> dependencies, boolean overrideIsRelevant) throws VerificationException {
        this.lock.lock();
        try {
            tx.verify();
            EnumSet<WalletTransaction.Pool> containingPools = this.getContainingPools(tx);
            if (!containingPools.equals(EnumSet.noneOf(WalletTransaction.Pool.class))) {
                log.debug("Received tx we already saw in a block or created ourselves: " + tx.getHashAsString());
                return;
            }
            if (!overrideIsRelevant && !this.isPendingTransactionRelevant(tx)) {
                return;
            }
            if (this.isTransactionRisky(tx, dependencies) && !this.acceptRiskyTransactions) {
                return;
            }
            BigInteger valueSentToMe = tx.getValueSentToMe(this);
            BigInteger valueSentFromMe = tx.getValueSentFromMe(this);
            if (log.isInfoEnabled()) {
                log.info(String.format("Received a pending transaction %s that spends %s BTC from our own wallet, and sends us %s BTC", tx.getHashAsString(), Utils.bitcoinValueToFriendlyString(valueSentFromMe), Utils.bitcoinValueToFriendlyString(valueSentToMe)));
            }
            if (tx.getConfidence().getSource().equals((Object)TransactionConfidence.Source.UNKNOWN)) {
                log.warn("Wallet received transaction with an unknown source. Consider tagging it!");
            }
            this.commitTx(tx);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTransactionRisky(Transaction tx, @Nullable List<Transaction> dependencies) {
        this.lock.lock();
        try {
            RiskAnalysis analysis;
            RiskAnalysis.Result result;
            if (dependencies == null) {
                dependencies = ImmutableList.of();
            }
            if ((result = (analysis = this.riskAnalyzer.create(this, tx, (List<Transaction>)dependencies)).analyze()) != RiskAnalysis.Result.OK) {
                log.warn("Pending transaction {} was considered risky: {}", (Object)tx.getHashAsString(), (Object)analysis);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void receivePending(Transaction tx, @Nullable List<Transaction> dependencies) throws VerificationException {
        this.receivePending(tx, dependencies, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPendingTransactionRelevant(Transaction tx) throws ScriptException {
        this.lock.lock();
        try {
            EnumSet<WalletTransaction.Pool> containingPools = this.getContainingPools(tx);
            if (!containingPools.equals(EnumSet.noneOf(WalletTransaction.Pool.class))) {
                log.debug("Received tx we already saw in a block or created ourselves: " + tx.getHashAsString());
                boolean bl = false;
                return bl;
            }
            if (!this.isTransactionRelevant(tx)) {
                log.debug("Received tx that isn't relevant to this wallet, discarding.");
                boolean bl = false;
                return bl;
            }
            if (this.isTransactionRisky(tx, null) && !this.acceptRiskyTransactions) {
                log.warn("Received transaction {} with a lock time of {}, but not configured to accept these, discarding", (Object)tx.getHashAsString(), (Object)tx.getLockTime());
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTransactionRelevant(Transaction tx) throws ScriptException {
        this.lock.lock();
        try {
            boolean bl = tx.getValueSentFromMe(this).compareTo(BigInteger.ZERO) > 0 || tx.getValueSentToMe(this).compareTo(BigInteger.ZERO) > 0 || this.checkForDoubleSpendAgainstPending(tx, false);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean checkForDoubleSpendAgainstPending(Transaction tx, boolean takeAction) {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        HashSet<TransactionOutPoint> outpoints = new HashSet<TransactionOutPoint>();
        for (TransactionInput input : tx.getInputs()) {
            outpoints.add(input.getOutpoint());
        }
        LinkedList doubleSpentTxns = Lists.newLinkedList();
        for (Transaction p : this.pending.values()) {
            for (TransactionInput input : p.getInputs()) {
                TransactionOutPoint outpoint = input.getOutpoint();
                if (!outpoints.contains(outpoint) || !doubleSpentTxns.isEmpty() && doubleSpentTxns.getLast() == p) continue;
                doubleSpentTxns.add(p);
            }
        }
        if (takeAction && !doubleSpentTxns.isEmpty()) {
            this.killTx(tx, doubleSpentTxns);
        }
        return !doubleSpentTxns.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveFromBlock(Transaction tx, StoredBlock block, AbstractBlockChain.NewBlockType blockType, int relativityOffset) throws VerificationException {
        this.lock.lock();
        try {
            this.receive(tx, block, blockType, relativityOffset);
        }
        finally {
            this.lock.unlock();
        }
        if (blockType == AbstractBlockChain.NewBlockType.BEST_CHAIN) {
            this.maybeRotateKeys();
        }
    }

    private void receive(Transaction tx, StoredBlock block, AbstractBlockChain.NewBlockType blockType, int relativityOffset) throws VerificationException {
        boolean wasPending;
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        BigInteger prevBalance = this.getBalance();
        Sha256Hash txHash = tx.getHash();
        boolean bestChain = blockType == AbstractBlockChain.NewBlockType.BEST_CHAIN;
        boolean sideChain = blockType == AbstractBlockChain.NewBlockType.SIDE_CHAIN;
        BigInteger valueSentFromMe = tx.getValueSentFromMe(this);
        BigInteger valueSentToMe = tx.getValueSentToMe(this);
        BigInteger valueDifference = valueSentToMe.subtract(valueSentFromMe);
        log.info("Received tx{} for {} BTC: {} [{}] in block {}", new Object[]{sideChain ? " on a side chain" : "", Utils.bitcoinValueToFriendlyString(valueDifference), tx.getHashAsString(), relativityOffset, block != null ? block.getHeader().getHash() : "(unit test)"});
        ++this.onWalletChangedSuppressions;
        Transaction tmp = this.transactions.get(tx.getHash());
        if (tmp != null) {
            tx = tmp;
        }
        boolean bl = wasPending = this.pending.remove(txHash) != null;
        if (wasPending) {
            log.info("  <-pending");
        }
        if (bestChain) {
            if (wasPending) {
                for (TransactionOutput output : tx.getOutputs()) {
                    TransactionInput spentBy = output.getSpentBy();
                    if (spentBy == null) continue;
                    spentBy.disconnect();
                }
            }
            this.processTxFromBestChain(tx, wasPending);
        } else {
            Preconditions.checkState((boolean)sideChain);
            if (wasPending) {
                this.addWalletTransaction(WalletTransaction.Pool.PENDING, tx);
                log.info("  ->pending");
            } else {
                Sha256Hash hash = tx.getHash();
                if (!this.unspent.containsKey(hash) && !this.spent.containsKey(hash)) {
                    this.commitTx(tx);
                }
            }
        }
        if (block != null) {
            tx.setBlockAppearance(block, bestChain, relativityOffset);
            if (bestChain) {
                this.ignoreNextNewBlock.add(txHash);
            }
        }
        --this.onWalletChangedSuppressions;
        if (bestChain) {
            this.confidenceChanged.put(tx, TransactionConfidence.Listener.ChangeReason.TYPE);
        } else {
            this.maybeQueueOnWalletChanged();
        }
        if (!this.insideReorg && bestChain) {
            BigInteger newBalance = this.getBalance();
            log.info("Balance is now: " + Utils.bitcoinValueToFriendlyString(newBalance));
            if (!wasPending) {
                int diff = valueDifference.compareTo(BigInteger.ZERO);
                if (diff > 0) {
                    this.queueOnCoinsReceived(tx, prevBalance, newBalance);
                } else if (diff < 0) {
                    this.queueOnCoinsSent(tx, prevBalance, newBalance);
                }
            }
            this.checkBalanceFuturesLocked(newBalance);
        }
        this.informConfidenceListenersIfNotReorganizing();
        Preconditions.checkState((boolean)this.isConsistent());
        this.saveNow();
    }

    private void informConfidenceListenersIfNotReorganizing() {
        if (this.insideReorg) {
            return;
        }
        for (Map.Entry<Transaction, TransactionConfidence.Listener.ChangeReason> entry : this.confidenceChanged.entrySet()) {
            Transaction tx = entry.getKey();
            tx.getConfidence().queueListeners(entry.getValue());
            this.queueOnTransactionConfidenceChanged(tx);
        }
        this.confidenceChanged.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyNewBestBlock(StoredBlock block) throws VerificationException {
        Sha256Hash newBlockHash = block.getHeader().getHash();
        if (newBlockHash.equals(this.getLastBlockSeenHash())) {
            return;
        }
        this.lock.lock();
        try {
            this.setLastBlockSeenHash(newBlockHash);
            this.setLastBlockSeenHeight(block.getHeight());
            this.setLastBlockSeenTimeSecs(block.getHeader().getTimeSeconds());
            Set<Transaction> transactions = this.getTransactions(true);
            for (Transaction tx : transactions) {
                if (this.ignoreNextNewBlock.contains(tx.getHash())) {
                    this.ignoreNextNewBlock.remove(tx.getHash());
                    continue;
                }
                if (tx.getConfidence().getConfidenceType() != TransactionConfidence.ConfidenceType.BUILDING) continue;
                tx.getConfidence().notifyWorkDone(block.getHeader());
                this.confidenceChanged.put(tx, TransactionConfidence.Listener.ChangeReason.DEPTH);
            }
            this.informConfidenceListenersIfNotReorganizing();
            this.maybeQueueOnWalletChanged();
            this.saveLater();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void processTxFromBestChain(Transaction tx, boolean forceAddToPool) throws VerificationException {
        boolean hasOutputsToMe;
        boolean isDeadCoinbase;
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        Preconditions.checkState((!this.pending.containsKey(tx.getHash()) ? 1 : 0) != 0);
        boolean bl = isDeadCoinbase = tx.isCoinBase() && this.dead.containsKey(tx.getHash());
        if (isDeadCoinbase) {
            log.info("  coinbase tx {} <-dead: confidence {}", (Object)tx.getHashAsString(), (Object)tx.getConfidence().getConfidenceType().name());
            this.dead.remove(tx.getHash());
        }
        this.updateForSpends(tx, true);
        boolean bl2 = hasOutputsToMe = tx.getValueSentToMe(this, true).compareTo(BigInteger.ZERO) > 0;
        if (hasOutputsToMe) {
            if (tx.isEveryOwnedOutputSpent(this)) {
                log.info("  tx {} ->spent (by pending)", (Object)tx.getHashAsString());
                this.addWalletTransaction(WalletTransaction.Pool.SPENT, tx);
            } else {
                log.info("  tx {} ->unspent", (Object)tx.getHashAsString());
                this.addWalletTransaction(WalletTransaction.Pool.UNSPENT, tx);
            }
        } else if (tx.getValueSentFromMe(this).compareTo(BigInteger.ZERO) > 0) {
            log.info("  tx {} ->spent", (Object)tx.getHashAsString());
            this.addWalletTransaction(WalletTransaction.Pool.SPENT, tx);
        } else if (forceAddToPool) {
            log.info("  tx {} ->spent (manually added)", (Object)tx.getHashAsString());
            this.addWalletTransaction(WalletTransaction.Pool.SPENT, tx);
        }
        this.checkForDoubleSpendAgainstPending(tx, true);
    }

    private void updateForSpends(Transaction tx, boolean fromChain) throws VerificationException {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        if (fromChain) {
            Preconditions.checkState((!this.pending.containsKey(tx.getHash()) ? 1 : 0) != 0);
        }
        for (TransactionInput input : tx.getInputs()) {
            TransactionInput.ConnectionResult result = input.connect(this.unspent, TransactionInput.ConnectMode.ABORT_ON_CONFLICT);
            if (result == TransactionInput.ConnectionResult.NO_SUCH_TX && (result = input.connect(this.spent, TransactionInput.ConnectMode.ABORT_ON_CONFLICT)) == TransactionInput.ConnectionResult.NO_SUCH_TX && (result = input.connect(this.pending, TransactionInput.ConnectMode.ABORT_ON_CONFLICT)) == TransactionInput.ConnectionResult.NO_SUCH_TX) continue;
            if (result == TransactionInput.ConnectionResult.ALREADY_SPENT) {
                if (fromChain) {
                    log.warn("updateForSpends: saw double spend from chain, handling later.");
                    continue;
                }
                log.warn("Saw two pending transactions double spend each other");
                log.warn("  offending input is input {}", (Object)tx.getInputs().indexOf(input));
                log.warn("{}: {}", (Object)tx.getHash(), (Object)new String(Hex.encode((byte[])tx.unsafeBitcoinSerialize())));
                Transaction other = input.getConnectedOutput().getSpentBy().getParentTransaction();
                log.warn("{}: {}", (Object)other.getHash(), (Object)new String(Hex.encode((byte[])tx.unsafeBitcoinSerialize())));
                continue;
            }
            if (result != TransactionInput.ConnectionResult.SUCCESS) continue;
            Transaction connected = (Transaction)Preconditions.checkNotNull((Object)input.getOutpoint().fromTx);
            log.info("  marked {} as spent", (Object)input.getOutpoint());
            this.maybeMovePool(connected, "prevtx");
        }
        if (fromChain) {
            for (Transaction pendingTx : this.pending.values()) {
                for (TransactionInput input : pendingTx.getInputs()) {
                    TransactionInput.ConnectionResult result = input.connect(tx, TransactionInput.ConnectMode.ABORT_ON_CONFLICT);
                    Preconditions.checkState((result != TransactionInput.ConnectionResult.ALREADY_SPENT ? 1 : 0) != 0);
                    if (result != TransactionInput.ConnectionResult.SUCCESS) continue;
                    log.info("Connected pending tx input {}:{}", (Object)pendingTx.getHashAsString(), (Object)pendingTx.getInputs().indexOf(input));
                }
            }
        }
    }

    private void killCoinbase(Transaction coinbase) {
        log.warn("Coinbase killed by re-org: {}", (Object)coinbase.getHashAsString());
        coinbase.getConfidence().setOverridingTransaction(null);
        this.confidenceChanged.put(coinbase, TransactionConfidence.Listener.ChangeReason.TYPE);
        Sha256Hash hash = coinbase.getHash();
        this.pending.remove(hash);
        this.unspent.remove(hash);
        this.spent.remove(hash);
        this.addWalletTransaction(WalletTransaction.Pool.DEAD, coinbase);
    }

    private void killTx(Transaction overridingTx, List<Transaction> killedTx) {
        for (Transaction tx : killedTx) {
            log.warn("Saw double spend from chain override pending tx {}", (Object)tx.getHashAsString());
            log.warn("  <-pending ->dead   killed by {}", (Object)overridingTx.getHashAsString());
            log.warn("Disconnecting each input and moving connected transactions.");
            this.pending.remove(tx.getHash());
            this.addWalletTransaction(WalletTransaction.Pool.DEAD, tx);
            for (TransactionInput deadInput : tx.getInputs()) {
                Transaction connected = deadInput.getOutpoint().fromTx;
                if (connected == null) continue;
                deadInput.disconnect();
                this.maybeMovePool(connected, "kill");
            }
            tx.getConfidence().setOverridingTransaction(overridingTx);
            this.confidenceChanged.put(tx, TransactionConfidence.Listener.ChangeReason.TYPE);
        }
        log.warn("Now attempting to connect the inputs of the overriding transaction.");
        for (TransactionInput input : overridingTx.getInputs()) {
            TransactionInput.ConnectionResult result = input.connect(this.unspent, TransactionInput.ConnectMode.DISCONNECT_ON_CONFLICT);
            if (result == TransactionInput.ConnectionResult.SUCCESS) {
                this.maybeMovePool(input.getOutpoint().fromTx, "kill");
                continue;
            }
            result = input.connect(this.spent, TransactionInput.ConnectMode.DISCONNECT_ON_CONFLICT);
            if (result != TransactionInput.ConnectionResult.SUCCESS) continue;
            this.maybeMovePool(input.getOutpoint().fromTx, "kill");
        }
    }

    private void maybeMovePool(Transaction tx, String context) {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        if (tx.isEveryOwnedOutputSpent(this)) {
            if (this.unspent.remove(tx.getHash()) != null) {
                if (log.isInfoEnabled()) {
                    log.info("  {} {} <-unspent ->spent", (Object)tx.getHashAsString(), (Object)context);
                }
                this.spent.put(tx.getHash(), tx);
            }
        } else if (this.spent.remove(tx.getHash()) != null) {
            if (log.isInfoEnabled()) {
                log.info("  {} {} <-spent ->unspent", (Object)tx.getHashAsString(), (Object)context);
            }
            this.unspent.put(tx.getHash(), tx);
        }
    }

    public void addEventListener(WalletEventListener listener) {
        this.addEventListener(listener, Threading.USER_THREAD);
    }

    public void addEventListener(WalletEventListener listener, Executor executor) {
        this.eventListeners.add(new ListenerRegistration<WalletEventListener>(listener, executor));
    }

    public boolean removeEventListener(WalletEventListener listener) {
        return ListenerRegistration.removeFromList(listener, this.eventListeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean maybeCommitTx(Transaction tx) throws VerificationException {
        tx.verify();
        this.lock.lock();
        try {
            if (this.pending.containsKey(tx.getHash())) {
                boolean bl = false;
                return bl;
            }
            log.info("commitTx of {}", (Object)tx.getHashAsString());
            BigInteger balance = this.getBalance();
            tx.setUpdateTime(Utils.now());
            this.updateForSpends(tx, false);
            log.info("->pending: {}", (Object)tx.getHashAsString());
            tx.getConfidence().setConfidenceType(TransactionConfidence.ConfidenceType.PENDING);
            this.confidenceChanged.put(tx, TransactionConfidence.Listener.ChangeReason.TYPE);
            this.addWalletTransaction(WalletTransaction.Pool.PENDING, tx);
            try {
                BigInteger valueSentFromMe = tx.getValueSentFromMe(this);
                BigInteger valueSentToMe = tx.getValueSentToMe(this);
                BigInteger newBalance = balance.add(valueSentToMe).subtract(valueSentFromMe);
                if (valueSentToMe.compareTo(BigInteger.ZERO) > 0) {
                    this.checkBalanceFuturesLocked(null);
                    this.queueOnCoinsReceived(tx, balance, newBalance);
                }
                if (valueSentFromMe.compareTo(BigInteger.ZERO) > 0) {
                    this.queueOnCoinsSent(tx, balance, newBalance);
                }
                this.maybeQueueOnWalletChanged();
            }
            catch (ScriptException e) {
                throw new RuntimeException(e);
            }
            Preconditions.checkState((boolean)this.isConsistent());
            this.informConfidenceListenersIfNotReorganizing();
            this.saveNow();
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    public void commitTx(Transaction tx) throws VerificationException {
        Preconditions.checkArgument((boolean)this.maybeCommitTx(tx), (Object)"commitTx called on the same transaction twice");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Transaction> getTransactions(boolean includeDead) {
        this.lock.lock();
        try {
            HashSet<Transaction> all = new HashSet<Transaction>();
            all.addAll(this.unspent.values());
            all.addAll(this.spent.values());
            all.addAll(this.pending.values());
            if (includeDead) {
                all.addAll(this.dead.values());
            }
            HashSet<Transaction> hashSet = all;
            return hashSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<WalletTransaction> getWalletTransactions() {
        this.lock.lock();
        try {
            HashSet<WalletTransaction> all = new HashSet<WalletTransaction>();
            Wallet.addWalletTransactionsToSet(all, WalletTransaction.Pool.UNSPENT, this.unspent.values());
            Wallet.addWalletTransactionsToSet(all, WalletTransaction.Pool.SPENT, this.spent.values());
            Wallet.addWalletTransactionsToSet(all, WalletTransaction.Pool.DEAD, this.dead.values());
            Wallet.addWalletTransactionsToSet(all, WalletTransaction.Pool.PENDING, this.pending.values());
            HashSet<WalletTransaction> hashSet = all;
            return hashSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static void addWalletTransactionsToSet(Set<WalletTransaction> txs, WalletTransaction.Pool poolType, Collection<Transaction> pool) {
        for (Transaction tx : pool) {
            txs.add(new WalletTransaction(poolType, tx));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWalletTransaction(WalletTransaction wtx) {
        this.lock.lock();
        try {
            this.addWalletTransaction(wtx.getPool(), wtx.getTransaction());
        }
        finally {
            this.lock.unlock();
        }
    }

    private void addWalletTransaction(WalletTransaction.Pool pool, Transaction tx) {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        this.transactions.put(tx.getHash(), tx);
        switch (pool) {
            case UNSPENT: {
                Preconditions.checkState((this.unspent.put(tx.getHash(), tx) == null ? 1 : 0) != 0);
                break;
            }
            case SPENT: {
                Preconditions.checkState((this.spent.put(tx.getHash(), tx) == null ? 1 : 0) != 0);
                break;
            }
            case PENDING: {
                Preconditions.checkState((this.pending.put(tx.getHash(), tx) == null ? 1 : 0) != 0);
                break;
            }
            case DEAD: {
                Preconditions.checkState((this.dead.put(tx.getHash(), tx) == null ? 1 : 0) != 0);
                break;
            }
            default: {
                throw new RuntimeException("Unknown wallet transaction type " + (Object)((Object)pool));
            }
        }
        tx.getConfidence().addEventListener(this.txConfidenceListener, Threading.SAME_THREAD);
    }

    public List<Transaction> getTransactionsByTime() {
        return this.getRecentTransactions(0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Transaction> getRecentTransactions(int numTransactions, boolean includeDead) {
        this.lock.lock();
        try {
            Preconditions.checkArgument((numTransactions >= 0 ? 1 : 0) != 0);
            int size = this.getPoolSize(WalletTransaction.Pool.UNSPENT) + this.getPoolSize(WalletTransaction.Pool.SPENT) + this.getPoolSize(WalletTransaction.Pool.PENDING);
            if (numTransactions > size || numTransactions == 0) {
                numTransactions = size;
            }
            ArrayList<Transaction> all = new ArrayList<Transaction>(this.getTransactions(includeDead));
            Collections.sort(all, Collections.reverseOrder(new Comparator<Transaction>(){

                @Override
                public int compare(Transaction t1, Transaction t2) {
                    return t1.getUpdateTime().compareTo(t2.getUpdateTime());
                }
            }));
            if (numTransactions == all.size()) {
                ArrayList<Transaction> arrayList = all;
                return arrayList;
            }
            all.subList(numTransactions, all.size()).clear();
            ArrayList<Transaction> arrayList = all;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Transaction getTransaction(Sha256Hash hash) {
        this.lock.lock();
        try {
            Transaction transaction = this.transactions.get(hash);
            return transaction;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTransactions(int fromHeight) {
        block4: {
            this.lock.lock();
            try {
                if (fromHeight == 0) {
                    this.unspent.clear();
                    this.spent.clear();
                    this.pending.clear();
                    this.dead.clear();
                    this.transactions.clear();
                    this.saveLater();
                    break block4;
                }
                throw new UnsupportedOperationException();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        this.lock.lock();
        try {
            boolean dirty = false;
            Iterator<Transaction> i = this.pending.values().iterator();
            while (i.hasNext()) {
                Transaction tx = i.next();
                if (!this.isTransactionRisky(tx, null) || this.acceptRiskyTransactions) continue;
                log.debug("Found risky transaction {} in wallet during cleanup.", (Object)tx.getHashAsString());
                if (!tx.isAnyOutputSpent()) {
                    tx.disconnectInputs();
                    i.remove();
                    this.transactions.remove(tx.getHash());
                    dirty = true;
                    log.info("Removed transaction {} from pending pool during cleanup.", (Object)tx.getHashAsString());
                    continue;
                }
                log.info("Cannot remove transaction {} from pending pool during cleanup, as it's already spent partially.", (Object)tx.getHashAsString());
            }
            if (dirty) {
                Preconditions.checkState((boolean)this.isConsistent());
                this.saveLater();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EnumSet<WalletTransaction.Pool> getContainingPools(Transaction tx) {
        this.lock.lock();
        try {
            EnumSet<WalletTransaction.Pool> result = EnumSet.noneOf(WalletTransaction.Pool.class);
            Sha256Hash txHash = tx.getHash();
            if (this.unspent.containsKey(txHash)) {
                result.add(WalletTransaction.Pool.UNSPENT);
            }
            if (this.spent.containsKey(txHash)) {
                result.add(WalletTransaction.Pool.SPENT);
            }
            if (this.pending.containsKey(txHash)) {
                result.add(WalletTransaction.Pool.PENDING);
            }
            if (this.dead.containsKey(txHash)) {
                result.add(WalletTransaction.Pool.DEAD);
            }
            EnumSet<WalletTransaction.Pool> enumSet = result;
            return enumSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    int getPoolSize(WalletTransaction.Pool pool) {
        this.lock.lock();
        try {
            switch (pool) {
                case UNSPENT: {
                    int n = this.unspent.size();
                    return n;
                }
                case SPENT: {
                    int n = this.spent.size();
                    return n;
                }
                case PENDING: {
                    int n = this.pending.size();
                    return n;
                }
                case DEAD: {
                    int n = this.dead.size();
                    return n;
                }
            }
            throw new RuntimeException("Unreachable");
        }
        finally {
            this.lock.unlock();
        }
    }

    public Transaction createSend(Address address, BigInteger nanocoins) throws InsufficientMoneyException {
        SendRequest req = SendRequest.to(address, nanocoins);
        this.completeTx(req);
        return req.tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction sendCoinsOffline(SendRequest request) throws InsufficientMoneyException {
        this.lock.lock();
        try {
            this.completeTx(request);
            this.commitTx(request.tx);
            Transaction transaction = request.tx;
            return transaction;
        }
        finally {
            this.lock.unlock();
        }
    }

    public SendResult sendCoins(TransactionBroadcaster broadcaster, Address to, BigInteger value) throws InsufficientMoneyException {
        SendRequest request = SendRequest.to(to, value);
        return this.sendCoins(broadcaster, request);
    }

    public SendResult sendCoins(TransactionBroadcaster broadcaster, SendRequest request) throws InsufficientMoneyException {
        Preconditions.checkState((!this.lock.isHeldByCurrentThread() ? 1 : 0) != 0);
        Transaction tx = this.sendCoinsOffline(request);
        SendResult result = new SendResult();
        result.tx = tx;
        result.broadcastComplete = broadcaster.broadcastTransaction(tx);
        return result;
    }

    public SendResult sendCoins(SendRequest request) throws InsufficientMoneyException {
        TransactionBroadcaster broadcaster = this.vTransactionBroadcaster;
        Preconditions.checkState((broadcaster != null ? 1 : 0) != 0, (Object)"No transaction broadcaster is configured");
        return this.sendCoins(broadcaster, request);
    }

    public Transaction sendCoins(Peer peer, SendRequest request) throws InsufficientMoneyException {
        Transaction tx = this.sendCoinsOffline(request);
        peer.sendMessage(tx);
        return tx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeTx(SendRequest req) throws InsufficientMoneyException {
        this.lock.lock();
        try {
            BigInteger calculatedFee;
            BigInteger feePerKb;
            BigInteger baseFee;
            Transaction tx;
            CoinSelection bestCoinSelection;
            Preconditions.checkArgument((!req.completed ? 1 : 0) != 0, (Object)"Given SendRequest has already been completed.");
            BigInteger value = BigInteger.ZERO;
            for (TransactionOutput output : req.tx.getOutputs()) {
                value = value.add(output.getValue());
            }
            BigInteger totalOutput = value;
            log.info("Completing send tx with {} outputs totalling {} satoshis (not including fees)", (Object)req.tx.getOutputs().size(), (Object)value);
            BigInteger totalInput = BigInteger.ZERO;
            for (TransactionInput input : req.tx.getInputs()) {
                if (input.getConnectedOutput() != null) {
                    totalInput = totalInput.add(input.getConnectedOutput().getValue());
                    continue;
                }
                log.warn("SendRequest transaction already has inputs but we don't know how much they are worth - they will be added to fee.");
            }
            value = value.subtract(totalInput);
            ArrayList<TransactionInput> originalInputs = new ArrayList<TransactionInput>(req.tx.getInputs());
            boolean needAtLeastReferenceFee = false;
            if (req.ensureMinRequiredFee && !req.emptyWallet) {
                for (TransactionOutput output : req.tx.getOutputs()) {
                    if (output.getValue().compareTo(Utils.CENT) >= 0) continue;
                    if (output.getValue().compareTo(output.getMinNonDustValue()) < 0) {
                        throw new IllegalArgumentException("Tried to send dust with ensureMinRequiredFee set - no way to complete this");
                    }
                    needAtLeastReferenceFee = true;
                    break;
                }
            }
            LinkedList<TransactionOutput> candidates = this.calculateAllSpendCandidates(true);
            TransactionOutput bestChangeOutput = null;
            if (!req.emptyWallet) {
                FeeCalculation feeCalculation = new FeeCalculation(req, value, originalInputs, needAtLeastReferenceFee, candidates);
                bestCoinSelection = feeCalculation.bestCoinSelection;
                bestChangeOutput = feeCalculation.bestChangeOutput;
            } else {
                Preconditions.checkState((req.tx.getOutputs().size() == 1 ? 1 : 0) != 0, (Object)"Empty wallet TX must have a single output only.");
                CoinSelector selector = req.coinSelector == null ? this.coinSelector : req.coinSelector;
                bestCoinSelection = selector.select(NetworkParameters.MAX_MONEY, candidates);
                req.tx.getOutput(0).setValue(bestCoinSelection.valueGathered);
                totalOutput = bestCoinSelection.valueGathered;
            }
            for (TransactionOutput output : bestCoinSelection.gathered) {
                req.tx.addInput(output);
            }
            if (req.ensureMinRequiredFee && req.emptyWallet && !this.adjustOutputDownwardsForFee(tx = req.tx, bestCoinSelection, baseFee = req.fee == null ? BigInteger.ZERO : req.fee, feePerKb = req.feePerKb == null ? BigInteger.ZERO : req.feePerKb)) {
                throw new InsufficientMoneyException.CouldNotAdjustDownwards();
            }
            totalInput = totalInput.add(bestCoinSelection.valueGathered);
            if (bestChangeOutput != null) {
                req.tx.addOutput(bestChangeOutput);
                totalOutput = totalOutput.add(bestChangeOutput.getValue());
                log.info("  with {} coins change", (Object)Utils.bitcoinValueToFriendlyString(bestChangeOutput.getValue()));
            }
            if ((calculatedFee = totalInput.subtract(totalOutput)).compareTo(BigInteger.ZERO) > 0) {
                log.info("  with a fee of {}", (Object)Utils.bitcoinValueToFriendlyString(calculatedFee));
            }
            req.tx.signInputs(Transaction.SigHash.ALL, this, req.aesKey);
            int size = req.tx.bitcoinSerialize().length;
            if (size > 102400) {
                throw new IllegalArgumentException(String.format("Transaction could not be created without exceeding max size: %d vs %d", size, 102400));
            }
            req.tx.getConfidence().setSource(TransactionConfidence.Source.SELF);
            req.tx.setPurpose(Transaction.Purpose.USER_PAYMENT);
            req.completed = true;
            req.fee = calculatedFee;
            log.info("  completed: {}", (Object)req.tx);
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean adjustOutputDownwardsForFee(Transaction tx, CoinSelection coinSelection, BigInteger baseFee, BigInteger feePerKb) {
        TransactionOutput output = tx.getOutput(0);
        int size = tx.bitcoinSerialize().length;
        BigInteger fee = baseFee.add(BigInteger.valueOf((size += this.estimateBytesForSigning(coinSelection)) / 1000 + 1).multiply(feePerKb));
        output.setValue(output.getValue().subtract(fee));
        if (output.getValue().compareTo(Utils.CENT) < 0 && fee.compareTo(Transaction.REFERENCE_DEFAULT_MIN_TX_FEE) < 0) {
            output.setValue(output.getValue().subtract(Transaction.REFERENCE_DEFAULT_MIN_TX_FEE.subtract(fee)));
        }
        return output.getMinNonDustValue().compareTo(output.getValue()) <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList<TransactionOutput> calculateAllSpendCandidates(boolean excludeImmatureCoinbases) {
        this.lock.lock();
        try {
            LinkedList candidates = Lists.newLinkedList();
            for (Transaction tx : Iterables.concat(this.unspent.values(), this.pending.values())) {
                if (excludeImmatureCoinbases && !tx.isMature()) continue;
                for (TransactionOutput output : tx.getOutputs()) {
                    if (!output.isAvailableForSpending() || !output.isMine(this)) continue;
                    candidates.add(output);
                }
            }
            LinkedList linkedList = candidates;
            return linkedList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedList<TransactionOutput> getWatchedOutputs(boolean excludeImmatureCoinbases) {
        this.lock.lock();
        try {
            LinkedList candidates = Lists.newLinkedList();
            for (Transaction tx : Iterables.concat(this.unspent.values(), this.pending.values())) {
                if (excludeImmatureCoinbases && !tx.isMature()) continue;
                for (TransactionOutput output : tx.getOutputs()) {
                    if (!output.isAvailableForSpending()) continue;
                    try {
                        Script scriptPubKey = output.getScriptPubKey();
                        if (!this.watchedScripts.contains(scriptPubKey)) continue;
                        candidates.add(output);
                    }
                    catch (ScriptException e) {}
                }
            }
            LinkedList linkedList = candidates;
            return linkedList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Address getChangeAddress() {
        this.lock.lock();
        try {
            Preconditions.checkState((this.keychain.size() > 0 ? 1 : 0) != 0, (Object)"Can't send value without an address to use for receiving change");
            ECKey first = this.keychain.get(0);
            Address address = first.toAddress(this.params);
            return address;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean addKey(ECKey key) {
        return this.addKeys(Lists.newArrayList((Object[])new ECKey[]{key})) == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addKeys(List<ECKey> keys) {
        this.lock.lock();
        try {
            int added = 0;
            for (ECKey key : keys) {
                if (this.keychain.contains(key)) continue;
                if (!(!this.isEncrypted() || key.isEncrypted() && this.keyCrypter.equals(key.getKeyCrypter()))) {
                    throw new KeyCrypterException("Cannot add key " + key.toString() + " because the keyCrypter does not match the wallets. Keys must be homogenous.");
                }
                if (key.isEncrypted() && !this.isEncrypted()) {
                    throw new KeyCrypterException("Cannot add key because it's encrypted and this wallet is not.");
                }
                this.keychain.add(key);
                ++added;
            }
            this.queueOnKeysAdded(keys);
            this.saveNow();
            int n = added;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isAddressWatched(Address address) {
        Script script = ScriptBuilder.createOutputScript(address);
        return this.isWatchedScript(script);
    }

    public boolean addWatchedAddress(Address address) {
        long now = Utils.currentTimeMillis() / 1000L;
        return this.addWatchedAddresses(Lists.newArrayList((Object[])new Address[]{address}), now) == 1;
    }

    public boolean addWatchedAddress(Address address, long creationTime) {
        return this.addWatchedAddresses(Lists.newArrayList((Object[])new Address[]{address}), creationTime) == 1;
    }

    public int addWatchedAddresses(List<Address> addresses, long creationTime) {
        ArrayList scripts = Lists.newArrayList();
        for (Address address : addresses) {
            Script script = ScriptBuilder.createOutputScript(address);
            script.setCreationTimeSeconds(creationTime);
            scripts.add(script);
        }
        return this.addWatchedScripts(scripts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addWatchedScripts(List<Script> scripts) {
        this.lock.lock();
        try {
            int added = 0;
            for (Script script : scripts) {
                if (this.watchedScripts.contains(script)) continue;
                this.watchedScripts.add(script);
                ++added;
            }
            this.queueOnScriptsAdded(scripts);
            this.saveNow();
            int n = added;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ECKey findKeyFromPubHash(byte[] pubkeyHash) {
        this.lock.lock();
        try {
            for (ECKey key : this.keychain) {
                if (!Arrays.equals(key.getPubKeyHash(), pubkeyHash)) continue;
                ECKey eCKey = key;
                return eCKey;
            }
            ECKey eCKey = null;
            return eCKey;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasKey(ECKey key) {
        this.lock.lock();
        try {
            boolean bl = this.keychain.contains(key);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isPubKeyHashMine(byte[] pubkeyHash) {
        return this.findKeyFromPubHash(pubkeyHash) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWatchedScript(Script script) {
        this.lock.lock();
        try {
            boolean bl = this.watchedScripts.contains(script);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ECKey findKeyFromPubKey(byte[] pubkey) {
        this.lock.lock();
        try {
            for (ECKey key : this.keychain) {
                if (!Arrays.equals(key.getPubKey(), pubkey)) continue;
                ECKey eCKey = key;
                return eCKey;
            }
            ECKey eCKey = null;
            return eCKey;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isPubKeyMine(byte[] pubkey) {
        return this.findKeyFromPubKey(pubkey) != null;
    }

    public BigInteger getBalance() {
        return this.getBalance(BalanceType.AVAILABLE);
    }

    public BigInteger getBalance(BalanceType balanceType) {
        this.lock.lock();
        try {
            if (balanceType == BalanceType.AVAILABLE) {
                BigInteger bigInteger = this.getBalance(this.coinSelector);
                return bigInteger;
            }
            if (balanceType == BalanceType.ESTIMATED) {
                LinkedList<TransactionOutput> all = this.calculateAllSpendCandidates(false);
                BigInteger value = BigInteger.ZERO;
                for (TransactionOutput out : all) {
                    value = value.add(out.getValue());
                }
                BigInteger bigInteger = value;
                return bigInteger;
            }
            throw new AssertionError((Object)"Unknown balance type");
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigInteger getBalance(CoinSelector selector) {
        this.lock.lock();
        try {
            Preconditions.checkNotNull((Object)selector);
            LinkedList<TransactionOutput> candidates = this.calculateAllSpendCandidates(true);
            CoinSelection selection = selector.select(NetworkParameters.MAX_MONEY, candidates);
            BigInteger bigInteger = selection.valueGathered;
            return bigInteger;
        }
        finally {
            this.lock.unlock();
        }
    }

    public BigInteger getWatchedBalance() {
        return this.getWatchedBalance(this.coinSelector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigInteger getWatchedBalance(CoinSelector selector) {
        this.lock.lock();
        try {
            Preconditions.checkNotNull((Object)selector);
            LinkedList<TransactionOutput> candidates = this.getWatchedOutputs(true);
            CoinSelection selection = selector.select(NetworkParameters.MAX_MONEY, candidates);
            BigInteger bigInteger = selection.valueGathered;
            return bigInteger;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return this.toString(false, true, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(boolean includePrivateKeys, boolean includeTransactions, boolean includeExtensions, @Nullable AbstractBlockChain chain) {
        this.lock.lock();
        try {
            StringBuilder builder = new StringBuilder();
            BigInteger estimatedBalance = this.getBalance(BalanceType.ESTIMATED);
            BigInteger availableBalance = this.getBalance(BalanceType.AVAILABLE);
            builder.append(String.format("Wallet containing %s BTC (available: %s BTC) in:%n", Utils.bitcoinValueToPlainString(estimatedBalance), Utils.bitcoinValueToPlainString(availableBalance)));
            builder.append(String.format("  %d pending transactions%n", this.pending.size()));
            builder.append(String.format("  %d unspent transactions%n", this.unspent.size()));
            builder.append(String.format("  %d spent transactions%n", this.spent.size()));
            builder.append(String.format("  %d dead transactions%n", this.dead.size()));
            Date lastBlockSeenTime = this.getLastBlockSeenTime();
            String lastBlockSeenTimeStr = lastBlockSeenTime == null ? "time unknown" : lastBlockSeenTime.toString();
            builder.append(String.format("Last seen best block: %d (%s): %s%n", this.getLastBlockSeenHeight(), lastBlockSeenTimeStr, this.getLastBlockSeenHash()));
            if (this.keyCrypter != null) {
                builder.append(String.format("Encryption: %s%n", this.keyCrypter.toString()));
            }
            builder.append("\nKeys:\n");
            for (ECKey key : this.keychain) {
                Address address = key.toAddress(this.params);
                builder.append("  addr:");
                builder.append(address.toString());
                builder.append(" hash160:");
                builder.append(Utils.bytesToHexString(address.getHash160()));
                builder.append(" ");
                builder.append(includePrivateKeys ? key.toStringWithPrivate() : key.toString());
                builder.append("\n");
            }
            if (!this.watchedScripts.isEmpty()) {
                builder.append("\nWatched scripts:\n");
                for (Script script : this.watchedScripts) {
                    builder.append("  ");
                    builder.append(script.toString());
                    builder.append("\n");
                }
            }
            if (includeTransactions) {
                if (this.pending.size() > 0) {
                    builder.append("\n>>> PENDING:\n");
                    this.toStringHelper(builder, this.pending, chain, SORT_ORDER_BY_UPDATE_TIME);
                }
                if (this.unspent.size() > 0) {
                    builder.append("\n>>> UNSPENT:\n");
                    this.toStringHelper(builder, this.unspent, chain, SORT_ORDER_BY_HEIGHT);
                }
                if (this.spent.size() > 0) {
                    builder.append("\n>>> SPENT:\n");
                    this.toStringHelper(builder, this.spent, chain, SORT_ORDER_BY_HEIGHT);
                }
                if (this.dead.size() > 0) {
                    builder.append("\n>>> DEAD:\n");
                    this.toStringHelper(builder, this.dead, chain, SORT_ORDER_BY_HEIGHT);
                }
            }
            if (includeExtensions && this.extensions.size() > 0) {
                builder.append("\n>>> EXTENSIONS:\n");
                for (WalletExtension extension : this.extensions.values()) {
                    builder.append(extension).append("\n\n");
                }
            }
            String string = builder.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void toStringHelper(StringBuilder builder, Map<Sha256Hash, Transaction> transactionMap, @Nullable AbstractBlockChain chain, @Nullable Comparator<Transaction> sortOrder) {
        Collection<Transaction> txns;
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        if (sortOrder != null) {
            txns = new TreeSet<Transaction>(sortOrder);
            txns.addAll(transactionMap.values());
        } else {
            txns = transactionMap.values();
        }
        for (Transaction tx : txns) {
            try {
                builder.append("Sends ");
                builder.append(Utils.bitcoinValueToFriendlyString(tx.getValueSentFromMe(this)));
                builder.append(" and receives ");
                builder.append(Utils.bitcoinValueToFriendlyString(tx.getValueSentToMe(this)));
                builder.append(", total value ");
                builder.append(Utils.bitcoinValueToFriendlyString(tx.getValue(this)));
                builder.append(".\n");
            }
            catch (ScriptException e) {
                // empty catch block
            }
            builder.append(tx.toString(chain));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reorganize(StoredBlock splitPoint, List<StoredBlock> oldBlocks, List<StoredBlock> newBlocks) throws VerificationException {
        this.lock.lock();
        try {
            Preconditions.checkState((this.confidenceChanged.size() == 0 ? 1 : 0) != 0);
            Preconditions.checkState((!this.insideReorg ? 1 : 0) != 0);
            this.insideReorg = true;
            Preconditions.checkState((this.onWalletChangedSuppressions == 0 ? 1 : 0) != 0);
            ++this.onWalletChangedSuppressions;
            ArrayListMultimap mapBlockTx = ArrayListMultimap.create();
            for (Transaction tx : this.getTransactions(true)) {
                Map<Sha256Hash, Integer> appearsIn = tx.getAppearsInHashes();
                if (appearsIn == null) continue;
                for (Map.Entry<Sha256Hash, Integer> block : appearsIn.entrySet()) {
                    mapBlockTx.put((Object)block.getKey(), (Object)new TxOffsetPair(tx, block.getValue()));
                }
            }
            for (Sha256Hash blockHash : mapBlockTx.keySet()) {
                Collections.sort(mapBlockTx.get((Object)blockHash));
            }
            ArrayList<Sha256Hash> oldBlockHashes = new ArrayList<Sha256Hash>(oldBlocks.size());
            log.info("Old part of chain (top to bottom):");
            for (StoredBlock b : oldBlocks) {
                log.info("  {}", (Object)b.getHeader().getHashAsString());
                oldBlockHashes.add(b.getHeader().getHash());
            }
            log.info("New part of chain (top to bottom):");
            for (StoredBlock b : newBlocks) {
                log.info("  {}", (Object)b.getHeader().getHashAsString());
            }
            Collections.reverse(newBlocks);
            LinkedList oldChainTxns = Lists.newLinkedList();
            for (Sha256Hash blockHash : oldBlockHashes) {
                for (TxOffsetPair pair : mapBlockTx.get((Object)blockHash)) {
                    Transaction tx = pair.tx;
                    Sha256Hash txHash = tx.getHash();
                    if (tx.isCoinBase()) {
                        this.killCoinbase(tx);
                        continue;
                    }
                    for (TransactionOutput output : tx.getOutputs()) {
                        TransactionInput input = output.getSpentBy();
                        if (input == null) continue;
                        input.disconnect();
                    }
                    for (TransactionInput input : tx.getInputs()) {
                        input.disconnect();
                    }
                    oldChainTxns.add(tx);
                    this.unspent.remove(txHash);
                    this.spent.remove(txHash);
                    Preconditions.checkState((!this.pending.containsKey(txHash) ? 1 : 0) != 0);
                    Preconditions.checkState((!this.dead.containsKey(txHash) ? 1 : 0) != 0);
                }
            }
            for (Transaction tx : oldChainTxns) {
                if (tx.isCoinBase()) continue;
                log.info("  ->pending {}", (Object)tx.getHash());
                tx.getConfidence().setConfidenceType(TransactionConfidence.ConfidenceType.PENDING);
                this.confidenceChanged.put(tx, TransactionConfidence.Listener.ChangeReason.TYPE);
                this.addWalletTransaction(WalletTransaction.Pool.PENDING, tx);
                this.updateForSpends(tx, false);
            }
            int depthToSubtract = oldBlocks.size();
            BigInteger workDoneToSubtract = BigInteger.ZERO;
            for (StoredBlock b : oldBlocks) {
                workDoneToSubtract = workDoneToSubtract.add(b.getHeader().getWork());
            }
            log.info("depthToSubtract = " + depthToSubtract + ", workDoneToSubtract = " + workDoneToSubtract);
            this.subtractDepthAndWorkDone(depthToSubtract, workDoneToSubtract, this.spent.values());
            this.subtractDepthAndWorkDone(depthToSubtract, workDoneToSubtract, this.unspent.values());
            this.subtractDepthAndWorkDone(depthToSubtract, workDoneToSubtract, this.dead.values());
            this.setLastBlockSeenHash(splitPoint.getHeader().getHash());
            for (StoredBlock block : newBlocks) {
                log.info("Replaying block {}", (Object)block.getHeader().getHashAsString());
                for (TxOffsetPair pair : mapBlockTx.get((Object)block.getHeader().getHash())) {
                    log.info("  tx {}", (Object)pair.tx.getHash());
                    try {
                        this.receive(pair.tx, block, AbstractBlockChain.NewBlockType.BEST_CHAIN, pair.offset);
                    }
                    catch (ScriptException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.notifyNewBestBlock(block);
            }
            Preconditions.checkState((boolean)this.isConsistent());
            BigInteger balance = this.getBalance();
            log.info("post-reorg balance is {}", (Object)Utils.bitcoinValueToFriendlyString(balance));
            this.queueOnReorganize();
            this.insideReorg = false;
            --this.onWalletChangedSuppressions;
            this.maybeQueueOnWalletChanged();
            this.checkBalanceFuturesLocked(balance);
            this.informConfidenceListenersIfNotReorganizing();
            this.saveLater();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void subtractDepthAndWorkDone(int depthToSubtract, BigInteger workDoneToSubtract, Collection<Transaction> transactions) {
        for (Transaction tx : transactions) {
            if (tx.getConfidence().getConfidenceType() != TransactionConfidence.ConfidenceType.BUILDING) continue;
            tx.getConfidence().setDepthInBlocks(tx.getConfidence().getDepthInBlocks() - depthToSubtract);
            tx.getConfidence().setWorkDone(tx.getConfidence().getWorkDone().subtract(workDoneToSubtract));
            this.confidenceChanged.put(tx, TransactionConfidence.Listener.ChangeReason.DEPTH);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Transaction> getPendingTransactions() {
        this.lock.lock();
        try {
            Collection<Transaction> collection = Collections.unmodifiableCollection(this.pending.values());
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getEarliestKeyCreationTime() {
        this.lock.lock();
        try {
            long earliestTime = Long.MAX_VALUE;
            for (ECKey key : this.keychain) {
                earliestTime = Math.min(key.getCreationTimeSeconds(), earliestTime);
            }
            for (Script script : this.watchedScripts) {
                earliestTime = Math.min(script.getCreationTimeSeconds(), earliestTime);
            }
            if (earliestTime == Long.MAX_VALUE) {
                long l = Utils.currentTimeMillis() / 1000L;
                return l;
            }
            long l = earliestTime;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Sha256Hash getLastBlockSeenHash() {
        this.lock.lock();
        try {
            Sha256Hash sha256Hash = this.lastBlockSeenHash;
            return sha256Hash;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastBlockSeenHash(@Nullable Sha256Hash lastBlockSeenHash) {
        this.lock.lock();
        try {
            this.lastBlockSeenHash = lastBlockSeenHash;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastBlockSeenHeight(int lastBlockSeenHeight) {
        this.lock.lock();
        try {
            this.lastBlockSeenHeight = lastBlockSeenHeight;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastBlockSeenTimeSecs(long timeSecs) {
        this.lock.lock();
        try {
            this.lastBlockSeenTimeSecs = timeSecs;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastBlockSeenTimeSecs() {
        this.lock.lock();
        try {
            long l = this.lastBlockSeenTimeSecs;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Nullable
    public Date getLastBlockSeenTime() {
        long secs = this.getLastBlockSeenTimeSecs();
        if (secs == 0L) {
            return null;
        }
        return new Date(secs * 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLastBlockSeenHeight() {
        this.lock.lock();
        try {
            int n = this.lastBlockSeenHeight;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public KeyParameter encrypt(CharSequence password) {
        Preconditions.checkNotNull((Object)password);
        Preconditions.checkArgument((password.length() > 0 ? 1 : 0) != 0);
        KeyCrypterScrypt scrypt = new KeyCrypterScrypt();
        KeyParameter derivedKey = scrypt.deriveKey(password);
        this.encrypt(scrypt, derivedKey);
        return derivedKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encrypt(KeyCrypter keyCrypter, KeyParameter aesKey) {
        this.lock.lock();
        try {
            Preconditions.checkNotNull((Object)keyCrypter);
            Preconditions.checkState((this.getEncryptionType() == Protos.Wallet.EncryptionType.UNENCRYPTED ? 1 : 0) != 0, (Object)"Wallet is already encrypted");
            ArrayList<ECKey> encryptedKeyChain = new ArrayList<ECKey>();
            for (ECKey key : this.keychain) {
                if (key.isEncrypted()) {
                    encryptedKeyChain.add(key);
                    continue;
                }
                ECKey encryptedKey = key.encrypt(keyCrypter, aesKey);
                if (!ECKey.encryptionIsReversible(key, encryptedKey, keyCrypter, aesKey)) {
                    throw new KeyCrypterException("The key " + key.toString() + " cannot be successfully decrypted after encryption so aborting wallet encryption.");
                }
                encryptedKeyChain.add(encryptedKey);
            }
            for (ECKey key : this.keychain) {
                if (key.isEncrypted()) continue;
                key.clearPrivateKey();
            }
            this.keychain = encryptedKeyChain;
            this.keyCrypter = keyCrypter;
            this.saveNow();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrypt(KeyParameter aesKey) {
        this.lock.lock();
        try {
            Preconditions.checkState((this.getEncryptionType() != Protos.Wallet.EncryptionType.UNENCRYPTED ? 1 : 0) != 0, (Object)"Wallet is already decrypted");
            Preconditions.checkNotNull((Object)this.keyCrypter);
            ArrayList<ECKey> decryptedKeyChain = new ArrayList<ECKey>();
            for (ECKey key : this.keychain) {
                if (!key.isEncrypted()) {
                    decryptedKeyChain.add(key);
                    continue;
                }
                ECKey decryptedECKey = key.decrypt(this.keyCrypter, aesKey);
                decryptedKeyChain.add(decryptedECKey);
            }
            this.keychain = decryptedKeyChain;
            this.keyCrypter = null;
            this.saveNow();
        }
        finally {
            this.lock.unlock();
        }
    }

    public ECKey addNewEncryptedKey(KeyCrypter keyCrypter, KeyParameter aesKey) {
        ECKey newKey = new ECKey().encrypt((KeyCrypter)Preconditions.checkNotNull((Object)keyCrypter), (KeyParameter)Preconditions.checkNotNull((Object)aesKey));
        this.addKey(newKey);
        return newKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ECKey addNewEncryptedKey(CharSequence password) {
        this.lock.lock();
        try {
            Preconditions.checkNotNull((Object)this.keyCrypter, (Object)"Wallet is not encrypted, you must call encrypt() first.");
            ECKey eCKey = this.addNewEncryptedKey(this.keyCrypter, this.keyCrypter.deriveKey(password));
            return eCKey;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkPassword(CharSequence password) {
        this.lock.lock();
        try {
            boolean bl = this.keyCrypter != null && this.checkAESKey(this.keyCrypter.deriveKey((CharSequence)Preconditions.checkNotNull((Object)password)));
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean checkAESKey(KeyParameter aesKey) {
        this.lock.lock();
        try {
            if (!this.getKeys().iterator().hasNext()) {
                boolean bl = false;
                return bl;
            }
            ECKey firstEncryptedECKey = null;
            Iterator<ECKey> iterator = this.getKeys().iterator();
            while (iterator.hasNext() && firstEncryptedECKey == null) {
                ECKey loopECKey = iterator.next();
                if (!loopECKey.isEncrypted()) continue;
                firstEncryptedECKey = loopECKey;
            }
            if (firstEncryptedECKey == null) {
                boolean loopECKey = false;
                return loopECKey;
            }
            String originalAddress = firstEncryptedECKey.toAddress(this.getNetworkParameters()).toString();
            if (firstEncryptedECKey.isEncrypted() && firstEncryptedECKey.getEncryptedPrivateKey() != null) {
                try {
                    ECKey rebornKey = firstEncryptedECKey.decrypt(this.keyCrypter, aesKey);
                    String rebornAddress = rebornKey.toAddress(this.getNetworkParameters()).toString();
                    boolean bl = originalAddress.equals(rebornAddress);
                    return bl;
                }
                catch (KeyCrypterException ede) {
                    boolean bl = false;
                    this.lock.unlock();
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyCrypter getKeyCrypter() {
        this.lock.lock();
        try {
            KeyCrypter keyCrypter = this.keyCrypter;
            return keyCrypter;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeyCrypter(KeyCrypter keyCrypter) {
        this.lock.lock();
        try {
            Preconditions.checkState((this.keyCrypter == null ? 1 : 0) != 0);
            this.keyCrypter = keyCrypter;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Protos.Wallet.EncryptionType getEncryptionType() {
        this.lock.lock();
        try {
            if (this.keyCrypter == null) {
                Protos.Wallet.EncryptionType encryptionType = Protos.Wallet.EncryptionType.UNENCRYPTED;
                return encryptionType;
            }
            Protos.Wallet.EncryptionType encryptionType = this.keyCrypter.getUnderstoodEncryptionType();
            return encryptionType;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isEncrypted() {
        return this.getEncryptionType() != Protos.Wallet.EncryptionType.UNENCRYPTED;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public int getBloomFilterElementCount() {
        int size = this.getKeychainSize() * 2;
        for (Transaction tx : this.getTransactions(false)) {
            for (TransactionOutput out : tx.getOutputs()) {
                try {
                    if (!this.isTxOutputBloomFilterable(out)) continue;
                    ++size;
                }
                catch (ScriptException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return size += this.watchedScripts.size();
    }

    @Override
    public boolean isRequiringUpdateAllBloomFilter() {
        return !this.watchedScripts.isEmpty();
    }

    public BloomFilter getBloomFilter(double falsePositiveRate) {
        return this.getBloomFilter(this.getBloomFilterElementCount(), falsePositiveRate, (long)(Math.random() * 9.223372036854776E18));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BloomFilter getBloomFilter(int size, double falsePositiveRate, long nTweak) {
        BloomFilter filter = new BloomFilter(size, falsePositiveRate, nTweak);
        this.lock.lock();
        try {
            for (ECKey key : this.keychain) {
                filter.insert(key.getPubKey());
                filter.insert(key.getPubKeyHash());
            }
            for (Script script : this.watchedScripts) {
                for (ScriptChunk chunk : script.getChunks()) {
                    if (chunk.isOpCode() || chunk.data.length < 8) continue;
                    filter.insert(chunk.data);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        for (Transaction tx : this.getTransactions(false)) {
            for (int i = 0; i < tx.getOutputs().size(); ++i) {
                TransactionOutput out = tx.getOutputs().get(i);
                try {
                    if (!this.isTxOutputBloomFilterable(out)) continue;
                    TransactionOutPoint outPoint = new TransactionOutPoint(this.params, (long)i, tx);
                    filter.insert(outPoint.bitcoinSerialize());
                    continue;
                }
                catch (ScriptException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return filter;
    }

    private boolean isTxOutputBloomFilterable(TransactionOutput out) {
        return out.isMine(this) && out.getScriptPubKey().isSentToRawPubKey() || out.isWatched(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoinSelector getCoinSelector() {
        this.lock.lock();
        try {
            CoinSelector coinSelector = this.coinSelector;
            return coinSelector;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCoinSelector(@Nonnull CoinSelector coinSelector) {
        this.lock.lock();
        try {
            this.coinSelector = (CoinSelector)Preconditions.checkNotNull((Object)coinSelector);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void allowSpendingUnconfirmedTransactions() {
        this.setCoinSelector(AllowUnconfirmedCoinSelector.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<BigInteger> getBalanceFuture(BigInteger value, BalanceType type) {
        this.lock.lock();
        try {
            SettableFuture future = SettableFuture.create();
            BigInteger current = this.getBalance(type);
            if (current.compareTo(value) >= 0) {
                future.set((Object)current);
            } else {
                BalanceFutureRequest req = new BalanceFutureRequest();
                req.future = future;
                req.value = value;
                req.type = type;
                this.balanceFutureRequests.add(req);
            }
            SettableFuture settableFuture = future;
            return settableFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void checkBalanceFuturesLocked(@Nullable BigInteger avail) {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        BigInteger estimated = null;
        ListIterator<BalanceFutureRequest> it = this.balanceFutureRequests.listIterator();
        while (it.hasNext()) {
            final BalanceFutureRequest req = it.next();
            BigInteger val = null;
            if (req.type == BalanceType.AVAILABLE) {
                if (avail == null) {
                    avail = this.getBalance(BalanceType.AVAILABLE);
                }
                if (avail.compareTo(req.value) < 0) continue;
                val = avail;
            } else if (req.type == BalanceType.ESTIMATED) {
                if (estimated == null) {
                    estimated = this.getBalance(BalanceType.ESTIMATED);
                }
                if (estimated.compareTo(req.value) < 0) continue;
                val = estimated;
            }
            it.remove();
            final BigInteger v = (BigInteger)Preconditions.checkNotNull(val);
            Threading.USER_THREAD.execute(new Runnable(){

                @Override
                public void run() {
                    req.future.set((Object)v);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExtension(WalletExtension extension) {
        String id = ((WalletExtension)Preconditions.checkNotNull((Object)extension)).getWalletExtensionID();
        this.lock.lock();
        try {
            if (this.extensions.containsKey(id)) {
                throw new IllegalStateException("Cannot add two extensions with the same ID: " + id);
            }
            this.extensions.put(id, extension);
            this.saveNow();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WalletExtension addOrGetExistingExtension(WalletExtension extension) {
        String id = ((WalletExtension)Preconditions.checkNotNull((Object)extension)).getWalletExtensionID();
        this.lock.lock();
        try {
            WalletExtension previousExtension = this.extensions.get(id);
            if (previousExtension != null) {
                WalletExtension walletExtension = previousExtension;
                return walletExtension;
            }
            this.extensions.put(id, extension);
            this.saveNow();
            WalletExtension walletExtension = extension;
            return walletExtension;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOrUpdateExtension(WalletExtension extension) {
        String id = ((WalletExtension)Preconditions.checkNotNull((Object)extension)).getWalletExtensionID();
        this.lock.lock();
        try {
            this.extensions.put(id, extension);
            this.saveNow();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, WalletExtension> getExtensions() {
        this.lock.lock();
        try {
            ImmutableMap immutableMap = ImmutableMap.copyOf(this.extensions);
            return immutableMap;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void queueOnTransactionConfidenceChanged(final Transaction tx) {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        for (final ListenerRegistration<WalletEventListener> registration : this.eventListeners) {
            if (registration.executor == Threading.SAME_THREAD) {
                ((WalletEventListener)registration.listener).onTransactionConfidenceChanged(this, tx);
                continue;
            }
            registration.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((WalletEventListener)registration.listener).onTransactionConfidenceChanged(Wallet.this, tx);
                }
            });
        }
    }

    private void maybeQueueOnWalletChanged() {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        Preconditions.checkState((this.onWalletChangedSuppressions >= 0 ? 1 : 0) != 0);
        if (this.onWalletChangedSuppressions > 0) {
            return;
        }
        for (final ListenerRegistration<WalletEventListener> registration : this.eventListeners) {
            registration.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((WalletEventListener)registration.listener).onWalletChanged(Wallet.this);
                }
            });
        }
    }

    private void queueOnCoinsReceived(final Transaction tx, final BigInteger balance, final BigInteger newBalance) {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        for (final ListenerRegistration<WalletEventListener> registration : this.eventListeners) {
            registration.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((WalletEventListener)registration.listener).onCoinsReceived(Wallet.this, tx, balance, newBalance);
                }
            });
        }
    }

    private void queueOnCoinsSent(final Transaction tx, final BigInteger prevBalance, final BigInteger newBalance) {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        for (final ListenerRegistration<WalletEventListener> registration : this.eventListeners) {
            registration.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((WalletEventListener)registration.listener).onCoinsSent(Wallet.this, tx, prevBalance, newBalance);
                }
            });
        }
    }

    private void queueOnReorganize() {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        Preconditions.checkState((boolean)this.insideReorg);
        for (final ListenerRegistration<WalletEventListener> registration : this.eventListeners) {
            registration.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((WalletEventListener)registration.listener).onReorganize(Wallet.this);
                }
            });
        }
    }

    private void queueOnKeysAdded(final List<ECKey> keys) {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        for (final ListenerRegistration<WalletEventListener> registration : this.eventListeners) {
            registration.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((WalletEventListener)registration.listener).onKeysAdded(Wallet.this, keys);
                }
            });
        }
    }

    private void queueOnScriptsAdded(final List<Script> scripts) {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        for (final ListenerRegistration<WalletEventListener> registration : this.eventListeners) {
            registration.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((WalletEventListener)registration.listener).onScriptsAdded(Wallet.this, scripts);
                }
            });
        }
    }

    private int estimateBytesForSigning(CoinSelection selection) {
        int size = 0;
        for (TransactionOutput output : selection.gathered) {
            try {
                if (output.getScriptPubKey().isSentToAddress()) {
                    ECKey key = this.findKeyFromPubHash(output.getScriptPubKey().getPubKeyHash());
                    size += ((ECKey)Preconditions.checkNotNull((Object)key, (Object)"Coin selection includes unspendable outputs")).getPubKey().length + 75;
                    continue;
                }
                if (output.getScriptPubKey().isSentToRawPubKey()) {
                    size += 74;
                    continue;
                }
                throw new IllegalStateException("Unknown output type returned in coin selection");
            }
            catch (ScriptException e) {
                throw new IllegalStateException(e);
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransactionBroadcaster(@Nullable TransactionBroadcaster broadcaster) {
        Transaction[] toBroadcast = new Transaction[]{};
        this.lock.lock();
        try {
            if (this.vTransactionBroadcaster == broadcaster) {
                return;
            }
            this.vTransactionBroadcaster = broadcaster;
            if (broadcaster == null) {
                return;
            }
            toBroadcast = this.pending.values().toArray(toBroadcast);
        }
        finally {
            this.lock.unlock();
        }
        for (Transaction tx : toBroadcast) {
            Preconditions.checkState((tx.getConfidence().getConfidenceType() == TransactionConfidence.ConfidenceType.PENDING ? 1 : 0) != 0);
            log.info("New broadcaster so uploading waiting tx {}", (Object)tx.getHash());
            broadcaster.broadcastTransaction(tx);
        }
    }

    public void setKeyRotationTime(Date time) {
        this.setKeyRotationTime(time.getTime() / 1000L);
    }

    public Date getKeyRotationTime() {
        return new Date(this.vKeyRotationTimestamp * 1000L);
    }

    public void setKeyRotationTime(long unixTimeSeconds) {
        this.vKeyRotationTimestamp = unixTimeSeconds;
        if (unixTimeSeconds > 0L) {
            log.info("Key rotation time set: {}", (Object)unixTimeSeconds);
            this.maybeRotateKeys();
        }
        this.saveNow();
    }

    public void setKeyRotationEnabled(boolean enabled) {
        this.vKeyRotationEnabled = enabled;
        if (enabled) {
            this.maybeRotateKeys();
        }
    }

    public boolean isKeyRotating(ECKey key) {
        long time = this.vKeyRotationTimestamp;
        return time != 0L && key.getCreationTimeSeconds() < time;
    }

    private void maybeRotateKeys() {
        Transaction tx;
        Preconditions.checkState((!this.lock.isHeldByCurrentThread() ? 1 : 0) != 0);
        if (!this.vKeyRotationEnabled) {
            return;
        }
        long keyRotationTimestamp = this.vKeyRotationTimestamp;
        if (keyRotationTimestamp == 0L) {
            return;
        }
        TransactionBroadcaster broadcaster = this.vTransactionBroadcaster;
        while ((tx = this.rekeyOneBatch(keyRotationTimestamp, broadcaster)) != null && tx.getInputs().size() == 600) {
        }
    }

    @Nullable
    private Transaction rekeyOneBatch(long keyRotationTimestamp, final TransactionBroadcaster broadcaster) {
        Transaction rekeyTx;
        this.lock.lock();
        try {
            Iterator<ECKey> i$;
            ECKey safeKey = null;
            boolean haveRotatingKeys = false;
            for (ECKey key : this.keychain) {
                long t = key.getCreationTimeSeconds();
                if (t < keyRotationTimestamp) {
                    haveRotatingKeys = true;
                    continue;
                }
                safeKey = key;
            }
            if (!haveRotatingKeys) {
                i$ = null;
                return i$;
            }
            if (safeKey == null) {
                log.warn("Key rotation requested but no keys newer than the timestamp are available.");
                i$ = null;
                return i$;
            }
            KeyTimeCoinSelector selector = new KeyTimeCoinSelector(this, keyRotationTimestamp, true);
            CoinSelection toMove = selector.select(BigInteger.ZERO, this.calculateAllSpendCandidates(true));
            if (toMove.valueGathered.equals(BigInteger.ZERO)) {
                Transaction t = null;
                return t;
            }
            rekeyTx = new Transaction(this.params);
            for (TransactionOutput output : toMove.gathered) {
                rekeyTx.addInput(output);
            }
            rekeyTx.addOutput(toMove.valueGathered, safeKey);
            if (!this.adjustOutputDownwardsForFee(rekeyTx, toMove, BigInteger.ZERO, Transaction.REFERENCE_DEFAULT_MIN_TX_FEE)) {
                log.error("Failed to adjust rekey tx for fees.");
                Transaction transaction = null;
                return transaction;
            }
            rekeyTx.getConfidence().setSource(TransactionConfidence.Source.SELF);
            rekeyTx.setPurpose(Transaction.Purpose.KEY_ROTATION);
            rekeyTx.signInputs(Transaction.SigHash.ALL, this);
            Preconditions.checkState((rekeyTx.bitcoinSerialize().length < 102400 ? 1 : 0) != 0);
            this.commitTx(rekeyTx);
        }
        catch (VerificationException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.lock.unlock();
        }
        if (broadcaster == null) {
            return rekeyTx;
        }
        log.info("Attempting to send key rotation tx: {}", (Object)rekeyTx);
        new Thread(){

            @Override
            public void run() {
                try {
                    Futures.addCallback(broadcaster.broadcastTransaction(rekeyTx), (FutureCallback)new FutureCallback<Transaction>(){

                        public void onSuccess(Transaction transaction) {
                            log.info("Successfully broadcast key rotation tx: {}", (Object)transaction);
                        }

                        public void onFailure(Throwable throwable) {
                            log.error("Failed to broadcast key rotation tx", throwable);
                        }
                    });
                }
                catch (Exception e) {
                    log.error("Failed to broadcast rekey tx, will try again later", (Throwable)e);
                }
            }
        }.start();
        return rekeyTx;
    }

    private class FeeCalculation {
        private CoinSelection bestCoinSelection;
        private TransactionOutput bestChangeOutput;

        public FeeCalculation(SendRequest req, BigInteger value, List<TransactionInput> originalInputs, boolean needAtLeastReferenceFee, LinkedList<TransactionOutput> candidates) throws InsufficientMoneyException {
            Preconditions.checkState((boolean)Wallet.this.lock.isHeldByCurrentThread());
            BigInteger additionalValueForNextCategory = null;
            CoinSelection selection3 = null;
            CoinSelection selection2 = null;
            TransactionOutput selection2Change = null;
            CoinSelection selection1 = null;
            TransactionOutput selection1Change = null;
            int lastCalculatedSize = 0;
            BigInteger valueMissing = null;
            while (true) {
                this.resetTxInputs(req, originalInputs);
                BigInteger fees = req.fee == null ? BigInteger.ZERO : req.fee;
                fees = lastCalculatedSize > 0 ? fees.add(BigInteger.valueOf(lastCalculatedSize / 1000 + 1).multiply(req.feePerKb)) : fees.add(req.feePerKb);
                if (needAtLeastReferenceFee && fees.compareTo(Transaction.REFERENCE_DEFAULT_MIN_TX_FEE) < 0) {
                    fees = Transaction.REFERENCE_DEFAULT_MIN_TX_FEE;
                }
                BigInteger valueNeeded = value.add(fees);
                if (additionalValueForNextCategory != null) {
                    valueNeeded = valueNeeded.add(additionalValueForNextCategory);
                }
                BigInteger additionalValueSelected = additionalValueForNextCategory;
                CoinSelector selector = req.coinSelector == null ? Wallet.this.coinSelector : req.coinSelector;
                CoinSelection selection = selector.select(valueNeeded, candidates);
                if (selection.valueGathered.compareTo(valueNeeded) < 0) {
                    valueMissing = valueNeeded.subtract(selection.valueGathered);
                    break;
                }
                Preconditions.checkState((selection.gathered.size() > 0 || originalInputs.size() > 0 ? 1 : 0) != 0);
                boolean eitherCategory2Or3 = false;
                boolean isCategory3 = false;
                BigInteger change = selection.valueGathered.subtract(valueNeeded);
                if (additionalValueSelected != null) {
                    change = change.add(additionalValueSelected);
                }
                if (req.ensureMinRequiredFee && !change.equals(BigInteger.ZERO) && change.compareTo(Utils.CENT) < 0 && fees.compareTo(Transaction.REFERENCE_DEFAULT_MIN_TX_FEE) < 0) {
                    eitherCategory2Or3 = true;
                    additionalValueForNextCategory = Utils.CENT;
                    change = change.subtract(Transaction.REFERENCE_DEFAULT_MIN_TX_FEE.subtract(fees));
                }
                int size = 0;
                TransactionOutput changeOutput = null;
                if (change.compareTo(BigInteger.ZERO) > 0) {
                    Address changeAddress = req.changeAddress;
                    if (changeAddress == null) {
                        changeAddress = Wallet.this.getChangeAddress();
                    }
                    changeOutput = new TransactionOutput(Wallet.this.params, req.tx, change, changeAddress);
                    if (req.ensureMinRequiredFee && Transaction.MIN_NONDUST_OUTPUT.compareTo(change) >= 0) {
                        isCategory3 = true;
                        additionalValueForNextCategory = Transaction.REFERENCE_DEFAULT_MIN_TX_FEE.add(Transaction.MIN_NONDUST_OUTPUT.add(BigInteger.ONE));
                    } else {
                        size += changeOutput.bitcoinSerialize().length + VarInt.sizeOf(req.tx.getOutputs().size()) - VarInt.sizeOf(req.tx.getOutputs().size() - 1);
                        if (!eitherCategory2Or3) {
                            additionalValueForNextCategory = null;
                        }
                    }
                } else if (eitherCategory2Or3) {
                    isCategory3 = true;
                    additionalValueForNextCategory = Transaction.REFERENCE_DEFAULT_MIN_TX_FEE.add(BigInteger.ONE);
                }
                for (TransactionOutput output : selection.gathered) {
                    TransactionInput input = req.tx.addInput(output);
                    Preconditions.checkState((input.getScriptBytes().length == 0 ? 1 : 0) != 0);
                }
                size += req.tx.bitcoinSerialize().length;
                if ((size += Wallet.this.estimateBytesForSigning(selection)) / 1000 > lastCalculatedSize / 1000 && req.feePerKb.compareTo(BigInteger.ZERO) > 0) {
                    lastCalculatedSize = size;
                    additionalValueForNextCategory = additionalValueSelected;
                    continue;
                }
                if (isCategory3) {
                    if (selection3 == null) {
                        selection3 = selection;
                    }
                } else if (eitherCategory2Or3) {
                    Preconditions.checkState((selection2 == null ? 1 : 0) != 0);
                    Preconditions.checkState((boolean)additionalValueForNextCategory.equals(Utils.CENT));
                    selection2 = selection;
                    selection2Change = (TransactionOutput)Preconditions.checkNotNull((Object)changeOutput);
                } else {
                    Preconditions.checkState((selection1 == null ? 1 : 0) != 0);
                    Preconditions.checkState((additionalValueForNextCategory == null ? 1 : 0) != 0);
                    selection1 = selection;
                    selection1Change = changeOutput;
                }
                if (additionalValueForNextCategory == null) break;
                if (additionalValueSelected == null) continue;
                Preconditions.checkState((additionalValueForNextCategory.compareTo(additionalValueSelected) > 0 ? 1 : 0) != 0);
            }
            this.resetTxInputs(req, originalInputs);
            if (selection3 == null && selection2 == null && selection1 == null) {
                Preconditions.checkNotNull((Object)valueMissing);
                log.warn("Insufficient value in wallet for send: needed {} more", (Object)Utils.bitcoinValueToFriendlyString(valueMissing));
                throw new InsufficientMoneyException(valueMissing);
            }
            BigInteger lowestFee = null;
            this.bestCoinSelection = null;
            this.bestChangeOutput = null;
            if (selection1 != null) {
                lowestFee = selection1Change != null ? selection1.valueGathered.subtract(selection1Change.getValue()) : selection1.valueGathered;
                this.bestCoinSelection = selection1;
                this.bestChangeOutput = selection1Change;
            }
            if (selection2 != null) {
                BigInteger fee = selection2.valueGathered.subtract(((TransactionOutput)Preconditions.checkNotNull(selection2Change)).getValue());
                if (lowestFee == null || fee.compareTo(lowestFee) < 0) {
                    lowestFee = fee;
                    this.bestCoinSelection = selection2;
                    this.bestChangeOutput = selection2Change;
                }
            }
            if (selection3 != null && (lowestFee == null || selection3.valueGathered.compareTo(lowestFee) < 0)) {
                this.bestCoinSelection = selection3;
                this.bestChangeOutput = null;
            }
        }

        private void resetTxInputs(SendRequest req, List<TransactionInput> originalInputs) {
            req.tx.clearInputs();
            for (TransactionInput input : originalInputs) {
                req.tx.addInput(input);
            }
        }
    }

    private static class BalanceFutureRequest {
        public SettableFuture<BigInteger> future;
        public BigInteger value;
        public BalanceType type;

        private BalanceFutureRequest() {
        }
    }

    private static class TxOffsetPair
    implements Comparable<TxOffsetPair> {
        public final Transaction tx;
        public final int offset;

        public TxOffsetPair(Transaction tx, int offset) {
            this.tx = tx;
            this.offset = offset;
        }

        @Override
        public int compareTo(TxOffsetPair o) {
            return Ints.compare((int)this.offset, (int)o.offset);
        }
    }

    public static enum BalanceType {
        ESTIMATED,
        AVAILABLE;

    }

    public static class SendRequest {
        public Transaction tx;
        public boolean emptyWallet = false;
        public Address changeAddress = null;
        public BigInteger fee = null;
        public BigInteger feePerKb = DEFAULT_FEE_PER_KB;
        public static BigInteger DEFAULT_FEE_PER_KB = Transaction.REFERENCE_DEFAULT_MIN_TX_FEE;
        public boolean ensureMinRequiredFee = true;
        public KeyParameter aesKey = null;
        public CoinSelector coinSelector = null;
        private boolean completed;

        private SendRequest() {
        }

        public static SendRequest to(Address destination, BigInteger value) {
            SendRequest req = new SendRequest();
            NetworkParameters parameters = destination.getParameters();
            Preconditions.checkNotNull((Object)parameters, (Object)"Address is for an unknown network");
            req.tx = new Transaction(parameters);
            req.tx.addOutput(value, destination);
            return req;
        }

        public static SendRequest to(NetworkParameters params, ECKey destination, BigInteger value) {
            SendRequest req = new SendRequest();
            req.tx = new Transaction(params);
            req.tx.addOutput(value, destination);
            return req;
        }

        public static SendRequest forTx(Transaction tx) {
            SendRequest req = new SendRequest();
            req.tx = tx;
            return req;
        }

        public static SendRequest emptyWallet(Address destination) {
            SendRequest req = new SendRequest();
            NetworkParameters parameters = destination.getParameters();
            Preconditions.checkNotNull((Object)parameters, (Object)"Address is for an unknown network");
            req.tx = new Transaction(parameters);
            req.tx.addOutput(BigInteger.ZERO, destination);
            req.emptyWallet = true;
            return req;
        }
    }

    public static class SendResult {
        public Transaction tx;
        public ListenableFuture<Transaction> broadcastComplete;
    }
}

