/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.AddressFormatException;
import com.google.bitcoin.core.Base58;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.VarInt;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedLongs;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.spongycastle.crypto.digests.RIPEMD160Digest;
import org.spongycastle.util.encoders.Hex;

public class Utils {
    public static final BigInteger NEGATIVE_ONE = BigInteger.valueOf(-1L);
    private static final MessageDigest digest;
    public static final String BITCOIN_SIGNED_MESSAGE_HEADER = "Bitcoin Signed Message:\n";
    public static final byte[] BITCOIN_SIGNED_MESSAGE_HEADER_BYTES;
    public static final BigInteger COIN;
    public static final BigInteger CENT;
    private static BlockingQueue<Boolean> mockSleepQueue;
    public static volatile Date mockTime;
    private static final int[] bitMask;

    public static BigInteger toNanoCoins(int coins, int cents) {
        Preconditions.checkArgument((cents < 100 ? 1 : 0) != 0);
        Preconditions.checkArgument((cents >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((coins >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument(((long)coins < NetworkParameters.MAX_MONEY.divide(COIN).longValue() ? 1 : 0) != 0);
        BigInteger bi = BigInteger.valueOf(coins).multiply(COIN);
        bi = bi.add(BigInteger.valueOf(cents).multiply(CENT));
        return bi;
    }

    public static byte[] bigIntegerToBytes(BigInteger b, int numBytes) {
        if (b == null) {
            return null;
        }
        byte[] bytes = new byte[numBytes];
        byte[] biBytes = b.toByteArray();
        int start = biBytes.length == numBytes + 1 ? 1 : 0;
        int length = Math.min(biBytes.length, numBytes);
        System.arraycopy(biBytes, start, bytes, numBytes - length, length);
        return bytes;
    }

    public static BigInteger toNanoCoins(String coins) {
        BigInteger bigint = new BigDecimal(coins).movePointRight(8).toBigIntegerExact();
        if (bigint.compareTo(BigInteger.ZERO) < 0) {
            throw new ArithmeticException("Negative coins specified");
        }
        if (bigint.compareTo(NetworkParameters.MAX_MONEY) > 0) {
            throw new ArithmeticException("Amount larger than the total quantity of Bitcoins possible specified.");
        }
        return bigint;
    }

    public static void uint32ToByteArrayBE(long val, byte[] out, int offset) {
        out[offset + 0] = (byte)(0xFFL & val >> 24);
        out[offset + 1] = (byte)(0xFFL & val >> 16);
        out[offset + 2] = (byte)(0xFFL & val >> 8);
        out[offset + 3] = (byte)(0xFFL & val >> 0);
    }

    public static void uint32ToByteArrayLE(long val, byte[] out, int offset) {
        out[offset + 0] = (byte)(0xFFL & val >> 0);
        out[offset + 1] = (byte)(0xFFL & val >> 8);
        out[offset + 2] = (byte)(0xFFL & val >> 16);
        out[offset + 3] = (byte)(0xFFL & val >> 24);
    }

    public static void uint64ToByteArrayLE(long val, byte[] out, int offset) {
        out[offset + 0] = (byte)(0xFFL & val >> 0);
        out[offset + 1] = (byte)(0xFFL & val >> 8);
        out[offset + 2] = (byte)(0xFFL & val >> 16);
        out[offset + 3] = (byte)(0xFFL & val >> 24);
        out[offset + 4] = (byte)(0xFFL & val >> 32);
        out[offset + 5] = (byte)(0xFFL & val >> 40);
        out[offset + 6] = (byte)(0xFFL & val >> 48);
        out[offset + 7] = (byte)(0xFFL & val >> 56);
    }

    public static void uint32ToByteStreamLE(long val, OutputStream stream) throws IOException {
        stream.write((int)(0xFFL & val >> 0));
        stream.write((int)(0xFFL & val >> 8));
        stream.write((int)(0xFFL & val >> 16));
        stream.write((int)(0xFFL & val >> 24));
    }

    public static void int64ToByteStreamLE(long val, OutputStream stream) throws IOException {
        stream.write((int)(0xFFL & val >> 0));
        stream.write((int)(0xFFL & val >> 8));
        stream.write((int)(0xFFL & val >> 16));
        stream.write((int)(0xFFL & val >> 24));
        stream.write((int)(0xFFL & val >> 32));
        stream.write((int)(0xFFL & val >> 40));
        stream.write((int)(0xFFL & val >> 48));
        stream.write((int)(0xFFL & val >> 56));
    }

    public static void uint64ToByteStreamLE(BigInteger val, OutputStream stream) throws IOException {
        byte[] bytes = val.toByteArray();
        if (bytes.length > 8) {
            throw new RuntimeException("Input too large to encode into a uint64");
        }
        bytes = Utils.reverseBytes(bytes);
        stream.write(bytes);
        if (bytes.length < 8) {
            for (int i = 0; i < 8 - bytes.length; ++i) {
                stream.write(0);
            }
        }
    }

    public static byte[] doubleDigest(byte[] input) {
        return Utils.doubleDigest(input, 0, input.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] doubleDigest(byte[] input, int offset, int length) {
        MessageDigest messageDigest = digest;
        synchronized (messageDigest) {
            digest.reset();
            digest.update(input, offset, length);
            byte[] first = digest.digest();
            return digest.digest(first);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] singleDigest(byte[] input, int offset, int length) {
        MessageDigest messageDigest = digest;
        synchronized (messageDigest) {
            digest.reset();
            digest.update(input, offset, length);
            return digest.digest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] doubleDigestTwoBuffers(byte[] input1, int offset1, int length1, byte[] input2, int offset2, int length2) {
        MessageDigest messageDigest = digest;
        synchronized (messageDigest) {
            digest.reset();
            digest.update(input1, offset1, length1);
            digest.update(input2, offset2, length2);
            byte[] first = digest.digest();
            return digest.digest(first);
        }
    }

    public static boolean isLessThanUnsigned(long n1, long n2) {
        return UnsignedLongs.compare((long)n1, (long)n2) < 0;
    }

    public static String bytesToHexString(byte[] bytes) {
        StringBuffer buf = new StringBuffer(bytes.length * 2);
        for (byte b : bytes) {
            String s = Integer.toString(0xFF & b, 16);
            if (s.length() < 2) {
                buf.append('0');
            }
            buf.append(s);
        }
        return buf.toString();
    }

    public static byte[] reverseBytes(byte[] bytes) {
        byte[] buf = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            buf[i] = bytes[bytes.length - 1 - i];
        }
        return buf;
    }

    public static byte[] reverseDwordBytes(byte[] bytes, int trimLength) {
        Preconditions.checkArgument((bytes.length % 4 == 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((trimLength < 0 || trimLength % 4 == 0 ? 1 : 0) != 0);
        byte[] rev = new byte[trimLength >= 0 && bytes.length > trimLength ? trimLength : bytes.length];
        for (int i = 0; i < rev.length; i += 4) {
            System.arraycopy(bytes, i, rev, i, 4);
            for (int j = 0; j < 4; ++j) {
                rev[i + j] = bytes[i + 3 - j];
            }
        }
        return rev;
    }

    public static long readUint32(byte[] bytes, int offset) {
        return ((long)bytes[offset++] & 0xFFL) << 0 | ((long)bytes[offset++] & 0xFFL) << 8 | ((long)bytes[offset++] & 0xFFL) << 16 | ((long)bytes[offset] & 0xFFL) << 24;
    }

    public static long readInt64(byte[] bytes, int offset) {
        return ((long)bytes[offset++] & 0xFFL) << 0 | ((long)bytes[offset++] & 0xFFL) << 8 | ((long)bytes[offset++] & 0xFFL) << 16 | ((long)bytes[offset++] & 0xFFL) << 24 | ((long)bytes[offset++] & 0xFFL) << 32 | ((long)bytes[offset++] & 0xFFL) << 40 | ((long)bytes[offset++] & 0xFFL) << 48 | ((long)bytes[offset] & 0xFFL) << 56;
    }

    public static long readUint32BE(byte[] bytes, int offset) {
        return ((long)bytes[offset + 0] & 0xFFL) << 24 | ((long)bytes[offset + 1] & 0xFFL) << 16 | ((long)bytes[offset + 2] & 0xFFL) << 8 | ((long)bytes[offset + 3] & 0xFFL) << 0;
    }

    public static int readUint16BE(byte[] bytes, int offset) {
        return (bytes[offset] & 0xFF) << 8 | bytes[offset + 1] & 0xFF;
    }

    public static byte[] sha256hash160(byte[] input) {
        try {
            byte[] sha256 = MessageDigest.getInstance("SHA-256").digest(input);
            RIPEMD160Digest digest = new RIPEMD160Digest();
            digest.update(sha256, 0, sha256.length);
            byte[] out = new byte[20];
            digest.doFinal(out, 0);
            return out;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String bitcoinValueToFriendlyString(BigInteger value) {
        boolean negative;
        boolean bl = negative = value.compareTo(BigInteger.ZERO) < 0;
        if (negative) {
            value = value.negate();
        }
        BigDecimal bd = new BigDecimal(value, 8);
        String formatted = bd.toPlainString();
        int decimalPoint = formatted.indexOf(".");
        int toDelete = 0;
        for (int i = formatted.length() - 1; i > decimalPoint + 2 && formatted.charAt(i) == '0'; --i) {
            ++toDelete;
        }
        return (negative ? "-" : "") + formatted.substring(0, formatted.length() - toDelete);
    }

    public static String bitcoinValueToPlainString(BigInteger value) {
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        BigDecimal valueInBTC = new BigDecimal(value).divide(new BigDecimal(COIN));
        return valueInBTC.toPlainString();
    }

    public static BigInteger decodeMPI(byte[] mpi, boolean hasLength) {
        boolean isNegative;
        byte[] buf;
        if (hasLength) {
            int length = (int)Utils.readUint32BE(mpi, 0);
            buf = new byte[length];
            System.arraycopy(mpi, 4, buf, 0, length);
        } else {
            buf = mpi;
        }
        if (buf.length == 0) {
            return BigInteger.ZERO;
        }
        boolean bl = isNegative = (buf[0] & 0x80) == 128;
        if (isNegative) {
            buf[0] = (byte)(buf[0] & 0x7F);
        }
        BigInteger result = new BigInteger(buf);
        return isNegative ? result.negate() : result;
    }

    public static byte[] encodeMPI(BigInteger value, boolean includeLength) {
        byte[] result;
        boolean isNegative;
        if (value.equals(BigInteger.ZERO)) {
            if (!includeLength) {
                return new byte[0];
            }
            return new byte[]{0, 0, 0, 0};
        }
        boolean bl = isNegative = value.compareTo(BigInteger.ZERO) < 0;
        if (isNegative) {
            value = value.negate();
        }
        byte[] array = value.toByteArray();
        int length = array.length;
        if ((array[0] & 0x80) == 128) {
            ++length;
        }
        if (includeLength) {
            byte[] result2 = new byte[length + 4];
            System.arraycopy(array, 0, result2, length - array.length + 3, array.length);
            Utils.uint32ToByteArrayBE(length, result2, 0);
            if (isNegative) {
                result2[4] = (byte)(result2[4] | 0x80);
            }
            return result2;
        }
        if (length != array.length) {
            result = new byte[length];
            System.arraycopy(array, 0, result, 1, array.length);
        } else {
            result = array;
        }
        if (isNegative) {
            result[0] = (byte)(result[0] | 0x80);
        }
        return result;
    }

    public static BigInteger decodeCompactBits(long compact) {
        int size = (int)(compact >> 24) & 0xFF;
        byte[] bytes = new byte[4 + size];
        bytes[3] = (byte)size;
        if (size >= 1) {
            bytes[4] = (byte)(compact >> 16 & 0xFFL);
        }
        if (size >= 2) {
            bytes[5] = (byte)(compact >> 8 & 0xFFL);
        }
        if (size >= 3) {
            bytes[6] = (byte)(compact >> 0 & 0xFFL);
        }
        return Utils.decodeMPI(bytes, true);
    }

    public static Date rollMockClock(int seconds) {
        return Utils.rollMockClockMillis(seconds * 1000);
    }

    public static Date rollMockClockMillis(long millis) {
        if (mockTime == null) {
            throw new IllegalStateException("You need to use setMockClock() first.");
        }
        mockTime = new Date(mockTime.getTime() + millis);
        return mockTime;
    }

    public static void setMockClock() {
        mockTime = new Date();
    }

    public static void setMockClock(long mockClock) {
        mockTime = new Date(mockClock * 1000L);
    }

    public static Date now() {
        if (mockTime != null) {
            return mockTime;
        }
        return new Date();
    }

    public static long currentTimeMillis() {
        if (mockTime != null) {
            return mockTime.getTime();
        }
        return System.currentTimeMillis();
    }

    public static byte[] copyOf(byte[] in, int length) {
        byte[] out = new byte[length];
        System.arraycopy(in, 0, out, 0, Math.min(length, in.length));
        return out;
    }

    public static byte[] appendByte(byte[] bytes, byte b) {
        byte[] result = Arrays.copyOf(bytes, bytes.length + 1);
        result[result.length - 1] = b;
        return result;
    }

    public static byte[] parseAsHexOrBase58(String data) {
        try {
            return Hex.decode((String)data);
        }
        catch (Exception e) {
            try {
                return Base58.decodeChecked(data);
            }
            catch (AddressFormatException e1) {
                return null;
            }
        }
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    public static byte[] formatMessageForSigning(String message) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bos.write(BITCOIN_SIGNED_MESSAGE_HEADER_BYTES.length);
            bos.write(BITCOIN_SIGNED_MESSAGE_HEADER_BYTES);
            byte[] messageBytes = message.getBytes(Charsets.UTF_8);
            VarInt size = new VarInt(messageBytes.length);
            bos.write(size.encode());
            bos.write(messageBytes);
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean checkBitLE(byte[] data, int index) {
        return (data[index >>> 3] & bitMask[7 & index]) != 0;
    }

    public static void setBitLE(byte[] data, int index) {
        int n = index >>> 3;
        data[n] = (byte)(data[n] | bitMask[7 & index]);
    }

    public static void sleep(long millis) {
        if (mockSleepQueue == null) {
            Uninterruptibles.sleepUninterruptibly((long)millis, (TimeUnit)TimeUnit.MILLISECONDS);
        } else {
            try {
                boolean isMultiPass = mockSleepQueue.take();
                Utils.rollMockClockMillis(millis);
                if (isMultiPass) {
                    mockSleepQueue.offer(true);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static void setMockSleep(boolean isEnable) {
        if (isEnable) {
            mockSleepQueue = new ArrayBlockingQueue<Boolean>(1);
            mockTime = new Date(System.currentTimeMillis());
        } else {
            mockSleepQueue = null;
        }
    }

    public static void passMockSleep() {
        mockSleepQueue.offer(false);
    }

    public static void finishMockSleep() {
        if (mockSleepQueue != null) {
            mockSleepQueue.offer(true);
        }
    }

    public static int maxOfMostFreq(int ... items) {
        ArrayList<Integer> list = new ArrayList<Integer>(items.length);
        for (int item : items) {
            list.add(item);
        }
        return Utils.maxOfMostFreq(list);
    }

    public static int maxOfMostFreq(List<Integer> items) {
        if (items.isEmpty()) {
            return 0;
        }
        items = Ordering.natural().reverse().sortedCopy(items);
        LinkedList pairs = Lists.newLinkedList();
        pairs.add(new Pair((Integer)items.get(0), 0));
        Iterator i$ = items.iterator();
        while (i$.hasNext()) {
            int item = (Integer)i$.next();
            Pair pair = (Pair)pairs.getLast();
            if (pair.item != item) {
                pair = new Pair(item, 0);
                pairs.add(pair);
            }
            ++pair.count;
        }
        Collections.sort(pairs);
        int maxCount = ((Pair)pairs.getFirst()).count;
        int maxItem = ((Pair)pairs.getFirst()).item;
        for (Pair pair : pairs) {
            if (pair.count != maxCount) break;
            maxItem = Math.max(maxItem, pair.item);
        }
        return maxItem;
    }

    static {
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        BITCOIN_SIGNED_MESSAGE_HEADER_BYTES = BITCOIN_SIGNED_MESSAGE_HEADER.getBytes(Charsets.UTF_8);
        COIN = new BigInteger("100000000", 10);
        CENT = new BigInteger("1000000", 10);
        bitMask = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
    }

    private static class Pair
    implements Comparable<Pair> {
        int item;
        int count;

        public Pair(int item, int count) {
            this.count = count;
            this.item = item;
        }

        @Override
        public int compareTo(Pair o) {
            return -Ints.compare((int)this.count, (int)o.count);
        }
    }
}

