/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.Address;
import com.google.bitcoin.core.ChildMessage;
import com.google.bitcoin.core.ECKey;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.ProtocolException;
import com.google.bitcoin.core.ScriptException;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.TransactionInput;
import com.google.bitcoin.core.Utils;
import com.google.bitcoin.core.VarInt;
import com.google.bitcoin.core.Wallet;
import com.google.bitcoin.script.Script;
import com.google.bitcoin.script.ScriptBuilder;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionOutput
extends ChildMessage
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(TransactionOutput.class);
    private static final long serialVersionUID = -590332479859256824L;
    private BigInteger value;
    private byte[] scriptBytes;
    private transient WeakReference<Script> scriptPubKey;
    private boolean availableForSpending;
    private TransactionInput spentBy;
    Transaction parentTransaction;
    private transient int scriptLen;

    public TransactionOutput(NetworkParameters params, @Nullable Transaction parent, byte[] payload, int offset) throws ProtocolException {
        super(params, payload, offset);
        this.parentTransaction = parent;
        this.availableForSpending = true;
    }

    public TransactionOutput(NetworkParameters params, Transaction parent, byte[] msg, int offset, boolean parseLazy, boolean parseRetain) throws ProtocolException {
        super(params, msg, offset, parent, parseLazy, parseRetain, Integer.MIN_VALUE);
        this.parentTransaction = parent;
        this.availableForSpending = true;
    }

    public TransactionOutput(NetworkParameters params, Transaction parent, BigInteger value, Address to) {
        this(params, parent, value, ScriptBuilder.createOutputScript(to).getProgram());
    }

    public TransactionOutput(NetworkParameters params, Transaction parent, BigInteger value, ECKey to) {
        this(params, parent, value, ScriptBuilder.createOutputScript(to).getProgram());
    }

    public TransactionOutput(NetworkParameters params, Transaction parent, BigInteger value, byte[] scriptBytes) {
        super(params);
        Preconditions.checkArgument((value.compareTo(BigInteger.ZERO) >= 0 || value.equals(Utils.NEGATIVE_ONE) ? 1 : 0) != 0, (Object)"Negative values not allowed");
        Preconditions.checkArgument((value.compareTo(NetworkParameters.MAX_MONEY) < 0 ? 1 : 0) != 0, (Object)"Values larger than MAX_MONEY not allowed");
        this.value = value;
        this.scriptBytes = scriptBytes;
        this.parentTransaction = parent;
        this.availableForSpending = true;
        this.length = 8 + VarInt.sizeOf(scriptBytes.length) + scriptBytes.length;
    }

    public Script getScriptPubKey() throws ScriptException {
        Script script;
        Script script2 = script = this.scriptPubKey == null ? null : (Script)this.scriptPubKey.get();
        if (script == null) {
            this.maybeParse();
            script = new Script(this.scriptBytes);
            this.scriptPubKey = new WeakReference<Script>(script);
            return script;
        }
        return script;
    }

    @Override
    protected void parseLite() throws ProtocolException {
        long outputValue = this.readInt64();
        this.value = BigInteger.valueOf(outputValue);
        this.scriptLen = (int)this.readVarInt();
        this.length = this.cursor - this.offset + this.scriptLen;
    }

    @Override
    void parse() throws ProtocolException {
        this.scriptBytes = this.readBytes(this.scriptLen);
    }

    @Override
    protected void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        Preconditions.checkNotNull((Object)this.scriptBytes);
        Utils.int64ToByteStreamLE(this.getValue().longValue(), stream);
        stream.write(new VarInt(this.scriptBytes.length).encode());
        stream.write(this.scriptBytes);
    }

    public BigInteger getValue() {
        this.maybeParse();
        return this.value;
    }

    public void setValue(BigInteger value) {
        Preconditions.checkNotNull((Object)value);
        this.unCache();
        this.value = value;
    }

    int getIndex() {
        Preconditions.checkNotNull((Object)this.parentTransaction, (Object)"This output is not attached to a parent transaction.");
        for (int i = 0; i < this.parentTransaction.getOutputs().size(); ++i) {
            if (this.parentTransaction.getOutputs().get(i) != this) continue;
            return i;
        }
        throw new RuntimeException("Output linked to wrong parent transaction?");
    }

    public BigInteger getMinNonDustValue(BigInteger feePerKbRequired) {
        BigInteger size = BigInteger.valueOf(this.bitcoinSerialize().length + 148);
        BigInteger[] nonDustAndRemainder = feePerKbRequired.multiply(size).divideAndRemainder(BigInteger.valueOf(1000L));
        return nonDustAndRemainder[1].equals(BigInteger.ZERO) ? nonDustAndRemainder[0] : nonDustAndRemainder[0].add(BigInteger.ONE);
    }

    public BigInteger getMinNonDustValue() {
        return this.getMinNonDustValue(Transaction.REFERENCE_DEFAULT_MIN_TX_FEE.multiply(BigInteger.valueOf(3L)));
    }

    public void markAsSpent(TransactionInput input) {
        Preconditions.checkState((boolean)this.availableForSpending);
        this.availableForSpending = false;
        this.spentBy = input;
    }

    public void markAsUnspent() {
        this.availableForSpending = true;
        this.spentBy = null;
    }

    public boolean isAvailableForSpending() {
        return this.availableForSpending;
    }

    public byte[] getScriptBytes() {
        this.maybeParse();
        return this.scriptBytes;
    }

    public boolean isMineOrWatched(Wallet wallet) {
        return this.isMine(wallet) || this.isWatched(wallet);
    }

    public boolean isWatched(Wallet wallet) {
        try {
            Script script = this.getScriptPubKey();
            return wallet.isWatchedScript(script);
        }
        catch (ScriptException e) {
            log.debug("Could not parse tx output script: {}", (Object)e.toString());
            return false;
        }
    }

    public boolean isMine(Wallet wallet) {
        try {
            Script script = this.getScriptPubKey();
            if (script.isSentToRawPubKey()) {
                byte[] pubkey = script.getPubKey();
                return wallet.isPubKeyMine(pubkey);
            }
            byte[] pubkeyHash = script.getPubKeyHash();
            return wallet.isPubKeyHashMine(pubkeyHash);
        }
        catch (ScriptException e) {
            log.debug("Could not parse tx output script: {}", (Object)e.toString());
            return false;
        }
    }

    public String toString() {
        try {
            return "TxOut of " + Utils.bitcoinValueToFriendlyString(this.value) + " to " + this.getScriptPubKey().getToAddress(this.params).toString() + " script:" + this.getScriptPubKey().toString();
        }
        catch (ScriptException e) {
            throw new RuntimeException(e);
        }
    }

    public TransactionInput getSpentBy() {
        return this.spentBy;
    }

    public Transaction getParentTransaction() {
        return (Transaction)Preconditions.checkNotNull((Object)this.parentTransaction, (Object)"Free-standing TransactionOutput");
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.maybeParse();
        out.defaultWriteObject();
    }
}

