/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.Address;
import com.google.bitcoin.core.ChildMessage;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.ProtocolException;
import com.google.bitcoin.core.ScriptException;
import com.google.bitcoin.core.Sha256Hash;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.TransactionOutPoint;
import com.google.bitcoin.core.TransactionOutput;
import com.google.bitcoin.core.Utils;
import com.google.bitcoin.core.VarInt;
import com.google.bitcoin.core.VerificationException;
import com.google.bitcoin.script.Script;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Map;
import javax.annotation.Nullable;

public class TransactionInput
extends ChildMessage
implements Serializable {
    public static final long NO_SEQUENCE = 0xFFFFFFFFL;
    private static final long serialVersionUID = 2L;
    public static final byte[] EMPTY_ARRAY = new byte[0];
    private long sequence;
    private TransactionOutPoint outpoint;
    private byte[] scriptBytes;
    private transient WeakReference<Script> scriptSig;
    private Transaction parentTransaction;

    public TransactionInput(NetworkParameters params, Transaction parentTransaction, byte[] scriptBytes) {
        super(params);
        this.scriptBytes = scriptBytes;
        this.outpoint = new TransactionOutPoint(params, 0xFFFFFFFFL, (Transaction)null);
        this.sequence = 0xFFFFFFFFL;
        this.parentTransaction = parentTransaction;
        this.length = 40 + (scriptBytes == null ? 1 : VarInt.sizeOf(scriptBytes.length) + scriptBytes.length);
    }

    public TransactionInput(NetworkParameters params, @Nullable Transaction parentTransaction, byte[] scriptBytes, TransactionOutPoint outpoint) {
        super(params);
        this.scriptBytes = scriptBytes;
        this.outpoint = outpoint;
        this.sequence = 0xFFFFFFFFL;
        this.parentTransaction = parentTransaction;
        this.length = 40 + (scriptBytes == null ? 1 : VarInt.sizeOf(scriptBytes.length) + scriptBytes.length);
    }

    TransactionInput(NetworkParameters params, Transaction parentTransaction, TransactionOutput output) {
        super(params);
        long outputIndex = output.getIndex();
        this.outpoint = new TransactionOutPoint(params, outputIndex, output.parentTransaction);
        this.scriptBytes = EMPTY_ARRAY;
        this.sequence = 0xFFFFFFFFL;
        this.parentTransaction = parentTransaction;
        this.length = 41;
    }

    public TransactionInput(NetworkParameters params, Transaction parentTransaction, byte[] payload, int offset) throws ProtocolException {
        super(params, payload, offset);
        this.parentTransaction = parentTransaction;
    }

    public TransactionInput(NetworkParameters params, Transaction parentTransaction, byte[] msg, int offset, boolean parseLazy, boolean parseRetain) throws ProtocolException {
        super(params, msg, offset, parentTransaction, parseLazy, parseRetain, Integer.MIN_VALUE);
        this.parentTransaction = parentTransaction;
    }

    @Override
    protected void parseLite() throws ProtocolException {
        int curs = this.cursor;
        int scriptLen = (int)this.readVarInt(36);
        this.length = this.cursor - this.offset + scriptLen + 4;
        this.cursor = curs;
    }

    @Override
    void parse() throws ProtocolException {
        this.outpoint = new TransactionOutPoint(this.params, this.bytes, this.cursor, this, this.parseLazy, this.parseRetain);
        this.cursor += this.outpoint.getMessageSize();
        int scriptLen = (int)this.readVarInt();
        this.scriptBytes = this.readBytes(scriptLen);
        this.sequence = this.readUint32();
    }

    @Override
    protected void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        this.outpoint.bitcoinSerialize(stream);
        stream.write(new VarInt(this.scriptBytes.length).encode());
        stream.write(this.scriptBytes);
        Utils.uint32ToByteStreamLE(this.sequence, stream);
    }

    public boolean isCoinBase() {
        this.maybeParse();
        return this.outpoint.getHash().equals(Sha256Hash.ZERO_HASH) && (this.outpoint.getIndex() & 0xFFFFFFFFL) == 0xFFFFFFFFL;
    }

    public Script getScriptSig() throws ScriptException {
        Script script;
        Script script2 = script = this.scriptSig == null ? null : (Script)this.scriptSig.get();
        if (script == null) {
            this.maybeParse();
            script = new Script(this.scriptBytes);
            this.scriptSig = new WeakReference<Script>(script);
            return script;
        }
        return script;
    }

    public void setScriptSig(Script scriptSig) {
        this.scriptSig = new WeakReference<Object>(Preconditions.checkNotNull((Object)scriptSig));
        this.setScriptBytes(scriptSig.getProgram());
    }

    @Deprecated
    public Address getFromAddress() throws ScriptException {
        if (this.isCoinBase()) {
            throw new ScriptException("This is a coinbase transaction which generates new coins. It does not have a from address.");
        }
        return this.getScriptSig().getFromAddress(this.params);
    }

    public long getSequenceNumber() {
        this.maybeParse();
        return this.sequence;
    }

    public void setSequenceNumber(long sequence) {
        this.unCache();
        this.sequence = sequence;
    }

    public TransactionOutPoint getOutpoint() {
        this.maybeParse();
        return this.outpoint;
    }

    public byte[] getScriptBytes() {
        this.maybeParse();
        return this.scriptBytes;
    }

    void setScriptBytes(byte[] scriptBytes) {
        this.unCache();
        this.scriptSig = null;
        int oldLength = this.length;
        this.scriptBytes = scriptBytes;
        int newLength = 40 + (scriptBytes == null ? 1 : VarInt.sizeOf(scriptBytes.length) + scriptBytes.length);
        this.adjustLength(newLength - oldLength);
    }

    public Transaction getParentTransaction() {
        return this.parentTransaction;
    }

    public String toString() {
        if (this.isCoinBase()) {
            return "TxIn: COINBASE";
        }
        try {
            return "TxIn for [" + this.outpoint + "]: " + this.getScriptSig();
        }
        catch (ScriptException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    TransactionOutput getConnectedOutput(Map<Sha256Hash, Transaction> transactions) {
        Transaction tx = transactions.get(this.outpoint.getHash());
        if (tx == null) {
            return null;
        }
        return tx.getOutputs().get((int)this.outpoint.getIndex());
    }

    public ConnectionResult connect(Map<Sha256Hash, Transaction> transactions, ConnectMode mode) {
        Transaction tx = transactions.get(this.outpoint.getHash());
        if (tx == null) {
            return ConnectionResult.NO_SUCH_TX;
        }
        return this.connect(tx, mode);
    }

    public ConnectionResult connect(Transaction transaction, ConnectMode mode) {
        if (!transaction.getHash().equals(this.outpoint.getHash())) {
            return ConnectionResult.NO_SUCH_TX;
        }
        Preconditions.checkElementIndex((int)((int)this.outpoint.getIndex()), (int)transaction.getOutputs().size(), (String)"Corrupt transaction");
        TransactionOutput out = transaction.getOutput((int)this.outpoint.getIndex());
        if (!out.isAvailableForSpending()) {
            if (out.parentTransaction.equals(this.outpoint.fromTx)) {
                return ConnectionResult.SUCCESS;
            }
            if (mode == ConnectMode.DISCONNECT_ON_CONFLICT) {
                out.markAsUnspent();
            } else if (mode == ConnectMode.ABORT_ON_CONFLICT) {
                this.outpoint.fromTx = (Transaction)Preconditions.checkNotNull((Object)out.parentTransaction);
                return ConnectionResult.ALREADY_SPENT;
            }
        }
        this.connect(out);
        return ConnectionResult.SUCCESS;
    }

    public void connect(TransactionOutput out) {
        this.outpoint.fromTx = (Transaction)Preconditions.checkNotNull((Object)out.parentTransaction);
        out.markAsSpent(this);
    }

    public boolean disconnect() {
        if (this.outpoint.fromTx == null) {
            return false;
        }
        TransactionOutput output = this.outpoint.fromTx.getOutput((int)this.outpoint.getIndex());
        if (output.getSpentBy() == this) {
            output.markAsUnspent();
            this.outpoint.fromTx = null;
            return true;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.maybeParse();
        out.defaultWriteObject();
    }

    public boolean hasSequence() {
        return this.sequence != 0xFFFFFFFFL;
    }

    public void verify() throws VerificationException {
        Transaction fromTx = this.getOutpoint().fromTx;
        long spendingIndex = this.getOutpoint().getIndex();
        Preconditions.checkNotNull((Object)fromTx, (Object)"Not connected");
        TransactionOutput output = fromTx.getOutput((int)spendingIndex);
        this.verify(output);
    }

    public void verify(TransactionOutput output) throws VerificationException {
        if (output.parentTransaction != null) {
            if (!this.getOutpoint().getHash().equals(output.parentTransaction.getHash())) {
                throw new VerificationException("This input does not refer to the tx containing the output.");
            }
            if (this.getOutpoint().getIndex() != (long)output.getIndex()) {
                throw new VerificationException("This input refers to a different output on the given tx.");
            }
        }
        Script pubKey = output.getScriptPubKey();
        int myIndex = this.parentTransaction.getInputs().indexOf(this);
        this.getScriptSig().correctlySpends(this.parentTransaction, myIndex, pubKey, true);
    }

    @Nullable
    public TransactionOutput getConnectedOutput() {
        return this.getOutpoint().getConnectedOutput();
    }

    public static enum ConnectMode {
        DISCONNECT_ON_CONFLICT,
        ABORT_ON_CONFLICT;

    }

    public static enum ConnectionResult {
        NO_SUCH_TX,
        ALREADY_SPENT,
        SUCCESS;

    }
}

