/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.BitcoinSerializer;
import com.google.bitcoin.core.Message;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.PeerAddress;
import com.google.bitcoin.core.ProtocolException;
import com.google.bitcoin.net.AbstractTimeoutHandler;
import com.google.bitcoin.net.MessageWriteTarget;
import com.google.bitcoin.net.StreamParser;
import com.google.bitcoin.utils.Threading;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.NotYetConnectedException;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PeerSocketHandler
extends AbstractTimeoutHandler
implements StreamParser {
    private static final Logger log = LoggerFactory.getLogger(PeerSocketHandler.class);
    private final BitcoinSerializer serializer;
    protected PeerAddress peerAddress;
    private boolean closePending = false;
    @VisibleForTesting
    MessageWriteTarget writeTarget = null;
    private byte[] largeReadBuffer;
    private int largeReadBufferPos;
    private BitcoinSerializer.BitcoinPacketHeader header;
    private Lock lock = Threading.lock("PeerSocketHandler");

    public PeerSocketHandler(NetworkParameters params, InetSocketAddress remoteIp) {
        this.serializer = new BitcoinSerializer((NetworkParameters)Preconditions.checkNotNull((Object)params));
        this.peerAddress = new PeerAddress(remoteIp);
    }

    public PeerSocketHandler(NetworkParameters params, PeerAddress peerAddress) {
        this.serializer = new BitcoinSerializer((NetworkParameters)Preconditions.checkNotNull((Object)params));
        this.peerAddress = (PeerAddress)Preconditions.checkNotNull((Object)peerAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(Message message) throws NotYetConnectedException {
        this.lock.lock();
        try {
            if (this.writeTarget == null) {
                throw new NotYetConnectedException();
            }
        }
        finally {
            this.lock.unlock();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.serializer.serialize(message, out);
            this.writeTarget.writeBytes(out.toByteArray());
        }
        catch (IOException e) {
            this.exceptionCaught(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.lock.lock();
        try {
            if (this.writeTarget == null) {
                this.closePending = true;
                return;
            }
        }
        finally {
            this.lock.unlock();
        }
        this.writeTarget.closeConnection();
    }

    @Override
    protected void timeoutOccurred() {
        log.info("{}: Timed out", (Object)this.getAddress());
        this.close();
    }

    protected abstract void processMessage(Message var1) throws Exception;

    @Override
    public int receiveBytes(ByteBuffer buff) {
        Preconditions.checkArgument((buff.position() == 0 && buff.capacity() >= 24 ? 1 : 0) != 0);
        try {
            int i = 0;
            while (true) {
                Message message;
                if (this.largeReadBuffer != null) {
                    Preconditions.checkState((i == 0 ? 1 : 0) != 0);
                    int bytesToGet = Math.min(buff.remaining(), this.largeReadBuffer.length - this.largeReadBufferPos);
                    buff.get(this.largeReadBuffer, this.largeReadBufferPos, bytesToGet);
                    this.largeReadBufferPos += bytesToGet;
                    if (this.largeReadBufferPos == this.largeReadBuffer.length) {
                        this.processMessage(this.serializer.deserializePayload(this.header, ByteBuffer.wrap(this.largeReadBuffer)));
                        this.largeReadBuffer = null;
                        this.header = null;
                    } else {
                        return buff.position();
                    }
                }
                int preSerializePosition = buff.position();
                try {
                    message = this.serializer.deserialize(buff);
                }
                catch (BufferUnderflowException e) {
                    if (i == 0 && buff.limit() == buff.capacity()) {
                        buff.position(0);
                        try {
                            this.serializer.seekPastMagicBytes(buff);
                            this.header = this.serializer.deserializeHeader(buff);
                            this.largeReadBuffer = new byte[this.header.size];
                            this.largeReadBufferPos = buff.remaining();
                            buff.get(this.largeReadBuffer, 0, this.largeReadBufferPos);
                        }
                        catch (BufferUnderflowException e1) {
                            throw new ProtocolException("No magic bytes+header after reading " + buff.capacity() + " bytes");
                        }
                    } else {
                        buff.position(preSerializePosition);
                    }
                    return buff.position();
                }
                this.processMessage(message);
                ++i;
            }
        }
        catch (Exception e) {
            this.exceptionCaught(e);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWriteTarget(MessageWriteTarget writeTarget) {
        Preconditions.checkArgument((writeTarget != null ? 1 : 0) != 0);
        this.lock.lock();
        boolean closeNow = false;
        try {
            Preconditions.checkArgument((this.writeTarget == null ? 1 : 0) != 0);
            closeNow = this.closePending;
            this.writeTarget = writeTarget;
        }
        finally {
            this.lock.unlock();
        }
        if (closeNow) {
            writeTarget.closeConnection();
        }
    }

    @Override
    public int getMaxMessageSize() {
        return 0x2000000;
    }

    public PeerAddress getAddress() {
        return this.peerAddress;
    }

    private void exceptionCaught(Exception e) {
        String s;
        PeerAddress addr = this.getAddress();
        String string = s = addr == null ? "?" : addr.toString();
        if (e instanceof ConnectException || e instanceof IOException) {
            log.info(s + " - " + e.getMessage());
        } else {
            log.warn(s + " - ", (Throwable)e);
            Thread.UncaughtExceptionHandler handler = Threading.uncaughtExceptionHandler;
            if (handler != null) {
                handler.uncaughtException(Thread.currentThread(), e);
            }
        }
        this.close();
    }
}

