/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.AbstractBlockChain;
import com.google.bitcoin.core.AddressMessage;
import com.google.bitcoin.core.AlertMessage;
import com.google.bitcoin.core.Block;
import com.google.bitcoin.core.BloomFilter;
import com.google.bitcoin.core.FilteredBlock;
import com.google.bitcoin.core.GetBlocksMessage;
import com.google.bitcoin.core.GetDataMessage;
import com.google.bitcoin.core.GetHeadersMessage;
import com.google.bitcoin.core.HeadersMessage;
import com.google.bitcoin.core.InventoryItem;
import com.google.bitcoin.core.InventoryMessage;
import com.google.bitcoin.core.MemoryPool;
import com.google.bitcoin.core.MemoryPoolMessage;
import com.google.bitcoin.core.Message;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.NotFoundMessage;
import com.google.bitcoin.core.PeerAddress;
import com.google.bitcoin.core.PeerEventListener;
import com.google.bitcoin.core.PeerSocketHandler;
import com.google.bitcoin.core.Ping;
import com.google.bitcoin.core.Pong;
import com.google.bitcoin.core.ProtocolException;
import com.google.bitcoin.core.PrunedException;
import com.google.bitcoin.core.Sha256Hash;
import com.google.bitcoin.core.StoredBlock;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.TransactionConfidence;
import com.google.bitcoin.core.TransactionInput;
import com.google.bitcoin.core.Utils;
import com.google.bitcoin.core.VerificationException;
import com.google.bitcoin.core.VersionAck;
import com.google.bitcoin.core.VersionMessage;
import com.google.bitcoin.core.Wallet;
import com.google.bitcoin.store.BlockStore;
import com.google.bitcoin.store.BlockStoreException;
import com.google.bitcoin.utils.ListenerRegistration;
import com.google.bitcoin.utils.Threading;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import net.jcip.annotations.GuardedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Peer
extends PeerSocketHandler {
    private static final Logger log = LoggerFactory.getLogger(Peer.class);
    protected final ReentrantLock lock = Threading.lock("peer");
    private final NetworkParameters params;
    private final AbstractBlockChain blockChain;
    private final CopyOnWriteArrayList<PeerListenerRegistration> eventListeners;
    private volatile boolean vDownloadData;
    private final VersionMessage versionMessage;
    private final AtomicInteger blocksAnnounced = new AtomicInteger();
    private final MemoryPool memoryPool;
    private final CopyOnWriteArrayList<Wallet> wallets;
    @GuardedBy(value="lock")
    private long fastCatchupTimeSecs;
    @GuardedBy(value="lock")
    private boolean downloadBlockBodies = true;
    @GuardedBy(value="lock")
    private boolean useFilteredBlocks = false;
    private volatile BloomFilter vBloomFilter;
    private FilteredBlock currentFilteredBlock = null;
    private int filteredBlocksReceived;
    private static final int RESEND_BLOOM_FILTER_BLOCK_COUNT = 25000;
    private final HashSet<Sha256Hash> pendingBlockDownloads = new HashSet();
    private volatile int vMinProtocolVersion = 60001;
    private final CopyOnWriteArrayList<GetDataRequest> getDataFutures;
    private final ReentrantLock lastPingTimesLock = new ReentrantLock();
    @GuardedBy(value="lastPingTimesLock")
    private long[] lastPingTimes = null;
    private final CopyOnWriteArrayList<PendingPing> pendingPings;
    private static final int PING_MOVING_AVERAGE_WINDOW = 20;
    private volatile VersionMessage vPeerVersionMessage;
    private boolean isAcked;
    private final SettableFuture<Peer> connectionOpenFuture = SettableFuture.create();
    @GuardedBy(value="lock")
    private Sha256Hash lastGetBlocksBegin;
    @GuardedBy(value="lock")
    private Sha256Hash lastGetBlocksEnd;

    public Peer(NetworkParameters params, VersionMessage ver, @Nullable AbstractBlockChain chain, PeerAddress remoteAddress) {
        this(params, ver, remoteAddress, chain, null);
    }

    public Peer(NetworkParameters params, VersionMessage ver, PeerAddress remoteAddress, @Nullable AbstractBlockChain chain, @Nullable MemoryPool mempool) {
        super(params, remoteAddress);
        this.params = (NetworkParameters)Preconditions.checkNotNull((Object)params);
        this.versionMessage = (VersionMessage)Preconditions.checkNotNull((Object)ver);
        this.blockChain = chain;
        this.vDownloadData = chain != null;
        this.getDataFutures = new CopyOnWriteArrayList();
        this.eventListeners = new CopyOnWriteArrayList();
        this.fastCatchupTimeSecs = params.getGenesisBlock().getTimeSeconds();
        this.isAcked = false;
        this.pendingPings = new CopyOnWriteArrayList();
        this.wallets = new CopyOnWriteArrayList();
        this.memoryPool = mempool;
    }

    public Peer(NetworkParameters params, AbstractBlockChain blockChain, PeerAddress peerAddress, String thisSoftwareName, String thisSoftwareVersion) {
        this(params, new VersionMessage(params, blockChain.getBestChainHeight(), true), blockChain, peerAddress);
        this.versionMessage.appendToSubVer(thisSoftwareName, thisSoftwareVersion, null);
    }

    public void addEventListener(PeerEventListener listener) {
        this.addEventListener(listener, Threading.USER_THREAD);
    }

    public void addEventListener(PeerEventListener listener, Executor executor) {
        this.eventListeners.add(new PeerListenerRegistration(listener, executor));
    }

    void addEventListenerWithoutOnDisconnect(PeerEventListener listener, Executor executor) {
        this.eventListeners.add(new PeerListenerRegistration(listener, executor, false));
    }

    public boolean removeEventListener(PeerEventListener listener) {
        return ListenerRegistration.removeFromList(listener, this.eventListeners);
    }

    public String toString() {
        PeerAddress addr = this.getAddress();
        if (addr == null) {
            return "Peer()";
        }
        return addr.toString();
    }

    @Override
    public void connectionClosed() {
        for (final PeerListenerRegistration registration : this.eventListeners) {
            if (!registration.callOnDisconnect) continue;
            registration.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((PeerEventListener)registration.listener).onPeerDisconnected(Peer.this, 0);
                }
            });
        }
    }

    @Override
    public void connectionOpened() {
        PeerAddress address = this.getAddress();
        log.info("Announcing to {} as: {}", address == null ? "Peer" : address.toSocketAddress(), (Object)this.versionMessage.subVer);
        this.sendMessage(this.versionMessage);
        this.connectionOpenFuture.set((Object)this);
    }

    public ListenableFuture<Peer> getConnectionOpenFuture() {
        return this.connectionOpenFuture;
    }

    @Override
    protected void processMessage(Message m) throws Exception {
        for (final PeerListenerRegistration registration : this.eventListeners) {
            if (registration.executor != Threading.SAME_THREAD || (m = ((PeerEventListener)registration.listener).onPreMessageReceived(this, m)) != null) continue;
            break;
        }
        if (m == null) {
            return;
        }
        if (this.currentFilteredBlock != null && !(m instanceof Transaction)) {
            this.endFilteredBlock(this.currentFilteredBlock);
            this.currentFilteredBlock = null;
        }
        if (m instanceof NotFoundMessage) {
            this.processNotFoundMessage((NotFoundMessage)m);
        } else if (m instanceof InventoryMessage) {
            this.processInv((InventoryMessage)m);
        } else if (m instanceof Block) {
            this.processBlock((Block)m);
        } else if (m instanceof FilteredBlock) {
            this.startFilteredBlock((FilteredBlock)m);
        } else if (m instanceof Transaction) {
            this.processTransaction((Transaction)m);
        } else if (m instanceof GetDataMessage) {
            this.processGetData((GetDataMessage)m);
        } else if (!(m instanceof AddressMessage)) {
            if (m instanceof HeadersMessage) {
                this.processHeaders((HeadersMessage)m);
            } else if (m instanceof AlertMessage) {
                this.processAlert((AlertMessage)m);
            } else if (m instanceof VersionMessage) {
                this.processVersionMessage((VersionMessage)m);
            } else if (m instanceof VersionAck) {
                if (this.vPeerVersionMessage == null) {
                    throw new ProtocolException("got a version ack before version");
                }
                if (this.isAcked) {
                    throw new ProtocolException("got more than one version ack");
                }
                this.isAcked = true;
                this.setTimeoutEnabled(false);
                for (final PeerListenerRegistration registration : this.eventListeners) {
                    registration.executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            ((PeerEventListener)registration.listener).onPeerConnected(Peer.this, 1);
                        }
                    });
                }
                int version = this.vMinProtocolVersion;
                if (this.vPeerVersionMessage.clientVersion < version) {
                    log.warn("Connected to a peer speaking protocol version {} but need {}, closing", (Object)this.vPeerVersionMessage.clientVersion, (Object)version);
                    this.close();
                }
            } else if (m instanceof Ping) {
                if (((Ping)m).hasNonce()) {
                    this.sendMessage(new Pong(((Ping)m).getNonce()));
                }
            } else if (m instanceof Pong) {
                this.processPong((Pong)m);
            } else {
                log.warn("Received unhandled message: {}", (Object)m);
            }
        }
    }

    private void processVersionMessage(VersionMessage m) throws ProtocolException {
        if (this.vPeerVersionMessage != null) {
            throw new ProtocolException("Got two version messages from peer");
        }
        this.vPeerVersionMessage = m;
        int peerVersion = this.vPeerVersionMessage.clientVersion;
        PeerAddress peerAddress = this.getAddress();
        long peerTime = this.vPeerVersionMessage.time * 1000L;
        log.info("Connected to {}: version={}, subVer='{}', services=0x{}, time={}, blocks={}", new Object[]{peerAddress == null ? "Peer" : peerAddress.getAddr().getHostAddress(), peerVersion, this.vPeerVersionMessage.subVer, this.vPeerVersionMessage.localServices, String.format("%tF %tT", peerTime, peerTime), this.vPeerVersionMessage.bestHeight});
        this.sendMessage(new VersionAck());
        if (!this.vPeerVersionMessage.hasBlockChain() || !this.params.allowEmptyPeerChain() && this.vPeerVersionMessage.bestHeight <= 0L) {
            throw new ProtocolException("Peer does not have a copy of the block chain.");
        }
    }

    private void startFilteredBlock(FilteredBlock m) {
        this.currentFilteredBlock = m;
        ++this.filteredBlocksReceived;
        if (this.filteredBlocksReceived % 25000 == 24999) {
            this.sendMessage(this.vBloomFilter);
        }
    }

    private void processNotFoundMessage(NotFoundMessage m) {
        block0: for (GetDataRequest req : this.getDataFutures) {
            for (InventoryItem item : m.getItems()) {
                if (!item.hash.equals(req.hash)) continue;
                log.info("{}: Bottomed out dep tree at {}", (Object)this, (Object)req.hash);
                req.future.cancel(true);
                this.getDataFutures.remove(req);
                continue block0;
            }
        }
    }

    private void processAlert(AlertMessage m) {
        try {
            if (m.isSignatureValid()) {
                log.info("Received alert from peer {}: {}", (Object)this.toString(), (Object)m.getStatusBar());
            } else {
                log.warn("Received alert with invalid signature from peer {}: {}", (Object)this.toString(), (Object)m.getStatusBar());
            }
        }
        catch (Throwable t) {
            log.error("Failed to check signature: bug in platform libraries?", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processHeaders(HeadersMessage m) throws ProtocolException {
        block21: {
            boolean downloadBlockBodies;
            long fastCatchupTimeSecs;
            this.lock.lock();
            try {
                if (this.blockChain == null) {
                    log.warn("Received headers when Peer is not configured with a chain.");
                    return;
                }
                fastCatchupTimeSecs = this.fastCatchupTimeSecs;
                downloadBlockBodies = this.downloadBlockBodies;
            }
            finally {
                this.lock.unlock();
            }
            try {
                Preconditions.checkState((!downloadBlockBodies ? 1 : 0) != 0, (Object)this.toString());
                for (int i = 0; i < m.getBlockHeaders().size(); ++i) {
                    boolean reachedTop;
                    Block header = m.getBlockHeaders().get(i);
                    boolean passedTime = header.getTimeSeconds() >= fastCatchupTimeSecs;
                    boolean bl = reachedTop = (long)this.blockChain.getBestChainHeight() >= this.vPeerVersionMessage.bestHeight;
                    if (!passedTime && !reachedTop) {
                        if (!this.vDownloadData) {
                            log.info("Lost download peer status, throwing away downloaded headers.");
                            return;
                        }
                        if (!this.blockChain.add(header)) {
                            throw new ProtocolException("Got unconnected header from peer: " + header.getHashAsString());
                        }
                    } else {
                        this.lock.lock();
                        try {
                            log.info("Passed the fast catchup time, discarding {} headers and requesting full blocks", (Object)(m.getBlockHeaders().size() - i));
                            this.downloadBlockBodies = true;
                            this.lastGetBlocksBegin = Sha256Hash.ZERO_HASH;
                            this.blockChainDownloadLocked(Sha256Hash.ZERO_HASH);
                        }
                        finally {
                            this.lock.unlock();
                        }
                        return;
                    }
                    this.invokeOnBlocksDownloaded(header);
                }
                if (m.getBlockHeaders().size() < 2000) break block21;
                this.lock.lock();
                try {
                    this.blockChainDownloadLocked(Sha256Hash.ZERO_HASH);
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (VerificationException e) {
                log.warn("Block header verification failed", (Throwable)e);
            }
            catch (PrunedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void processGetData(GetDataMessage getdata) {
        log.info("{}: Received getdata message: {}", (Object)this.getAddress(), (Object)getdata.toString());
        ArrayList<Message> items = new ArrayList<Message>();
        for (PeerListenerRegistration registration : this.eventListeners) {
            List<Message> listenerItems;
            if (registration.executor != Threading.SAME_THREAD || (listenerItems = ((PeerEventListener)registration.listener).getData(this, getdata)) == null) continue;
            items.addAll(listenerItems);
        }
        if (items.size() == 0) {
            return;
        }
        log.info("{}: Sending {} items gathered from listeners to peer", (Object)this.getAddress(), (Object)items.size());
        for (Message item : items) {
            this.sendMessage(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTransaction(Transaction tx) throws VerificationException {
        Transaction fTx;
        tx.verify();
        this.lock.lock();
        try {
            log.debug("{}: Received tx {}", (Object)this.getAddress(), (Object)tx.getHashAsString());
            if (this.memoryPool != null) {
                tx = this.memoryPool.seen(tx, this.getAddress());
            }
            fTx = tx;
            fTx.getConfidence().setSource(TransactionConfidence.Source.NETWORK);
            if (this.maybeHandleRequestedData(fTx)) {
                return;
            }
            if (this.currentFilteredBlock != null) {
                if (!this.currentFilteredBlock.provideTransaction(tx)) {
                    this.endFilteredBlock(this.currentFilteredBlock);
                    this.currentFilteredBlock = null;
                }
                return;
            }
            for (final Wallet wallet : this.wallets) {
                try {
                    if (!wallet.isPendingTransactionRelevant(fTx)) continue;
                    Futures.addCallback(this.downloadDependencies(fTx), (FutureCallback)new FutureCallback<List<Transaction>>(){

                        public void onSuccess(List<Transaction> dependencies) {
                            try {
                                log.info("{}: Dependency download complete!", (Object)Peer.this.getAddress());
                                wallet.receivePending(fTx, dependencies);
                            }
                            catch (VerificationException e) {
                                log.error("{}: Wallet failed to process pending transaction {}", (Object)Peer.this.getAddress(), (Object)fTx.getHashAsString());
                                log.error("Error was: ", (Throwable)e);
                            }
                        }

                        public void onFailure(Throwable throwable) {
                            log.error("Could not download dependencies of tx {}", (Object)fTx.getHashAsString());
                            log.error("Error was: ", throwable);
                        }
                    });
                }
                catch (VerificationException e) {
                    log.error("Wallet failed to verify tx", (Throwable)e);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        for (final PeerListenerRegistration registration : this.eventListeners) {
            registration.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((PeerEventListener)registration.listener).onTransaction(Peer.this, fTx);
                }
            });
        }
    }

    public ListenableFuture<List<Transaction>> downloadDependencies(Transaction tx) {
        Preconditions.checkNotNull((Object)this.memoryPool, (Object)"Must have a configured MemoryPool object to download dependencies.");
        TransactionConfidence.ConfidenceType txConfidence = tx.getConfidence().getConfidenceType();
        Preconditions.checkArgument((txConfidence != TransactionConfidence.ConfidenceType.BUILDING ? 1 : 0) != 0);
        log.info("{}: Downloading dependencies of {}", (Object)this.getAddress(), (Object)tx.getHashAsString());
        final LinkedList<Transaction> results = new LinkedList<Transaction>();
        ListenableFuture<Object> future = this.downloadDependenciesInternal(tx, new Object(), results);
        final SettableFuture resultFuture = SettableFuture.create();
        Futures.addCallback(future, (FutureCallback)new FutureCallback(){

            public void onSuccess(Object ignored) {
                resultFuture.set((Object)results);
            }

            public void onFailure(Throwable throwable) {
                resultFuture.setException(throwable);
            }
        });
        return resultFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListenableFuture<Object> downloadDependenciesInternal(Transaction tx, final Object marker, final List<Transaction> results) {
        Preconditions.checkNotNull((Object)this.memoryPool, (Object)"Must have a configured MemoryPool object to download dependencies.");
        final SettableFuture resultFuture = SettableFuture.create();
        final Sha256Hash rootTxHash = tx.getHash();
        CopyOnWriteArraySet<Transaction> dependencies = new CopyOnWriteArraySet<Transaction>();
        CopyOnWriteArraySet<Sha256Hash> needToRequest = new CopyOnWriteArraySet<Sha256Hash>();
        for (TransactionInput input : tx.getInputs()) {
            Sha256Hash hash = input.getOutpoint().getHash();
            Transaction dep = this.memoryPool.get(hash);
            if (dep == null) {
                needToRequest.add(hash);
                continue;
            }
            dependencies.add(dep);
        }
        results.addAll(dependencies);
        this.lock.lock();
        try {
            ArrayList futures = Lists.newArrayList();
            GetDataMessage getdata = new GetDataMessage(this.params);
            final long nonce = (long)(Math.random() * 9.223372036854776E18);
            if (needToRequest.size() > 1) {
                log.info("{}: Requesting {} transactions for dep resolution", (Object)this.getAddress(), (Object)needToRequest.size());
            }
            for (Sha256Hash hash : needToRequest) {
                getdata.addTransaction(hash);
                GetDataRequest req = new GetDataRequest();
                req.hash = hash;
                req.future = SettableFuture.create();
                if (!this.isNotFoundMessageSupported()) {
                    req.nonce = nonce;
                }
                futures.add(req.future);
                this.getDataFutures.add(req);
            }
            for (Transaction dep : dependencies) {
                futures.add(Futures.immediateFuture((Object)dep));
            }
            ListenableFuture successful = Futures.successfulAsList((Iterable)futures);
            Futures.addCallback((ListenableFuture)successful, (FutureCallback)new FutureCallback<List<Transaction>>(){

                public void onSuccess(List<Transaction> transactions) {
                    LinkedList childFutures = Lists.newLinkedList();
                    for (Transaction tx : transactions) {
                        if (tx == null) continue;
                        log.info("{}: Downloaded dependency of {}: {}", new Object[]{Peer.this.getAddress(), rootTxHash, tx.getHashAsString()});
                        results.add(tx);
                        childFutures.add(Peer.this.downloadDependenciesInternal(tx, marker, results));
                    }
                    if (childFutures.size() == 0) {
                        resultFuture.set(marker);
                    } else {
                        Futures.addCallback((ListenableFuture)Futures.successfulAsList((Iterable)childFutures), (FutureCallback)new FutureCallback<List<Object>>(){

                            public void onSuccess(List<Object> objects) {
                                resultFuture.set(marker);
                            }

                            public void onFailure(Throwable throwable) {
                                resultFuture.setException(throwable);
                            }
                        });
                    }
                }

                public void onFailure(Throwable throwable) {
                    resultFuture.setException(throwable);
                }
            });
            this.sendMessage(getdata);
            if (!this.isNotFoundMessageSupported()) {
                log.info("{}: Dep resolution waiting for a pong with nonce {}", (Object)this, (Object)nonce);
                this.ping(nonce).addListener(new Runnable(){

                    @Override
                    public void run() {
                        for (GetDataRequest req : Peer.this.getDataFutures) {
                            if (req.nonce != nonce) continue;
                            log.info("{}: Bottomed out dep tree at {}", (Object)this, (Object)req.hash);
                            req.future.cancel(true);
                            Peer.this.getDataFutures.remove(req);
                        }
                    }
                }, Threading.SAME_THREAD);
            }
        }
        catch (Exception e) {
            log.error("{}: Couldn't send getdata in downloadDependencies({})", (Object)this, (Object)tx.getHash());
            resultFuture.setException((Throwable)e);
            SettableFuture settableFuture = resultFuture;
            return settableFuture;
        }
        finally {
            this.lock.unlock();
        }
        return resultFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBlock(Block m) {
        block13: {
            if (log.isDebugEnabled()) {
                log.debug("{}: Received broadcast block {}", (Object)this.getAddress(), (Object)m.getHashAsString());
            }
            if (this.maybeHandleRequestedData(m)) {
                return;
            }
            if (this.blockChain == null) {
                log.warn("Received block but was not configured with an AbstractBlockChain");
                return;
            }
            if (!this.vDownloadData) {
                log.debug("{}: Received block we did not ask for: {}", (Object)this.getAddress(), (Object)m.getHashAsString());
                return;
            }
            this.pendingBlockDownloads.remove(m.getHash());
            try {
                if (this.blockChain.add(m)) {
                    this.invokeOnBlocksDownloaded(m);
                    break block13;
                }
                this.lock.lock();
                try {
                    if (this.downloadBlockBodies) {
                        Block orphanRoot = (Block)Preconditions.checkNotNull((Object)this.blockChain.getOrphanRoot(m.getHash()));
                        this.blockChainDownloadLocked(orphanRoot.getHash());
                    } else {
                        log.info("Did not start chain download on solved block due to in-flight header download.");
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (VerificationException e) {
                log.warn("{}: Block verification failed", (Object)this.getAddress(), (Object)e);
            }
            catch (PrunedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endFilteredBlock(FilteredBlock m) {
        block10: {
            if (log.isDebugEnabled()) {
                log.debug("{}: Received broadcast filtered block {}", (Object)this.getAddress(), (Object)m.getHash().toString());
            }
            if (!this.vDownloadData) {
                log.debug("{}: Received block we did not ask for: {}", (Object)this.getAddress(), (Object)m.getHash().toString());
                return;
            }
            if (this.blockChain == null) {
                log.warn("Received filtered block but was not configured with an AbstractBlockChain");
                return;
            }
            this.pendingBlockDownloads.remove(m.getBlockHeader().getHash());
            try {
                if (this.blockChain.add(m)) {
                    this.invokeOnBlocksDownloaded(m.getBlockHeader());
                    break block10;
                }
                this.lock.lock();
                try {
                    Block orphanRoot = (Block)Preconditions.checkNotNull((Object)this.blockChain.getOrphanRoot(m.getHash()));
                    this.blockChainDownloadLocked(orphanRoot.getHash());
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (VerificationException e) {
                log.warn("{}: FilteredBlock verification failed", (Object)this.getAddress(), (Object)e);
            }
            catch (PrunedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private boolean maybeHandleRequestedData(Message m) {
        boolean found = false;
        Sha256Hash hash = m.getHash();
        for (GetDataRequest req : this.getDataFutures) {
            if (!hash.equals(req.hash)) continue;
            req.future.set((Object)m);
            this.getDataFutures.remove(req);
            found = true;
        }
        return found;
    }

    private void invokeOnBlocksDownloaded(final Block m) {
        final int blocksLeft = Math.max(0, (int)this.vPeerVersionMessage.bestHeight - ((AbstractBlockChain)Preconditions.checkNotNull((Object)this.blockChain)).getBestChainHeight());
        for (final PeerListenerRegistration registration : this.eventListeners) {
            registration.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((PeerEventListener)registration.listener).onBlocksDownloaded(Peer.this, m, blocksLeft);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInv(InventoryMessage inv) {
        List<InventoryItem> items = inv.getItems();
        LinkedList<InventoryItem> transactions = new LinkedList<InventoryItem>();
        LinkedList<InventoryItem> blocks = new LinkedList<InventoryItem>();
        block7: for (InventoryItem item : items) {
            switch (item.type) {
                case Transaction: {
                    transactions.add(item);
                    continue block7;
                }
                case Block: {
                    blocks.add(item);
                    continue block7;
                }
            }
            throw new IllegalStateException("Not implemented: " + (Object)((Object)item.type));
        }
        boolean downloadData = this.vDownloadData;
        if (transactions.size() == 0 && blocks.size() == 1) {
            if (downloadData && this.blockChain != null) {
                if (!this.blockChain.isOrphan(((InventoryItem)blocks.get((int)0)).hash)) {
                    this.blocksAnnounced.incrementAndGet();
                }
            } else {
                this.blocksAnnounced.incrementAndGet();
            }
        }
        GetDataMessage getdata = new GetDataMessage(this.params);
        Iterator it = transactions.iterator();
        while (it.hasNext()) {
            InventoryItem item = (InventoryItem)it.next();
            if (this.memoryPool == null) {
                if (!downloadData) continue;
                getdata.addItem(item);
                continue;
            }
            if (this.memoryPool.maybeWasSeen(item.hash)) {
                it.remove();
            } else {
                log.debug("{}: getdata on tx {}", (Object)this.getAddress(), (Object)item.hash);
                getdata.addItem(item);
            }
            this.memoryPool.seen(item.hash, this.getAddress());
        }
        boolean pingAfterGetData = false;
        this.lock.lock();
        try {
            if (blocks.size() > 0 && downloadData && this.blockChain != null) {
                for (InventoryItem item : blocks) {
                    if (this.blockChain.isOrphan(item.hash) && this.downloadBlockBodies) {
                        Block orphanRoot = (Block)Preconditions.checkNotNull((Object)this.blockChain.getOrphanRoot(item.hash));
                        this.blockChainDownloadLocked(orphanRoot.getHash());
                        continue;
                    }
                    if (this.pendingBlockDownloads.contains(item.hash)) continue;
                    if (this.vPeerVersionMessage.isBloomFilteringSupported() && this.useFilteredBlocks) {
                        getdata.addItem(new InventoryItem(InventoryItem.Type.FilteredBlock, item.hash));
                        pingAfterGetData = true;
                    } else {
                        getdata.addItem(item);
                    }
                    this.pendingBlockDownloads.add(item.hash);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        if (!getdata.getItems().isEmpty()) {
            this.sendMessage(getdata);
        }
        if (pingAfterGetData) {
            this.sendMessage(new Ping((long)(Math.random() * 9.223372036854776E18)));
        }
    }

    public ListenableFuture<Block> getBlock(Sha256Hash blockHash) {
        log.info("Request to fetch block {}", (Object)blockHash);
        GetDataMessage getdata = new GetDataMessage(this.params);
        getdata.addBlock(blockHash);
        return this.sendSingleGetData(getdata);
    }

    public ListenableFuture<Transaction> getPeerMempoolTransaction(Sha256Hash hash) {
        log.info("Request to fetch peer mempool tx  {}", (Object)hash);
        GetDataMessage getdata = new GetDataMessage(this.params);
        getdata.addTransaction(hash);
        return this.sendSingleGetData(getdata);
    }

    private ListenableFuture sendSingleGetData(GetDataMessage getdata) {
        Preconditions.checkArgument((getdata.getItems().size() == 1 ? 1 : 0) != 0);
        GetDataRequest req = new GetDataRequest();
        req.future = SettableFuture.create();
        req.hash = getdata.getItems().get((int)0).hash;
        this.getDataFutures.add(req);
        this.sendMessage(getdata);
        return req.future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDownloadParameters(long secondsSinceEpoch, boolean useFilteredBlocks) {
        this.lock.lock();
        try {
            Preconditions.checkNotNull((Object)this.blockChain);
            if (secondsSinceEpoch == 0L) {
                this.fastCatchupTimeSecs = this.params.getGenesisBlock().getTimeSeconds();
                this.downloadBlockBodies = true;
            } else {
                this.fastCatchupTimeSecs = secondsSinceEpoch;
                if (this.fastCatchupTimeSecs > this.blockChain.getChainHead().getHeader().getTimeSeconds()) {
                    this.downloadBlockBodies = false;
                }
            }
            this.useFilteredBlocks = useFilteredBlocks;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addWallet(Wallet wallet) {
        this.wallets.add(wallet);
    }

    public void removeWallet(Wallet wallet) {
        this.wallets.remove(wallet);
    }

    @GuardedBy(value="lock")
    private void blockChainDownloadLocked(Sha256Hash toHash) {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        ArrayList<Sha256Hash> blockLocator = new ArrayList<Sha256Hash>(51);
        BlockStore store = ((AbstractBlockChain)Preconditions.checkNotNull((Object)this.blockChain)).getBlockStore();
        StoredBlock chainHead = this.blockChain.getChainHead();
        Sha256Hash chainHeadHash = chainHead.getHeader().getHash();
        if (Objects.equal((Object)this.lastGetBlocksBegin, (Object)chainHeadHash) && Objects.equal((Object)this.lastGetBlocksEnd, (Object)toHash)) {
            log.info("blockChainDownloadLocked({}): ignoring duplicated request", (Object)toHash.toString());
            return;
        }
        log.debug("{}: blockChainDownloadLocked({}) current head = {}", new Object[]{this.toString(), toHash.toString(), chainHead.getHeader().getHashAsString()});
        StoredBlock cursor = chainHead;
        for (int i = 100; cursor != null && i > 0; cursor = cursor.getPrev(store), --i) {
            blockLocator.add(cursor.getHeader().getHash());
            try {
                continue;
            }
            catch (BlockStoreException e) {
                log.error("Failed to walk the block chain whilst constructing a locator");
                throw new RuntimeException(e);
            }
        }
        if (cursor != null) {
            blockLocator.add(this.params.getGenesisBlock().getHash());
        }
        this.lastGetBlocksBegin = chainHeadHash;
        this.lastGetBlocksEnd = toHash;
        if (this.downloadBlockBodies) {
            GetBlocksMessage message = new GetBlocksMessage(this.params, blockLocator, toHash);
            this.sendMessage(message);
        } else {
            GetHeadersMessage message = new GetHeadersMessage(this.params, blockLocator, toHash);
            this.sendMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBlockChainDownload() {
        this.setDownloadData(true);
        final int blocksLeft = this.getPeerBlockHeightDifference();
        if (blocksLeft >= 0) {
            for (final PeerListenerRegistration registration : this.eventListeners) {
                registration.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        ((PeerEventListener)registration.listener).onChainDownloadStarted(Peer.this, blocksLeft);
                    }
                });
            }
            this.lock.lock();
            try {
                this.blockChainDownloadLocked(Sha256Hash.ZERO_HASH);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPingTimeData(long sample) {
        this.lastPingTimesLock.lock();
        try {
            if (this.lastPingTimes == null) {
                this.lastPingTimes = new long[20];
                Arrays.fill(this.lastPingTimes, sample);
            } else {
                System.arraycopy(this.lastPingTimes, 1, this.lastPingTimes, 0, this.lastPingTimes.length - 1);
                this.lastPingTimes[this.lastPingTimes.length - 1] = sample;
            }
        }
        finally {
            this.lastPingTimesLock.unlock();
        }
    }

    public ListenableFuture<Long> ping() throws ProtocolException {
        return this.ping((long)(Math.random() * 9.223372036854776E18));
    }

    protected ListenableFuture<Long> ping(long nonce) throws ProtocolException {
        VersionMessage ver = this.vPeerVersionMessage;
        if (!ver.isPingPongSupported()) {
            throw new ProtocolException("Peer version is too low for measurable pings: " + ver);
        }
        PendingPing pendingPing = new PendingPing(nonce);
        this.pendingPings.add(pendingPing);
        this.sendMessage(new Ping(pendingPing.nonce));
        return pendingPing.future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastPingTime() {
        this.lastPingTimesLock.lock();
        try {
            if (this.lastPingTimes == null) {
                long l = Long.MAX_VALUE;
                return l;
            }
            long l = this.lastPingTimes[this.lastPingTimes.length - 1];
            return l;
        }
        finally {
            this.lastPingTimesLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getPingTime() {
        this.lastPingTimesLock.lock();
        try {
            if (this.lastPingTimes == null) {
                long l = Long.MAX_VALUE;
                return l;
            }
            long sum = 0L;
            for (long i : this.lastPingTimes) {
                sum += i;
            }
            long l = (long)((double)sum / (double)this.lastPingTimes.length);
            return l;
        }
        finally {
            this.lastPingTimesLock.unlock();
        }
    }

    private void processPong(Pong m) {
        for (PendingPing ping : this.pendingPings) {
            if (m.getNonce() != ping.nonce) continue;
            this.pendingPings.remove(ping);
            ping.complete();
            return;
        }
    }

    public int getPeerBlockHeightDifference() {
        Preconditions.checkNotNull((Object)this.blockChain, (Object)"No block chain configured");
        int chainHeight = (int)this.getBestHeight();
        Preconditions.checkState((this.params.allowEmptyPeerChain() || chainHeight > 0 ? 1 : 0) != 0, (String)"Connected to peer with zero/negative chain height", (Object[])new Object[]{chainHeight});
        return chainHeight - this.blockChain.getBestChainHeight();
    }

    private boolean isNotFoundMessageSupported() {
        return this.vPeerVersionMessage.clientVersion >= NotFoundMessage.MIN_PROTOCOL_VERSION;
    }

    public boolean getDownloadData() {
        return this.vDownloadData;
    }

    public void setDownloadData(boolean downloadData) {
        this.vDownloadData = downloadData;
    }

    public VersionMessage getPeerVersionMessage() {
        return this.vPeerVersionMessage;
    }

    public VersionMessage getVersionMessage() {
        return this.versionMessage;
    }

    public long getBestHeight() {
        return this.vPeerVersionMessage.bestHeight + (long)this.blocksAnnounced.get();
    }

    public boolean setMinProtocolVersion(int minProtocolVersion) {
        this.vMinProtocolVersion = minProtocolVersion;
        if (this.getVersionMessage().clientVersion < minProtocolVersion) {
            log.warn("{}: Disconnecting due to new min protocol version {}", (Object)this, (Object)minProtocolVersion);
            this.close();
            return true;
        }
        return false;
    }

    public void setBloomFilter(BloomFilter filter) {
        Preconditions.checkNotNull((Object)filter, (Object)"Clearing filters is not currently supported");
        VersionMessage ver = this.vPeerVersionMessage;
        if (ver == null || !ver.isBloomFilteringSupported()) {
            return;
        }
        this.vBloomFilter = filter;
        boolean shouldQueryMemPool = this.memoryPool != null || this.vDownloadData;
        log.info("{}: Sending Bloom filter{}", (Object)this, (Object)(shouldQueryMemPool ? " and querying mempool" : ""));
        this.sendMessage(filter);
        this.sendMessage(new MemoryPoolMessage());
    }

    public BloomFilter getBloomFilter() {
        return this.vBloomFilter;
    }

    private class PendingPing {
        public SettableFuture<Long> future = SettableFuture.create();
        public final long nonce;
        public final long startTimeMsec;

        public PendingPing(long nonce) {
            this.nonce = nonce;
            this.startTimeMsec = Utils.currentTimeMillis();
        }

        public void complete() {
            Preconditions.checkNotNull(this.future, (Object)"Already completed");
            Long elapsed = Utils.currentTimeMillis() - this.startTimeMsec;
            Peer.this.addPingTimeData(elapsed);
            log.debug("{}: ping time is {} msec", (Object)Peer.this.toString(), (Object)elapsed);
            this.future.set((Object)elapsed);
            this.future = null;
        }
    }

    private static class GetDataRequest {
        Sha256Hash hash;
        SettableFuture future;
        long nonce;

        private GetDataRequest() {
        }
    }

    static class PeerListenerRegistration
    extends ListenerRegistration<PeerEventListener> {
        boolean callOnDisconnect = true;

        public PeerListenerRegistration(PeerEventListener listener, Executor executor) {
            super(listener, executor);
        }

        public PeerListenerRegistration(PeerEventListener listener, Executor executor, boolean callOnDisconnect) {
            this(listener, executor);
            this.callOnDisconnect = callOnDisconnect;
        }
    }
}

