/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.Message;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.ProtocolException;
import com.google.bitcoin.core.Sha256Hash;
import com.google.bitcoin.core.Utils;
import com.google.bitcoin.core.VarInt;
import com.google.bitcoin.core.VerificationException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class PartialMerkleTree
extends Message {
    int transactionCount;
    byte[] matchedChildBits;
    List<Sha256Hash> hashes;

    public PartialMerkleTree(NetworkParameters params, byte[] payloadBytes, int offset) throws ProtocolException {
        super(params, payloadBytes, offset);
    }

    @Override
    public void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        Utils.uint32ToByteStreamLE(this.transactionCount, stream);
        stream.write(new VarInt(this.hashes.size()).encode());
        for (Sha256Hash hash : this.hashes) {
            stream.write(Utils.reverseBytes(hash.getBytes()));
        }
        stream.write(new VarInt(this.matchedChildBits.length).encode());
        stream.write(this.matchedChildBits);
    }

    @Override
    void parse() throws ProtocolException {
        this.transactionCount = (int)this.readUint32();
        int nHashes = (int)this.readVarInt();
        this.hashes = new ArrayList<Sha256Hash>(nHashes);
        for (int i = 0; i < nHashes; ++i) {
            this.hashes.add(this.readHash());
        }
        int nFlagBytes = (int)this.readVarInt();
        this.matchedChildBits = this.readBytes(nFlagBytes);
        this.length = this.cursor - this.offset;
    }

    @Override
    protected void parseLite() {
    }

    private int getTreeWidth(int height) {
        return this.transactionCount + (1 << height) - 1 >> height;
    }

    private Sha256Hash recursiveExtractHashes(int height, int pos, ValuesUsed used, List<Sha256Hash> matchedHashes) throws VerificationException {
        if (used.bitsUsed >= this.matchedChildBits.length * 8) {
            throw new VerificationException("CPartialMerkleTree overflowed its bits array");
        }
        boolean parentOfMatch = Utils.checkBitLE(this.matchedChildBits, used.bitsUsed++);
        if (height == 0 || !parentOfMatch) {
            if (used.hashesUsed >= this.hashes.size()) {
                throw new VerificationException("CPartialMerkleTree overflowed its hash array");
            }
            if (height == 0 && parentOfMatch) {
                matchedHashes.add(this.hashes.get(used.hashesUsed));
            }
            return this.hashes.get(used.hashesUsed++);
        }
        byte[] left = this.recursiveExtractHashes(height - 1, pos * 2, used, matchedHashes).getBytes();
        byte[] right = pos * 2 + 1 < this.getTreeWidth(height - 1) ? this.recursiveExtractHashes(height - 1, pos * 2 + 1, used, matchedHashes).getBytes() : left;
        return new Sha256Hash(Utils.reverseBytes(Utils.doubleDigestTwoBuffers(Utils.reverseBytes(left), 0, 32, Utils.reverseBytes(right), 0, 32)));
    }

    public Sha256Hash getTxnHashAndMerkleRoot(List<Sha256Hash> matchedHashes) throws VerificationException {
        matchedHashes.clear();
        if (this.transactionCount == 0) {
            throw new VerificationException("Got a CPartialMerkleTree with 0 transactions");
        }
        if (this.transactionCount > 16666) {
            throw new VerificationException("Got a CPartialMerkleTree with more transactions than is possible");
        }
        if (this.hashes.size() > this.transactionCount) {
            throw new VerificationException("Got a CPartialMerkleTree with more hashes than transactions");
        }
        if (this.matchedChildBits.length * 8 < this.hashes.size()) {
            throw new VerificationException("Got a CPartialMerkleTree with fewer matched bits than hashes");
        }
        int height = 0;
        while (this.getTreeWidth(height) > 1) {
            ++height;
        }
        ValuesUsed used = new ValuesUsed();
        Sha256Hash merkleRoot = this.recursiveExtractHashes(height, 0, used, matchedHashes);
        if ((used.bitsUsed + 7) / 8 != this.matchedChildBits.length || used.hashesUsed != this.hashes.size()) {
            throw new VerificationException("Got a CPartialMerkleTree that didn't need all the data it provided");
        }
        return merkleRoot;
    }

    private static class ValuesUsed {
        public int bitsUsed = 0;
        public int hashesUsed = 0;

        private ValuesUsed() {
        }
    }
}

