/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.Block;
import com.google.bitcoin.core.Sha256Hash;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.TransactionInput;
import com.google.bitcoin.core.TransactionOutput;
import com.google.bitcoin.core.Utils;
import com.google.bitcoin.params.MainNetParams;
import com.google.bitcoin.params.RegTestParams;
import com.google.bitcoin.params.TestNet2Params;
import com.google.bitcoin.params.TestNet3Params;
import com.google.bitcoin.params.UnitTestParams;
import com.google.bitcoin.script.Script;
import com.google.common.base.Objects;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.spongycastle.util.encoders.Hex;

public abstract class NetworkParameters
implements Serializable {
    public static final int PROTOCOL_VERSION = 70001;
    public static final byte[] SATOSHI_KEY = Hex.decode((String)"04fc9702847840aaf195de8442ebecedf5b095cdbb9bc716bda9110971b28a49e0ead8564ff0db22209e0374782c093bb899692d524e9d6a6956e7c5ecbcd68284");
    public static final String ID_MAINNET = "org.bitcoin.production";
    public static final String ID_TESTNET = "org.bitcoin.test";
    public static final String ID_UNITTESTNET = "com.google.bitcoin.unittest";
    public static final String PAYMENT_PROTOCOL_ID_MAINNET = "main";
    public static final String PAYMENT_PROTOCOL_ID_TESTNET = "test";
    protected Block genesisBlock;
    protected BigInteger proofOfWorkLimit;
    protected int port;
    protected long packetMagic;
    protected int addressHeader;
    protected int p2shHeader;
    protected int dumpedPrivateKeyHeader;
    protected int interval;
    protected int targetTimespan;
    protected byte[] alertSigningKey;
    protected String id;
    protected int spendableCoinbaseDepth;
    protected int subsidyDecreaseBlockCount;
    protected int[] acceptableAddressCodes;
    protected String[] dnsSeeds;
    protected Map<Integer, Sha256Hash> checkpoints = new HashMap<Integer, Sha256Hash>();
    public static final int TARGET_TIMESPAN = 1209600;
    public static final int TARGET_SPACING = 600;
    public static final int INTERVAL = 2016;
    public static final int BIP16_ENFORCE_TIME = 1333238400;
    public static final BigInteger MAX_MONEY = new BigInteger("21000000", 10).multiply(Utils.COIN);

    protected NetworkParameters() {
        this.alertSigningKey = SATOSHI_KEY;
        this.genesisBlock = NetworkParameters.createGenesis(this);
    }

    private static Block createGenesis(NetworkParameters n) {
        Block genesisBlock = new Block(n);
        Transaction t = new Transaction(n);
        try {
            byte[] bytes = Hex.decode((String)"04ffff001d0104455468652054696d65732030332f4a616e2f32303039204368616e63656c6c6f72206f6e206272696e6b206f66207365636f6e64206261696c6f757420666f722062616e6b73");
            t.addInput(new TransactionInput(n, t, bytes));
            ByteArrayOutputStream scriptPubKeyBytes = new ByteArrayOutputStream();
            Script.writeBytes(scriptPubKeyBytes, Hex.decode((String)"04678afdb0fe5548271967f1a67130b7105cd6a828e03909a67962e0ea1f61deb649f6bc3f4cef38c4f35504e51ec112de5c384df7ba0b8d578a4c702b6bf11d5f"));
            scriptPubKeyBytes.write(172);
            t.addOutput(new TransactionOutput(n, t, Utils.toNanoCoins(50, 0), scriptPubKeyBytes.toByteArray()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        genesisBlock.addTransaction(t);
        return genesisBlock;
    }

    @Deprecated
    public static NetworkParameters testNet() {
        return TestNet3Params.get();
    }

    @Deprecated
    public static NetworkParameters testNet2() {
        return TestNet2Params.get();
    }

    @Deprecated
    public static NetworkParameters testNet3() {
        return TestNet3Params.get();
    }

    @Deprecated
    public static NetworkParameters prodNet() {
        return MainNetParams.get();
    }

    @Deprecated
    public static NetworkParameters unitTests() {
        return UnitTestParams.get();
    }

    @Deprecated
    public static NetworkParameters regTests() {
        return RegTestParams.get();
    }

    public String getId() {
        return this.id;
    }

    public abstract String getPaymentProtocolId();

    public boolean equals(Object other) {
        if (!(other instanceof NetworkParameters)) {
            return false;
        }
        NetworkParameters o = (NetworkParameters)other;
        return o.getId().equals(this.getId());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getId()});
    }

    @Nullable
    public static NetworkParameters fromID(String id) {
        if (id.equals(ID_MAINNET)) {
            return MainNetParams.get();
        }
        if (id.equals(ID_TESTNET)) {
            return TestNet3Params.get();
        }
        if (id.equals(ID_UNITTESTNET)) {
            return UnitTestParams.get();
        }
        return null;
    }

    @Nullable
    public static NetworkParameters fromPmtProtocolID(String pmtProtocolId) {
        if (pmtProtocolId.equals(PAYMENT_PROTOCOL_ID_MAINNET)) {
            return MainNetParams.get();
        }
        if (pmtProtocolId.equals(PAYMENT_PROTOCOL_ID_TESTNET)) {
            return TestNet3Params.get();
        }
        return null;
    }

    public int getSpendableCoinbaseDepth() {
        return this.spendableCoinbaseDepth;
    }

    public boolean passesCheckpoint(int height, Sha256Hash hash) {
        Sha256Hash checkpointHash = this.checkpoints.get(height);
        return checkpointHash == null || checkpointHash.equals(hash);
    }

    public boolean isCheckpoint(int height) {
        Sha256Hash checkpointHash = this.checkpoints.get(height);
        return checkpointHash != null;
    }

    public int getSubsidyDecreaseBlockCount() {
        return this.subsidyDecreaseBlockCount;
    }

    public String[] getDnsSeeds() {
        return this.dnsSeeds;
    }

    public Block getGenesisBlock() {
        return this.genesisBlock;
    }

    public int getPort() {
        return this.port;
    }

    public long getPacketMagic() {
        return this.packetMagic;
    }

    public int getAddressHeader() {
        return this.addressHeader;
    }

    public int getP2SHHeader() {
        return this.p2shHeader;
    }

    public int getDumpedPrivateKeyHeader() {
        return this.dumpedPrivateKeyHeader;
    }

    public int getTargetTimespan() {
        return this.targetTimespan;
    }

    public int[] getAcceptableAddressCodes() {
        return this.acceptableAddressCodes;
    }

    public boolean allowEmptyPeerChain() {
        return true;
    }

    public int getInterval() {
        return this.interval;
    }

    public BigInteger getProofOfWorkLimit() {
        return this.proofOfWorkLimit;
    }

    public byte[] getAlertSigningKey() {
        return this.alertSigningKey;
    }
}

