/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.Block;
import com.google.bitcoin.core.InventoryItem;
import com.google.bitcoin.core.ListMessage;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.ProtocolException;
import com.google.bitcoin.core.Transaction;
import com.google.common.base.Preconditions;

public class InventoryMessage
extends ListMessage {
    private static final long serialVersionUID = -7050246551646107066L;

    public InventoryMessage(NetworkParameters params, byte[] bytes) throws ProtocolException {
        super(params, bytes);
    }

    public InventoryMessage(NetworkParameters params, byte[] msg, boolean parseLazy, boolean parseRetain, int length) throws ProtocolException {
        super(params, msg, parseLazy, parseRetain, length);
    }

    public InventoryMessage(NetworkParameters params) {
        super(params);
    }

    public void addBlock(Block block) {
        this.addItem(new InventoryItem(InventoryItem.Type.Block, block.getHash()));
    }

    public void addTransaction(Transaction tx) {
        this.addItem(new InventoryItem(InventoryItem.Type.Transaction, tx.getHash()));
    }

    public static InventoryMessage with(Transaction ... txns) {
        Preconditions.checkArgument((txns.length > 0 ? 1 : 0) != 0);
        InventoryMessage result = new InventoryMessage(txns[0].getParams());
        for (Transaction tx : txns) {
            result.addTransaction(tx);
        }
        return result;
    }
}

