/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.AbstractBlockChain;
import com.google.bitcoin.core.Block;
import com.google.bitcoin.core.BlockChainListener;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.PrunedException;
import com.google.bitcoin.core.Sha256Hash;
import com.google.bitcoin.core.StoredBlock;
import com.google.bitcoin.core.StoredTransactionOutput;
import com.google.bitcoin.core.StoredUndoableBlock;
import com.google.bitcoin.core.Transaction;
import com.google.bitcoin.core.TransactionInput;
import com.google.bitcoin.core.TransactionOutput;
import com.google.bitcoin.core.TransactionOutputChanges;
import com.google.bitcoin.core.VerificationException;
import com.google.bitcoin.core.Wallet;
import com.google.bitcoin.script.Script;
import com.google.bitcoin.store.BlockStoreException;
import com.google.bitcoin.store.FullPrunedBlockStore;
import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullPrunedBlockChain
extends AbstractBlockChain {
    private static final Logger log = LoggerFactory.getLogger(FullPrunedBlockChain.class);
    protected final FullPrunedBlockStore blockStore;
    private boolean runScripts = true;
    ExecutorService scriptVerificationExecutor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());

    public FullPrunedBlockChain(NetworkParameters params, Wallet wallet, FullPrunedBlockStore blockStore) throws BlockStoreException {
        this(params, new ArrayList<BlockChainListener>(), blockStore);
        if (wallet != null) {
            this.addWallet(wallet);
        }
    }

    public FullPrunedBlockChain(NetworkParameters params, FullPrunedBlockStore blockStore) throws BlockStoreException {
        this(params, new ArrayList<BlockChainListener>(), blockStore);
    }

    public FullPrunedBlockChain(NetworkParameters params, List<BlockChainListener> listeners, FullPrunedBlockStore blockStore) throws BlockStoreException {
        super(params, listeners, blockStore);
        this.blockStore = blockStore;
        this.chainHead = blockStore.getVerifiedChainHead();
    }

    @Override
    protected StoredBlock addToBlockStore(StoredBlock storedPrev, Block header, TransactionOutputChanges txOutChanges) throws BlockStoreException, VerificationException {
        StoredBlock newBlock = storedPrev.build(header);
        this.blockStore.put(newBlock, new StoredUndoableBlock(newBlock.getHeader().getHash(), txOutChanges));
        return newBlock;
    }

    @Override
    protected StoredBlock addToBlockStore(StoredBlock storedPrev, Block block) throws BlockStoreException, VerificationException {
        StoredBlock newBlock = storedPrev.build(block);
        this.blockStore.put(newBlock, new StoredUndoableBlock(newBlock.getHeader().getHash(), block.transactions));
        return newBlock;
    }

    @Override
    protected boolean shouldVerifyTransactions() {
        return true;
    }

    public void setRunScripts(boolean value) {
        this.runScripts = value;
    }

    @Override
    protected TransactionOutputChanges connectTransactions(int height, Block block) throws VerificationException, BlockStoreException {
        boolean enforcePayToScriptHash;
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        if (block.transactions == null) {
            throw new RuntimeException("connectTransactions called with Block that didn't have transactions!");
        }
        if (!this.params.passesCheckpoint(height, block.getHash())) {
            throw new VerificationException("Block failed checkpoint lockin at " + height);
        }
        this.blockStore.beginDatabaseBatchWrite();
        LinkedList<StoredTransactionOutput> txOutsSpent = new LinkedList<StoredTransactionOutput>();
        LinkedList<StoredTransactionOutput> txOutsCreated = new LinkedList<StoredTransactionOutput>();
        long sigOps = 0L;
        boolean bl = enforcePayToScriptHash = block.getTimeSeconds() >= 1333238400L;
        if (this.scriptVerificationExecutor.isShutdown()) {
            this.scriptVerificationExecutor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        }
        ArrayList<FutureTask<VerificationException>> listScriptVerificationResults = new ArrayList<FutureTask<VerificationException>>(block.transactions.size());
        try {
            if (!this.params.isCheckpoint(height)) {
                for (Transaction tx : block.transactions) {
                    Sha256Hash hash = tx.getHash();
                    if (this.blockStore.hasUnspentOutputs(hash, tx.getOutputs().size())) {
                        throw new VerificationException("Block failed BIP30 test!");
                    }
                    if (!enforcePayToScriptHash) continue;
                    sigOps += (long)tx.getSigOpCount();
                }
            }
            BigInteger totalFees = BigInteger.ZERO;
            BigInteger coinbaseValue = null;
            for (Transaction transaction : block.transactions) {
                LinkedList<Script> prevOutScripts;
                boolean isCoinBase;
                block32: {
                    BigInteger valueOut;
                    BigInteger valueIn;
                    block34: {
                        block33: {
                            block31: {
                                block30: {
                                    block29: {
                                        isCoinBase = transaction.isCoinBase();
                                        valueIn = BigInteger.ZERO;
                                        valueOut = BigInteger.ZERO;
                                        prevOutScripts = new LinkedList<Script>();
                                        if (!isCoinBase) {
                                            for (int index = 0; index < transaction.getInputs().size(); ++index) {
                                                TransactionInput in = transaction.getInputs().get(index);
                                                StoredTransactionOutput prevOut = this.blockStore.getTransactionOutput(in.getOutpoint().getHash(), in.getOutpoint().getIndex());
                                                if (prevOut == null) {
                                                    throw new VerificationException("Attempted to spend a non-existent or already spent output!");
                                                }
                                                if (height - prevOut.getHeight() < this.params.getSpendableCoinbaseDepth()) {
                                                    throw new VerificationException("Tried to spend coinbase at depth " + (height - prevOut.getHeight()));
                                                }
                                                valueIn = valueIn.add(prevOut.getValue());
                                                if (enforcePayToScriptHash) {
                                                    if (new Script(prevOut.getScriptBytes()).isPayToScriptHash()) {
                                                        sigOps += Script.getP2SHSigOpCount(in.getScriptBytes());
                                                    }
                                                    if (sigOps > 20000L) {
                                                        throw new VerificationException("Too many P2SH SigOps in block");
                                                    }
                                                }
                                                prevOutScripts.add(new Script(prevOut.getScriptBytes()));
                                                this.blockStore.removeUnspentTransactionOutput(prevOut);
                                                txOutsSpent.add(prevOut);
                                            }
                                        }
                                        Sha256Hash hash = transaction.getHash();
                                        for (TransactionOutput out : transaction.getOutputs()) {
                                            valueOut = valueOut.add(out.getValue());
                                            StoredTransactionOutput newOut = new StoredTransactionOutput(hash, out.getIndex(), out.getValue(), height, isCoinBase, out.getScriptBytes());
                                            this.blockStore.addUnspentTransactionOutput(newOut);
                                            txOutsCreated.add(newOut);
                                        }
                                        if (valueOut.compareTo(BigInteger.ZERO) < 0) break block29;
                                        if (valueOut.compareTo(NetworkParameters.MAX_MONEY) <= 0) break block30;
                                    }
                                    throw new VerificationException("Transaction output value out of rage");
                                }
                                if (!isCoinBase) break block31;
                                coinbaseValue = valueOut;
                                break block32;
                            }
                            if (valueIn.compareTo(valueOut) < 0) break block33;
                            if (valueIn.compareTo(NetworkParameters.MAX_MONEY) <= 0) break block34;
                        }
                        throw new VerificationException("Transaction input value out of range");
                    }
                    totalFees = totalFees.add(valueIn.subtract(valueOut));
                }
                if (isCoinBase || !this.runScripts) continue;
                FutureTask<VerificationException> future = new FutureTask<VerificationException>(new Verifier(transaction, prevOutScripts, enforcePayToScriptHash));
                this.scriptVerificationExecutor.execute(future);
                listScriptVerificationResults.add(future);
            }
            if (totalFees.compareTo(NetworkParameters.MAX_MONEY) > 0 || block.getBlockInflation(height).add(totalFees).compareTo(coinbaseValue) < 0) {
                throw new VerificationException("Transaction fees out of range");
            }
            for (Future future : listScriptVerificationResults) {
                VerificationException e;
                try {
                    e = (VerificationException)future.get();
                }
                catch (InterruptedException thrownE) {
                    throw new RuntimeException(thrownE);
                }
                catch (ExecutionException thrownE) {
                    log.error("Script.correctlySpends threw a non-normal exception: " + thrownE.getCause());
                    throw new VerificationException("Bug in Script.correctlySpends, likely script malformed in some new and interesting way.", thrownE);
                }
                if (e == null) continue;
                throw e;
            }
        }
        catch (VerificationException e) {
            this.scriptVerificationExecutor.shutdownNow();
            this.blockStore.abortDatabaseBatchWrite();
            throw e;
        }
        catch (BlockStoreException e) {
            this.scriptVerificationExecutor.shutdownNow();
            this.blockStore.abortDatabaseBatchWrite();
            throw e;
        }
        return new TransactionOutputChanges(txOutsCreated, txOutsSpent);
    }

    @Override
    protected synchronized TransactionOutputChanges connectTransactions(StoredBlock newBlock) throws VerificationException, BlockStoreException, PrunedException {
        TransactionOutputChanges txOutChanges;
        block32: {
            Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
            if (!this.params.passesCheckpoint(newBlock.getHeight(), newBlock.getHeader().getHash())) {
                throw new VerificationException("Block failed checkpoint lockin at " + newBlock.getHeight());
            }
            this.blockStore.beginDatabaseBatchWrite();
            StoredUndoableBlock block = this.blockStore.getUndoBlock(newBlock.getHeader().getHash());
            if (block == null) {
                this.blockStore.abortDatabaseBatchWrite();
                throw new PrunedException(newBlock.getHeader().getHash());
            }
            try {
                block33: {
                    boolean enforcePayToScriptHash;
                    List<Transaction> transactions = block.getTransactions();
                    if (transactions == null) break block33;
                    LinkedList<StoredTransactionOutput> txOutsSpent = new LinkedList<StoredTransactionOutput>();
                    LinkedList<StoredTransactionOutput> txOutsCreated = new LinkedList<StoredTransactionOutput>();
                    long sigOps = 0L;
                    boolean bl = enforcePayToScriptHash = newBlock.getHeader().getTimeSeconds() >= 1333238400L;
                    if (!this.params.isCheckpoint(newBlock.getHeight())) {
                        for (Transaction tx : transactions) {
                            Sha256Hash hash = tx.getHash();
                            if (!this.blockStore.hasUnspentOutputs(hash, tx.getOutputs().size())) continue;
                            throw new VerificationException("Block failed BIP30 test!");
                        }
                    }
                    BigInteger totalFees = BigInteger.ZERO;
                    BigInteger coinbaseValue = null;
                    if (this.scriptVerificationExecutor.isShutdown()) {
                        this.scriptVerificationExecutor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
                    }
                    ArrayList<FutureTask<VerificationException>> listScriptVerificationResults = new ArrayList<FutureTask<VerificationException>>(transactions.size());
                    for (Transaction transaction : transactions) {
                        LinkedList<Script> prevOutScripts;
                        boolean isCoinBase;
                        block37: {
                            BigInteger valueOut;
                            BigInteger valueIn;
                            block39: {
                                block38: {
                                    block36: {
                                        block35: {
                                            block34: {
                                                isCoinBase = transaction.isCoinBase();
                                                valueIn = BigInteger.ZERO;
                                                valueOut = BigInteger.ZERO;
                                                prevOutScripts = new LinkedList<Script>();
                                                if (!isCoinBase) {
                                                    for (int index = 0; index < transaction.getInputs().size(); ++index) {
                                                        TransactionInput in = transaction.getInputs().get(index);
                                                        StoredTransactionOutput prevOut = this.blockStore.getTransactionOutput(in.getOutpoint().getHash(), in.getOutpoint().getIndex());
                                                        if (prevOut == null) {
                                                            throw new VerificationException("Attempted spend of a non-existent or already spent output!");
                                                        }
                                                        if (newBlock.getHeight() - prevOut.getHeight() < this.params.getSpendableCoinbaseDepth()) {
                                                            throw new VerificationException("Tried to spend coinbase at depth " + (newBlock.getHeight() - prevOut.getHeight()));
                                                        }
                                                        valueIn = valueIn.add(prevOut.getValue());
                                                        if (enforcePayToScriptHash) {
                                                            Script script = new Script(prevOut.getScriptBytes());
                                                            if (script.isPayToScriptHash()) {
                                                                sigOps += Script.getP2SHSigOpCount(in.getScriptBytes());
                                                            }
                                                            if (sigOps > 20000L) {
                                                                throw new VerificationException("Too many P2SH SigOps in block");
                                                            }
                                                        }
                                                        prevOutScripts.add(new Script(prevOut.getScriptBytes()));
                                                        this.blockStore.removeUnspentTransactionOutput(prevOut);
                                                        txOutsSpent.add(prevOut);
                                                    }
                                                }
                                                Sha256Hash hash = transaction.getHash();
                                                for (TransactionOutput out : transaction.getOutputs()) {
                                                    valueOut = valueOut.add(out.getValue());
                                                    StoredTransactionOutput newOut = new StoredTransactionOutput(hash, out.getIndex(), out.getValue(), newBlock.getHeight(), isCoinBase, out.getScriptBytes());
                                                    this.blockStore.addUnspentTransactionOutput(newOut);
                                                    txOutsCreated.add(newOut);
                                                }
                                                if (valueOut.compareTo(BigInteger.ZERO) < 0) break block34;
                                                if (valueOut.compareTo(NetworkParameters.MAX_MONEY) <= 0) break block35;
                                            }
                                            throw new VerificationException("Transaction output value out of rage");
                                        }
                                        if (!isCoinBase) break block36;
                                        coinbaseValue = valueOut;
                                        break block37;
                                    }
                                    if (valueIn.compareTo(valueOut) < 0) break block38;
                                    if (valueIn.compareTo(NetworkParameters.MAX_MONEY) <= 0) break block39;
                                }
                                throw new VerificationException("Transaction input value out of range");
                            }
                            totalFees = totalFees.add(valueIn.subtract(valueOut));
                        }
                        if (isCoinBase) continue;
                        FutureTask<VerificationException> future = new FutureTask<VerificationException>(new Verifier(transaction, prevOutScripts, enforcePayToScriptHash));
                        this.scriptVerificationExecutor.execute(future);
                        listScriptVerificationResults.add(future);
                    }
                    if (totalFees.compareTo(NetworkParameters.MAX_MONEY) > 0 || newBlock.getHeader().getBlockInflation(newBlock.getHeight()).add(totalFees).compareTo(coinbaseValue) < 0) {
                        throw new VerificationException("Transaction fees out of range");
                    }
                    txOutChanges = new TransactionOutputChanges(txOutsCreated, txOutsSpent);
                    for (Future future : listScriptVerificationResults) {
                        VerificationException e;
                        try {
                            e = (VerificationException)future.get();
                        }
                        catch (InterruptedException thrownE) {
                            throw new RuntimeException(thrownE);
                        }
                        catch (ExecutionException thrownE) {
                            log.error("Script.correctlySpends threw a non-normal exception: " + thrownE.getCause());
                            throw new VerificationException("Bug in Script.correctlySpends, likely script malformed in some new and interesting way.", thrownE);
                        }
                        if (e == null) continue;
                        throw e;
                    }
                    break block32;
                }
                txOutChanges = block.getTxOutChanges();
                if (!this.params.isCheckpoint(newBlock.getHeight())) {
                    for (StoredTransactionOutput out : txOutChanges.txOutsCreated) {
                        Sha256Hash hash = out.getHash();
                        if (this.blockStore.getTransactionOutput(hash, out.getIndex()) == null) continue;
                        throw new VerificationException("Block failed BIP30 test!");
                    }
                }
                for (StoredTransactionOutput out : txOutChanges.txOutsCreated) {
                    this.blockStore.addUnspentTransactionOutput(out);
                }
                for (StoredTransactionOutput out : txOutChanges.txOutsSpent) {
                    this.blockStore.removeUnspentTransactionOutput(out);
                }
            }
            catch (VerificationException e) {
                this.scriptVerificationExecutor.shutdownNow();
                this.blockStore.abortDatabaseBatchWrite();
                throw e;
            }
            catch (BlockStoreException e) {
                this.scriptVerificationExecutor.shutdownNow();
                this.blockStore.abortDatabaseBatchWrite();
                throw e;
            }
        }
        return txOutChanges;
    }

    @Override
    protected void disconnectTransactions(StoredBlock oldBlock) throws PrunedException, BlockStoreException {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        this.blockStore.beginDatabaseBatchWrite();
        try {
            StoredUndoableBlock undoBlock = this.blockStore.getUndoBlock(oldBlock.getHeader().getHash());
            if (undoBlock == null) {
                throw new PrunedException(oldBlock.getHeader().getHash());
            }
            TransactionOutputChanges txOutChanges = undoBlock.getTxOutChanges();
            for (StoredTransactionOutput out : txOutChanges.txOutsSpent) {
                this.blockStore.addUnspentTransactionOutput(out);
            }
            for (StoredTransactionOutput out : txOutChanges.txOutsCreated) {
                this.blockStore.removeUnspentTransactionOutput(out);
            }
        }
        catch (PrunedException e) {
            this.blockStore.abortDatabaseBatchWrite();
            throw e;
        }
        catch (BlockStoreException e) {
            this.blockStore.abortDatabaseBatchWrite();
            throw e;
        }
    }

    @Override
    protected void doSetChainHead(StoredBlock chainHead) throws BlockStoreException {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        this.blockStore.setVerifiedChainHead(chainHead);
        this.blockStore.commitDatabaseBatchWrite();
    }

    @Override
    protected void notSettingChainHead() throws BlockStoreException {
        this.blockStore.abortDatabaseBatchWrite();
    }

    @Override
    protected StoredBlock getStoredBlockInCurrentScope(Sha256Hash hash) throws BlockStoreException {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        return this.blockStore.getOnceUndoableStoredBlock(hash);
    }

    private static class Verifier
    implements Callable<VerificationException> {
        final Transaction tx;
        final List<Script> prevOutScripts;
        final boolean enforcePayToScriptHash;

        public Verifier(Transaction tx, List<Script> prevOutScripts, boolean enforcePayToScriptHash) {
            this.tx = tx;
            this.prevOutScripts = prevOutScripts;
            this.enforcePayToScriptHash = enforcePayToScriptHash;
        }

        @Override
        @Nullable
        public VerificationException call() throws Exception {
            try {
                ListIterator<Script> prevOutIt = this.prevOutScripts.listIterator();
                for (int index = 0; index < this.tx.getInputs().size(); ++index) {
                    this.tx.getInputs().get(index).getScriptSig().correctlySpends(this.tx, index, prevOutIt.next(), this.enforcePayToScriptHash);
                }
            }
            catch (VerificationException e) {
                return e;
            }
            return null;
        }
    }
}

