/*
 * Decompiled with CFR 0.152.
 */
package com.google.bitcoin.core;

import com.google.bitcoin.core.AddressFormatException;
import com.google.bitcoin.core.NetworkParameters;
import com.google.bitcoin.core.VersionedChecksummedBytes;
import com.google.bitcoin.core.WrongNetworkException;
import com.google.bitcoin.params.MainNetParams;
import com.google.bitcoin.params.TestNet3Params;
import com.google.bitcoin.script.Script;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

public class Address
extends VersionedChecksummedBytes {
    public static final int LENGTH = 20;

    public Address(NetworkParameters params, int version, byte[] hash160) throws WrongNetworkException {
        super(version, hash160);
        Preconditions.checkNotNull((Object)params);
        Preconditions.checkArgument((hash160.length == 20 ? 1 : 0) != 0, (Object)"Addresses are 160-bit hashes, so you must provide 20 bytes");
        if (!Address.isAcceptableVersion(params, version)) {
            throw new WrongNetworkException(version, params.getAcceptableAddressCodes());
        }
    }

    public static Address fromP2SHHash(NetworkParameters params, byte[] hash160) {
        try {
            return new Address(params, params.getP2SHHeader(), hash160);
        }
        catch (WrongNetworkException e) {
            throw new RuntimeException(e);
        }
    }

    public static Address fromP2SHScript(NetworkParameters params, Script scriptPubKey) {
        Preconditions.checkArgument((boolean)scriptPubKey.isPayToScriptHash(), (Object)"Not a P2SH script");
        return Address.fromP2SHHash(params, scriptPubKey.getPubKeyHash());
    }

    public Address(NetworkParameters params, byte[] hash160) {
        super(params.getAddressHeader(), hash160);
        Preconditions.checkArgument((hash160.length == 20 ? 1 : 0) != 0, (Object)"Addresses are 160-bit hashes, so you must provide 20 bytes");
    }

    public Address(@Nullable NetworkParameters params, String address) throws AddressFormatException {
        super(address);
        if (params != null && !Address.isAcceptableVersion(params, this.version)) {
            throw new WrongNetworkException(this.version, params.getAcceptableAddressCodes());
        }
    }

    public byte[] getHash160() {
        return this.bytes;
    }

    public boolean isP2SHAddress() {
        NetworkParameters parameters = this.getParameters();
        return parameters != null && this.version == parameters.p2shHeader;
    }

    @Nullable
    public NetworkParameters getParameters() {
        NetworkParameters[] networks;
        for (NetworkParameters params : networks = new NetworkParameters[]{TestNet3Params.get(), MainNetParams.get()}) {
            if (!Address.isAcceptableVersion(params, this.version)) continue;
            return params;
        }
        return null;
    }

    @Nullable
    public static NetworkParameters getParametersFromAddress(String address) throws AddressFormatException {
        try {
            return new Address(null, address).getParameters();
        }
        catch (WrongNetworkException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isAcceptableVersion(NetworkParameters params, int version) {
        for (int v : params.getAcceptableAddressCodes()) {
            if (version != v) continue;
            return true;
        }
        return false;
    }
}

