/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import autovalue.shaded.com.google$.auto.common.$MoreElements;
import autovalue.shaded.com.google$.auto.common.$MoreTypes;
import autovalue.shaded.com.google$.common.base.$Equivalence;
import autovalue.shaded.com.google$.common.base.$VerifyException;
import autovalue.shaded.com.google$.common.collect.$ImmutableBiMap;
import autovalue.shaded.com.google$.common.collect.$ImmutableList;
import autovalue.shaded.com.google$.common.collect.$ImmutableMap;
import com.google.auto.value.processor.AutoBuilderProcessor;
import com.google.auto.value.processor.AutoValueishProcessor;
import com.google.auto.value.processor.BuilderMethodClassifier;
import com.google.auto.value.processor.BuilderSpec;
import com.google.auto.value.processor.ErrorReporter;
import com.google.auto.value.processor.PropertyNames;
import com.google.auto.value.processor.TypeEncoder;
import com.google.auto.value.processor.TypeVariables;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.Types;

class BuilderMethodClassifierForAutoBuilder
extends BuilderMethodClassifier<VariableElement> {
    private final ExecutableElement executable;
    private final $ImmutableBiMap<VariableElement, String> paramToPropertyName;

    private BuilderMethodClassifierForAutoBuilder(ErrorReporter errorReporter, ProcessingEnvironment processingEnv, ExecutableElement executable, TypeMirror builtType, TypeElement builderType, $ImmutableBiMap<VariableElement, String> paramToPropertyName, $ImmutableMap<String, TypeMirror> rewrittenPropertyTypes) {
        super(errorReporter, processingEnv, builtType, builderType, rewrittenPropertyTypes);
        this.executable = executable;
        this.paramToPropertyName = paramToPropertyName;
    }

    static Optional<BuilderMethodClassifier<VariableElement>> classify(Iterable<ExecutableElement> methods, ErrorReporter errorReporter, ProcessingEnvironment processingEnv, ExecutableElement executable, TypeMirror builtType, TypeElement builderType) {
        $ImmutableMap<String, TypeMirror> rewrittenPropertyTypes;
        $ImmutableBiMap<VariableElement, String> paramToPropertyName = executable.getParameters().stream().collect($ImmutableBiMap.toImmutableBiMap(v -> v, v -> v.getSimpleName().toString()));
        BuilderMethodClassifierForAutoBuilder classifier = new BuilderMethodClassifierForAutoBuilder(errorReporter, processingEnv, executable, builtType, builderType, paramToPropertyName, rewrittenPropertyTypes = BuilderMethodClassifierForAutoBuilder.rewriteParameterTypes(executable, builderType, errorReporter, processingEnv.getTypeUtils()));
        if (classifier.classifyMethods(methods, false)) {
            return Optional.of(classifier);
        }
        return Optional.empty();
    }

    private static $ImmutableMap<String, TypeMirror> rewriteParameterTypes(ExecutableElement executable, TypeElement builderType, ErrorReporter errorReporter, Types typeUtils) {
        List<? extends TypeParameterElement> builderTypeParams;
        $ImmutableList<TypeParameterElement> executableTypeParams = BuilderMethodClassifierForAutoBuilder.executableTypeParams(executable);
        if (!BuilderSpec.sameTypeParameters(executableTypeParams, builderTypeParams = builderType.getTypeParameters())) {
            errorReporter.abortWithError(builderType, "[AutoBuilderTypeParams] Builder type parameters %s must match type parameters %s of %s", TypeEncoder.typeParametersString(builderTypeParams), TypeEncoder.typeParametersString(executableTypeParams), AutoBuilderProcessor.executableString(executable));
        }
        if (executableTypeParams.isEmpty()) {
            return executable.getParameters().stream().collect($ImmutableMap.toImmutableMap(v -> v.getSimpleName().toString(), Element::asType));
        }
        LinkedHashMap<$Equivalence.Wrapper<TypeVariable>, TypeVariable> typeVariables = new LinkedHashMap<$Equivalence.Wrapper<TypeVariable>, TypeVariable>();
        for (int i = 0; i < executableTypeParams.size(); ++i) {
            TypeVariable from = $MoreTypes.asTypeVariable(((TypeParameterElement)executableTypeParams.get(i)).asType());
            TypeVariable to = $MoreTypes.asTypeVariable(builderTypeParams.get(i).asType());
            typeVariables.put($MoreTypes.equivalence().wrap(from), to);
        }
        Function<TypeVariable, TypeMirror> substitute = v -> (TypeMirror)typeVariables.get($MoreTypes.equivalence().wrap(v));
        return executable.getParameters().stream().collect($ImmutableMap.toImmutableMap(v -> v.getSimpleName().toString(), v -> TypeVariables.substituteTypeVariables(v.asType(), substitute, typeUtils)));
    }

    private static $ImmutableList<TypeParameterElement> executableTypeParams(ExecutableElement executable) {
        switch (executable.getKind()) {
            case CONSTRUCTOR: {
                TypeElement container = $MoreElements.asType(executable.getEnclosingElement());
                return (($ImmutableList.Builder)(($ImmutableList.Builder)$ImmutableList.builder().addAll(container.getTypeParameters())).addAll(executable.getTypeParameters())).build();
            }
            case METHOD: {
                return $ImmutableList.copyOf(executable.getTypeParameters());
            }
        }
        throw new $VerifyException("Unexpected executable kind " + (Object)((Object)executable.getKind()));
    }

    @Override
    Optional<String> propertyForBuilderGetter(ExecutableElement method) {
        String methodName = method.getSimpleName().toString();
        if (this.paramToPropertyName.containsValue(methodName)) {
            return Optional.of(methodName);
        }
        if (AutoValueishProcessor.isPrefixedGetter(method)) {
            int prefixLength = methodName.startsWith("get") ? 3 : 2;
            String unprefixed = methodName.substring(prefixLength);
            String propertyName = PropertyNames.decapitalizeLikeJavaBeans(unprefixed);
            if (this.paramToPropertyName.containsValue(propertyName)) {
                return Optional.of(propertyName);
            }
            propertyName = PropertyNames.decapitalizeNormally(unprefixed);
            if (this.paramToPropertyName.containsValue(propertyName)) {
                return Optional.of(propertyName);
            }
        }
        return Optional.empty();
    }

    @Override
    void checkForFailedJavaBean(ExecutableElement rejectedSetter) {
    }

    @Override
    $ImmutableBiMap<String, VariableElement> propertyElements() {
        return this.paramToPropertyName.inverse();
    }

    @Override
    TypeMirror originalPropertyType(VariableElement propertyElement) {
        return propertyElement.asType();
    }

    @Override
    String propertyString(VariableElement propertyElement) {
        return "parameter \"" + propertyElement.getSimpleName() + "\" of " + AutoBuilderProcessor.executableString(this.executable);
    }

    @Override
    String autoWhat() {
        return "AutoBuilder";
    }

    @Override
    String getterMustMatch() {
        return "a parameter of " + AutoBuilderProcessor.executableString(this.executable);
    }

    @Override
    String fooBuilderMustMatch() {
        return "foo";
    }
}

