/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import autovalue.shaded.com.google$.common.base.$Throwables;
import autovalue.shaded.com.google$.common.collect.$ImmutableList;
import autovalue.shaded.com.google$.common.collect.$ImmutableMap;
import autovalue.shaded.com.google$.escapevelocity.$Template;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

abstract class TemplateVars {
    private final $ImmutableList<Field> fields = TemplateVars.getFields(this.getClass());

    abstract $Template parsedTemplate();

    TemplateVars() {
    }

    private static $ImmutableList<Field> getFields(Class<?> c) {
        $ImmutableList.Builder<Field> fieldsBuilder = $ImmutableList.builder();
        while (c != TemplateVars.class) {
            TemplateVars.addFields(fieldsBuilder, c.getDeclaredFields());
            c = c.getSuperclass();
        }
        return fieldsBuilder.build();
    }

    private static void addFields($ImmutableList.Builder<Field> fieldsBuilder, Field[] declaredFields) {
        for (Field field : declaredFields) {
            if (field.isSynthetic() || TemplateVars.isStaticFinal(field)) continue;
            if (Modifier.isPrivate(field.getModifiers())) {
                throw new IllegalArgumentException("Field cannot be private: " + field);
            }
            if (Modifier.isStatic(field.getModifiers())) {
                throw new IllegalArgumentException("Field cannot be static unless also final: " + field);
            }
            if (field.getType().isPrimitive()) {
                throw new IllegalArgumentException("Field cannot be primitive: " + field);
            }
            fieldsBuilder.add((Object)field);
        }
    }

    String toText() {
        Map<String, Object> vars = this.toVars();
        return this.parsedTemplate().evaluate(vars);
    }

    private Map<String, Object> toVars() {
        TreeMap<String, Object> vars = new TreeMap<String, Object>();
        for (Field field : this.fields) {
            Object value = TemplateVars.fieldValue(field, this);
            if (value == null) {
                throw new IllegalArgumentException("Field cannot be null (was it set?): " + field);
            }
            Object old = vars.put(field.getName(), value);
            if (old == null) continue;
            throw new IllegalArgumentException("Two fields called " + field.getName() + "?!");
        }
        return $ImmutableMap.copyOf(vars);
    }

    static $Template parsedTemplateForResource(String resourceName) {
        try {
            return $Template.parseFrom(resourceName, TemplateVars::readerFromResource);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
        catch (IOException | IllegalStateException | NullPointerException e) {
            return TemplateVars.retryParseAfterException(resourceName, e);
        }
    }

    private static $Template retryParseAfterException(String resourceName, Exception exception) {
        try {
            return $Template.parseFrom(resourceName, TemplateVars::readerFromUrl);
        }
        catch (IOException t) {
            $Throwables.getRootCause(exception).initCause(t);
            throw new AssertionError((Object)exception);
        }
    }

    private static Reader readerFromResource(String resourceName) {
        InputStream in = TemplateVars.class.getResourceAsStream(resourceName);
        if (in == null) {
            throw new IllegalArgumentException("Could not find resource: " + resourceName);
        }
        return new InputStreamReader(in, StandardCharsets.UTF_8);
    }

    private static Reader readerFromUrl(String resourceName) throws IOException {
        InputStream in;
        block5: {
            URL resourceUrl = TemplateVars.class.getResource(resourceName);
            if (resourceUrl == null) {
                throw new IllegalArgumentException("Could not find resource: " + resourceName);
            }
            try {
                if (resourceUrl.getProtocol().equalsIgnoreCase("file")) {
                    in = TemplateVars.inputStreamFromFile(resourceUrl);
                    break block5;
                }
                if (resourceUrl.getProtocol().equalsIgnoreCase("jar")) {
                    in = TemplateVars.inputStreamFromJar(resourceUrl);
                    break block5;
                }
                throw new AssertionError((Object)("Template fallback logic fails for: " + resourceUrl));
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
        return new InputStreamReader(in, StandardCharsets.UTF_8);
    }

    private static InputStream inputStreamFromJar(URL resourceUrl) throws URISyntaxException, IOException {
        int bang;
        String resourceUrlString = resourceUrl.toString().substring("jar:".length());
        String entryName = resourceUrlString.substring((bang = resourceUrlString.lastIndexOf(33)) + 1);
        if (entryName.startsWith("/")) {
            entryName = entryName.substring(1);
        }
        URI jarUri = new URI(resourceUrlString.substring(0, bang));
        final JarFile jar = new JarFile(new File(jarUri));
        JarEntry entry = jar.getJarEntry(entryName);
        InputStream in = jar.getInputStream(entry);
        return new FilterInputStream(in){

            @Override
            public void close() throws IOException {
                super.close();
                jar.close();
            }
        };
    }

    private static InputStream inputStreamFromFile(URL resourceUrl) throws IOException, URISyntaxException {
        File resourceFile = new File(resourceUrl.toURI());
        return new FileInputStream(resourceFile);
    }

    private static Object fieldValue(Field field, Object container) {
        try {
            return field.get(container);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isStaticFinal(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
    }
}

