/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.processor;

import autovalue.shaded.com.google$.auto.common.$AnnotationMirrors;
import autovalue.shaded.com.google$.auto.common.$GeneratedAnnotations;
import autovalue.shaded.com.google$.auto.common.$MoreElements;
import autovalue.shaded.com.google$.auto.common.$MoreTypes;
import autovalue.shaded.com.google$.auto.common.$Visibility;
import autovalue.shaded.com.google$.common.base.$Throwables;
import autovalue.shaded.com.google$.common.collect.$BiMap;
import autovalue.shaded.com.google$.common.collect.$ImmutableBiMap;
import autovalue.shaded.com.google$.common.collect.$ImmutableCollection;
import autovalue.shaded.com.google$.common.collect.$ImmutableList;
import autovalue.shaded.com.google$.common.collect.$ImmutableListMultimap;
import autovalue.shaded.com.google$.common.collect.$ImmutableMap;
import autovalue.shaded.com.google$.common.collect.$ImmutableSet;
import autovalue.shaded.com.google$.common.collect.$Iterables;
import autovalue.shaded.com.google$.common.collect.$Sets;
import com.google.auto.value.processor.AbortProcessingException;
import com.google.auto.value.processor.AnnotationOutput;
import com.google.auto.value.processor.AutoValueOrOneOfTemplateVars;
import com.google.auto.value.processor.EclipseHack;
import com.google.auto.value.processor.ErrorReporter;
import com.google.auto.value.processor.MissingTypeException;
import com.google.auto.value.processor.Optionalish;
import com.google.auto.value.processor.SimpleMethod;
import com.google.auto.value.processor.TypeEncoder;
import com.google.auto.value.processor.TypeSimplifier;
import java.beans.Introspector;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.lang.annotation.Inherited;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

abstract class AutoValueOrOneOfProcessor
extends AbstractProcessor {
    private final String annotationClassName;
    private final List<String> deferredTypeNames = new ArrayList<String>();
    private TypeElement annotationType;
    private String simpleAnnotationName;
    private ErrorReporter errorReporter;

    AutoValueOrOneOfProcessor(String annotationClassName) {
        this.annotationClassName = annotationClassName;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.errorReporter = new ErrorReporter(processingEnv);
    }

    final ErrorReporter errorReporter() {
        return this.errorReporter;
    }

    final Types typeUtils() {
        return this.processingEnv.getTypeUtils();
    }

    final Elements elementUtils() {
        return this.processingEnv.getElementUtils();
    }

    @Override
    public final SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.annotationType = this.elementUtils().getTypeElement(this.annotationClassName);
        if (this.annotationType == null) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Did not process @" + this.annotationClassName + " because the annotation class was not found");
            return false;
        }
        this.simpleAnnotationName = this.annotationType.getSimpleName().toString();
        List deferredTypes = this.deferredTypeNames.stream().map(name -> this.elementUtils().getTypeElement((CharSequence)name)).collect(Collectors.toList());
        if (roundEnv.processingOver()) {
            for (TypeElement type : deferredTypes) {
                this.errorReporter.reportError("Did not generate @" + this.simpleAnnotationName + " class for " + type.getQualifiedName() + " because it references undefined types", type);
            }
            return false;
        }
        Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(this.annotationType);
        $ImmutableCollection types = (($ImmutableList.Builder)(($ImmutableList.Builder)new $ImmutableList.Builder().addAll((Iterable)deferredTypes)).addAll(ElementFilter.typesIn(annotatedElements))).build();
        this.deferredTypeNames.clear();
        for (TypeElement type : types) {
            try {
                this.processType(type);
            }
            catch (AbortProcessingException abortProcessingException) {
            }
            catch (MissingTypeException e) {
                this.deferredTypeNames.add(type.getQualifiedName().toString());
            }
            catch (RuntimeException e) {
                String trace = $Throwables.getStackTraceAsString(e);
                this.errorReporter.reportError("@" + this.simpleAnnotationName + " processor threw an exception: " + trace, type);
                throw e;
            }
        }
        return false;
    }

    abstract void processType(TypeElement var1);

    abstract Optional<String> nullableAnnotationForMethod(ExecutableElement var1);

    final $ImmutableSet<Property> propertySet(TypeElement type, $ImmutableSet<ExecutableElement> propertyMethods, $ImmutableListMultimap<ExecutableElement, AnnotationMirror> annotatedPropertyMethods) {
        $BiMap methodToPropertyName = this.propertyNameToMethodMap(propertyMethods).inverse();
        LinkedHashMap methodToIdentifier = new LinkedHashMap(methodToPropertyName);
        AutoValueOrOneOfProcessor.fixReservedIdentifiers(methodToIdentifier);
        EclipseHack eclipseHack = new EclipseHack(this.processingEnv);
        DeclaredType declaredType = $MoreTypes.asDeclared(type.asType());
        $ImmutableMap<ExecutableElement, TypeMirror> returnTypes = eclipseHack.methodReturnTypes(propertyMethods, declaredType);
        $ImmutableSet.Builder props = $ImmutableSet.builder();
        for (ExecutableElement propertyMethod : propertyMethods) {
            TypeMirror returnType = returnTypes.get(propertyMethod);
            String propertyType = TypeEncoder.encodeWithAnnotations(returnType);
            String propertyName = (String)(($ImmutableMap)((Object)methodToPropertyName)).get(propertyMethod);
            String identifier = (String)methodToIdentifier.get(propertyMethod);
            $ImmutableCollection annotationMirrors = annotatedPropertyMethods.get((Object)propertyMethod);
            $ImmutableList<String> annotations = AutoValueOrOneOfProcessor.annotationStrings((List<? extends AnnotationMirror>)((Object)annotationMirrors));
            Optional<String> nullableAnnotation = this.nullableAnnotationForMethod(propertyMethod);
            Property p = new Property(propertyName, identifier, propertyMethod, propertyType, annotations, nullableAnnotation);
            props.add(p);
            if (!p.isNullable() || !returnType.getKind().isPrimitive()) continue;
            this.errorReporter().reportError("Primitive types cannot be @Nullable", propertyMethod);
        }
        return props.build();
    }

    final void defineSharedVarsForType(TypeElement type, $ImmutableSet<ExecutableElement> methods, AutoValueOrOneOfTemplateVars vars) {
        vars.pkg = TypeSimplifier.packageNameOf(type);
        vars.origClass = TypeSimplifier.classNameOf(type);
        vars.simpleClassName = TypeSimplifier.simpleNameOf(vars.origClass);
        vars.generated = $GeneratedAnnotations.generatedAnnotation(this.elementUtils(), this.processingEnv.getSourceVersion()).map(annotation -> TypeEncoder.encode(annotation.asType())).orElse("");
        vars.formalTypes = TypeEncoder.formalTypeParametersString(type);
        vars.actualTypes = TypeSimplifier.actualTypeParametersString(type);
        vars.wildcardTypes = AutoValueOrOneOfProcessor.wildcardTypeParametersString(type);
        vars.annotations = this.copiedClassAnnotations(type);
        Map<ObjectMethod, ExecutableElement> methodsToGenerate = AutoValueOrOneOfProcessor.determineObjectMethodsToGenerate(methods);
        vars.toString = methodsToGenerate.containsKey((Object)ObjectMethod.TO_STRING);
        vars.equals = methodsToGenerate.containsKey((Object)ObjectMethod.EQUALS);
        vars.hashCode = methodsToGenerate.containsKey((Object)ObjectMethod.HASH_CODE);
        vars.equalsParameterType = AutoValueOrOneOfProcessor.equalsParameterType(methodsToGenerate);
    }

    static $ImmutableList<String> annotationStrings(List<? extends AnnotationMirror> annotations) {
        return $ImmutableList.copyOf(annotations.stream().map(AnnotationOutput::sourceFormForAnnotation).collect(Collectors.toList()));
    }

    static String generatedClassName(TypeElement type, String prefix) {
        String name = type.getSimpleName().toString();
        while (type.getEnclosingElement() instanceof TypeElement) {
            type = (TypeElement)type.getEnclosingElement();
            name = type.getSimpleName() + "_" + name;
        }
        String pkg = TypeSimplifier.packageNameOf(type);
        String dot = pkg.isEmpty() ? "" : ".";
        return pkg + dot + prefix + name;
    }

    private static boolean isJavaLangObject(TypeElement type) {
        return type.getSuperclass().getKind() == TypeKind.NONE && type.getKind() == ElementKind.CLASS;
    }

    static ObjectMethod objectMethodToOverride(ExecutableElement method) {
        String name = method.getSimpleName().toString();
        switch (method.getParameters().size()) {
            case 0: {
                if (name.equals("toString")) {
                    return ObjectMethod.TO_STRING;
                }
                if (!name.equals("hashCode")) break;
                return ObjectMethod.HASH_CODE;
            }
            case 1: {
                TypeElement paramType;
                TypeMirror param;
                if (!name.equals("equals") || !(param = $Iterables.getOnlyElement(method.getParameters()).asType()).getKind().equals((Object)TypeKind.DECLARED) || !(paramType = $MoreTypes.asTypeElement(param)).getQualifiedName().contentEquals("java.lang.Object")) break;
                return ObjectMethod.EQUALS;
            }
        }
        return ObjectMethod.NONE;
    }

    final $ImmutableBiMap<String, ExecutableElement> propertyNameToMethodMap(Set<ExecutableElement> propertyMethods) {
        LinkedHashMap<String, ExecutableElement> map = new LinkedHashMap<String, ExecutableElement>();
        HashSet<String> reportedDups = new HashSet<String>();
        boolean allPrefixed = AutoValueOrOneOfProcessor.gettersAllPrefixed(propertyMethods);
        for (ExecutableElement method : propertyMethods) {
            String methodName = method.getSimpleName().toString();
            String name = allPrefixed ? AutoValueOrOneOfProcessor.nameWithoutPrefix(methodName) : methodName;
            ExecutableElement old = map.put(name, method);
            if (old == null) continue;
            String message = "More than one @" + this.simpleAnnotationName + " property called " + name;
            this.errorReporter.reportError(message, method);
            if (!reportedDups.add(name)) continue;
            this.errorReporter.reportError(message, old);
        }
        return $ImmutableBiMap.copyOf(map);
    }

    private static boolean gettersAllPrefixed(Set<ExecutableElement> methods) {
        return AutoValueOrOneOfProcessor.prefixedGettersIn(methods).size() == methods.size();
    }

    static $ImmutableSet<ExecutableElement> prefixedGettersIn(Iterable<ExecutableElement> methods) {
        $ImmutableSet.Builder getters = $ImmutableSet.builder();
        for (ExecutableElement method : methods) {
            boolean is;
            String name = method.getSimpleName().toString();
            boolean get = name.startsWith("get") && !name.equals("get");
            boolean bl = is = name.startsWith("is") && !name.equals("is") && method.getReturnType().getKind() == TypeKind.BOOLEAN;
            if (!get && !is) continue;
            getters.add(method);
        }
        return getters.build();
    }

    private static String nameWithoutPrefix(String name) {
        if (name.startsWith("get")) {
            name = name.substring(3);
        } else {
            assert (name.startsWith("is"));
            name = name.substring(2);
        }
        return Introspector.decapitalize(name);
    }

    final void checkModifiersIfNested(TypeElement type) {
        ElementKind enclosingKind = type.getEnclosingElement().getKind();
        if (enclosingKind.isClass() || enclosingKind.isInterface()) {
            if (type.getModifiers().contains((Object)Modifier.PRIVATE)) {
                this.errorReporter.abortWithError("@" + this.simpleAnnotationName + " class must not be private", type);
            } else if ($Visibility.effectiveVisibilityOfElement(type).equals((Object)$Visibility.PRIVATE)) {
                this.errorReporter.abortWithError("@" + this.simpleAnnotationName + " class must not be nested in a private class", type);
            }
            if (!type.getModifiers().contains((Object)Modifier.STATIC)) {
                this.errorReporter.abortWithError("Nested @" + this.simpleAnnotationName + " class must be static", type);
            }
        }
    }

    static void fixReservedIdentifiers(Map<?, String> methodToIdentifier) {
        for (Map.Entry<?, String> entry : methodToIdentifier.entrySet()) {
            if (!SourceVersion.isKeyword(entry.getValue())) continue;
            entry.setValue(AutoValueOrOneOfProcessor.disambiguate(entry.getValue(), methodToIdentifier.values()));
        }
    }

    private static String disambiguate(String name, Collection<String> existingNames) {
        int i = 0;
        String candidate;
        while (existingNames.contains(candidate = name + i)) {
            ++i;
        }
        return candidate;
    }

    private static Map<ObjectMethod, ExecutableElement> determineObjectMethodsToGenerate(Set<ExecutableElement> methods) {
        EnumMap<ObjectMethod, ExecutableElement> methodsToGenerate = new EnumMap<ObjectMethod, ExecutableElement>(ObjectMethod.class);
        for (ExecutableElement method : methods) {
            boolean canGenerate;
            ObjectMethod override = AutoValueOrOneOfProcessor.objectMethodToOverride(method);
            boolean bl = canGenerate = method.getModifiers().contains((Object)Modifier.ABSTRACT) || AutoValueOrOneOfProcessor.isJavaLangObject((TypeElement)method.getEnclosingElement());
            if (override.equals((Object)ObjectMethod.NONE) || !canGenerate) continue;
            methodsToGenerate.put(override, method);
        }
        return methodsToGenerate;
    }

    static String equalsParameterType(Map<ObjectMethod, ExecutableElement> methodsToGenerate) {
        ExecutableElement equals = methodsToGenerate.get((Object)ObjectMethod.EQUALS);
        if (equals == null) {
            return "";
        }
        TypeMirror parameterType = equals.getParameters().get(0).asType();
        return TypeEncoder.encodeWithAnnotations(parameterType);
    }

    static $ImmutableSet<ExecutableElement> abstractMethodsIn($ImmutableSet<ExecutableElement> methods) {
        HashSet<Name> noArgMethods = new HashSet<Name>();
        $ImmutableSet.Builder abstracts = $ImmutableSet.builder();
        for (ExecutableElement method : methods) {
            boolean hasArgs;
            if (!method.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
            boolean bl = hasArgs = !method.getParameters().isEmpty();
            if (!hasArgs && !noArgMethods.add(method.getSimpleName())) continue;
            abstracts.add(method);
        }
        return abstracts.build();
    }

    static $ImmutableSet<ExecutableElement> propertyMethodsIn(Set<ExecutableElement> abstractMethods) {
        $ImmutableSet.Builder properties = $ImmutableSet.builder();
        for (ExecutableElement method : abstractMethods) {
            if (!method.getParameters().isEmpty() || method.getReturnType().getKind() == TypeKind.VOID || AutoValueOrOneOfProcessor.objectMethodToOverride(method) != ObjectMethod.NONE) continue;
            properties.add(method);
        }
        return properties.build();
    }

    final void checkReturnType(TypeElement autoValueClass, ExecutableElement getter) {
        TypeMirror type = getter.getReturnType();
        if (type.getKind() == TypeKind.ARRAY) {
            TypeMirror componentType = ((ArrayType)type).getComponentType();
            if (componentType.getKind().isPrimitive()) {
                this.warnAboutPrimitiveArrays(autoValueClass, getter);
            } else {
                this.errorReporter.reportError("An @" + this.simpleAnnotationName + " class cannot define an array-valued property unless it is a primitive array", getter);
            }
        }
    }

    private void warnAboutPrimitiveArrays(TypeElement autoValueClass, ExecutableElement getter) {
        boolean suppressed = false;
        Optional<AnnotationMirror> maybeAnnotation = AutoValueOrOneOfProcessor.getAnnotationMirror(getter, "java.lang.SuppressWarnings");
        if (maybeAnnotation.isPresent()) {
            AnnotationValue listValue = $AnnotationMirrors.getAnnotationValue(maybeAnnotation.get(), "value");
            suppressed = listValue.accept(new ContainsMutableVisitor(), null);
        }
        if (!suppressed) {
            String warning = "An @" + this.simpleAnnotationName + " property that is a primitive array returns the original array, which can therefore be modified by the caller. If this OK, you can suppress this warning with @SuppressWarnings(\"mutable\"). Otherwise, you should replace the property with an immutable type, perhaps a simple wrapper around the original array.";
            boolean sameClass = getter.getEnclosingElement().equals(autoValueClass);
            if (sameClass) {
                this.errorReporter.reportWarning(warning, getter);
            } else {
                this.errorReporter.reportWarning(warning + " Method: " + getter.getEnclosingElement() + "." + getter, autoValueClass);
            }
        }
    }

    final String getSerialVersionUID(TypeElement type) {
        TypeMirror serializable = this.elementUtils().getTypeElement(Serializable.class.getName()).asType();
        if (this.typeUtils().isAssignable(type.asType(), serializable)) {
            List<VariableElement> fields = ElementFilter.fieldsIn(type.getEnclosedElements());
            for (VariableElement field : fields) {
                if (!field.getSimpleName().contentEquals("serialVersionUID")) continue;
                Object value = field.getConstantValue();
                if (field.getModifiers().containsAll(Arrays.asList(Modifier.STATIC, Modifier.FINAL)) && field.asType().getKind() == TypeKind.LONG && value != null) {
                    return value + "L";
                }
                this.errorReporter.reportError("serialVersionUID must be a static final long compile-time constant", field);
                break;
            }
        }
        return "";
    }

    $ImmutableList<AnnotationMirror> annotationsToCopy(Element autoValueType, Element typeOrMethod, Set<String> excludedAnnotations) {
        $ImmutableList.Builder result = $ImmutableList.builder();
        for (AnnotationMirror annotationMirror : typeOrMethod.getAnnotationMirrors()) {
            String annotationFqName = AutoValueOrOneOfProcessor.getAnnotationFqName(annotationMirror);
            if (this.isInAutoValuePackage(annotationFqName) || excludedAnnotations.contains(annotationFqName) || !this.annotationVisibleFrom(annotationMirror, autoValueType)) continue;
            result.add(annotationMirror);
        }
        return result.build();
    }

    private boolean isInAutoValuePackage(String className) {
        return className.startsWith("com.google.auto.value.") && !className.contains("Test");
    }

    private $ImmutableList<String> copiedClassAnnotations(TypeElement type) {
        if (AutoValueOrOneOfProcessor.hasAnnotationMirror(type, "com.google.auto.value.AutoValue.CopyAnnotations")) {
            $Sets.SetView<String> excludedAnnotations = $Sets.union(this.getExcludedClasses(type), AutoValueOrOneOfProcessor.getAnnotationsMarkedWithInherited(type));
            return this.copyAnnotations(type, type, excludedAnnotations);
        }
        return $ImmutableList.of();
    }

    private $ImmutableList<String> copyAnnotations(Element autoValueType, Element typeOrMethod, Set<String> excludedAnnotations) {
        $ImmutableList<AnnotationMirror> annotationsToCopy = this.annotationsToCopy(autoValueType, typeOrMethod, excludedAnnotations);
        return AutoValueOrOneOfProcessor.annotationStrings(annotationsToCopy);
    }

    private Set<String> getExcludedClasses(Element element) {
        Optional<AnnotationMirror> maybeAnnotation = AutoValueOrOneOfProcessor.getAnnotationMirror(element, "com.google.auto.value.AutoValue.CopyAnnotations");
        if (!maybeAnnotation.isPresent()) {
            return $ImmutableSet.of();
        }
        List excludedClasses = (List)$AnnotationMirrors.getAnnotationValue(maybeAnnotation.get(), "exclude").getValue();
        return excludedClasses.stream().map(annotationValue -> $MoreTypes.asTypeElement((DeclaredType)annotationValue.getValue())).map(typeElement -> typeElement.getQualifiedName().toString()).collect(Collectors.toSet());
    }

    private static Set<String> getAnnotationsMarkedWithInherited(Element element) {
        return element.getAnnotationMirrors().stream().filter(a -> $MoreElements.isAnnotationPresent(a.getAnnotationType().asElement(), Inherited.class)).map(a -> AutoValueOrOneOfProcessor.getAnnotationFqName(a)).collect(Collectors.toSet());
    }

    private static String getAnnotationFqName(AnnotationMirror annotation) {
        return ((QualifiedNameable)annotation.getAnnotationType().asElement()).getQualifiedName().toString();
    }

    final $ImmutableListMultimap<ExecutableElement, AnnotationMirror> propertyMethodAnnotationMap(TypeElement type, $ImmutableSet<ExecutableElement> propertyMethods) {
        $ImmutableListMultimap.Builder builder = $ImmutableListMultimap.builder();
        for (ExecutableElement propertyMethod : propertyMethods) {
            builder.putAll((Object)propertyMethod, this.propertyMethodAnnotations(type, propertyMethod));
        }
        return builder.build();
    }

    private $ImmutableList<AnnotationMirror> propertyMethodAnnotations(TypeElement type, ExecutableElement method) {
        $ImmutableCollection excludedAnnotations = (($ImmutableSet.Builder)(($ImmutableSet.Builder)$ImmutableSet.builder().addAll(this.getExcludedClasses(method))).add(Override.class.getCanonicalName())).build();
        Set returnTypeAnnotations = method.getReturnType().getAnnotationMirrors().stream().map(a -> a.getAnnotationType().asElement()).map($MoreElements::asType).map(e -> e.getQualifiedName().toString()).collect(Collectors.toSet());
        $Sets.SetView<String> excluded = $Sets.union(excludedAnnotations, returnTypeAnnotations);
        return this.annotationsToCopy(type, method, excluded);
    }

    private boolean annotationVisibleFrom(AnnotationMirror annotation, Element from) {
        Element annotationElement = annotation.getAnnotationType().asElement();
        $Visibility visibility = $Visibility.effectiveVisibilityOfElement(annotationElement);
        switch (visibility) {
            case PUBLIC: {
                return true;
            }
            case PROTECTED: {
                return $MoreElements.getPackage(annotationElement).equals($MoreElements.getPackage(from)) || this.typeUtils().isSubtype(from.asType(), annotationElement.getEnclosingElement().asType());
            }
            case DEFAULT: {
                return $MoreElements.getPackage(annotationElement).equals($MoreElements.getPackage(from));
            }
        }
        return false;
    }

    private static String wildcardTypeParametersString(TypeElement type) {
        List<? extends TypeParameterElement> typeParameters = type.getTypeParameters();
        if (typeParameters.isEmpty()) {
            return "";
        }
        return typeParameters.stream().map(e -> "?").collect(Collectors.joining(", ", "<", ">"));
    }

    static Optional<AnnotationMirror> getAnnotationMirror(Element element, String annotationName) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            TypeElement annotationElement = $MoreTypes.asTypeElement(annotationMirror.getAnnotationType());
            if (!annotationElement.getQualifiedName().contentEquals(annotationName)) continue;
            return Optional.of(annotationMirror);
        }
        return Optional.empty();
    }

    static boolean hasAnnotationMirror(Element element, String annotationName) {
        return AutoValueOrOneOfProcessor.getAnnotationMirror(element, annotationName).isPresent();
    }

    final void writeSourceFile(String className, String text, TypeElement originatingType) {
        try {
            JavaFileObject sourceFile = this.processingEnv.getFiler().createSourceFile(className, originatingType);
            try (Writer writer = sourceFile.openWriter();){
                writer.write(text);
            }
        }
        catch (IOException e) {
            this.errorReporter.reportWarning("Could not write generated class " + className + ": " + e, originatingType);
        }
    }

    private static class ContainsMutableVisitor
    extends SimpleAnnotationValueVisitor8<Boolean, Void> {
        private ContainsMutableVisitor() {
        }

        @Override
        public Boolean visitArray(List<? extends AnnotationValue> list, Void p) {
            return list.stream().map(av -> av.getValue()).anyMatch("mutable"::equals);
        }
    }

    static enum ObjectMethod {
        NONE,
        TO_STRING,
        EQUALS,
        HASH_CODE;

    }

    public static class Property {
        private final String name;
        private final String identifier;
        private final ExecutableElement method;
        private final String type;
        private final $ImmutableList<String> annotations;
        private final Optional<String> nullableAnnotation;
        private final Optionalish optional;

        Property(String name, String identifier, ExecutableElement method, String type, $ImmutableList<String> annotations, Optional<String> nullableAnnotation) {
            this.name = name;
            this.identifier = identifier;
            this.method = method;
            this.type = type;
            this.annotations = annotations;
            this.nullableAnnotation = nullableAnnotation;
            TypeMirror propertyType = method.getReturnType();
            this.optional = Optionalish.createIfOptional(propertyType);
        }

        public String toString() {
            return this.identifier;
        }

        public String getName() {
            return this.name;
        }

        public String getGetter() {
            return this.method.getSimpleName().toString();
        }

        public TypeMirror getTypeMirror() {
            return this.method.getReturnType();
        }

        public String getType() {
            return this.type;
        }

        public TypeKind getKind() {
            return this.method.getReturnType().getKind();
        }

        public List<String> getAnnotations() {
            return this.annotations;
        }

        public Optionalish getOptional() {
            return this.optional;
        }

        public final String getNullableAnnotation() {
            return this.nullableAnnotation.orElse("");
        }

        public boolean isNullable() {
            return this.nullableAnnotation.isPresent();
        }

        public String getAccess() {
            return SimpleMethod.access(this.method);
        }

        public boolean equals(Object obj) {
            return obj instanceof Property && ((Property)obj).method.equals(this.method);
        }

        public int hashCode() {
            return this.method.hashCode();
        }
    }
}

