/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.webtoken.JsonWebSignature;
import com.google.api.client.json.webtoken.JsonWebToken;
import com.google.api.client.util.GenericData;
import com.google.api.client.util.Joiner;
import com.google.api.client.util.ObjectParser;
import com.google.api.client.util.PemReader;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.SecurityUtils;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.OAuth2Utils;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.sql.Date;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceAccountCredentials
extends GoogleCredentials {
    private static final String GRANT_TYPE = "urn:ietf:params:oauth:grant-type:jwt-bearer";
    private static final String PARSE_ERROR_PREFIX = "Error parsing token refresh response. ";
    private final String clientId;
    private final String clientEmail;
    private final PrivateKey privateKey;
    private final String privateKeyId;
    private final HttpTransport transport;
    private final GenericUrl tokenServerUrl;
    private final Collection<String> scopes;

    public ServiceAccountCredentials(String clientId, String clientEmail, PrivateKey privateKey, String privateKeyId, Collection<String> scopes) {
        this(clientId, clientEmail, privateKey, privateKeyId, scopes, null);
    }

    public ServiceAccountCredentials(String clientId, String clientEmail, PrivateKey privateKey, String privateKeyId, Collection<String> scopes, HttpTransport transport) {
        this.clientId = clientId;
        this.clientEmail = (String)Preconditions.checkNotNull((Object)clientEmail);
        this.privateKey = (PrivateKey)Preconditions.checkNotNull((Object)privateKey);
        this.privateKeyId = privateKeyId;
        this.scopes = scopes == null ? Collections.emptyList() : Collections.unmodifiableCollection(scopes);
        this.transport = transport == null ? OAuth2Utils.HTTP_TRANSPORT : transport;
        this.tokenServerUrl = new GenericUrl("https://accounts.google.com/o/oauth2/token");
    }

    static ServiceAccountCredentials fromJson(Map<String, Object> json, HttpTransport transport) throws IOException {
        String clientId = (String)json.get("client_id");
        String clientEmail = (String)json.get("client_email");
        String privateKeyPkcs8 = (String)json.get("private_key");
        String privateKeyId = (String)json.get("private_key_id");
        if (clientId == null || clientEmail == null || privateKeyPkcs8 == null || privateKeyId == null) {
            throw new IOException("Error reading service account credential from JSON, expecting  'client_id', 'client_email', 'private_key' and 'private_key_id'.");
        }
        return ServiceAccountCredentials.fromPkcs8(clientId, clientEmail, privateKeyPkcs8, privateKeyId, null, transport);
    }

    public static ServiceAccountCredentials fromPkcs8(String clientId, String clientEmail, String privateKeyPkcs8, String privateKeyId, Collection<String> scopes) throws IOException {
        return ServiceAccountCredentials.fromPkcs8(clientId, clientEmail, privateKeyPkcs8, privateKeyId, scopes, null);
    }

    public static ServiceAccountCredentials fromPkcs8(String clientId, String clientEmail, String privateKeyPkcs8, String privateKeyId, Collection<String> scopes, HttpTransport transport) throws IOException {
        PrivateKey privateKey = ServiceAccountCredentials.privateKeyFromPkcs8(privateKeyPkcs8);
        return new ServiceAccountCredentials(clientId, clientEmail, privateKey, privateKeyId, scopes, transport);
    }

    static PrivateKey privateKeyFromPkcs8(String privateKeyPkcs8) throws IOException {
        StringReader reader = new StringReader(privateKeyPkcs8);
        PemReader.Section section = PemReader.readFirstSectionAndClose((Reader)reader, (String)"PRIVATE KEY");
        if (section == null) {
            throw new IOException("Invalid PKCS#8 data.");
        }
        byte[] bytes = section.getBase64DecodedBytes();
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytes);
        GeneralSecurityException unexpectedException = null;
        try {
            KeyFactory keyFactory = SecurityUtils.getRsaKeyFactory();
            PrivateKey privateKey = keyFactory.generatePrivate(keySpec);
            return privateKey;
        }
        catch (NoSuchAlgorithmException exception) {
            unexpectedException = exception;
        }
        catch (InvalidKeySpecException exception) {
            unexpectedException = exception;
        }
        throw OAuth2Utils.exceptionWithCause(new IOException("Unexpected exception reading PKCS#8 data"), unexpectedException);
    }

    @Override
    public AccessToken refreshAccessToken() throws IOException {
        HttpResponse response;
        if (this.createScopedRequired()) {
            throw new IOException("Scopes not configured for service account. Scoped should be specifed by calling createScoped or passing scopes to constructor.");
        }
        JsonWebSignature.Header header = new JsonWebSignature.Header();
        header.setAlgorithm("RS256");
        header.setType("JWT");
        header.setKeyId(this.privateKeyId);
        JsonWebToken.Payload payload = new JsonWebToken.Payload();
        long currentTime = this.clock.currentTimeMillis();
        payload.setIssuer(this.clientEmail);
        payload.setAudience((Object)"https://accounts.google.com/o/oauth2/token");
        payload.setIssuedAtTimeSeconds(Long.valueOf(currentTime / 1000L));
        payload.setExpirationTimeSeconds(Long.valueOf(currentTime / 1000L + 3600L));
        payload.setSubject(null);
        payload.put("scope", (Object)Joiner.on((char)' ').join(this.scopes));
        JsonFactory jsonFactory = OAuth2Utils.JSON_FACTORY;
        String assertion = null;
        try {
            assertion = JsonWebSignature.signUsingRsaSha256((PrivateKey)this.privateKey, (JsonFactory)jsonFactory, (JsonWebSignature.Header)header, (JsonWebToken.Payload)payload);
        }
        catch (GeneralSecurityException e) {
            throw OAuth2Utils.exceptionWithCause(new IOException("Error signing service account access token request with private key."), e);
        }
        GenericData tokenRequest = new GenericData();
        tokenRequest.set("grant_type", (Object)GRANT_TYPE);
        tokenRequest.set("assertion", (Object)assertion);
        UrlEncodedContent content = new UrlEncodedContent((Object)tokenRequest);
        HttpRequestFactory requestFactory = this.transport.createRequestFactory();
        HttpRequest request = requestFactory.buildPostRequest(this.tokenServerUrl, (HttpContent)content);
        request.setParser((ObjectParser)new JsonObjectParser(jsonFactory));
        try {
            response = request.execute();
        }
        catch (IOException e) {
            throw OAuth2Utils.exceptionWithCause(new IOException("Error getting access token for service account: "), e);
        }
        GenericData responseData = (GenericData)response.parseAs(GenericData.class);
        String accessToken = OAuth2Utils.validateString(responseData, "access_token", PARSE_ERROR_PREFIX);
        int expiresInSeconds = OAuth2Utils.validateInt32(responseData, "expires_in", PARSE_ERROR_PREFIX);
        long expiresAtMilliseconds = this.clock.currentTimeMillis() + (long)(expiresInSeconds * 1000);
        AccessToken access = new AccessToken(accessToken, new Date(expiresAtMilliseconds));
        return access;
    }

    @Override
    public boolean createScopedRequired() {
        return this.scopes.isEmpty();
    }

    @Override
    public GoogleCredentials createScoped(Collection<String> newScopes) {
        return new ServiceAccountCredentials(this.clientId, this.clientEmail, this.privateKey, this.privateKeyId, newScopes, this.transport);
    }

    public final String getClientId() {
        return this.clientId;
    }

    public final String getClientEmail() {
        return this.clientEmail;
    }

    public final PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public final String getPrivateKeyId() {
        return this.privateKeyId;
    }

    public final Collection<String> getScopes() {
        return this.scopes;
    }
}

