/*
 * Decompiled with CFR 0.152.
 */
package com.google.area120.tables.v1alpha;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.area120.tables.v1alpha.TablesServiceSettings;
import com.google.area120.tables.v1alpha.stub.TablesServiceStub;
import com.google.area120.tables.v1alpha.stub.TablesServiceStubSettings;
import com.google.area120.tables.v1alpha1.BatchCreateRowsRequest;
import com.google.area120.tables.v1alpha1.BatchCreateRowsResponse;
import com.google.area120.tables.v1alpha1.BatchDeleteRowsRequest;
import com.google.area120.tables.v1alpha1.BatchUpdateRowsRequest;
import com.google.area120.tables.v1alpha1.BatchUpdateRowsResponse;
import com.google.area120.tables.v1alpha1.CreateRowRequest;
import com.google.area120.tables.v1alpha1.DeleteRowRequest;
import com.google.area120.tables.v1alpha1.GetRowRequest;
import com.google.area120.tables.v1alpha1.GetTableRequest;
import com.google.area120.tables.v1alpha1.GetWorkspaceRequest;
import com.google.area120.tables.v1alpha1.ListRowsRequest;
import com.google.area120.tables.v1alpha1.ListRowsResponse;
import com.google.area120.tables.v1alpha1.ListTablesRequest;
import com.google.area120.tables.v1alpha1.ListTablesResponse;
import com.google.area120.tables.v1alpha1.ListWorkspacesRequest;
import com.google.area120.tables.v1alpha1.ListWorkspacesResponse;
import com.google.area120.tables.v1alpha1.Row;
import com.google.area120.tables.v1alpha1.RowName;
import com.google.area120.tables.v1alpha1.Table;
import com.google.area120.tables.v1alpha1.TableName;
import com.google.area120.tables.v1alpha1.UpdateRowRequest;
import com.google.area120.tables.v1alpha1.Workspace;
import com.google.area120.tables.v1alpha1.WorkspaceName;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class TablesServiceClient
implements BackgroundResource {
    private final TablesServiceSettings settings;
    private final TablesServiceStub stub;

    public static final TablesServiceClient create() throws IOException {
        return TablesServiceClient.create(TablesServiceSettings.newBuilder().build());
    }

    public static final TablesServiceClient create(TablesServiceSettings settings) throws IOException {
        return new TablesServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final TablesServiceClient create(TablesServiceStub stub) {
        return new TablesServiceClient(stub);
    }

    protected TablesServiceClient(TablesServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TablesServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected TablesServiceClient(TablesServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final TablesServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public TablesServiceStub getStub() {
        return this.stub;
    }

    public final Table getTable(TableName name) {
        GetTableRequest request = GetTableRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTable(request);
    }

    public final Table getTable(String name) {
        GetTableRequest request = GetTableRequest.newBuilder().setName(name).build();
        return this.getTable(request);
    }

    public final Table getTable(GetTableRequest request) {
        return (Table)this.getTableCallable().call((Object)request);
    }

    public final UnaryCallable<GetTableRequest, Table> getTableCallable() {
        return this.stub.getTableCallable();
    }

    public final ListTablesPagedResponse listTables(ListTablesRequest request) {
        return (ListTablesPagedResponse)((Object)this.listTablesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTablesRequest, ListTablesPagedResponse> listTablesPagedCallable() {
        return this.stub.listTablesPagedCallable();
    }

    public final UnaryCallable<ListTablesRequest, ListTablesResponse> listTablesCallable() {
        return this.stub.listTablesCallable();
    }

    public final Workspace getWorkspace(WorkspaceName name) {
        GetWorkspaceRequest request = GetWorkspaceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getWorkspace(request);
    }

    public final Workspace getWorkspace(String name) {
        GetWorkspaceRequest request = GetWorkspaceRequest.newBuilder().setName(name).build();
        return this.getWorkspace(request);
    }

    public final Workspace getWorkspace(GetWorkspaceRequest request) {
        return (Workspace)this.getWorkspaceCallable().call((Object)request);
    }

    public final UnaryCallable<GetWorkspaceRequest, Workspace> getWorkspaceCallable() {
        return this.stub.getWorkspaceCallable();
    }

    public final ListWorkspacesPagedResponse listWorkspaces(ListWorkspacesRequest request) {
        return (ListWorkspacesPagedResponse)((Object)this.listWorkspacesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListWorkspacesRequest, ListWorkspacesPagedResponse> listWorkspacesPagedCallable() {
        return this.stub.listWorkspacesPagedCallable();
    }

    public final UnaryCallable<ListWorkspacesRequest, ListWorkspacesResponse> listWorkspacesCallable() {
        return this.stub.listWorkspacesCallable();
    }

    public final Row getRow(RowName name) {
        GetRowRequest request = GetRowRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRow(request);
    }

    public final Row getRow(String name) {
        GetRowRequest request = GetRowRequest.newBuilder().setName(name).build();
        return this.getRow(request);
    }

    public final Row getRow(GetRowRequest request) {
        return (Row)this.getRowCallable().call((Object)request);
    }

    public final UnaryCallable<GetRowRequest, Row> getRowCallable() {
        return this.stub.getRowCallable();
    }

    public final ListRowsPagedResponse listRows(String parent) {
        ListRowsRequest request = ListRowsRequest.newBuilder().setParent(parent).build();
        return this.listRows(request);
    }

    public final ListRowsPagedResponse listRows(ListRowsRequest request) {
        return (ListRowsPagedResponse)((Object)this.listRowsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRowsRequest, ListRowsPagedResponse> listRowsPagedCallable() {
        return this.stub.listRowsPagedCallable();
    }

    public final UnaryCallable<ListRowsRequest, ListRowsResponse> listRowsCallable() {
        return this.stub.listRowsCallable();
    }

    public final Row createRow(String parent, Row row) {
        CreateRowRequest request = CreateRowRequest.newBuilder().setParent(parent).setRow(row).build();
        return this.createRow(request);
    }

    public final Row createRow(CreateRowRequest request) {
        return (Row)this.createRowCallable().call((Object)request);
    }

    public final UnaryCallable<CreateRowRequest, Row> createRowCallable() {
        return this.stub.createRowCallable();
    }

    public final BatchCreateRowsResponse batchCreateRows(BatchCreateRowsRequest request) {
        return (BatchCreateRowsResponse)this.batchCreateRowsCallable().call((Object)request);
    }

    public final UnaryCallable<BatchCreateRowsRequest, BatchCreateRowsResponse> batchCreateRowsCallable() {
        return this.stub.batchCreateRowsCallable();
    }

    public final Row updateRow(Row row, FieldMask updateMask) {
        UpdateRowRequest request = UpdateRowRequest.newBuilder().setRow(row).setUpdateMask(updateMask).build();
        return this.updateRow(request);
    }

    public final Row updateRow(UpdateRowRequest request) {
        return (Row)this.updateRowCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateRowRequest, Row> updateRowCallable() {
        return this.stub.updateRowCallable();
    }

    public final BatchUpdateRowsResponse batchUpdateRows(BatchUpdateRowsRequest request) {
        return (BatchUpdateRowsResponse)this.batchUpdateRowsCallable().call((Object)request);
    }

    public final UnaryCallable<BatchUpdateRowsRequest, BatchUpdateRowsResponse> batchUpdateRowsCallable() {
        return this.stub.batchUpdateRowsCallable();
    }

    public final void deleteRow(RowName name) {
        DeleteRowRequest request = DeleteRowRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteRow(request);
    }

    public final void deleteRow(String name) {
        DeleteRowRequest request = DeleteRowRequest.newBuilder().setName(name).build();
        this.deleteRow(request);
    }

    public final void deleteRow(DeleteRowRequest request) {
        this.deleteRowCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteRowRequest, Empty> deleteRowCallable() {
        return this.stub.deleteRowCallable();
    }

    public final void batchDeleteRows(BatchDeleteRowsRequest request) {
        this.batchDeleteRowsCallable().call((Object)request);
    }

    public final UnaryCallable<BatchDeleteRowsRequest, Empty> batchDeleteRowsCallable() {
        return this.stub.batchDeleteRowsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListRowsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRowsRequest, ListRowsResponse, Row, ListRowsPage, ListRowsFixedSizeCollection> {
        private ListRowsFixedSizeCollection(List<ListRowsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRowsFixedSizeCollection createEmptyCollection() {
            return new ListRowsFixedSizeCollection(null, 0);
        }

        protected ListRowsFixedSizeCollection createCollection(List<ListRowsPage> pages, int collectionSize) {
            return new ListRowsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRowsPage
    extends AbstractPage<ListRowsRequest, ListRowsResponse, Row, ListRowsPage> {
        private ListRowsPage(PageContext<ListRowsRequest, ListRowsResponse, Row> context, ListRowsResponse response) {
            super(context, (Object)response);
        }

        private static ListRowsPage createEmptyPage() {
            return new ListRowsPage(null, null);
        }

        protected ListRowsPage createPage(PageContext<ListRowsRequest, ListRowsResponse, Row> context, ListRowsResponse response) {
            return new ListRowsPage(context, response);
        }

        public ApiFuture<ListRowsPage> createPageAsync(PageContext<ListRowsRequest, ListRowsResponse, Row> context, ApiFuture<ListRowsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRowsPagedResponse
    extends AbstractPagedListResponse<ListRowsRequest, ListRowsResponse, Row, ListRowsPage, ListRowsFixedSizeCollection> {
        public static ApiFuture<ListRowsPagedResponse> createAsync(PageContext<ListRowsRequest, ListRowsResponse, Row> context, ApiFuture<ListRowsResponse> futureResponse) {
            ApiFuture<ListRowsPage> futurePage = ListRowsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListRowsPage, ListRowsPagedResponse>(){

                public ListRowsPagedResponse apply(ListRowsPage input) {
                    return new ListRowsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListRowsPagedResponse(ListRowsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRowsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListWorkspacesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListWorkspacesRequest, ListWorkspacesResponse, Workspace, ListWorkspacesPage, ListWorkspacesFixedSizeCollection> {
        private ListWorkspacesFixedSizeCollection(List<ListWorkspacesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListWorkspacesFixedSizeCollection createEmptyCollection() {
            return new ListWorkspacesFixedSizeCollection(null, 0);
        }

        protected ListWorkspacesFixedSizeCollection createCollection(List<ListWorkspacesPage> pages, int collectionSize) {
            return new ListWorkspacesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListWorkspacesPage
    extends AbstractPage<ListWorkspacesRequest, ListWorkspacesResponse, Workspace, ListWorkspacesPage> {
        private ListWorkspacesPage(PageContext<ListWorkspacesRequest, ListWorkspacesResponse, Workspace> context, ListWorkspacesResponse response) {
            super(context, (Object)response);
        }

        private static ListWorkspacesPage createEmptyPage() {
            return new ListWorkspacesPage(null, null);
        }

        protected ListWorkspacesPage createPage(PageContext<ListWorkspacesRequest, ListWorkspacesResponse, Workspace> context, ListWorkspacesResponse response) {
            return new ListWorkspacesPage(context, response);
        }

        public ApiFuture<ListWorkspacesPage> createPageAsync(PageContext<ListWorkspacesRequest, ListWorkspacesResponse, Workspace> context, ApiFuture<ListWorkspacesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListWorkspacesPagedResponse
    extends AbstractPagedListResponse<ListWorkspacesRequest, ListWorkspacesResponse, Workspace, ListWorkspacesPage, ListWorkspacesFixedSizeCollection> {
        public static ApiFuture<ListWorkspacesPagedResponse> createAsync(PageContext<ListWorkspacesRequest, ListWorkspacesResponse, Workspace> context, ApiFuture<ListWorkspacesResponse> futureResponse) {
            ApiFuture<ListWorkspacesPage> futurePage = ListWorkspacesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListWorkspacesPage, ListWorkspacesPagedResponse>(){

                public ListWorkspacesPagedResponse apply(ListWorkspacesPage input) {
                    return new ListWorkspacesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListWorkspacesPagedResponse(ListWorkspacesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListWorkspacesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListTablesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTablesRequest, ListTablesResponse, Table, ListTablesPage, ListTablesFixedSizeCollection> {
        private ListTablesFixedSizeCollection(List<ListTablesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTablesFixedSizeCollection createEmptyCollection() {
            return new ListTablesFixedSizeCollection(null, 0);
        }

        protected ListTablesFixedSizeCollection createCollection(List<ListTablesPage> pages, int collectionSize) {
            return new ListTablesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTablesPage
    extends AbstractPage<ListTablesRequest, ListTablesResponse, Table, ListTablesPage> {
        private ListTablesPage(PageContext<ListTablesRequest, ListTablesResponse, Table> context, ListTablesResponse response) {
            super(context, (Object)response);
        }

        private static ListTablesPage createEmptyPage() {
            return new ListTablesPage(null, null);
        }

        protected ListTablesPage createPage(PageContext<ListTablesRequest, ListTablesResponse, Table> context, ListTablesResponse response) {
            return new ListTablesPage(context, response);
        }

        public ApiFuture<ListTablesPage> createPageAsync(PageContext<ListTablesRequest, ListTablesResponse, Table> context, ApiFuture<ListTablesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTablesPagedResponse
    extends AbstractPagedListResponse<ListTablesRequest, ListTablesResponse, Table, ListTablesPage, ListTablesFixedSizeCollection> {
        public static ApiFuture<ListTablesPagedResponse> createAsync(PageContext<ListTablesRequest, ListTablesResponse, Table> context, ApiFuture<ListTablesResponse> futureResponse) {
            ApiFuture<ListTablesPage> futurePage = ListTablesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListTablesPage, ListTablesPagedResponse>(){

                public ListTablesPagedResponse apply(ListTablesPage input) {
                    return new ListTablesPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListTablesPagedResponse(ListTablesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTablesFixedSizeCollection.createEmptyCollection());
        }
    }
}

