/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.utilities;

import android.content.res.AssetManager;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.devtools.build.android.desugar.runtime.ThrowableExtension;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionException;

public final class SceneformBufferUtils {
    private static final String TAG = SceneformBufferUtils.class.getSimpleName();
    private static final int DEFAULT_BLOCK_SIZE = 8192;

    private SceneformBufferUtils() {
    }

    @Nullable
    public static ByteBuffer readFile(AssetManager assetManager, String string) {
        InputStream inputStream;
        try {
            inputStream = assetManager.open(string);
        }
        catch (IOException iOException) {
            String string2 = iOException.getMessage();
            Log.e((String)TAG, (String)new StringBuilder(23 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Failed to read file ").append(string).append(" - ").append(string2).toString());
            return null;
        }
        ByteBuffer byteBuffer = SceneformBufferUtils.readStream(inputStream);
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                String string3 = iOException.getMessage();
                Log.e((String)TAG, (String)new StringBuilder(46 + String.valueOf(string).length() + String.valueOf(string3).length()).append("Failed to close the input stream from file ").append(string).append(" - ").append(string3).toString());
            }
        }
        return byteBuffer;
    }

    @Nullable
    public static ByteBuffer readStream(@Nullable InputStream inputStream) {
        ByteBuffer byteBuffer = null;
        if (inputStream == null) {
            return null;
        }
        try {
            byte[] byArray = SceneformBufferUtils.inputStreamToByteArray(inputStream);
            byteBuffer = ByteBuffer.wrap(byArray);
        }
        catch (IOException iOException) {
            String string = String.valueOf(iOException.getMessage());
            Log.e((String)TAG, (String)(string.length() != 0 ? "Failed to read stream - ".concat(string) : new String("Failed to read stream - ")));
        }
        return byteBuffer;
    }

    private static int copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[8192];
        int n2 = 0;
        while ((n = inputStream.read(byArray)) > 0) {
            n2 += n;
            outputStream.write(byArray, 0, n);
        }
        outputStream.flush();
        return n2;
    }

    public static byte[] copyByteBufferToArray(ByteBuffer byteBuffer) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[8192];
        int n = byteBuffer.limit();
        while (byteBuffer.position() < n) {
            int n2 = byteBuffer.position();
            byteBuffer.get(byArray, 0, Math.min(8192, n - n2));
            int n3 = byteBuffer.position() - n2;
            byteArrayOutputStream.write(byArray, 0, n3);
        }
        byteArrayOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public static ByteBuffer copyByteBuffer(ByteBuffer byteBuffer) throws IOException {
        return ByteBuffer.wrap(SceneformBufferUtils.copyByteBufferToArray(byteBuffer));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ByteBuffer inputStreamToByteBuffer(Callable<InputStream> callable) {
        ByteBuffer byteBuffer;
        block6: {
            try {
                InputStream inputStream = callable.call();
                try {
                    byteBuffer = SceneformBufferUtils.readStream(inputStream);
                    if (inputStream == null) break block6;
                }
                catch (Throwable throwable) {
                    if (inputStream == null) throw throwable;
                    try {
                        inputStream.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        ThrowableExtension.addSuppressed((Throwable)throwable, (Throwable)throwable2);
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            catch (Exception exception) {
                throw new CompletionException(exception);
            }
        }
        if (byteBuffer != null) return byteBuffer;
        throw new AssertionError((Object)"Failed reading data from stream");
    }

    public static byte[] inputStreamCallableToByteArray(Callable<InputStream> callable) throws Exception {
        byte[] byArray;
        block5: {
            InputStream inputStream = callable.call();
            try {
                byArray = SceneformBufferUtils.inputStreamToByteArray(inputStream);
                if (inputStream == null) break block5;
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        ThrowableExtension.addSuppressed((Throwable)throwable, (Throwable)throwable2);
                    }
                }
                throw throwable;
            }
            inputStream.close();
        }
        return byArray;
    }

    public static byte[] inputStreamToByteArray(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        SceneformBufferUtils.copy(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }
}

