/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.utilities;

import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.google.ar.sceneform.utilities.MovingAverage;

public class MovingAverageMillisecondsTracker {
    private static final double NANOSECONDS_TO_MILLISECONDS = 1.0E-6;
    @Nullable
    private MovingAverage movingAverage;
    private final double weight;
    private final Clock clock;
    private long beginSampleTimestampNano;

    public MovingAverageMillisecondsTracker() {
        this(0.9f);
    }

    public MovingAverageMillisecondsTracker(double d2) {
        this.weight = d2;
        this.clock = new a(0);
    }

    @VisibleForTesting
    public MovingAverageMillisecondsTracker(Clock clock) {
        this(clock, 0.9f);
    }

    @VisibleForTesting
    public MovingAverageMillisecondsTracker(Clock clock, double d2) {
        this.weight = d2;
        this.clock = clock;
    }

    public void beginSample() {
        this.beginSampleTimestampNano = this.clock.a();
    }

    public void endSample() {
        long l = this.clock.a() - this.beginSampleTimestampNano;
        double d2 = (double)l * 1.0E-6;
        if (this.movingAverage == null) {
            this.movingAverage = new MovingAverage(d2, this.weight);
            return;
        }
        this.movingAverage.addSample(d2);
    }

    public double getAverage() {
        if (this.movingAverage != null) {
            return this.movingAverage.getAverage();
        }
        return 0.0;
    }

    private static final class a
    implements Clock {
        private a() {
        }

        @Override
        public final long a() {
            return System.nanoTime();
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }

    static interface Clock {
        public long a();
    }
}

