/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.utilities;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.net.Uri;
import android.net.http.HttpResponseCache;
import android.os.Build;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.google.ar.sceneform.utilities.Preconditions;
import com.google.ar.sceneform.utilities.a;
import com.google.ar.sceneform.utilities.b;
import com.google.ar.sceneform.utilities.c;
import com.google.ar.sceneform.utilities.d;
import com.google.ar.sceneform.utilities.e;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;

public class LoadHelper {
    private static final String TAG = LoadHelper.class.getName();
    public static final int INVALID_RESOURCE_IDENTIFIER = 0;
    private static final String RAW_RESOURCE_TYPE = "raw";
    private static final String DRAWABLE_RESOURCE_TYPE = "drawable";
    private static final char SLASH_DELIMETER = '/';
    private static final String ANDROID_ASSET = "/android_asset/";
    private static final long DEFAULT_CACHE_SIZE_BYTES = 0x20000000L;

    private LoadHelper() {
    }

    public static Boolean isAndroidResource(Uri uri) {
        Preconditions.checkNotNull(uri, "Parameter \"sourceUri\" was null.");
        return TextUtils.equals((CharSequence)"android.resource", (CharSequence)uri.getScheme());
    }

    public static Boolean isFileAsset(Uri uri) {
        Preconditions.checkNotNull(uri, "Parameter \"sourceUri\" was null.");
        String string = uri.getScheme();
        return TextUtils.isEmpty((CharSequence)string) || Objects.equals("file", string);
    }

    public static Uri resolveUri(Uri uri, @Nullable Uri uri2) {
        if (uri2 == null) {
            return uri;
        }
        return LoadHelper.resolve(uri2, uri);
    }

    public static Callable<InputStream> fromResource(Context context, int n) {
        Preconditions.checkNotNull(context, "Parameter \"context\" was null.");
        String string = context.getResources().getResourceTypeName(n);
        if (string.equals(RAW_RESOURCE_TYPE) || string.equals(DRAWABLE_RESOURCE_TYPE)) {
            return new b(context, n);
        }
        String string2 = context.getResources().getResourceName(n);
        throw new IllegalArgumentException(new StringBuilder(73 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Unknown resource resourceType '").append(string).append("' in resId '").append(string2).append("'. Resource will not be loaded").toString());
    }

    public static Callable<InputStream> fromUri(Context context, Uri uri) {
        return LoadHelper.fromUri(context, uri, null);
    }

    public static Callable<InputStream> fromUri(Context context, Uri uri, @Nullable Map<String, String> map) {
        Preconditions.checkNotNull(uri, "Parameter \"sourceUri\" was null.");
        Preconditions.checkNotNull(context, "Parameter \"context\" was null.");
        if (LoadHelper.isFileAsset(uri).booleanValue()) {
            return LoadHelper.fileUriToInputStreamCreator(context, uri);
        }
        if (LoadHelper.isAndroidResource(uri).booleanValue()) {
            return LoadHelper.androidResourceUriToInputStreamCreator(context, uri);
        }
        if (LoadHelper.isGltfDataUri(uri)) {
            return LoadHelper.dataUriInputStreamCreator(uri);
        }
        return LoadHelper.remoteUriToInputStreamCreator(uri, map);
    }

    public static Uri resourceToUri(Context context, int n) {
        Resources resources = context.getResources();
        return new Uri.Builder().scheme("android.resource").authority(resources.getResourcePackageName(n)).appendPath(resources.getResourceTypeName(n)).appendPath(resources.getResourceEntryName(n)).build();
    }

    public static int rawResourceNameToIdentifier(Context context, String string) {
        return context.getResources().getIdentifier(string, RAW_RESOURCE_TYPE, context.getPackageName());
    }

    public static void enableCaching(Context context) {
        LoadHelper.enableCaching(0x20000000L, context.getCacheDir(), "http_cache");
    }

    public static void enableCaching(long l, File file, String string) {
        if (HttpResponseCache.getInstalled() == null) {
            try {
                File file2 = new File(file, string);
                if (Build.VERSION.SDK_INT >= 14) {
                    HttpResponseCache.install((File)file2, (long)l);
                }
                return;
            }
            catch (IOException iOException) {
                String string2 = String.valueOf(iOException);
                Log.i((String)TAG, (String)new StringBuilder(40 + String.valueOf(string2).length()).append("HTTP response cache installation failed:").append(string2).toString());
            }
        }
    }

    public static void flushHttpCache() {
        HttpResponseCache httpResponseCache = HttpResponseCache.getInstalled();
        if (httpResponseCache != null) {
            httpResponseCache.flush();
        }
    }

    private static Callable<InputStream> fileUriToInputStreamCreator(Context context, Uri uri) {
        String string;
        AssetManager assetManager = context.getAssets();
        if (uri.getAuthority() == null) {
            string = uri.getPath();
        } else if (uri.getPath().isEmpty()) {
            string = uri.getAuthority();
        } else {
            String string2 = String.valueOf(uri.getAuthority());
            String string3 = String.valueOf(uri.getPath());
            string = string3.length() != 0 ? string2.concat(string3) : new String(string2);
        }
        String string4 = string;
        String string5 = LoadHelper.removeAndroidAssetPath(string);
        return new a(assetManager, string5, string4);
    }

    private static String removeAndroidAssetPath(String string) {
        String string2 = string;
        if (string.startsWith(ANDROID_ASSET)) {
            string2 = string.substring(15);
        }
        return string2;
    }

    private static Callable<InputStream> androidResourceUriToInputStreamCreator(Context context, Uri uri) {
        int n;
        String string = uri.getPath();
        String string2 = string.substring(1, n = string.lastIndexOf(47));
        if (string2.equals(RAW_RESOURCE_TYPE) || string2.equals(DRAWABLE_RESOURCE_TYPE)) {
            return new d(context, uri);
        }
        String string3 = String.valueOf(uri);
        throw new IllegalArgumentException(new StringBuilder(71 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Unknown resource resourceType '").append(string2).append("' in uri '").append(string3).append("'. Resource will not be loaded").toString());
    }

    private static Callable<InputStream> remoteUriToInputStreamCreator(Uri uri, @Nullable Map<String, String> map) {
        try {
            URL uRL = new URL(uri.toString());
            URLConnection uRLConnection = uRL.openConnection();
            if (map != null) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    uRLConnection.addRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            return new c(uRLConnection);
        }
        catch (MalformedURLException malformedURLException) {
            String string = String.valueOf(uri);
            throw new IllegalArgumentException(new StringBuilder(23 + String.valueOf(string).length()).append("Unable to parse url: '").append(string).append("'").toString(), malformedURLException);
        }
        catch (IOException iOException) {
            String string = String.valueOf(uri);
            throw new AssertionError(new StringBuilder(32 + String.valueOf(string).length()).append("Error opening url connection: '").append(string).append("'").toString(), iOException);
        }
    }

    private static Uri resolve(Uri uri, Uri uri2) {
        try {
            URI uRI = new URI(uri.toString());
            URI uRI2 = new URI(uri2.toString());
            URI uRI3 = uRI.resolve(uRI2);
            return Uri.parse((String)uRI3.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Unable to parse Uri.", uRISyntaxException);
        }
    }

    private static boolean assetExists(AssetManager assetManager, String string) throws IOException {
        String[] stringArray;
        String string2;
        int n = string.lastIndexOf(47);
        if (n != -1) {
            string2 = string.substring(n + 1);
            stringArray = assetManager.list(string.substring(0, n));
        } else {
            string2 = string;
            stringArray = assetManager.list("");
        }
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                String string3 = stringArray2[i];
                if (!string2.equals(string3)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isDataUri(Uri uri) {
        String string = uri.getScheme();
        return string != null && string.equals("data");
    }

    public static boolean isGltfDataUri(Uri uri) {
        if (!LoadHelper.isDataUri(uri)) {
            return false;
        }
        return LoadHelper.getGltfExtensionFromSchemeSpecificPart(uri.getSchemeSpecificPart()) != null;
    }

    @Nullable
    private static String getGltfExtensionFromSchemeSpecificPart(String string) {
        if (string.startsWith("model/gltf-binary")) {
            return "glb";
        }
        if (string.startsWith("model/gltf+json")) {
            return "gltf";
        }
        return null;
    }

    private static Callable<InputStream> dataUriInputStreamCreator(Uri uri) {
        String string = uri.getSchemeSpecificPart();
        int n = string.indexOf(44);
        if (n < 0) {
            throw new IllegalArgumentException("Malformed data uri - does not contain a ','");
        }
        String string2 = string.substring(0, n);
        boolean bl = string2.contains(";base64");
        String string3 = string.substring(n + 1);
        return new e(bl, string3);
    }

    public static String getLastPathSegment(Uri uri) {
        if (LoadHelper.isGltfDataUri(uri)) {
            String string = String.valueOf(LoadHelper.getGltfExtensionFromSchemeSpecificPart(uri.getSchemeSpecificPart()));
            if (string.length() != 0) {
                return "file.".concat(string);
            }
            return new String("file.");
        }
        String string = uri.getLastPathSegment();
        if (string == null) {
            String string2 = uri.toString();
            string = string2.substring(string2.lastIndexOf(47) + 1);
        }
        return string;
    }

    static final /* synthetic */ InputStream lambda$dataUriInputStreamCreator$4$LoadHelper(boolean bl, String string) throws Exception {
        return new ByteArrayInputStream(bl ? Base64.decode((String)string, (int)0) : string.getBytes());
    }

    static final /* synthetic */ InputStream lambda$remoteUriToInputStreamCreator$3$LoadHelper(URLConnection uRLConnection) throws Exception {
        return uRLConnection.getInputStream();
    }

    static final /* synthetic */ InputStream lambda$androidResourceUriToInputStreamCreator$2$LoadHelper(Context context, Uri uri) throws Exception {
        return context.getContentResolver().openInputStream(uri);
    }

    static final /* synthetic */ InputStream lambda$fileUriToInputStreamCreator$1$LoadHelper(AssetManager assetManager, String string, String string2) throws Exception {
        if (LoadHelper.assetExists(assetManager, string)) {
            return assetManager.open(string);
        }
        return new FileInputStream(new File(string2));
    }

    static final /* synthetic */ InputStream lambda$fromResource$0$LoadHelper(Context context, int n) throws Exception {
        return context.getResources().openRawResource(n);
    }
}

