/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.utilities;

public class EnvironmentalHdrParameters {
    public static final float DEFAULT_AMBIENT_SH_SCALE_FOR_FILAMENT = 1.0f;
    public static final float DEFAULT_DIRECT_INTENSITY_FOR_FILAMENT = 1.0f;
    public static final float DEFAULT_REFLECTION_SCALE_FOR_FILAMENT = 1.0f;
    private final float ambientShScaleForFilament;
    private final float directIntensityForFilament;
    private final float reflectionScaleForFilament;

    public static Builder builder() {
        return new Builder();
    }

    public static EnvironmentalHdrParameters makeDefault() {
        return EnvironmentalHdrParameters.builder().setAmbientShScaleForFilament(1.0f).setDirectIntensityForFilament(1.0f).setReflectionScaleForFilament(1.0f).build();
    }

    private EnvironmentalHdrParameters(Builder builder) {
        this.ambientShScaleForFilament = builder.ambientShScaleForFilament;
        this.directIntensityForFilament = builder.directIntensityForFilament;
        this.reflectionScaleForFilament = builder.reflectionScaleForFilament;
    }

    public float getAmbientShScaleForFilament() {
        return this.ambientShScaleForFilament;
    }

    public float getDirectIntensityForFilament() {
        return this.directIntensityForFilament;
    }

    public float getReflectionScaleForFilament() {
        return this.reflectionScaleForFilament;
    }

    public static class Builder {
        private float ambientShScaleForFilament;
        private float directIntensityForFilament;
        private float reflectionScaleForFilament;

        public Builder() {
        }

        public EnvironmentalHdrParameters build() {
            return new EnvironmentalHdrParameters(this);
        }

        public Builder setDirectIntensityForFilament(float f) {
            this.directIntensityForFilament = f;
            return this;
        }

        public Builder setAmbientShScaleForFilament(float f) {
            this.ambientShScaleForFilament = f;
            return this;
        }

        public Builder setReflectionScaleForFilament(float f) {
            this.reflectionScaleForFilament = f;
            return this;
        }
    }
}

