/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.resources;

import android.support.annotation.GuardedBy;
import android.support.annotation.Nullable;
import com.google.ar.sceneform.resources.ResourceHolder;
import com.google.ar.sceneform.resources.a;
import com.google.ar.sceneform.utilities.Preconditions;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;

public class ResourceRegistry<T>
implements ResourceHolder {
    private static final String TAG = ResourceRegistry.class.getSimpleName();
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private final Map<Object, WeakReference<T>> registry = new HashMap<Object, WeakReference<T>>();
    @GuardedBy(value="lock")
    private final Map<Object, CompletableFuture<T>> futureRegistry = new HashMap<Object, CompletableFuture<T>>();

    public ResourceRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CompletableFuture<T> get(Object object) {
        Preconditions.checkNotNull(object, "Parameter 'id' was null.");
        Object object2 = this.lock;
        synchronized (object2) {
            WeakReference<T> weakReference = this.registry.get(object);
            if (weakReference != null) {
                Object t = weakReference.get();
                if (t != null) {
                    return CompletableFuture.completedFuture(t);
                }
                this.registry.remove(object);
            }
            return this.futureRegistry.get(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Object object, CompletableFuture<T> completableFuture) {
        Preconditions.checkNotNull(object, "Parameter 'id' was null.");
        Preconditions.checkNotNull(completableFuture, "Parameter 'futureResource' was null.");
        if (completableFuture.isDone()) {
            if (completableFuture.isCompletedExceptionally()) {
                return;
            }
            Object t = Preconditions.checkNotNull(completableFuture.getNow(null));
            Object object2 = this.lock;
            synchronized (object2) {
                this.registry.put(object, new WeakReference<Object>(t));
                this.futureRegistry.remove(object);
                return;
            }
        }
        Object object3 = this.lock;
        synchronized (object3) {
            this.futureRegistry.put(object, completableFuture);
            this.registry.remove(object);
        }
        completableFuture.handle((BiFunction)new a(this, object, completableFuture));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyAllResources() {
        Object object = this.lock;
        synchronized (object) {
            Iterator<Map.Entry<Object, CompletableFuture<T>>> iterator = this.futureRegistry.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, CompletableFuture<T>> entry = iterator.next();
                iterator.remove();
                CompletableFuture<T> completableFuture = entry.getValue();
                if (completableFuture.isDone()) continue;
                completableFuture.cancel(true);
            }
            this.registry.clear();
            return;
        }
    }

    @Override
    public long reclaimReleasedResources() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final /* synthetic */ Void lambda$register$0$ResourceRegistry(Object object, CompletableFuture completableFuture, Object object2, Throwable throwable) {
        ResourceRegistry resourceRegistry = this;
        synchronized (resourceRegistry) {
            Object object3 = this.lock;
            synchronized (object3) {
                CompletableFuture<T> completableFuture2 = this.futureRegistry.get(object);
                if (completableFuture2 == completableFuture) {
                    this.futureRegistry.remove(object);
                    if (throwable == null) {
                        this.registry.put(object, new WeakReference<Object>(object2));
                    }
                }
            }
        }
        return null;
    }
}

