/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.math;

import com.google.ar.sceneform.math.MathHelper;
import com.google.ar.sceneform.utilities.Preconditions;

public class Vector3 {
    public float x;
    public float y;
    public float z;

    public Vector3() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public Vector3(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    public Vector3(Vector3 vector3) {
        Preconditions.checkNotNull(vector3, "Parameter \"v\" was null.");
        this.set(vector3);
    }

    public void set(Vector3 vector3) {
        Preconditions.checkNotNull(vector3, "Parameter \"v\" was null.");
        this.x = vector3.x;
        this.y = vector3.y;
        this.z = vector3.z;
    }

    public void set(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    void setZero() {
        this.set(0.0f, 0.0f, 0.0f);
    }

    void setOne() {
        this.set(1.0f, 1.0f, 1.0f);
    }

    void setForward() {
        this.set(0.0f, 0.0f, -1.0f);
    }

    void setBack() {
        this.set(0.0f, 0.0f, 1.0f);
    }

    void setUp() {
        this.set(0.0f, 1.0f, 0.0f);
    }

    void setDown() {
        this.set(0.0f, -1.0f, 0.0f);
    }

    void setRight() {
        this.set(1.0f, 0.0f, 0.0f);
    }

    void setLeft() {
        this.set(-1.0f, 0.0f, 0.0f);
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public String toString() {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        return new StringBuilder(57).append("[x=").append(f).append(", y=").append(f2).append(", z=").append(f3).append("]").toString();
    }

    public Vector3 normalized() {
        Vector3 vector3 = new Vector3(this);
        float f = Vector3.dot(this, this);
        if (MathHelper.almostEqualRelativeAndAbs(f, 0.0f)) {
            vector3.setZero();
        } else if (f != 1.0f) {
            float f2 = (float)(1.0 / Math.sqrt(f));
            vector3.set(this.scaled(f2));
        }
        return vector3;
    }

    public Vector3 scaled(float f) {
        return new Vector3(this.x * f, this.y * f, this.z * f);
    }

    public Vector3 negated() {
        return new Vector3(-this.x, -this.y, -this.z);
    }

    public static Vector3 add(Vector3 vector3, Vector3 vector32) {
        Preconditions.checkNotNull(vector3, "Parameter \"lhs\" was null.");
        Preconditions.checkNotNull(vector32, "Parameter \"rhs\" was null.");
        return new Vector3(vector3.x + vector32.x, vector3.y + vector32.y, vector3.z + vector32.z);
    }

    public static Vector3 subtract(Vector3 vector3, Vector3 vector32) {
        Preconditions.checkNotNull(vector3, "Parameter \"lhs\" was null.");
        Preconditions.checkNotNull(vector32, "Parameter \"rhs\" was null.");
        return new Vector3(vector3.x - vector32.x, vector3.y - vector32.y, vector3.z - vector32.z);
    }

    public static float dot(Vector3 vector3, Vector3 vector32) {
        Preconditions.checkNotNull(vector3, "Parameter \"lhs\" was null.");
        Preconditions.checkNotNull(vector32, "Parameter \"rhs\" was null.");
        return vector3.x * vector32.x + vector3.y * vector32.y + vector3.z * vector32.z;
    }

    public static Vector3 cross(Vector3 vector3, Vector3 vector32) {
        Preconditions.checkNotNull(vector3, "Parameter \"lhs\" was null.");
        Preconditions.checkNotNull(vector32, "Parameter \"rhs\" was null.");
        float f = vector3.x;
        float f2 = vector3.y;
        float f3 = vector3.z;
        float f4 = vector32.x;
        float f5 = vector32.y;
        float f6 = vector32.z;
        return new Vector3(f2 * f6 - f3 * f5, f3 * f4 - f * f6, f * f5 - f2 * f4);
    }

    public static Vector3 min(Vector3 vector3, Vector3 vector32) {
        Preconditions.checkNotNull(vector3, "Parameter \"lhs\" was null.");
        Preconditions.checkNotNull(vector32, "Parameter \"rhs\" was null.");
        return new Vector3(Math.min(vector3.x, vector32.x), Math.min(vector3.y, vector32.y), Math.min(vector3.z, vector32.z));
    }

    public static Vector3 max(Vector3 vector3, Vector3 vector32) {
        Preconditions.checkNotNull(vector3, "Parameter \"lhs\" was null.");
        Preconditions.checkNotNull(vector32, "Parameter \"rhs\" was null.");
        return new Vector3(Math.max(vector3.x, vector32.x), Math.max(vector3.y, vector32.y), Math.max(vector3.z, vector32.z));
    }

    static float componentMax(Vector3 vector3) {
        Preconditions.checkNotNull(vector3, "Parameter \"a\" was null.");
        return Math.max(Math.max(vector3.x, vector3.y), vector3.z);
    }

    static float componentMin(Vector3 vector3) {
        Preconditions.checkNotNull(vector3, "Parameter \"a\" was null.");
        return Math.min(Math.min(vector3.x, vector3.y), vector3.z);
    }

    public static Vector3 lerp(Vector3 vector3, Vector3 vector32, float f) {
        Preconditions.checkNotNull(vector3, "Parameter \"a\" was null.");
        Preconditions.checkNotNull(vector32, "Parameter \"b\" was null.");
        return new Vector3(MathHelper.lerp(vector3.x, vector32.x, f), MathHelper.lerp(vector3.y, vector32.y, f), MathHelper.lerp(vector3.z, vector32.z, f));
    }

    public static float angleBetweenVectors(Vector3 vector3, Vector3 vector32) {
        float f;
        float f2 = vector3.length();
        float f3 = f2 * (f = vector32.length());
        if (MathHelper.almostEqualRelativeAndAbs(f3, 0.0f)) {
            return 0.0f;
        }
        float f4 = Vector3.dot(vector3, vector32);
        float f5 = f4 / f3;
        f5 = MathHelper.clamp(f5, -1.0f, 1.0f);
        float f6 = (float)Math.acos(f5);
        return (float)Math.toDegrees(f6);
    }

    public static boolean equals(Vector3 vector3, Vector3 vector32) {
        Preconditions.checkNotNull(vector3, "Parameter \"lhs\" was null.");
        Preconditions.checkNotNull(vector32, "Parameter \"rhs\" was null.");
        boolean bl = true & MathHelper.almostEqualRelativeAndAbs(vector3.x, vector32.x);
        bl &= MathHelper.almostEqualRelativeAndAbs(vector3.y, vector32.y);
        return bl &= MathHelper.almostEqualRelativeAndAbs(vector3.z, vector32.z);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Vector3)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        return Vector3.equals(this, (Vector3)object);
    }

    public int hashCode() {
        int n = 31 + Float.floatToIntBits(this.x);
        n = n * 31 + Float.floatToIntBits(this.y);
        n = n * 31 + Float.floatToIntBits(this.z);
        return n;
    }

    public static Vector3 zero() {
        return new Vector3();
    }

    public static Vector3 one() {
        Vector3 vector3 = new Vector3();
        vector3.setOne();
        return vector3;
    }

    public static Vector3 forward() {
        Vector3 vector3 = new Vector3();
        vector3.setForward();
        return vector3;
    }

    public static Vector3 back() {
        Vector3 vector3 = new Vector3();
        vector3.setBack();
        return vector3;
    }

    public static Vector3 up() {
        Vector3 vector3 = new Vector3();
        vector3.setUp();
        return vector3;
    }

    public static Vector3 down() {
        Vector3 vector3 = new Vector3();
        vector3.setDown();
        return vector3;
    }

    public static Vector3 right() {
        Vector3 vector3 = new Vector3();
        vector3.setRight();
        return vector3;
    }

    public static Vector3 left() {
        Vector3 vector3 = new Vector3();
        vector3.setLeft();
        return vector3;
    }
}

